package app.ringify.models.entries

import kotlinx.serialization.Serializable

@Serializable
data class EntryScores(
    val creatorPoints: Int,
    val opponentPoints: Int,
) {

    operator fun plus(other: EntryScores): EntryScores = EntryScores(
        creatorPoints + other.creatorPoints, opponentPoints + other.opponentPoints
    )

}
