package app.ringify.repositories.duels

import app.ringify.client.IRingifyClient
import app.ringify.models.duels.CreateDuelPayload
import app.ringify.models.duels.Duel
import app.ringify.models.duels.UpdateDuelPayload
import app.ringify.models.entries.Entry
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.http.*
import io.ktor.util.reflect.*

class DuelsRemoteRepository(
    client: IRingifyClient,
) : APIModelRemoteRepository<Duel, UUID, CreateDuelPayload, UpdateDuelPayload>(
    typeInfo<Duel>(),
    typeInfo<CreateDuelPayload>(),
    typeInfo<UpdateDuelPayload>(),
    typeInfo<List<Duel>>(),
    client,
    prefix = "/api/v1"
), IDuelsRemoteRepository {

    override suspend fun get(id: UUID): Duel? = get(id, null)

    override suspend fun create(payload: CreateDuelPayload): Duel? = create(payload, null)

    override suspend fun accept(id: UUID): Duel? = client
        .request(HttpMethod.Post, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id")
        .body()

    override suspend fun decline(id: UUID): Boolean = delete(id, null)

    override suspend fun listEntries(id: UUID): List<Entry> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/entries")
        .body()

}
