package app.ringify.models.duels

import app.ringify.models.users.User
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.UUID
import kotlinx.datetime.LocalDate
import kotlinx.serialization.Serializable

@Serializable
data class Duel(
    @Schema("Id of the Duel", "123abc")
    override val id: UUID,
    @Schema("Id of the user who created the duel", "abc123")
    val creatorId: UUID,
    @Schema("Id of the user who accepted the duel", "abc123")
    val opponentId: UUID,
    @Schema("Date the duel starts at", "2021-01-01")
    val startsAt: LocalDate,
    @Schema("Date the duel ends at", "2021-01-01")
    val endsAt: LocalDate,
    @Schema("If the duel was accepted by the opponent", "true")
    val isAccepted: Boolean,
    @Schema("Id of the user who won the duel", "abc123")
    val winnerId: UUID?,
    @Schema("User object of the creator of the duel")
    val creator: User? = null,
    @Schema("User object of the opponent of the duel")
    val opponent: User? = null,
) : IModel<UUID, CreateDuelPayload, UpdateDuelPayload>
