package app.ringify.repositories.teams

import app.ringify.client.IRingifyClient
import app.ringify.models.application.SearchOptions
import app.ringify.models.duels.Duel
import app.ringify.models.entries.Entry
import app.ringify.models.teams.CreateTeamPayload
import app.ringify.models.teams.Team
import app.ringify.models.teams.UpdateTeamPayload
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import dev.kaccelero.repositories.IPaginationOptions
import dev.kaccelero.repositories.Pagination
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*
import kotlinx.datetime.LocalDate

class TeamsRemoteRepository(
    client: IRingifyClient,
) : APIModelRemoteRepository<Team, UUID, CreateTeamPayload, UpdateTeamPayload>(
    typeInfo<Team>(),
    typeInfo<CreateTeamPayload>(),
    typeInfo<UpdateTeamPayload>(),
    typeInfo<List<Team>>(),
    client,
    prefix = "/api/v1"
), ITeamsRemoteRepository {

    override fun encodePaginationOptions(options: IPaginationOptions, builder: HttpRequestBuilder) = when (options) {
        is SearchOptions -> builder.parameter("search", options.search)
        else -> super.encodePaginationOptions(options, builder)
    }

    override suspend fun list(pagination: Pagination): List<Team> = list(pagination, null)

    override suspend fun get(id: UUID): Team? = get(id, null)

    override suspend fun create(payload: CreateTeamPayload): Team? = create(payload, null)

    override suspend fun update(id: UUID, payload: UpdateTeamPayload): Team? = update(id, payload, null)

    override suspend fun listDuels(id: UUID): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels")
        .body()

    override suspend fun listEntries(id: UUID, date: LocalDate): List<Entry> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/entries/$date")
        .body()

}
