package app.ringify.repositories.teams

import app.ringify.models.duels.Duel
import app.ringify.models.entries.Entry
import app.ringify.models.teams.CreateTeamPayload
import app.ringify.models.teams.Team
import app.ringify.models.teams.UpdateTeamPayload
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.Pagination
import kotlinx.datetime.LocalDate

interface ITeamsRemoteRepository {

    suspend fun list(pagination: Pagination): List<Team>
    suspend fun get(id: UUID): Team?
    suspend fun create(payload: CreateTeamPayload): Team?
    suspend fun update(id: UUID, payload: UpdateTeamPayload): Team?
    suspend fun listDuels(id: UUID): List<Duel>
    suspend fun listEntries(id: UUID, date: LocalDate): List<Entry>

}
