package app.ringify.repositories.teams

import app.ringify.client.IRingifyClient
import app.ringify.models.teams.CreateUserInTeamPayload
import app.ringify.models.teams.Team
import app.ringify.models.teams.UserInTeam
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.util.reflect.*

class UsersInTeamsRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<Team, UUID, *, *, *>,
) : APIChildModelRemoteRepository<UserInTeam, UUID, CreateUserInTeamPayload, Unit, UUID>(
    typeInfo<UserInTeam>(),
    typeInfo<CreateUserInTeamPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<UserInTeam>>(),
    client,
    parentRepository,
    route = "users",
    prefix = "/api/v1"
), IUsersInTeamsRemoteRepository {

    override suspend fun list(teamId: UUID): List<UserInTeam> =
        list(RecursiveId<Team, UUID, Unit>(teamId), null)

    override suspend fun create(payload: CreateUserInTeamPayload, teamId: UUID): UserInTeam? =
        create(payload, RecursiveId<Team, UUID, Unit>(teamId), null)

    override suspend fun delete(userId: UUID, teamId: UUID): Boolean =
        delete(userId, RecursiveId<Team, UUID, Unit>(teamId), null)

}
