package app.ringify.client

import app.ringify.repositories.auth.IAuthAPIRemoteRepository
import app.ringify.repositories.duels.IDuelsRemoteRepository
import app.ringify.repositories.entries.IEntriesRemoteRepository
import app.ringify.repositories.notifications.INotificationTokensRemoteRepository
import app.ringify.repositories.teams.ITeamsRemoteRepository
import app.ringify.repositories.teams.IUsersInTeamsRemoteRepository
import app.ringify.repositories.users.IUsersRemoteRepository
import app.ringify.repositories.watchers.IWatchersRemoteRepository
import dev.kaccelero.client.IAPIClient

interface IRingifyClient : IAPIClient {

    val auth: IAuthAPIRemoteRepository
    val users: IUsersRemoteRepository
    val duels: IDuelsRemoteRepository
    val entries: IEntriesRemoteRepository
    val notificationTokens: INotificationTokensRemoteRepository
    val teams: ITeamsRemoteRepository
    val usersInTeams: IUsersInTeamsRemoteRepository
    val watchers: IWatchersRemoteRepository

}
