package app.ringify.repositories.users

import app.ringify.models.duels.Duel
import app.ringify.models.teams.UserInTeam
import app.ringify.models.users.UpdateUserPayload
import app.ringify.models.users.User
import dev.kaccelero.models.UUID

interface IUsersRemoteRepository {

    suspend fun get(id: UUID): User?
    suspend fun update(id: UUID, payload: UpdateUserPayload): User?
    suspend fun delete(id: UUID): Boolean
    suspend fun listTeams(id: UUID): List<UserInTeam>
    suspend fun listDuels(id: UUID): List<Duel>
    suspend fun listEndedDuels(id: UUID): List<Duel>
    suspend fun listPendingDuels(id: UUID): List<Duel>

}
