package app.ringify.repositories.watchers

import app.ringify.client.IRingifyClient
import app.ringify.models.teams.Team
import app.ringify.models.users.User
import app.ringify.models.watchers.CreateWatcherPayload
import app.ringify.models.watchers.Watcher
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.util.reflect.*

class WatchersRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<User, UUID, *, *, *>,
) : APIChildModelRemoteRepository<Watcher, UUID, CreateWatcherPayload, Unit, UUID>(
    typeInfo<Watcher>(),
    typeInfo<CreateWatcherPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<Watcher>>(),
    client,
    parentRepository,
    prefix = "/api/v1"
), IWatchersRemoteRepository {

    override suspend fun create(payload: CreateWatcherPayload, userId: UUID): Watcher? =
        create(payload, RecursiveId<Team, UUID, Unit>(userId), null)

    override suspend fun delete(sourceId: UUID, userId: UUID): Boolean =
        delete(sourceId, RecursiveId<Team, UUID, Unit>(userId), null)

}
