/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.RawRes;
import app.rive.runtime.kotlin.Observable;
import app.rive.runtime.kotlin.R;
import app.rive.runtime.kotlin.RiveDrawable;
import app.rive.runtime.kotlin.core.AABB;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.Rive;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010=\u001a\u00020>J\u0016\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u0016J\b\u0010B\u001a\u00020>H\u0014J\u0018\u0010C\u001a\u00020>2\u0006\u0010D\u001a\u0002092\u0006\u0010E\u001a\u000209H\u0014J\u0006\u0010F\u001a\u00020>J\u0018\u0010F\u001a\u00020>2\u0006\u0010G\u001a\u00020\u00162\b\b\u0002\u0010H\u001a\u00020\u001cJ\u001e\u0010F\u001a\u00020>2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\b\b\u0002\u0010J\u001a\u00020\u001cJ\u001a\u0010K\u001a\u00020>2\b\b\u0002\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020OJ,\u0010K\u001a\u00020>2\u0006\u0010G\u001a\u00020\u00162\b\b\u0002\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020O2\b\b\u0002\u0010H\u001a\u00020\u001cJ2\u0010K\u001a\u00020>2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\b\b\u0002\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020O2\b\b\u0002\u0010J\u001a\u00020\u001cJ\u0010\u0010P\u001a\u00020>2\u0006\u0010Q\u001a\u00020\u0003H\u0016J\u0006\u0010R\u001a\u00020>J\u001e\u0010S\u001a\u00020>2\u0006\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u001cJ\u001e\u0010T\u001a\u00020>2\u0006\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020UJZ\u0010V\u001a\u00020>2\u0006\u0010W\u001a\u00020X2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010+\u001a\u00020*2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010L\u001a\u00020MJN\u0010Y\u001a\u00020>2\u0006\u0010&\u001a\u00020'2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010G\u001a\u0004\u0018\u00010\u00162\b\u0010@\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010L\u001a\u00020MH\u0002J\\\u0010Z\u001a\u00020>2\b\b\u0001\u0010[\u001a\u0002092\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010+\u001a\u00020*2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010L\u001a\u00020MJ\u0006\u0010\\\u001a\u00020>J\u0018\u0010\\\u001a\u00020>2\u0006\u0010G\u001a\u00020\u00162\b\b\u0002\u0010H\u001a\u00020\u001cJ\u001e\u0010\\\u001a\u00020>2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\b\b\u0002\u0010J\u001a\u00020\u001cJ\u0010\u0010]\u001a\u00020>2\u0006\u0010Q\u001a\u00020\u0003H\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R$\u0010+\u001a\u00020*2\u0006\u0010\t\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001fR\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u0012028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0017\u00105\u001a\b\u0012\u0004\u0012\u000206028F\u00a2\u0006\u0006\u001a\u0004\b7\u00104R\u0012\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010:R\u0017\u0010;\u001a\b\u0012\u0004\u0012\u0002060\u00118F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0014\u00a8\u0006^"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView;", "Landroid/view/View;", "Lapp/rive/runtime/kotlin/Observable;", "Lapp/rive/runtime/kotlin/RiveDrawable$Listener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "value", "Lapp/rive/runtime/kotlin/core/Alignment;", "alignment", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "animations", "", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getAnimations", "()Ljava/util/List;", "name", "", "artboardName", "getArtboardName", "()Ljava/lang/String;", "setArtboardName", "(Ljava/lang/String;)V", "", "autoplay", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "drawable", "Lapp/rive/runtime/kotlin/RiveDrawable;", "getDrawable", "()Lapp/rive/runtime/kotlin/RiveDrawable;", "file", "Lapp/rive/runtime/kotlin/core/File;", "getFile", "()Lapp/rive/runtime/kotlin/core/File;", "Lapp/rive/runtime/kotlin/core/Fit;", "fit", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "isPlaying", "playingAnimations", "Ljava/util/HashSet;", "getPlayingAnimations", "()Ljava/util/HashSet;", "playingStateMachines", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getPlayingStateMachines", "resourceId", "", "Ljava/lang/Integer;", "stateMachines", "getStateMachines", "destroy", "", "fireState", "stateMachineName", "inputName", "onDetachedFromWindow", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "pause", "animationName", "isStateMachine", "animationNames", "areStateMachines", "play", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "registerListener", "listener", "reset", "setBooleanState", "setNumberState", "", "setRiveBytes", "bytes", "", "setRiveFile", "setRiveResource", "resId", "stop", "unregisterListener", "kotlin_release"})
public final class RiveAnimationView
extends View
implements Observable<RiveDrawable.Listener> {
    @NotNull
    private final RiveDrawable drawable;
    private Integer resourceId;
    private HashMap _$_findViewCache;

    @NotNull
    public final RiveDrawable getDrawable() {
        return this.drawable;
    }

    @NotNull
    public final Fit getFit() {
        return this.drawable.getFit();
    }

    public final void setFit(@NotNull Fit value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.drawable.setFit(value);
        this.requestLayout();
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.drawable.getAlignment();
    }

    public final void setAlignment(@NotNull Alignment value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.drawable.setAlignment(value);
        this.requestLayout();
    }

    @Nullable
    public final File getFile() {
        return this.drawable.getFile();
    }

    @Nullable
    public final String getArtboardName() {
        return this.drawable.getArtboardName();
    }

    public final void setArtboardName(@Nullable String name) {
        this.drawable.setArtboardByName(name);
    }

    public final boolean getAutoplay() {
        return this.drawable.getAutoplay();
    }

    public final void setAutoplay(boolean value) {
        this.drawable.setAutoplay(value);
    }

    @NotNull
    public final List<LinearAnimationInstance> getAnimations() {
        return this.drawable.getAnimations();
    }

    @NotNull
    public final List<StateMachineInstance> getStateMachines() {
        return this.drawable.getStateMachines();
    }

    @NotNull
    public final HashSet<LinearAnimationInstance> getPlayingAnimations() {
        return this.drawable.getPlayingAnimations();
    }

    @NotNull
    public final HashSet<StateMachineInstance> getPlayingStateMachines() {
        return this.drawable.getPlayingStateMachines();
    }

    public final void pause() {
        this.drawable.pause();
    }

    public final void pause(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        this.drawable.pause(animationNames, areStateMachines);
    }

    public static /* synthetic */ void pause$default(RiveAnimationView riveAnimationView, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.pause(list, bl);
    }

    public final void pause(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        this.drawable.pause(animationName, isStateMachine);
    }

    public static /* synthetic */ void pause$default(RiveAnimationView riveAnimationView, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.pause(string, bl);
    }

    public final void stop() {
        this.drawable.stopAnimations();
    }

    public final void stop(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        this.drawable.stopAnimations(animationNames, areStateMachines);
    }

    public static /* synthetic */ void stop$default(RiveAnimationView riveAnimationView, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.stop(list, bl);
    }

    public final void stop(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        this.drawable.stopAnimations(animationName, isStateMachine);
    }

    public static /* synthetic */ void stop$default(RiveAnimationView riveAnimationView, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.stop(string, bl);
    }

    public final void play(@NotNull Loop loop, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.drawable.play(loop, direction);
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, Loop loop, Direction direction, int n, Object object) {
        if ((n & 1) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 2) != 0) {
            direction = Direction.AUTO;
        }
        riveAnimationView.play(loop, direction);
    }

    public final void play(@NotNull List<String> animationNames, @NotNull Loop loop, @NotNull Direction direction, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.drawable.play(animationNames, loop, direction, areStateMachines);
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, List list, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        riveAnimationView.play(list, loop, direction, bl);
    }

    public final void play(@NotNull String animationName, @NotNull Loop loop, @NotNull Direction direction, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.drawable.play(animationName, loop, direction, isStateMachine);
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, String string, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        riveAnimationView.play(string, loop, direction, bl);
    }

    public final void reset() {
        Integer n = this.resourceId;
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            boolean bl4 = this.drawable.getAutoplay();
            String string = this.drawable.getStateMachineName();
            String string2 = this.drawable.getAnimationName();
            String string3 = this.drawable.getArtboardName();
            Loop loop = this.drawable.getLoop();
            Alignment alignment = this.drawable.getAlignment();
            Fit fit = this.drawable.getFit();
            this.setRiveResource(it, string3, string2, string, bl4, fit, alignment, loop);
        } else {
            RiveAnimationView riveAnimationView = this;
            boolean bl = false;
            boolean bl5 = false;
            RiveAnimationView $this$run = riveAnimationView;
            boolean bl6 = false;
            $this$run.drawable.reset();
        }
    }

    public final void fireState(@NotNull String stateMachineName, @NotNull String inputName) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        this.drawable.fireState(stateMachineName, inputName);
    }

    public final void setBooleanState(@NotNull String stateMachineName, @NotNull String inputName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        this.drawable.setBooleanState(stateMachineName, inputName, value);
    }

    public final void setNumberState(@NotNull String stateMachineName, @NotNull String inputName, float value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        this.drawable.setNumberState(stateMachineName, inputName, value);
    }

    public final boolean isPlaying() {
        return this.drawable.isPlaying();
    }

    public final void setRiveResource(@RawRes int resId, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, @NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        this.resourceId = resId;
        InputStream inputStream = this.getResources().openRawResource(resId);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resources.openRawResource(resId)");
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        boolean bl = autoplay;
        String string = stateMachineName;
        String string2 = animationName;
        String string3 = artboardName;
        Loop loop2 = loop;
        Alignment alignment2 = alignment;
        Fit fit2 = fit;
        this.setRiveBytes(bytes, string3, string2, string, bl, fit2, alignment2, loop2);
    }

    public static /* synthetic */ void setRiveResource$default(RiveAnimationView riveAnimationView, int n, String string, String string2, String string3, boolean bl, Fit fit, Alignment alignment, Loop loop, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = riveAnimationView.drawable.getAutoplay();
        }
        if ((n2 & 0x20) != 0) {
            fit = Fit.CONTAIN;
        }
        if ((n2 & 0x40) != 0) {
            alignment = Alignment.CENTER;
        }
        if ((n2 & 0x80) != 0) {
            loop = Loop.NONE;
        }
        riveAnimationView.setRiveResource(n, string, string2, string3, bl, fit, alignment, loop);
    }

    public final void setRiveBytes(@NotNull byte[] bytes, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, @NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        File file = new File(bytes);
        boolean bl = autoplay;
        String string = stateMachineName;
        String string2 = animationName;
        String string3 = artboardName;
        Loop loop2 = loop;
        Alignment alignment2 = alignment;
        Fit fit2 = fit;
        this.setRiveFile(file, string3, string2, string, bl, fit2, alignment2, loop2);
    }

    public static /* synthetic */ void setRiveBytes$default(RiveAnimationView riveAnimationView, byte[] byArray, String string, String string2, String string3, boolean bl, Fit fit, Alignment alignment, Loop loop, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            bl = riveAnimationView.drawable.getAutoplay();
        }
        if ((n & 0x20) != 0) {
            fit = Fit.CONTAIN;
        }
        if ((n & 0x40) != 0) {
            alignment = Alignment.CENTER;
        }
        if ((n & 0x80) != 0) {
            loop = Loop.NONE;
        }
        riveAnimationView.setRiveBytes(byArray, string, string2, string3, bl, fit, alignment, loop);
    }

    private final void setRiveFile(File file, String artboardName, String animationName, String stateMachineName, boolean autoplay, Fit fit, Alignment alignment, Loop loop) {
        this.drawable.stop();
        this.drawable.clear();
        this.drawable.setFit(fit);
        this.drawable.setAlignment(alignment);
        this.drawable.setLoop(loop);
        this.drawable.setAutoplay(autoplay);
        this.drawable.setAnimationName(animationName);
        this.drawable.setStateMachineName(stateMachineName);
        this.drawable.setArtboardName(artboardName);
        this.drawable.setRiveFile(file);
        this.setBackground(this.drawable);
        this.requestLayout();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.pause();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int providedWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int providedHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0) {
            providedWidth = this.drawable.getIntrinsicWidth();
        }
        if (heightMode == 0) {
            providedHeight = this.drawable.getIntrinsicHeight();
        }
        AABB usedBounds = Rive.INSTANCE.calculateRequiredBounds(this.drawable.getFit(), this.drawable.getAlignment(), new AABB(providedWidth, providedHeight), this.drawable.arboardBounds());
        int width = 0;
        int height = 0;
        switch (widthMode) {
            case 0x40000000: {
                width = providedWidth;
                break;
            }
            case -2147483648: {
                width = Math.min((int)usedBounds.getWidth(), providedWidth);
                break;
            }
            default: {
                width = (int)usedBounds.getWidth();
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                height = providedHeight;
                break;
            }
            case -2147483648: {
                height = Math.min((int)usedBounds.getHeight(), providedHeight);
                break;
            }
            default: {
                height = (int)usedBounds.getHeight();
            }
        }
        this.setMeasuredDimension(width, height);
    }

    @Override
    public void registerListener(@NotNull RiveDrawable.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.drawable.registerListener(listener);
    }

    @Override
    public void unregisterListener(@NotNull RiveDrawable.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.drawable.unregisterListener(listener);
    }

    public final void destroy() {
        this.drawable.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiveAnimationView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.drawable = new RiveDrawable(null, null, null, null, null, null, false, 127, null);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RiveAnimationView, 0, 0);
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$apply = typedArray;
        boolean bl3 = false;
        try {
            int alignmentIndex = $this$apply.getInteger(R.styleable.RiveAnimationView_riveAlignment, 4);
            int fitIndex = $this$apply.getInteger(R.styleable.RiveAnimationView_riveFit, 1);
            int loopIndex = $this$apply.getInteger(R.styleable.RiveAnimationView_riveLoop, 3);
            boolean autoplay = $this$apply.getBoolean(R.styleable.RiveAnimationView_riveAutoPlay, this.getAutoplay());
            String artboardName = $this$apply.getString(R.styleable.RiveAnimationView_riveArtboard);
            String animationName = $this$apply.getString(R.styleable.RiveAnimationView_riveAnimation);
            String stateMachineName = $this$apply.getString(R.styleable.RiveAnimationView_riveStateMachine);
            int resourceId = $this$apply.getResourceId(R.styleable.RiveAnimationView_riveResource, -1);
            if (resourceId != -1) {
                String string = animationName;
                String string2 = stateMachineName;
                String string3 = artboardName;
                boolean bl4 = autoplay;
                Loop loop = Loop.values()[loopIndex];
                Fit fit = Fit.values()[fitIndex];
                Alignment alignment = Alignment.values()[alignmentIndex];
                this.setRiveResource(resourceId, string3, string, string2, bl4, fit, alignment, loop);
            } else {
                this.drawable.setAlignment(Alignment.values()[alignmentIndex]);
                this.drawable.setFit(Fit.values()[fitIndex]);
                this.drawable.setLoop(Loop.values()[loopIndex]);
                this.drawable.setAutoplay(autoplay);
                this.drawable.setArtboardName(artboardName);
                this.drawable.setAnimationName(animationName);
                this.drawable.setStateMachineName(stateMachineName);
            }
        }
        finally {
            $this$apply.recycle();
        }
    }

    public /* synthetic */ RiveAnimationView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

