/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin;

import android.animation.TimeAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import app.rive.runtime.kotlin.Observable;
import app.rive.runtime.kotlin.core.AABB;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Animation;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LayerState;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.PlayableInstance;
import app.rive.runtime.kotlin.core.Renderer;
import app.rive.runtime.kotlin.core.RiveException;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachine;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0002\u0096\u0001BQ\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00140U2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001c\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00140U2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\f0WH\u0002J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00170U2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\u0014H\u0002J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010\\\u001a\u00020\u0017H\u0002J \u0010]\u001a\u00020Z2\u0006\u0010^\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010]\u001a\u00020Z2\u0006\u0010a\u001a\u00020\u0017H\u0002J.\u0010b\u001a\u00020Z2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010_\u001a\u00020`2\b\b\u0002\u0010c\u001a\u00020\u0010H\u0002J\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00170U2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001c\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00170U2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\f0WH\u0002J\u0010\u0010e\u001a\u00020Z2\u0006\u0010[\u001a\u00020\u0014H\u0002J\u0010\u0010e\u001a\u00020Z2\u0006\u0010\\\u001a\u00020\u0017H\u0002J\u000e\u0010f\u001a\u00020Z2\u0006\u0010g\u001a\u00020hJ\u0006\u0010i\u001a\u00020SJ\u0006\u0010j\u001a\u00020ZJ\u0006\u0010k\u001a\u00020ZJ\u0010\u0010l\u001a\u00020Z2\u0006\u0010m\u001a\u00020nH\u0016J\u0016\u0010o\u001a\u00020Z2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010p\u001a\u00020\fJ\b\u0010q\u001a\u00020rH\u0016J\b\u0010s\u001a\u00020rH\u0016J\b\u0010t\u001a\u00020rH\u0016J\b\u0010u\u001a\u00020\u0010H\u0016J\u0010\u0010v\u001a\u00020Z2\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010y\u001a\u00020Z2\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010z\u001a\u00020Z2\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010{\u001a\u00020Z2\u0006\u0010|\u001a\u00020}H\u0002J\u0010\u0010~\u001a\u00020Z2\u0006\u0010w\u001a\u00020xH\u0002J\u0013\u0010\u007f\u001a\u00020Z2\t\u0010\u0080\u0001\u001a\u0004\u0018\u000101H\u0014J\u0007\u0010\u0081\u0001\u001a\u00020ZJ\u0019\u0010\u0081\u0001\u001a\u00020Z2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010c\u001a\u00020\u0010J \u0010\u0081\u0001\u001a\u00020Z2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\f0U2\t\b\u0002\u0010\u0082\u0001\u001a\u00020\u0010J\u001b\u0010\u0083\u0001\u001a\u00020Z2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010_\u001a\u00020`J-\u0010\u0083\u0001\u001a\u00020Z2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010_\u001a\u00020`2\b\b\u0002\u0010c\u001a\u00020\u0010J4\u0010\u0083\u0001\u001a\u00020Z2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\f0U2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010_\u001a\u00020`2\t\b\u0002\u0010\u0082\u0001\u001a\u00020\u0010J\u0012\u0010\u0084\u0001\u001a\u00020Z2\u0007\u0010\u0085\u0001\u001a\u00020\u0004H\u0016J\u0007\u0010\u0086\u0001\u001a\u00020ZJ\t\u0010\u0087\u0001\u001a\u00020ZH\u0002J\u0012\u0010\u0088\u0001\u001a\u00020Z2\u0007\u0010\u0089\u0001\u001a\u00020rH\u0016J\u0011\u0010\u008a\u0001\u001a\u00020Z2\u0006\u0010(\u001a\u00020)H\u0002J\u0011\u0010\u008b\u0001\u001a\u00020Z2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001f\u0010\u008c\u0001\u001a\u00020Z2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010p\u001a\u00020\f2\u0006\u0010B\u001a\u00020\u0010J\u0015\u0010\u008d\u0001\u001a\u00020Z2\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u0001H\u0016J\u001f\u0010\u0090\u0001\u001a\u00020Z2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010p\u001a\u00020\f2\u0006\u0010B\u001a\u00020hJ\u000f\u0010\u0091\u0001\u001a\u00020Z2\u0006\u00102\u001a\u000203J\t\u0010\u0092\u0001\u001a\u00020ZH\u0016J\t\u0010\u0093\u0001\u001a\u00020ZH\u0016J\u0007\u0010\u0094\u0001\u001a\u00020ZJ\u0019\u0010\u0094\u0001\u001a\u00020Z2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010c\u001a\u00020\u0010J \u0010\u0094\u0001\u001a\u00020Z2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\f0U2\t\b\u0002\u0010\u0082\u0001\u001a\u00020\u0010J\u0012\u0010\u0095\u0001\u001a\u00020Z2\u0007\u0010\u0085\u0001\u001a\u00020\u0004H\u0016R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0013j\b\u0012\u0004\u0012\u00020\u0017`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\r\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001d\"\u0004\b+\u0010\u001fR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b<\u0010-R\u001e\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010ARD\u0010C\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\u0016\u0010B\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00158F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GRD\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0013j\b\u0012\u0004\u0012\u00020\u0017`\u00152\u0016\u0010B\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0013j\b\u0012\u0004\u0012\u00020\u0017`\u00158F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010E\"\u0004\bJ\u0010GR\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u001d\"\u0004\bN\u0010\u001fR \u0010O\u001a\b\u0012\u0004\u0012\u00020\u00170!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010#\"\u0004\bQ\u0010%R\u000e\u0010R\u001a\u00020SX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0097\u0001"}, d2={"Lapp/rive/runtime/kotlin/RiveDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Animatable;", "Lapp/rive/runtime/kotlin/Observable;", "Lapp/rive/runtime/kotlin/RiveDrawable$Listener;", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "artboardName", "", "animationName", "stateMachineName", "autoplay", "", "(Lapp/rive/runtime/kotlin/core/Fit;Lapp/rive/runtime/kotlin/core/Alignment;Lapp/rive/runtime/kotlin/core/Loop;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "_playingAnimations", "Ljava/util/HashSet;", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "Lkotlin/collections/HashSet;", "_playingStateMachines", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "getAnimationName", "()Ljava/lang/String;", "setAnimationName", "(Ljava/lang/String;)V", "animations", "", "getAnimations", "()Ljava/util/List;", "setAnimations", "(Ljava/util/List;)V", "animator", "Landroid/animation/TimeAnimator;", "artboard", "Lapp/rive/runtime/kotlin/core/Artboard;", "getArtboardName", "setArtboardName", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "boundsCache", "Landroid/graphics/Rect;", "file", "Lapp/rive/runtime/kotlin/core/File;", "getFile", "()Lapp/rive/runtime/kotlin/core/File;", "setFile", "(Lapp/rive/runtime/kotlin/core/File;)V", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "isPlaying", "listeners", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "value", "playingAnimations", "getPlayingAnimations", "()Ljava/util/HashSet;", "setPlayingAnimations", "(Ljava/util/HashSet;)V", "playingStateMachines", "getPlayingStateMachines", "setPlayingStateMachines", "renderer", "Lapp/rive/runtime/kotlin/core/Renderer;", "getStateMachineName", "setStateMachineName", "stateMachines", "getStateMachines", "setStateMachines", "targetBounds", "Lapp/rive/runtime/kotlin/core/AABB;", "_animations", "", "animationNames", "", "_getOrCreateStateMachines", "_pause", "", "animation", "stateMachine", "_play", "animationInstance", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "stateMachineInstance", "_playAnimation", "isStateMachine", "_stateMachines", "_stop", "advance", "delta", "", "arboardBounds", "clear", "destroy", "draw", "canvas", "Landroid/graphics/Canvas;", "fireState", "inputName", "getIntrinsicHeight", "", "getIntrinsicWidth", "getOpacity", "isRunning", "notifyLoop", "playableInstance", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "state", "Lapp/rive/runtime/kotlin/core/LayerState;", "notifyStop", "onBoundsChange", "bounds", "pause", "areStateMachines", "play", "registerListener", "listener", "reset", "selectArtboard", "setAlpha", "alpha", "setArtboard", "setArtboardByName", "setBooleanState", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setNumberState", "setRiveFile", "start", "stop", "stopAnimations", "unregisterListener", "Listener", "kotlin_release"})
public final class RiveDrawable
extends Drawable
implements Animatable,
Observable<Listener> {
    private final Renderer renderer;
    private final TimeAnimator animator;
    private HashSet<Listener> listeners;
    private AABB targetBounds;
    private Artboard artboard;
    private Rect boundsCache;
    private HashSet<LinearAnimationInstance> _playingAnimations;
    private HashSet<StateMachineInstance> _playingStateMachines;
    @NotNull
    private List<LinearAnimationInstance> animations;
    @NotNull
    private List<StateMachineInstance> stateMachines;
    @Nullable
    private File file;
    @NotNull
    private Fit fit;
    @NotNull
    private Alignment alignment;
    @NotNull
    private Loop loop;
    @Nullable
    private String artboardName;
    @Nullable
    private String animationName;
    @Nullable
    private String stateMachineName;
    private boolean autoplay;

    @NotNull
    public final List<LinearAnimationInstance> getAnimations() {
        return this.animations;
    }

    public final void setAnimations(@NotNull List<LinearAnimationInstance> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.animations = list;
    }

    @NotNull
    public final List<StateMachineInstance> getStateMachines() {
        return this.stateMachines;
    }

    public final void setStateMachines(@NotNull List<StateMachineInstance> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.stateMachines = list;
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@Nullable File file) {
        this.file = file;
    }

    @NotNull
    public final HashSet<LinearAnimationInstance> getPlayingAnimations() {
        return this._playingAnimations;
    }

    private final void setPlayingAnimations(HashSet<LinearAnimationInstance> value) {
        this._playingAnimations = value;
    }

    @NotNull
    public final HashSet<StateMachineInstance> getPlayingStateMachines() {
        return this._playingStateMachines;
    }

    private final void setPlayingStateMachines(HashSet<StateMachineInstance> value) {
        this._playingStateMachines = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPlaying() {
        Collection collection = this.getPlayingAnimations();
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        collection = this.getPlayingStateMachines();
        bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    public final void advance(float delta) {
        Artboard artboard = this.artboard;
        if (artboard != null) {
            Artboard artboard2 = artboard;
            boolean bl = false;
            boolean bl2 = false;
            Artboard ab = artboard2;
            boolean bl3 = false;
            float elapsed = delta / (float)1000;
            Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.animations);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animationInstance = (LinearAnimationInstance)element$iv;
                boolean bl4 = false;
                if (!this.getPlayingAnimations().contains(animationInstance)) continue;
                Loop looped = animationInstance.advance(elapsed);
                animationInstance.apply(ab, 1.0f);
                if (looped == Loop.ONESHOT) {
                    this._stop(animationInstance);
                    continue;
                }
                if (looped == null) continue;
                this.notifyLoop(animationInstance);
            }
            $this$forEach$iv = CollectionsKt.toList((Iterable)this.stateMachines);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv;
                boolean bl5 = false;
                if (!this.getPlayingStateMachines().contains(stateMachineInstance)) continue;
                boolean stillPlaying = stateMachineInstance.advance(ab, elapsed);
                Iterable $this$forEach$iv2 = stateMachineInstance.getStatesChanged();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    LayerState it = (LayerState)element$iv2;
                    boolean bl6 = false;
                    this.notifyStateChanged(it);
                }
                if (stillPlaying) continue;
                this._pause(stateMachineInstance);
            }
            ab.advance(elapsed);
        }
        if (!this.isPlaying()) {
            this.animator.pause();
        }
        this.invalidateSelf();
    }

    public final void setRiveFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.selectArtboard();
    }

    public final void setArtboardByName(@Nullable String artboardName) {
        block3: {
            File it;
            boolean bl;
            boolean bl2;
            File file;
            block2: {
                this.stop();
                if (this.file != null) break block2;
                this.artboardName = artboardName;
                break block3;
            }
            File file2 = this.file;
            if (file2 != null) {
                file = file2;
                bl2 = false;
                bl = false;
                it = file;
                boolean bl3 = false;
                if (!CollectionsKt.contains((Iterable)it.getArtboardNames(), (Object)artboardName)) {
                    throw (Throwable)new RiveException("Artboard " + artboardName + " not found");
                }
            }
            this.artboardName = artboardName;
            File file3 = this.file;
            if (file3 == null) break block3;
            file = file3;
            bl2 = false;
            bl = false;
            it = file;
            boolean bl4 = false;
            this.setRiveFile(it);
        }
    }

    @NotNull
    public final AABB arboardBounds() {
        AABB output;
        Artboard artboard = this.artboard;
        AABB aABB = output = artboard != null ? artboard.getBounds() : null;
        if (output == null) {
            output = new AABB(0.0f, 0.0f);
        }
        return output;
    }

    public final void clear() {
        this.animator.cancel();
        this.animator.setCurrentPlayTime(0L);
        this.getPlayingAnimations().clear();
        this.animations.clear();
        this.getPlayingStateMachines().clear();
        this.stateMachines.clear();
    }

    public final void reset() {
        this.stop();
        this.clear();
        File file = this.file;
        if (file != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            this.setRiveFile(it);
        }
        this.invalidateSelf();
    }

    public final void destroy() {
        this.stop();
        this.renderer.cleanup();
    }

    public final void play(@NotNull List<String> animationNames, @NotNull Loop loop, @NotNull Direction direction, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Iterable $this$forEach$iv = animationNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this._playAnimation(it, loop, direction, areStateMachines);
        }
        this.animator.start();
    }

    public static /* synthetic */ void play$default(RiveDrawable riveDrawable, List list, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        riveDrawable.play(list, loop, direction, bl);
    }

    public final void play(@NotNull String animationName, @NotNull Loop loop, @NotNull Direction direction, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this._playAnimation(animationName, loop, direction, isStateMachine);
        this.animator.start();
    }

    public static /* synthetic */ void play$default(RiveDrawable riveDrawable, String string, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        riveDrawable.play(string, loop, direction, bl);
    }

    public final void play(@NotNull Loop loop, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Artboard artboard = this.artboard;
        if (artboard != null) {
            Artboard artboard2 = artboard;
            boolean bl = false;
            boolean bl2 = false;
            Artboard it = artboard2;
            boolean bl3 = false;
            Collection collection = it.getAnimationNames();
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                RiveDrawable._playAnimation$default(this, (String)CollectionsKt.first(it.getAnimationNames()), loop, direction, false, 8, null);
            } else {
                collection = it.getStateMachineNames();
                bl4 = false;
                if (!collection.isEmpty()) {
                    this._playAnimation((String)CollectionsKt.first(it.getStateMachineNames()), loop, direction, true);
                }
            }
        }
        this.animator.start();
    }

    public static /* synthetic */ void play$default(RiveDrawable riveDrawable, Loop loop, Direction direction, int n, Object object) {
        if ((n & 1) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 2) != 0) {
            direction = Direction.AUTO;
        }
        riveDrawable.play(loop, direction);
    }

    public final void pause() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.getPlayingAnimations());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this._pause(animation);
        }
        $this$forEach$iv = CollectionsKt.toList((Iterable)this.getPlayingStateMachines());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
            boolean bl = false;
            this._pause(stateMachine);
        }
    }

    public final void pause(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this._stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._pause(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._pause(animation);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveDrawable riveDrawable, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveDrawable.pause(list, bl);
    }

    public final void pause(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this._stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._pause(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._pause(animation);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveDrawable riveDrawable, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveDrawable.pause(string, bl);
    }

    public final void stopAnimations() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.animations);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this._stop(animation);
        }
        $this$forEach$iv = CollectionsKt.toList((Iterable)this.stateMachines);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
            boolean bl = false;
            this._stop(stateMachine);
        }
    }

    public final void stopAnimations(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this._stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._stop(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._stop(animation);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveDrawable riveDrawable, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveDrawable.stopAnimations(list, bl);
    }

    public final void stopAnimations(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this._stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._stop(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._stop(animation);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveDrawable riveDrawable, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveDrawable.stopAnimations(string, bl);
    }

    public final void fireState(@NotNull String stateMachineName, @NotNull String inputName) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            if (sMIInput == null) {
                throw new NullPointerException("null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMITrigger");
            }
            ((SMITrigger)sMIInput).fire();
            this._play(it);
        }
        this.animator.start();
    }

    public final void setBooleanState(@NotNull String stateMachineName, @NotNull String inputName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            if (sMIInput == null) {
                throw new NullPointerException("null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMIBoolean");
            }
            ((SMIBoolean)sMIInput).setValue(value);
            this._play(it);
        }
        this.animator.start();
    }

    public final void setNumberState(@NotNull String stateMachineName, @NotNull String inputName, float value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            if (sMIInput == null) {
                throw new NullPointerException("null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMINumber");
            }
            ((SMINumber)sMIInput).setValue(value);
            this._play(it);
        }
        this.animator.start();
    }

    private final List<LinearAnimationInstance> _animations(String animationName) {
        return this._animations(CollectionsKt.listOf((Object)animationName));
    }

    private final List<StateMachineInstance> _stateMachines(String animationName) {
        return this._stateMachines(CollectionsKt.listOf((Object)animationName));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LinearAnimationInstance> _animations(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.animations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LinearAnimationInstance animationInstance = (LinearAnimationInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(animationInstance.getAnimation().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StateMachineInstance> _stateMachines(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.stateMachines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(stateMachineInstance.getStateMachine().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<StateMachineInstance> _getOrCreateStateMachines(String animationName) {
        List<StateMachineInstance> stateMachineInstances = this._stateMachines(animationName);
        if (stateMachineInstances.isEmpty()) {
            Artboard artboard = this.artboard;
            if (artboard != null) {
                Artboard artboard2 = artboard;
                boolean bl = false;
                boolean bl2 = false;
                Artboard it = artboard2;
                boolean bl3 = false;
                StateMachine stateMachine = it.stateMachine(animationName);
                StateMachineInstance stateMachineInstance = new StateMachineInstance(stateMachine);
                this.stateMachines.add(stateMachineInstance);
                return CollectionsKt.listOf((Object)stateMachineInstance);
            }
        }
        return stateMachineInstances;
    }

    private final void _playAnimation(String animationName, Loop loop, Direction direction, boolean isStateMachine) {
        block4: {
            block3: {
                if (!isStateMachine) break block3;
                List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(animationName);
                Iterable $this$forEach$iv = stateMachineInstances;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv;
                    boolean bl = false;
                    this._play(stateMachineInstance);
                }
                break block4;
            }
            List<LinearAnimationInstance> animationInstances = this._animations(animationName);
            Iterable $this$forEach$iv = animationInstances;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animationInstance = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._play(animationInstance, loop, direction);
            }
            if (!animationInstances.isEmpty()) break block4;
            Artboard artboard = this.artboard;
            if (artboard != null) {
                Artboard artboard2 = artboard;
                boolean bl = false;
                boolean bl2 = false;
                Artboard it = artboard2;
                boolean bl3 = false;
                Animation animation = it.animation(animationName);
                LinearAnimationInstance linearAnimation = new LinearAnimationInstance(animation);
                this._play(linearAnimation, loop, direction);
            }
        }
    }

    static /* synthetic */ void _playAnimation$default(RiveDrawable riveDrawable, String string, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        riveDrawable._playAnimation(string, loop, direction, bl);
    }

    private final void _play(StateMachineInstance stateMachineInstance) {
        if (!this.stateMachines.contains(stateMachineInstance)) {
            this.stateMachines.add(stateMachineInstance);
        }
        this.getPlayingStateMachines().add(stateMachineInstance);
        this.notifyPlay(stateMachineInstance);
    }

    private final void _play(LinearAnimationInstance animationInstance, Loop loop, Direction direction) {
        Loop appliedLoop;
        Loop loop2 = appliedLoop = loop == Loop.NONE ? this.loop : loop;
        if (appliedLoop != Loop.NONE) {
            animationInstance.setLoop(appliedLoop);
        }
        if (!this.animations.contains(animationInstance)) {
            if (direction == Direction.BACKWARDS) {
                animationInstance.time(animationInstance.getAnimation().getEndTime());
            }
            this.animations.add(animationInstance);
        }
        if (direction != Direction.AUTO) {
            animationInstance.setDirection(direction);
        }
        this.getPlayingAnimations().add(animationInstance);
        this.notifyPlay(animationInstance);
    }

    private final void _pause(LinearAnimationInstance animation) {
        boolean removed = this.getPlayingAnimations().remove(animation);
        if (removed) {
            this.notifyPause(animation);
        }
    }

    private final void _pause(StateMachineInstance stateMachine) {
        boolean removed = this.getPlayingStateMachines().remove(stateMachine);
        if (removed) {
            this.notifyPause(stateMachine);
        }
    }

    private final void _stop(LinearAnimationInstance animation) {
        this.getPlayingAnimations().remove(animation);
        boolean removed = this.animations.remove(animation);
        if (removed) {
            this.notifyStop(animation);
        }
    }

    private final void _stop(StateMachineInstance stateMachine) {
        this.getPlayingStateMachines().remove(stateMachine);
        boolean removed = this.stateMachines.remove(stateMachine);
        if (removed) {
            this.notifyStop(stateMachine);
        }
    }

    private final void selectArtboard() {
        block2: {
            File file = this.file;
            if (file == null) break block2;
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File file3 = file2;
            boolean bl3 = false;
            String string = this.artboardName;
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                this.setArtboard(file3.artboard(it));
            } else {
                RiveDrawable riveDrawable = this;
                boolean bl7 = false;
                boolean bl8 = false;
                RiveDrawable $this$run = riveDrawable;
                boolean bl9 = false;
                $this$run.setArtboard(file3.getFirstArtboard());
            }
        }
    }

    private final void setArtboard(Artboard artboard) {
        this.artboard = artboard;
        if (this.autoplay) {
            String string = this.animationName;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                RiveDrawable.play$default(this, it, null, null, false, 14, null);
            } else {
                RiveDrawable riveDrawable = this;
                boolean bl = false;
                boolean bl4 = false;
                RiveDrawable $this$run = riveDrawable;
                boolean bl5 = false;
                String string3 = $this$run.stateMachineName;
                if (string3 != null) {
                    String string4 = string3;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    String it = string4;
                    boolean bl8 = false;
                    RiveDrawable.play$default($this$run, it, null, null, true, 6, null);
                } else {
                    RiveDrawable riveDrawable2 = $this$run;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    RiveDrawable $this$run2 = riveDrawable2;
                    boolean bl11 = false;
                    RiveDrawable.play$default($this$run2, null, null, 3, null);
                }
            }
        } else {
            artboard.advance(0.0f);
        }
    }

    protected void onBoundsChange(@Nullable Rect bounds) {
        block0: {
            super.onBoundsChange(bounds);
            Rect rect = bounds;
            if (rect == null) break block0;
            Rect rect2 = rect;
            boolean bl = false;
            boolean bl2 = false;
            Rect it = rect2;
            boolean bl3 = false;
            this.targetBounds = new AABB(bounds.width(), bounds.height());
        }
    }

    public void draw(@NotNull Canvas canvas) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Artboard artboard = this.artboard;
            if (artboard == null) break block1;
            Artboard artboard2 = artboard;
            boolean bl = false;
            boolean bl2 = false;
            Artboard ab = artboard2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)this.boundsCache, (Object)this.getBounds()) ^ true) {
                this.boundsCache = this.getBounds();
                this.targetBounds = new AABB(this.getBounds().width(), this.getBounds().height());
            }
            this.renderer.setCanvas(canvas);
            this.renderer.align(this.fit, this.alignment, this.targetBounds, ab.getBounds());
            int saved = canvas.save();
            ab.draw(this.renderer);
            canvas.restoreToCount(saved);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        Object object = this.artboard;
        return object != null && (object = ((Artboard)object).getBounds()) != null ? (int)((AABB)object).getWidth() : -1;
    }

    public int getIntrinsicHeight() {
        Object object = this.artboard;
        return object != null && (object = ((Artboard)object).getBounds()) != null ? (int)((AABB)object).getHeight() : -1;
    }

    public void start() {
        this.animator.start();
    }

    public void stop() {
        this.stopAnimations();
        this.animator.cancel();
    }

    public boolean isRunning() {
        return this.isPlaying();
    }

    @Override
    public void registerListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    private final void notifyPlay(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPlay(playableInstance);
        }
    }

    private final void notifyPause(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPause(playableInstance);
        }
    }

    private final void notifyStop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStop(playableInstance);
        }
    }

    private final void notifyLoop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyLoop(playableInstance);
        }
    }

    private final void notifyStateChanged(LayerState state) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStateChanged(state);
        }
    }

    @NotNull
    public final Fit getFit() {
        return this.fit;
    }

    public final void setFit(@NotNull Fit fit) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"<set-?>");
        this.fit = fit;
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final void setAlignment(@NotNull Alignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"<set-?>");
        this.alignment = alignment;
    }

    @NotNull
    public final Loop getLoop() {
        return this.loop;
    }

    public final void setLoop(@NotNull Loop loop) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"<set-?>");
        this.loop = loop;
    }

    @Nullable
    public final String getArtboardName() {
        return this.artboardName;
    }

    public final void setArtboardName(@Nullable String string) {
        this.artboardName = string;
    }

    @Nullable
    public final String getAnimationName() {
        return this.animationName;
    }

    public final void setAnimationName(@Nullable String string) {
        this.animationName = string;
    }

    @Nullable
    public final String getStateMachineName() {
        return this.stateMachineName;
    }

    public final void setStateMachineName(@Nullable String string) {
        this.stateMachineName = string;
    }

    public final boolean getAutoplay() {
        return this.autoplay;
    }

    public final void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    public RiveDrawable(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        this.fit = fit;
        this.alignment = alignment;
        this.loop = loop;
        this.artboardName = artboardName;
        this.animationName = animationName;
        this.stateMachineName = stateMachineName;
        this.autoplay = autoplay;
        this.renderer = new Renderer(false, 1, null);
        this.animator = new TimeAnimator();
        this.listeners = new HashSet();
        this._playingAnimations = new HashSet();
        this._playingStateMachines = new HashSet();
        boolean bl = false;
        this.animations = new ArrayList();
        bl = false;
        this.stateMachines = new ArrayList();
        this.targetBounds = new AABB(this.getBounds().width(), this.getBounds().height());
        this.animator.setTimeListener(new TimeAnimator.TimeListener(){

            public final void onTimeUpdate(TimeAnimator $noName_0, long $noName_1, long delta) {
                this.advance(delta);
            }
        });
    }

    public /* synthetic */ RiveDrawable(Fit fit, Alignment alignment, Loop loop, String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fit = Fit.CONTAIN;
        }
        if ((n & 2) != 0) {
            alignment = Alignment.CENTER;
        }
        if ((n & 4) != 0) {
            loop = Loop.NONE;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        this(fit, alignment, loop, string, string2, string3, bl);
    }

    public RiveDrawable() {
        this(null, null, null, null, null, null, false, 127, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\f"}, d2={"Lapp/rive/runtime/kotlin/RiveDrawable$Listener;", "", "notifyLoop", "", "animation", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "state", "Lapp/rive/runtime/kotlin/core/LayerState;", "notifyStop", "kotlin_release"})
    public static interface Listener {
        public void notifyPlay(@NotNull PlayableInstance var1);

        public void notifyPause(@NotNull PlayableInstance var1);

        public void notifyStop(@NotNull PlayableInstance var1);

        public void notifyLoop(@NotNull PlayableInstance var1);

        public void notifyStateChanged(@NotNull LayerState var1);
    }
}

