/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.Loop;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010#\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010$\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010%\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010&\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010'\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010(\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\b\u0010)\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u001f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0011\u0010!\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\n\u00a8\u0006*"}, d2={"Lapp/rive/runtime/kotlin/core/Animation;", "", "cppPointer", "", "(J)V", "getCppPointer", "()J", "duration", "", "getDuration", "()I", "effectiveDuration", "getEffectiveDuration", "effectiveDurationInSeconds", "", "getEffectiveDurationInSeconds", "()F", "endTime", "getEndTime", "fps", "getFps", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "name", "", "getName", "()Ljava/lang/String;", "startTime", "getStartTime", "workEnd", "getWorkEnd", "workStart", "getWorkStart", "cppDuration", "cppFps", "cppGetLoop", "cppName", "cppWorkEnd", "cppWorkStart", "toString", "kotlin_release"})
public final class Animation {
    private final long cppPointer;

    private final native String cppName(long var1);

    private final native int cppDuration(long var1);

    private final native int cppFps(long var1);

    private final native int cppWorkStart(long var1);

    private final native int cppWorkEnd(long var1);

    private final native int cppGetLoop(long var1);

    public final int getDuration() {
        return this.cppDuration(this.cppPointer);
    }

    public final int getEffectiveDuration() {
        if (this.getWorkStart() == -1) {
            return this.getDuration();
        }
        return this.getWorkEnd() - this.getWorkStart();
    }

    public final float getEffectiveDurationInSeconds() {
        return (float)this.getEffectiveDuration() / (float)this.getFps();
    }

    public final int getFps() {
        return this.cppFps(this.cppPointer);
    }

    public final int getWorkStart() {
        return this.cppWorkStart(this.cppPointer);
    }

    public final int getWorkEnd() {
        return this.cppWorkEnd(this.cppPointer);
    }

    @NotNull
    public final String getName() {
        return this.cppName(this.cppPointer);
    }

    public final float getStartTime() {
        return this.getWorkStart() == -1 ? 0.0f : (float)this.getWorkStart() / (float)this.getFps();
    }

    public final float getEndTime() {
        return this.getWorkEnd() == -1 ? (float)this.getDuration() / (float)this.getFps() : (float)this.getWorkEnd() / (float)this.getFps();
    }

    @NotNull
    public final Loop getLoop() {
        int intLoop = this.cppGetLoop(this.cppPointer);
        Loop loop = Loop.Companion.fromInt(intLoop);
        if (loop == null) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        Loop loop2 = loop;
        return loop2;
    }

    @NotNull
    public String toString() {
        return "Animation " + this.getName() + "\n- Duration" + this.getDuration() + "\n- fps " + this.getFps() + "\n- workStart " + this.getWorkStart() + "\n- workEnd " + this.getWorkEnd();
    }

    public final long getCppPointer() {
        return this.cppPointer;
    }

    public Animation(long cppPointer) {
        this.cppPointer = cppPointer;
    }
}

