/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.graphics.Canvas;
import app.rive.runtime.kotlin.core.AABB;
import app.rive.runtime.kotlin.core.Animation;
import app.rive.runtime.kotlin.core.Renderer;
import app.rive.runtime.kotlin.core.RiveException;
import app.rive.runtime.kotlin.core.StateMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000bJ\u0019\u0010)\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0082 J\u0019\u0010*\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0006H\u0082 J\u0019\u0010+\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u000bH\u0082 J\u0011\u0010,\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010-\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J)\u0010.\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0082 J\u0011\u00104\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u00105\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u00106\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0019\u00107\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0006H\u0082 J\u0019\u00108\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u000bH\u0082 J\u0011\u00109\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u000e\u0010:\u001a\u00020$2\u0006\u00100\u001a\u000201J\u000e\u0010;\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010;\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\r\u00a8\u0006<"}, d2={"Lapp/rive/runtime/kotlin/core/Artboard;", "", "cppPointer", "", "(J)V", "animationCount", "", "getAnimationCount", "()I", "animationNames", "", "", "getAnimationNames", "()Ljava/util/List;", "bounds", "Lapp/rive/runtime/kotlin/core/AABB;", "getBounds", "()Lapp/rive/runtime/kotlin/core/AABB;", "getCppPointer", "()J", "firstAnimation", "Lapp/rive/runtime/kotlin/core/Animation;", "getFirstAnimation", "()Lapp/rive/runtime/kotlin/core/Animation;", "firstStateMachine", "Lapp/rive/runtime/kotlin/core/StateMachine;", "getFirstStateMachine", "()Lapp/rive/runtime/kotlin/core/StateMachine;", "name", "getName", "()Ljava/lang/String;", "stateMachineCount", "getStateMachineCount", "stateMachineNames", "getStateMachineNames", "advance", "", "elapsedTime", "", "animation", "index", "cppAdvance", "cppAnimationByIndex", "cppAnimationByName", "cppAnimationCount", "cppBounds", "cppDraw", "rendererPointer", "renderer", "Lapp/rive/runtime/kotlin/core/Renderer;", "canvas", "Landroid/graphics/Canvas;", "cppFirstAnimation", "cppFirstStateMachine", "cppName", "cppStateMachineByIndex", "cppStateMachineByName", "cppStateMachineCount", "draw", "stateMachine", "kotlin_release"})
public final class Artboard {
    private final long cppPointer;

    private final native String cppName(long var1);

    private final native long cppFirstAnimation(long var1);

    private final native long cppAnimationByIndex(long var1, int var3);

    private final native long cppAnimationByName(long var1, String var3);

    private final native int cppAnimationCount(long var1);

    private final native long cppFirstStateMachine(long var1);

    private final native long cppStateMachineByIndex(long var1, int var3);

    private final native long cppStateMachineByName(long var1, String var3);

    private final native int cppStateMachineCount(long var1);

    private final native void cppAdvance(long var1, float var3);

    private final native void cppDraw(long var1, long var3, Renderer var5, Canvas var6);

    private final native long cppBounds(long var1);

    @NotNull
    public final String getName() {
        return this.cppName(this.cppPointer);
    }

    @NotNull
    public final Animation getFirstAnimation() throws RiveException {
        long animationPointer = this.cppFirstAnimation(this.cppPointer);
        if (animationPointer == 0L) {
            throw (Throwable)new RiveException("No Animations found.");
        }
        return new Animation(animationPointer);
    }

    @NotNull
    public final Animation animation(int index) throws RiveException {
        long animationPointer = this.cppAnimationByIndex(this.cppPointer, index);
        if (animationPointer == 0L) {
            throw (Throwable)new RiveException("No Animation found at index " + index + '.');
        }
        return new Animation(animationPointer);
    }

    @NotNull
    public final Animation animation(@NotNull String name) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long animationPointer = this.cppAnimationByName(this.cppPointer, name);
        if (animationPointer == 0L) {
            throw (Throwable)new RiveException("No Animation found with name " + name + '.');
        }
        return new Animation(animationPointer);
    }

    @NotNull
    public final StateMachine getFirstStateMachine() throws RiveException {
        long stateMachinePointer = this.cppFirstStateMachine(this.cppPointer);
        if (stateMachinePointer == 0L) {
            throw (Throwable)new RiveException("No StateMachines found.");
        }
        return new StateMachine(stateMachinePointer);
    }

    @NotNull
    public final StateMachine stateMachine(int index) throws RiveException {
        long stateMachinePointer = this.cppStateMachineByIndex(this.cppPointer, index);
        if (stateMachinePointer == 0L) {
            throw (Throwable)new RiveException("No StateMachine found at index " + index + '.');
        }
        return new StateMachine(stateMachinePointer);
    }

    @NotNull
    public final StateMachine stateMachine(@NotNull String name) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long stateMachinePointer = this.cppStateMachineByName(this.cppPointer, name);
        if (stateMachinePointer == 0L) {
            throw (Throwable)new RiveException("No StateMachine found with name " + name + '.');
        }
        return new StateMachine(stateMachinePointer);
    }

    public final int getAnimationCount() {
        return this.cppAnimationCount(this.cppPointer);
    }

    public final int getStateMachineCount() {
        return this.cppStateMachineCount(this.cppPointer);
    }

    public final void advance(float elapsedTime) {
        this.cppAdvance(this.cppPointer, elapsedTime);
    }

    public final void draw(@NotNull Renderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this.cppDraw(this.cppPointer, renderer.getCppPointer(), renderer, renderer.getCanvas());
    }

    @NotNull
    public final AABB getBounds() {
        return new AABB(this.cppBounds(this.cppPointer));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAnimationNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getAnimationCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.animation((int)it).getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStateMachineNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateMachineCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.stateMachine((int)it).getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public final long getCppPointer() {
        return this.cppPointer;
    }

    public Artboard(long cppPointer) {
        this.cppPointer = cppPointer;
    }
}

