/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import app.rive.runtime.kotlin.core.AABB;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0012J\u0011\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0082 J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u0011\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J1\u0010 \u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0082 J\u0016\u0010#\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u0012J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Lapp/rive/runtime/kotlin/core/Renderer;", "", "antialias", "", "(Z)V", "canvas", "Landroid/graphics/Canvas;", "getCanvas", "()Landroid/graphics/Canvas;", "setCanvas", "(Landroid/graphics/Canvas;)V", "cppPointer", "", "getCppPointer", "()J", "setCppPointer", "(J)V", "align", "", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "targetBounds", "Lapp/rive/runtime/kotlin/core/AABB;", "sourceBounds", "cleanup", "cleanupJNI", "clipPath", "path", "Landroid/graphics/Path;", "constructor", "cppAlign", "targetBoundsPointer", "srcBoundsPointer", "drawPath", "paint", "Landroid/graphics/Paint;", "restore", "save", "", "setMatrix", "matrix", "Landroid/graphics/Matrix;", "translate", "dx", "", "dy", "kotlin_release"})
public final class Renderer {
    private long cppPointer;
    public Canvas canvas;

    public final long getCppPointer() {
        return this.cppPointer;
    }

    public final void setCppPointer(long l) {
        this.cppPointer = l;
    }

    @NotNull
    public final Canvas getCanvas() {
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
        }
        return canvas;
    }

    public final void setCanvas(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"<set-?>");
        this.canvas = canvas;
    }

    private final native void cppAlign(long var1, Fit var3, Alignment var4, long var5, long var7);

    private final native long constructor(boolean var1);

    private final native void cleanupJNI(long var1);

    public final void setMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
        }
        canvas.concat(matrix);
    }

    public final void align(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull AABB targetBounds, @NotNull AABB sourceBounds) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)targetBounds, (String)"targetBounds");
        Intrinsics.checkNotNullParameter((Object)sourceBounds, (String)"sourceBounds");
        this.cppAlign(this.cppPointer, fit, alignment, targetBounds.getCppPointer(), sourceBounds.getCppPointer());
    }

    public final void cleanup() {
        this.cleanupJNI(this.cppPointer);
        this.cppPointer = 0L;
    }

    public final int save() {
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
        }
        return canvas.save();
    }

    public final void restore() {
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
        }
        canvas.restore();
    }

    public final void translate(float dx, float dy) {
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
        }
        canvas.translate(dx, dy);
    }

    public final void drawPath(@NotNull Path path, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
        }
        canvas.drawPath(path, paint);
    }

    public final boolean clipPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
        }
        return canvas.clipPath(path);
    }

    public Renderer(boolean antialias) {
        this.cppPointer = this.constructor(antialias);
    }

    public /* synthetic */ Renderer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public Renderer() {
        this(false, 1, null);
    }
}

