/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.RiveException;
import app.rive.runtime.kotlin.core.StateMachineBooleanInput;
import app.rive.runtime.kotlin.core.StateMachineInput;
import app.rive.runtime.kotlin.core.StateMachineNumberInput;
import app.rive.runtime.kotlin.core.StateMachineTriggerInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011J\u0011\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0019\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\bH\u0082 J\u0019\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\rH\u0082 J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010 \u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lapp/rive/runtime/kotlin/core/StateMachine;", "", "cppPointer", "", "(J)V", "getCppPointer", "()J", "inputCount", "", "getInputCount", "()I", "inputNames", "", "", "getInputNames", "()Ljava/util/List;", "inputs", "Lapp/rive/runtime/kotlin/core/StateMachineInput;", "getInputs", "layerCount", "getLayerCount", "name", "getName", "()Ljava/lang/String;", "_convertInput", "input", "cppInputCount", "cppLayerCount", "cppName", "cppStateMachineInputByIndex", "index", "cppStateMachineInputByName", "toString", "kotlin_release"})
public final class StateMachine {
    private final long cppPointer;

    private final native String cppName(long var1);

    private final native int cppInputCount(long var1);

    private final native int cppLayerCount(long var1);

    private final native long cppStateMachineInputByIndex(long var1, int var3);

    private final native long cppStateMachineInputByName(long var1, String var3);

    @NotNull
    public final String getName() {
        return this.cppName(this.cppPointer);
    }

    public final int getInputCount() {
        return this.cppInputCount(this.cppPointer);
    }

    public final int getLayerCount() {
        return this.cppLayerCount(this.cppPointer);
    }

    @NotNull
    public final StateMachineInput _convertInput(@NotNull StateMachineInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input.isBoolean()) {
            return new StateMachineBooleanInput(input.getCppPointer());
        }
        if (input.isTrigger()) {
            return new StateMachineTriggerInput(input.getCppPointer());
        }
        if (input.isNumber()) {
            return new StateMachineNumberInput(input.getCppPointer());
        }
        throw (Throwable)new RiveException("Unknown State Machine Input for " + input.getName() + '.');
    }

    @NotNull
    public final StateMachineInput input(int index) throws RiveException {
        long stateMachineInputPointer = this.cppStateMachineInputByIndex(this.cppPointer, index);
        if (stateMachineInputPointer == 0L) {
            throw (Throwable)new RiveException("No StateMachineInput found at index " + index + '.');
        }
        return this._convertInput(new StateMachineInput(stateMachineInputPointer));
    }

    @NotNull
    public final StateMachineInput input(@NotNull String name) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long stateMachineInputPointer = this.cppStateMachineInputByName(this.cppPointer, name);
        if (stateMachineInputPointer == 0L) {
            throw (Throwable)new RiveException("No StateMachineInput found with name " + name + '.');
        }
        return this._convertInput(new StateMachineInput(stateMachineInputPointer));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<StateMachineInput> getInputs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StateMachineInput stateMachineInput = this.input((int)it);
            collection.add(stateMachineInput);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getInputNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.input((int)it).getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return "StateMachine " + this.getName() + '\n';
    }

    public final long getCppPointer() {
        return this.cppPointer;
    }

    public StateMachine(long cppPointer) {
        this.cppPointer = cppPointer;
    }
}

