/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.AnimationState;
import app.rive.runtime.kotlin.core.AnyState;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.BlendState;
import app.rive.runtime.kotlin.core.EntryState;
import app.rive.runtime.kotlin.core.ExitState;
import app.rive.runtime.kotlin.core.LayerState;
import app.rive.runtime.kotlin.core.PlayableInstance;
import app.rive.runtime.kotlin.core.RiveException;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0011\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0082 J!\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0082 J\u0011\u0010)\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0082 J\u0019\u0010*\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\bH\u0082 J\u0019\u0010,\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\bH\u0082 J\u0011\u0010-\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0082 J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\rJ\u000e\u0010/\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\u00a8\u00060"}, d2={"Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "stateMachine", "Lapp/rive/runtime/kotlin/core/StateMachine;", "(Lapp/rive/runtime/kotlin/core/StateMachine;)V", "cppPointer", "", "inputCount", "", "getInputCount", "()I", "inputNames", "", "", "getInputNames", "()Ljava/util/List;", "inputs", "Lapp/rive/runtime/kotlin/core/SMIInput;", "getInputs", "stateChangedCount", "getStateChangedCount", "getStateMachine", "()Lapp/rive/runtime/kotlin/core/StateMachine;", "statesChanged", "Lapp/rive/runtime/kotlin/core/LayerState;", "getStatesChanged", "_convertInput", "input", "_convertLayerState", "state", "advance", "", "artboard", "Lapp/rive/runtime/kotlin/core/Artboard;", "elapsedTime", "", "constructor", "stateMachinePointer", "cppAdvance", "pointer", "artboardPointer", "cppInputCount", "cppSMIInputByIndex", "index", "cppStateChangedByIndex", "cppStateChangedCount", "name", "stateChanged", "kotlin_release"})
public final class StateMachineInstance
extends PlayableInstance {
    private long cppPointer;
    @NotNull
    private final StateMachine stateMachine;

    private final native long constructor(long var1);

    private final native boolean cppAdvance(long var1, long var3, float var5);

    private final native int cppInputCount(long var1);

    private final native long cppSMIInputByIndex(long var1, int var3);

    private final native int cppStateChangedCount(long var1);

    private final native long cppStateChangedByIndex(long var1, int var3);

    public final boolean advance(@NotNull Artboard artboard, float elapsedTime) {
        Intrinsics.checkNotNullParameter((Object)artboard, (String)"artboard");
        return this.cppAdvance(this.cppPointer, artboard.getCppPointer(), elapsedTime);
    }

    public final int getInputCount() {
        return this.cppInputCount(this.cppPointer);
    }

    public final int getStateChangedCount() {
        return this.cppStateChangedCount(this.cppPointer);
    }

    @NotNull
    public final SMIInput _convertInput(@NotNull SMIInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input.isBoolean()) {
            return new SMIBoolean(input.getCppPointer());
        }
        if (input.isTrigger()) {
            return new SMITrigger(input.getCppPointer());
        }
        if (input.isNumber()) {
            return new SMINumber(input.getCppPointer());
        }
        throw (Throwable)new RiveException("Unknown State Machine Input Instance for " + input.getName() + '.');
    }

    @NotNull
    public final SMIInput input(int index) throws RiveException {
        long stateMachineInputPointer = this.cppSMIInputByIndex(this.cppPointer, index);
        if (stateMachineInputPointer == 0L) {
            throw (Throwable)new RiveException("No StateMachineInput found at index " + index + '.');
        }
        return this._convertInput(new SMIInput(stateMachineInputPointer));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SMIInput input(@NotNull String name) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = 0;
        int n2 = this.getInputCount();
        while (n < n2) {
            void i;
            SMIInput output = this.input((int)i);
            if (Intrinsics.areEqual((Object)output.getName(), (Object)name)) {
                return output;
            }
            ++i;
        }
        throw (Throwable)new RiveException("No StateMachineInput found with name " + name + '.');
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SMIInput> getInputs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SMIInput sMIInput = this.input((int)it);
            collection.add(sMIInput);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getInputNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.input((int)it).getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LayerState _convertLayerState(@NotNull LayerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.isAnimationState()) {
            return new AnimationState(state.getCppPointer());
        }
        if (state.isAnyState()) {
            return new AnyState(state.getCppPointer());
        }
        if (state.isEntryState()) {
            return new EntryState(state.getCppPointer());
        }
        if (state.isExitState()) {
            return new ExitState(state.getCppPointer());
        }
        if (state.isBlendState()) {
            return new BlendState(state.getCppPointer());
        }
        throw (Throwable)new RiveException("Unknown Layer State for " + state + '.');
    }

    @NotNull
    public final LayerState stateChanged(int index) throws RiveException {
        long stateChanged = this.cppStateChangedByIndex(this.cppPointer, index);
        if (stateChanged == 0L) {
            throw (Throwable)new RiveException("No StateMachineInput found at index " + index + '.');
        }
        return this._convertLayerState(new LayerState(stateChanged));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LayerState> getStatesChanged() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateChangedCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LayerState layerState = this.stateChanged((int)it);
            collection.add(layerState);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public StateMachineInstance(@NotNull StateMachine stateMachine) {
        Intrinsics.checkNotNullParameter((Object)stateMachine, (String)"stateMachine");
        this.stateMachine = stateMachine;
        this.cppPointer = this.constructor(this.stateMachine.getCppPointer());
    }
}

