/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.graphics.RectF;
import androidx.annotation.OpenForTesting;
import androidx.annotation.WorkerThread;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RiveTextValueRun;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.core.errors.AnimationException;
import app.rive.runtime.kotlin.core.errors.StateMachineException;
import app.rive.runtime.kotlin.core.errors.StateMachineInputException;
import app.rive.runtime.kotlin.core.errors.TextValueRunException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010 \n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0019\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0092 J\u0019\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tH\u0092 J\u0011\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0019\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0092 J\u0019\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0092 J\u0019\u0010\u0013\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tH\u0092 J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0019\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0092 J!\u0010\u0016\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0092 J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0019\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0019H\u0092 J\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0019H\u0092 J\u0019\u0010 \u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tH\u0092 J\u001b\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tH\u0092 J!\u0010\"\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0092 J!\u0010$\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0092 J#\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0092 J)\u0010&\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0092 J\u0019\u0010'\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0092 J1\u0010)\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0019H\u0092 J\u0011\u0010/\u001a\u0002002\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0011\u00101\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0011\u00102\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0019\u00103\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0019H\u0092 J\u0011\u00105\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0003H\u0092 J\u0019\u00106\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0019H\u0092 J\u0011\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u0003H\u0096 J\u0010\u0010@\u001a\u00020=2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010@\u001a\u00020=2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010E\u001a\u00020B2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010E\u001a\u00020B2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010F\u001a\u00020G2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010K\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010L\u001a\u00020\tH\u0016J\u0018\u0010H\u001a\u00020I2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u001a\u0010J\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J \u0010K\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010L\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010W\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u0010X\u001a\u00020\u001b2\u0006\u0010Y\u001a\u00020\u0003H\u0017J*\u0010X\u001a\u00020\u001b2\u0006\u0010Y\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u0019H\u0017J\b\u0010Z\u001a\u00020\u001bH\u0016J\u0010\u0010h\u001a\u00020G2\u0006\u0010F\u001a\u00020GH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010A\u001a\u00020B8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR$\u0010\u001c\u001a\u00020\u00192\u0006\u0010M\u001a\u00020\u00198V@PX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u0014\u0010R\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0014\u0010U\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010TR\u0014\u0010[\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R$\u00104\u001a\u00020\u00192\u0006\u0010M\u001a\u00020\u00198V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010O\"\u0004\b_\u0010QR$\u00107\u001a\u00020\u00192\u0006\u0010M\u001a\u00020\u00198V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b`\u0010O\"\u0004\ba\u0010QR\u001a\u0010b\u001a\b\u0012\u0004\u0012\u00020\t0c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\u001a\u0010f\u001a\b\u0012\u0004\u0012\u00020\t0c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010e\u00a8\u0006i"}, d2={"Lapp/rive/runtime/kotlin/core/Artboard;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "<init>", "(JLjava/util/concurrent/locks/ReentrantLock;)V", "cppName", "", "cppPointer", "cppAnimationByIndex", "index", "", "cppAnimationByName", "name", "cppAnimationCount", "cppAnimationNameByIndex", "cppStateMachineByIndex", "cppStateMachineByName", "cppStateMachineCount", "cppStateMachineNameByIndex", "cppInputByNameAtPath", "path", "cppGetVolume", "", "cppSetVolume", "", "volume", "cppAdvance", "", "elapsedTime", "cppFindTextValueRun", "cppFindValueOfTextValueRun", "cppSetValueOfTextValueRun", "newText", "cppFindTextValueRunAtPath", "cppFindValueOfTextValueRunAtPath", "cppSetValueOfTextValueRunAtPath", "cppDraw", "rendererPointer", "cppDrawAligned", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "scaleFactor", "cppBounds", "Landroid/graphics/RectF;", "cppResetArtboardSize", "cppGetArtboardWidth", "cppSetArtboardWidth", "width", "cppGetArtboardHeight", "cppSetArtboardHeight", "height", "cppDelete", "pointer", "getName", "()Ljava/lang/String;", "firstAnimation", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getFirstAnimation", "()Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "animation", "firstStateMachine", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getFirstStateMachine", "()Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "stateMachine", "input", "Lapp/rive/runtime/kotlin/core/SMIInput;", "textRun", "Lapp/rive/runtime/kotlin/core/RiveTextValueRun;", "getTextRunValue", "setTextRunValue", "textValue", "value", "getVolume", "()F", "setVolume$kotlin_release", "(F)V", "animationCount", "getAnimationCount", "()I", "stateMachineCount", "getStateMachineCount", "advance", "draw", "rendererAddress", "resetArtboardSize", "bounds", "getBounds", "()Landroid/graphics/RectF;", "getWidth", "setWidth", "getHeight", "setHeight", "animationNames", "", "getAnimationNames", "()Ljava/util/List;", "stateMachineNames", "getStateMachineNames", "convertInput", "kotlin_release"})
@OpenForTesting
@SourceDebugExtension(value={"SMAP\nArtboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Artboard.kt\napp/rive/runtime/kotlin/core/Artboard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,375:1\n1557#2:376\n1628#2,3:377\n1557#2:381\n1628#2,3:382\n1557#2:385\n1628#2,3:386\n1#3:380\n*S KotlinDebug\n*F\n+ 1 Artboard.kt\napp/rive/runtime/kotlin/core/Artboard\n*L\n135#1:376\n135#1:377,3\n360#1:381\n360#1:382,3\n364#1:385\n364#1:386,3\n*E\n"})
public class Artboard
extends NativeObject {
    @NotNull
    private final ReentrantLock lock;

    public Artboard(long unsafeCppPointer, @NotNull ReentrantLock lock) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        super(unsafeCppPointer);
        this.lock = lock;
    }

    private native String cppName(long var1);

    private native long cppAnimationByIndex(long var1, int var3);

    private native long cppAnimationByName(long var1, String var3);

    private native int cppAnimationCount(long var1);

    private native String cppAnimationNameByIndex(long var1, int var3);

    private native long cppStateMachineByIndex(long var1, int var3);

    private native long cppStateMachineByName(long var1, String var3);

    private native int cppStateMachineCount(long var1);

    private native String cppStateMachineNameByIndex(long var1, int var3);

    private native long cppInputByNameAtPath(long var1, String var3, String var4);

    private native float cppGetVolume(long var1);

    private native void cppSetVolume(long var1, float var3);

    private native boolean cppAdvance(long var1, float var3);

    private native long cppFindTextValueRun(long var1, String var3);

    private native String cppFindValueOfTextValueRun(long var1, String var3);

    private native boolean cppSetValueOfTextValueRun(long var1, String var3, String var4);

    private native long cppFindTextValueRunAtPath(long var1, String var3, String var4);

    private native String cppFindValueOfTextValueRunAtPath(long var1, String var3, String var4);

    private native boolean cppSetValueOfTextValueRunAtPath(long var1, String var3, String var4, String var5);

    private native void cppDraw(long var1, long var3);

    private native void cppDrawAligned(long var1, long var3, Fit var5, Alignment var6, float var7);

    private native RectF cppBounds(long var1);

    private native void cppResetArtboardSize(long var1);

    private native float cppGetArtboardWidth(long var1);

    private native void cppSetArtboardWidth(long var1, float var3);

    private native float cppGetArtboardHeight(long var1);

    private native void cppSetArtboardHeight(long var1, float var3);

    @Override
    public native void cppDelete(long var1);

    @NotNull
    public String getName() {
        return this.cppName(this.getCppPointer());
    }

    @NotNull
    public LinearAnimationInstance getFirstAnimation() throws AnimationException {
        return this.animation(0);
    }

    @NotNull
    public LinearAnimationInstance animation(int index) throws AnimationException {
        long animationPointer = this.cppAnimationByIndex(this.getCppPointer(), index);
        if (animationPointer == 0L) {
            throw new AnimationException("No Animation found at index " + index + '.');
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, this.lock, 0.0f, 4, null);
        this.getDependencies().add(lai);
        return lai;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LinearAnimationInstance animation(@NotNull String name) throws AnimationException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long animationPointer = this.cppAnimationByName(this.getCppPointer(), name);
        if (animationPointer == 0L) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getAnimationNames();
            StringBuilder stringBuilder = new StringBuilder().append("Animation \"").append(name).append("\" not found. Available Animations: ");
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add('\"' + (String)it + '\"');
            }
            String string = stringBuilder.append((List)destination$iv$iv).append('\"').toString();
            throw new AnimationException(string);
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, this.lock, 0.0f, 4, null);
        this.getDependencies().add(lai);
        return lai;
    }

    @NotNull
    public StateMachineInstance getFirstStateMachine() throws StateMachineException {
        return this.stateMachine(0);
    }

    @NotNull
    public StateMachineInstance stateMachine(int index) throws StateMachineException {
        long stateMachinePointer = this.cppStateMachineByIndex(this.getCppPointer(), index);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found at index " + index + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer, this.lock);
        this.getDependencies().add(smi);
        return smi;
    }

    @NotNull
    public StateMachineInstance stateMachine(@NotNull String name) throws StateMachineException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long stateMachinePointer = this.cppStateMachineByName(this.getCppPointer(), name);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found with name " + name + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer, this.lock);
        this.getDependencies().add(smi);
        return smi;
    }

    @NotNull
    public SMIInput input(@NotNull String name, @NotNull String path) throws StateMachineInputException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long stateMachineInputPointer = this.cppInputByNameAtPath(this.getCppPointer(), name, path);
        if (stateMachineInputPointer == 0L) {
            throw new StateMachineInputException("No StateMachineInput found with name \"" + name + "\" in nested artboard " + path + '.');
        }
        SMIInput input = new SMIInput(stateMachineInputPointer);
        return this.convertInput(input);
    }

    @NotNull
    public RiveTextValueRun textRun(@NotNull String name) throws TextValueRunException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long textRunPointer = this.cppFindTextValueRun(this.getCppPointer(), name);
        if (textRunPointer == 0L) {
            throw new TextValueRunException("No Rive TextValueRun found with name \"" + name + ".\"");
        }
        RiveTextValueRun run = new RiveTextValueRun(textRunPointer);
        this.getDependencies().add(run);
        return run;
    }

    @Nullable
    public String getTextRunValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.cppFindValueOfTextValueRun(this.getCppPointer(), name);
    }

    public void setTextRunValue(@NotNull String name, @NotNull String textValue) throws TextValueRunException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        boolean successCheck = this.cppSetValueOfTextValueRun(this.getCppPointer(), name, textValue);
        if (!successCheck) {
            throw new TextValueRunException("Could not set text run. No Rive TextValueRun found with name \"" + name + ".\"");
        }
    }

    @NotNull
    public RiveTextValueRun textRun(@NotNull String name, @NotNull String path) throws TextValueRunException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long textRunPointer = this.cppFindTextValueRunAtPath(this.getCppPointer(), name, path);
        if (textRunPointer == 0L) {
            throw new TextValueRunException("No Rive TextValueRun found with name \"" + name + ".\" in nested artboard " + path);
        }
        RiveTextValueRun run = new RiveTextValueRun(textRunPointer);
        this.getDependencies().add(run);
        return run;
    }

    @Nullable
    public String getTextRunValue(@NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.cppFindValueOfTextValueRunAtPath(this.getCppPointer(), name, path);
    }

    public void setTextRunValue(@NotNull String name, @NotNull String textValue, @NotNull String path) throws TextValueRunException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean successCheck = this.cppSetValueOfTextValueRunAtPath(this.getCppPointer(), name, textValue, path);
        if (!successCheck) {
            throw new TextValueRunException("Could not set text run value at path. No Rive TextValueRun found with name \"" + name + ".\" in nested artboard \"" + path + ".\"");
        }
    }

    public float getVolume() {
        return this.cppGetVolume(this.getCppPointer());
    }

    public void setVolume$kotlin_release(float value) {
        this.cppSetVolume(this.getCppPointer(), value);
    }

    public int getAnimationCount() {
        return this.cppAnimationCount(this.getCppPointer());
    }

    public int getStateMachineCount() {
        return this.cppStateMachineCount(this.getCppPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advance(float elapsedTime) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = this.cppAdvance(this.getCppPointer(), elapsedTime);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void draw(long rendererAddress) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppDraw(this.getCppPointer(), rendererAddress);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void draw(long rendererAddress, @NotNull Fit fit, @NotNull Alignment alignment, float scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppDrawAligned(this.getCppPointer(), rendererAddress, fit, alignment, scaleFactor);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void draw$default(Artboard artboard, long l, Fit fit, Alignment alignment, float f, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: draw");
        }
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        artboard.draw(l, fit, alignment, f);
    }

    public void resetArtboardSize() {
        this.cppResetArtboardSize(this.getCppPointer());
    }

    @NotNull
    public RectF getBounds() {
        return this.cppBounds(this.getCppPointer());
    }

    public float getWidth() {
        return this.cppGetArtboardWidth(this.getCppPointer());
    }

    public void setWidth(float value) {
        this.cppSetArtboardWidth(this.getCppPointer(), value);
    }

    public float getHeight() {
        return this.cppGetArtboardHeight(this.getCppPointer());
    }

    public void setHeight(float value) {
        this.cppSetArtboardHeight(this.getCppPointer(), value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getAnimationNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getAnimationCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppAnimationNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getStateMachineNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateMachineCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppStateMachineNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }

    private SMIInput convertInput(SMIInput input) {
        SMIInput sMIInput;
        if (input.isBoolean()) {
            sMIInput = new SMIBoolean(input.getCppPointer());
        } else if (input.isTrigger()) {
            sMIInput = new SMITrigger(input.getCppPointer());
        } else if (input.isNumber()) {
            sMIInput = new SMINumber(input.getCppPointer());
        } else {
            throw new StateMachineInputException("Unknown State Machine Input Instance for " + input.getName() + '.');
        }
        SMIInput convertedInput = sMIInput;
        return convertedInput;
    }
}

