/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import androidx.annotation.OpenForTesting;
import androidx.annotation.VisibleForTesting;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.FileAssetLoader;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import app.rive.runtime.kotlin.core.errors.ArtboardException;
import app.rive.runtime.kotlin.core.errors.RiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0092 J\u0019\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0092 J\u0019\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013H\u0095 J\u0019\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013H\u0092 J\u0011\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011H\u0092 J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0096 J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010,\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lapp/rive/runtime/kotlin/core/File;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "bytes", "", "rendererType", "Lapp/rive/runtime/kotlin/core/RendererType;", "fileAssetLoader", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "<init>", "([BLapp/rive/runtime/kotlin/core/RendererType;Lapp/rive/runtime/kotlin/core/FileAssetLoader;)V", "getRendererType", "()Lapp/rive/runtime/kotlin/core/RendererType;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "import", "", "length", "", "fileAssetLoaderPointer", "cppArtboardByName", "cppPointer", "name", "", "cppArtboardByIndex", "index", "cppArtboardNameByIndex", "cppArtboardCount", "cppDelete", "", "pointer", "firstArtboard", "Lapp/rive/runtime/kotlin/core/Artboard;", "getFirstArtboard", "()Lapp/rive/runtime/kotlin/core/Artboard;", "artboard", "artboardCount", "getArtboardCount", "()I", "artboardNames", "", "getArtboardNames", "()Ljava/util/List;", "release", "kotlin_release"})
@OpenForTesting
@SourceDebugExtension(value={"SMAP\nFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 File.kt\napp/rive/runtime/kotlin/core/File\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1557#2:119\n1628#2,3:120\n1557#2:123\n1628#2,3:124\n1#3:127\n*S KotlinDebug\n*F\n+ 1 File.kt\napp/rive/runtime/kotlin/core/File\n*L\n77#1:119\n77#1:120,3\n109#1:123\n109#1:124,3\n*E\n"})
public class File
extends NativeObject {
    @NotNull
    private final RendererType rendererType;
    @NotNull
    private final ReentrantLock lock;

    public File(@NotNull byte[] bytes, @NotNull RendererType rendererType, @Nullable FileAssetLoader fileAssetLoader) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
        super(0L);
        this.rendererType = rendererType;
        FileAssetLoader fileAssetLoader2 = fileAssetLoader;
        if (fileAssetLoader2 != null) {
            fileAssetLoader2.setRendererType(this.getRendererType());
        }
        FileAssetLoader fileAssetLoader3 = fileAssetLoader;
        this.setCppPointer(this.import(bytes, bytes.length, this.getRendererType().getValue(), fileAssetLoader3 != null ? fileAssetLoader3.getCppPointer() : 0L));
        this.getRefs().incrementAndGet();
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ File(byte[] byArray, RendererType rendererType, FileAssetLoader fileAssetLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            rendererType = Rive.INSTANCE.getDefaultRendererType();
        }
        if ((n & 4) != 0) {
            fileAssetLoader = null;
        }
        this(byArray, rendererType, fileAssetLoader);
    }

    @NotNull
    public RendererType getRendererType() {
        return this.rendererType;
    }

    @NotNull
    public ReentrantLock getLock() {
        return this.lock;
    }

    private native long import(byte[] var1, int var2, int var3, long var4);

    private native long cppArtboardByName(long var1, String var3);

    @VisibleForTesting(otherwise=2)
    protected native long cppArtboardByIndex(long var1, int var3);

    private native String cppArtboardNameByIndex(long var1, int var3);

    private native int cppArtboardCount(long var1);

    @Override
    public native void cppDelete(long var1);

    @NotNull
    public Artboard getFirstArtboard() throws RiveException {
        return this.artboard(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Artboard artboard(@NotNull String name) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long artboardPointer = this.cppArtboardByName(this.getCppPointer(), name);
        if (artboardPointer == 0L) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getArtboardNames();
            StringBuilder stringBuilder = new StringBuilder().append("Artboard \"").append(name).append("\" not found. Available Artboards: ");
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add('\"' + (String)it + '\"');
            }
            String string = stringBuilder.append((List)destination$iv$iv).toString();
            throw new ArtboardException(string);
        }
        Artboard ab = new Artboard(artboardPointer, this.getLock());
        this.getDependencies().add(ab);
        return ab;
    }

    @NotNull
    public Artboard artboard(int index) throws RiveException {
        long artboardPointer = this.cppArtboardByIndex(this.getCppPointer(), index);
        if (artboardPointer == 0L) {
            throw new ArtboardException("No Artboard found at index " + index + '.');
        }
        Artboard ab = new Artboard(artboardPointer, this.getLock());
        this.getDependencies().add(ab);
        return ab;
    }

    public int getArtboardCount() {
        return this.cppArtboardCount(this.getCppPointer());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getArtboardNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getArtboardCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = this.cppArtboardNameByIndex(this.getCppPointer(), (int)it);
            collection.add(name);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int release() {
        ReentrantLock reentrantLock = this.getLock();
        synchronized (reentrantLock) {
            boolean bl = false;
            int n = super.release();
            return n;
        }
    }
}

