/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.AnimationState;
import app.rive.runtime.kotlin.core.AnyState;
import app.rive.runtime.kotlin.core.BlendState;
import app.rive.runtime.kotlin.core.EntryState;
import app.rive.runtime.kotlin.core.ExitState;
import app.rive.runtime.kotlin.core.LayerState;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.PlayableInstance;
import app.rive.runtime.kotlin.core.RiveEvent;
import app.rive.runtime.kotlin.core.RiveEventReport;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.errors.RiveEventException;
import app.rive.runtime.kotlin.core.errors.StateMachineInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0082 J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0082 J\u0019\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fH\u0082 J\u0011\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0082 J\u0019\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fH\u0082 J\u0011\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0082 J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fH\u0082 J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0004H\u0082 J\u0011\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0082 J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0082 J!\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0082 J!\u0010 \u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0082 J\u0011\u0010!\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0004H\u0096 J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\rJ\u0016\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rJ\u0016\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rJ\u0016\u0010,\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rJ\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J\u000e\u00105\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u00105\u001a\u0002042\u0006\u0010\"\u001a\u00020\u0019J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=H\u0002J\u000e\u0010?\u001a\u00020=2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010@\u001a\u00020A2\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010-\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010'R\u0014\u0010/\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010'R\u0014\u00101\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010'R\u0017\u00106\u001a\b\u0012\u0004\u0012\u000204078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0019078F\u00a2\u0006\u0006\u001a\u0004\b;\u00109R\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020=078F\u00a2\u0006\u0006\u001a\u0004\bC\u00109R\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020A078F\u00a2\u0006\u0006\u001a\u0004\bE\u00109\u00a8\u0006F"}, d2={"Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "<init>", "(JLjava/util/concurrent/locks/ReentrantLock;)V", "cppAdvance", "", "pointer", "elapsedTime", "", "cppInputCount", "", "cppPointer", "cppSMIInputByIndex", "index", "cppStateChangedCount", "cppStateChangedByIndex", "cppReportedEventCount", "cppReportedEventAt", "Lapp/rive/runtime/kotlin/core/RiveEventReport;", "cppName", "", "cppLayerCount", "cppPointerDown", "", "x", "y", "cppPointerUp", "cppPointerMove", "cppDelete", "name", "getName", "()Ljava/lang/String;", "layerCount", "getLayerCount", "()I", "advance", "elapsed", "pointerDown", "pointerUp", "pointerMove", "inputCount", "getInputCount", "stateChangedCount", "getStateChangedCount", "reportedEventCount", "getReportedEventCount", "convertInput", "Lapp/rive/runtime/kotlin/core/SMIInput;", "input", "inputs", "", "getInputs", "()Ljava/util/List;", "inputNames", "getInputNames", "convertLayerState", "Lapp/rive/runtime/kotlin/core/LayerState;", "state", "stateChanged", "eventAt", "Lapp/rive/runtime/kotlin/core/RiveEvent;", "statesChanged", "getStatesChanged", "eventsReported", "getEventsReported", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nStateMachineInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachineInstance.kt\napp/rive/runtime/kotlin/core/StateMachineInstance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n1557#3:200\n1628#3,3:201\n1557#3:204\n1628#3,3:205\n1557#3:208\n1628#3,3:209\n1557#3:212\n1628#3,3:213\n*S KotlinDebug\n*F\n+ 1 StateMachineInstance.kt\napp/rive/runtime/kotlin/core/StateMachineInstance\n*L\n122#1:200\n122#1:201,3\n126#1:204\n126#1:205,3\n189#1:208\n189#1:209,3\n194#1:212\n194#1:213,3\n*E\n"})
public final class StateMachineInstance
extends NativeObject
implements PlayableInstance {
    @NotNull
    private final ReentrantLock lock;

    public StateMachineInstance(long unsafeCppPointer, @NotNull ReentrantLock lock) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        super(unsafeCppPointer);
        this.lock = lock;
    }

    private final native boolean cppAdvance(long var1, float var3);

    private final native int cppInputCount(long var1);

    private final native long cppSMIInputByIndex(long var1, int var3);

    private final native int cppStateChangedCount(long var1);

    private final native long cppStateChangedByIndex(long var1, int var3);

    private final native int cppReportedEventCount(long var1);

    private final native RiveEventReport cppReportedEventAt(long var1, int var3);

    private final native String cppName(long var1);

    private final native int cppLayerCount(long var1);

    private final native void cppPointerDown(long var1, float var3, float var4);

    private final native void cppPointerUp(long var1, float var3, float var4);

    private final native void cppPointerMove(long var1, float var3, float var4);

    @Override
    public native void cppDelete(long var1);

    @Override
    @NotNull
    public String getName() {
        return this.cppName(this.getCppPointer());
    }

    public final int getLayerCount() {
        return this.cppLayerCount(this.getCppPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean advance(float elapsed) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = this.cppAdvance(this.getCppPointer(), elapsed);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pointerDown(float x, float y) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppPointerDown(this.getCppPointer(), x, y);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pointerUp(float x, float y) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppPointerUp(this.getCppPointer(), x, y);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pointerMove(float x, float y) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppPointerMove(this.getCppPointer(), x, y);
            return;
        }
    }

    public final int getInputCount() {
        return this.cppInputCount(this.getCppPointer());
    }

    private final int getStateChangedCount() {
        return this.cppStateChangedCount(this.getCppPointer());
    }

    private final int getReportedEventCount() {
        return this.cppReportedEventCount(this.getCppPointer());
    }

    private final SMIInput convertInput(SMIInput input) {
        SMIInput sMIInput;
        if (input.isBoolean()) {
            sMIInput = new SMIBoolean(input.getCppPointer());
        } else if (input.isTrigger()) {
            sMIInput = new SMITrigger(input.getCppPointer());
        } else if (input.isNumber()) {
            sMIInput = new SMINumber(input.getCppPointer());
        } else {
            throw new StateMachineInputException("Unknown State Machine Input Instance for " + input.getName() + '.');
        }
        SMIInput convertedInput = sMIInput;
        return convertedInput;
    }

    @NotNull
    public final SMIInput input(int index) throws StateMachineInputException {
        long stateMachineInputPointer = this.cppSMIInputByIndex(this.getCppPointer(), index);
        if (stateMachineInputPointer == 0L) {
            throw new StateMachineInputException("No StateMachineInput found at index " + index + '.');
        }
        SMIInput input = new SMIInput(stateMachineInputPointer);
        return this.convertInput(input);
    }

    @NotNull
    public final SMIInput input(@NotNull String name) throws StateMachineInputException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = this.getInputCount();
        for (int i = 0; i < n; ++i) {
            SMIInput output = this.input(i);
            if (!Intrinsics.areEqual((Object)output.getName(), (Object)name)) continue;
            return output;
        }
        throw new StateMachineInputException("No StateMachineInput found with name " + name + '.');
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SMIInput> getInputs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.input((int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getInputNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.input((int)it).getName());
        }
        return (List)destination$iv$iv;
    }

    private final LayerState convertLayerState(LayerState state) {
        LayerState layerState;
        if (state.isAnimationState()) {
            layerState = new AnimationState(state.getCppPointer());
        } else if (state.isAnyState()) {
            layerState = new AnyState(state.getCppPointer());
        } else if (state.isEntryState()) {
            layerState = new EntryState(state.getCppPointer());
        } else if (state.isExitState()) {
            layerState = new ExitState(state.getCppPointer());
        } else if (state.isBlendState()) {
            layerState = new BlendState(state.getCppPointer());
        } else {
            throw new StateMachineInputException("Unknown Layer State for " + state + '.');
        }
        LayerState convertedState = layerState;
        return convertedState;
    }

    @NotNull
    public final LayerState stateChanged(int index) throws StateMachineInputException {
        long stateChanged = this.cppStateChangedByIndex(this.getCppPointer(), index);
        if (stateChanged == 0L) {
            throw new StateMachineInputException("No LayerState found at index " + index + '.');
        }
        LayerState layerState = new LayerState(stateChanged);
        return this.convertLayerState(layerState);
    }

    @NotNull
    public final RiveEvent eventAt(int index) throws RiveEventException {
        RiveEventReport eventReport = this.cppReportedEventAt(this.getCppPointer(), index);
        if (eventReport.getUnsafeCppPointer() == 0L) {
            throw new RiveEventException("No Rive Event found at index " + index + '.');
        }
        return eventReport.getEvent();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LayerState> getStatesChanged() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateChangedCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.stateChanged((int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RiveEvent> getEventsReported() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getReportedEventCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.eventAt((int)it));
        }
        return (List)destination$iv$iv;
    }
}

