/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.renderers;

import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RefCount;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b1\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096 J\u0011\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0019\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J\u0011\u0010!\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0082 J9\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001cH\u0082 JA\u0010,\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001cH\u0082 J\u0019\u00103\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0019H\u0082 J\b\u00104\u001a\u00020\u0010H\u0017J\u0010\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u0019H\u0002J\b\u0010<\u001a\u00020\u0010H'J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u001cH'J\u0006\u0010?\u001a\u00020\u0010J\u000e\u0010@\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 J\r\u0010A\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\bBJ\b\u0010C\u001a\u00020\u0010H\u0007J\b\u0010D\u001a\u00020\u0010H\u0002J\b\u0010E\u001a\u00020\u0010H\u0016J\u0006\u0010F\u001a\u00020\u0010J\u0006\u0010G\u001a\u00020\u0010J0\u0010O\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010P\u001a\u00020)2\b\b\u0002\u0010+\u001a\u00020\u001cJ6\u0010Q\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001cJ\u0016\u0010R\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001cJ\u0016\u0010S\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020\u001cJ\u0010\u0010V\u001a\u00020\u00102\u0006\u0010W\u001a\u00020\u0012H\u0017J\b\u0010X\u001a\u00020\u0010H\u0017J\b\u0010Y\u001a\u00020\u0010H\u0014R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u00108\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u000eR\u001a\u00109\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u000e\"\u0004\b:\u0010;R\u0011\u0010H\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0011\u0010K\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010JR\u0011\u0010M\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010J\u00a8\u0006Z"}, d2={"Lapp/rive/runtime/kotlin/renderers/Renderer;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "Landroid/view/Choreographer$FrameCallback;", "type", "Lapp/rive/runtime/kotlin/core/RendererType;", "trace", "", "<init>", "(Lapp/rive/runtime/kotlin/core/RendererType;Z)V", "getType", "()Lapp/rive/runtime/kotlin/core/RendererType;", "setType", "(Lapp/rive/runtime/kotlin/core/RendererType;)V", "getTrace", "()Z", "cppDelete", "", "pointer", "", "cppStart", "rendererPointer", "cppStop", "cppSave", "cppRestore", "cppWidth", "", "cppHeight", "cppAvgFps", "", "cppDoFrame", "cppSetSurface", "surface", "Landroid/view/Surface;", "cppDestroySurface", "cppAlign", "cppPointer", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "targetBounds", "Landroid/graphics/RectF;", "srcBounds", "scaleFactor", "cppTransform", "x", "sy", "sx", "y", "tx", "ty", "constructor", "make", "setRendererType", "newType", "value", "isPlaying", "isAttached", "setAttached", "(Z)V", "draw", "advance", "elapsed", "start", "setSurface", "stopThread", "stopThread$kotlin_release", "stop", "destroySurface", "scheduleFrame", "save", "restore", "width", "getWidth", "()F", "height", "getHeight", "averageFps", "getAverageFps", "align", "sourceBounds", "transform", "scale", "translate", "dx", "dy", "doFrame", "frameTimeNanos", "delete", "disposeDependencies", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer.kt\napp/rive/runtime/kotlin/renderers/Renderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1863#2,2:243\n*S KotlinDebug\n*F\n+ 1 Renderer.kt\napp/rive/runtime/kotlin/renderers/Renderer\n*L\n239#1:243,2\n*E\n"})
public abstract class Renderer
extends NativeObject
implements Choreographer.FrameCallback {
    @NotNull
    private RendererType type;
    private final boolean trace;
    private boolean isPlaying;
    private boolean isAttached;

    public Renderer(@NotNull RendererType type, boolean trace) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(0L);
        this.type = type;
        this.trace = trace;
    }

    public /* synthetic */ Renderer(RendererType rendererType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            rendererType = Rive.INSTANCE.getDefaultRendererType();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(rendererType, bl);
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final RendererType getType() {
        return this.type;
    }

    public final void setType(@NotNull RendererType rendererType) {
        Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"<set-?>");
        this.type = rendererType;
    }

    public final boolean getTrace() {
        return this.trace;
    }

    @Override
    public native void cppDelete(long var1);

    private final native void cppStart(long var1);

    private final native void cppStop(long var1);

    private final native void cppSave(long var1);

    private final native void cppRestore(long var1);

    private final native int cppWidth(long var1);

    private final native int cppHeight(long var1);

    private final native float cppAvgFps(long var1);

    private final native void cppDoFrame(long var1);

    private final native void cppSetSurface(Surface var1, long var2);

    private final native void cppDestroySurface(long var1);

    private final native void cppAlign(long var1, Fit var3, Alignment var4, RectF var5, RectF var6, float var7);

    private final native void cppTransform(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    private final native long constructor(boolean var1, int var2);

    @CallSuper
    public void make() {
        if (!this.getHasCppObject()) {
            this.setCppPointer(this.constructor(this.trace, this.type.getValue()));
            this.getRefs().incrementAndGet();
        }
    }

    private final void setRendererType(int newType) {
        if (newType != this.type.getValue()) {
            this.type = RendererType.Companion.fromIndex(newType);
        }
    }

    public final boolean isPlaying() {
        return this.isPlaying;
    }

    public final boolean isAttached() {
        return this.isAttached;
    }

    public final void setAttached(boolean bl) {
        this.isAttached = bl;
    }

    @WorkerThread
    public abstract void draw();

    @WorkerThread
    public abstract void advance(float var1);

    public final void start() {
        if (this.isPlaying) {
            return;
        }
        if (!this.isAttached) {
            return;
        }
        if (!this.getHasCppObject()) {
            return;
        }
        this.isPlaying = true;
        this.cppStart(this.getCppPointer());
        this.scheduleFrame();
    }

    public final void setSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.cppSetSurface(surface, this.getCppPointer());
        this.isAttached = true;
        this.start();
    }

    @CallSuper
    public final void stopThread$kotlin_release() {
        if (!this.isPlaying) {
            return;
        }
        if (!this.getHasCppObject()) {
            return;
        }
        this.isPlaying = false;
        this.cppStop(this.getCppPointer());
    }

    @CallSuper
    public final void stop() {
        this.stopThread$kotlin_release();
        new Handler(Looper.getMainLooper()).post(() -> Renderer.stop$lambda$0(this));
    }

    private final void destroySurface() {
        this.isAttached = false;
        this.stop();
        this.cppDestroySurface(this.getCppPointer());
    }

    public void scheduleFrame() {
        new Handler(Looper.getMainLooper()).post(() -> Renderer.scheduleFrame$lambda$1(this));
    }

    public final void save() {
        this.cppSave(this.getCppPointer());
    }

    public final void restore() {
        this.cppRestore(this.getCppPointer());
    }

    public final float getWidth() {
        return this.cppWidth(this.getCppPointer());
    }

    public final float getHeight() {
        return this.cppHeight(this.getCppPointer());
    }

    public final float getAverageFps() {
        return this.cppAvgFps(this.getCppPointer());
    }

    public final void align(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull RectF targetBounds, @NotNull RectF sourceBounds, float scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)targetBounds, (String)"targetBounds");
        Intrinsics.checkNotNullParameter((Object)sourceBounds, (String)"sourceBounds");
        this.cppAlign(this.getCppPointer(), fit, alignment, targetBounds, sourceBounds, scaleFactor);
    }

    public static /* synthetic */ void align$default(Renderer renderer, Fit fit, Alignment alignment, RectF rectF, RectF rectF2, float f, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: align");
        }
        if ((n & 0x10) != 0) {
            f = 1.0f;
        }
        renderer.align(fit, alignment, rectF, rectF2, f);
    }

    public final void transform(float x, float sy, float sx, float y, float tx, float ty) {
        this.cppTransform(this.getCppPointer(), x, sy, sx, y, tx, ty);
    }

    public final void scale(float sx, float sy) {
        this.transform(sx, 0.0f, 0.0f, sy, 0.0f, 0.0f);
    }

    public final void translate(float dx, float dy) {
        this.transform(1.0f, 0.0f, 0.0f, 1.0f, dx, dy);
    }

    @CallSuper
    public void doFrame(long frameTimeNanos) {
        if (this.isPlaying) {
            this.cppDoFrame(this.getCppPointer());
            this.scheduleFrame();
        }
    }

    @CallSuper
    public void delete() {
        this.destroySurface();
        this.cppDelete(this.getCppPointer());
        this.setCppPointer(0L);
    }

    protected void disposeDependencies() {
        Iterable $this$forEach$iv = this.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RefCount it = (RefCount)element$iv;
            boolean bl = false;
            it.release();
        }
        this.getDependencies().clear();
    }

    private static final void stop$lambda$0(Renderer this$0) {
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this$0);
    }

    private static final void scheduleFrame$lambda$1(Renderer this$0) {
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this$0);
    }

    public Renderer() {
        this(null, false, 3, null);
    }
}

