/*
 * Decompiled with CFR 0.152.
 */
package app.rive.core;

import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.RiveLog;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\b2\b\b\u0002\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/rive/core/RCPointer;", "", "cppPointer", "", "onDelete", "Lkotlin/Function1;", "", "label", "", "(JLkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "getOnDelete", "()Lkotlin/jvm/functions/Function1;", "pointer", "getPointer", "()J", "referenceCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "acquire", "source", "release", "reason", "Companion", "kotlin_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRCPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RCPointer.kt\napp/rive/core/RCPointer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RiveLog.kt\napp/rive/RiveLog\n*L\n1#1,81:1\n1#2:82\n53#3:83\n53#3:84\n*S KotlinDebug\n*F\n+ 1 RCPointer.kt\napp/rive/core/RCPointer\n*L\n51#1:83\n69#1:84\n*E\n"})
public final class RCPointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long cppPointer;
    @NotNull
    private final Function1<Long, Unit> onDelete;
    @NotNull
    private final String label;
    @NotNull
    private AtomicInteger referenceCount;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "Rive/RCPointer";

    public RCPointer(long cppPointer, @NotNull Function1<? super Long, Unit> onDelete, @NotNull String label) {
        Intrinsics.checkNotNullParameter(onDelete, (String)"onDelete");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.cppPointer = cppPointer;
        this.onDelete = onDelete;
        this.label = label;
        this.referenceCount = new AtomicInteger(1);
    }

    @NotNull
    public final Function1<Long, Unit> getOnDelete() {
        return this.onDelete;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final long getPointer() {
        if (!(this.referenceCount.get() > 0)) {
            boolean bl = false;
            String string = "Attempting to access a released RCPointer (" + this.label + ").";
            throw new IllegalStateException(string.toString());
        }
        return this.cppPointer;
    }

    /*
     * WARNING - void declaration
     */
    public final void acquire(@NotNull String source) throws IllegalStateException {
        void tag$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int refCount = this.referenceCount.get();
        if (!(refCount > 0)) {
            boolean $i$a$-check-RCPointer$acquire$22 = false;
            String $i$a$-check-RCPointer$acquire$22 = "Attempting to acquire a null RCPointer (" + this.label + ").";
            throw new IllegalStateException($i$a$-check-RCPointer$acquire$22.toString());
        }
        String string = TAG;
        Function0 msg$iv = (Function0)new Function0<String>(this, source, refCount){
            final /* synthetic */ RCPointer this$0;
            final /* synthetic */ String $source;
            final /* synthetic */ int $refCount;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                this.$refCount = $refCount;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Acquiring " + this.this$0.getLabel() + " (source: " + this.$source + "; ref count before acquire: " + this.$refCount + ")";
            }
        };
        boolean $i$f$v = false;
        RiveLog.INSTANCE.getLogger().v((String)tag$iv, (Function0<String>)msg$iv);
        this.referenceCount.incrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    public final void release(@NotNull String source, @NotNull String reason) throws IllegalStateException {
        void tag$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object reasonLog = ((CharSequence)reason).length() == 0 ? "" : "reason: " + reason + "; ";
        String string = TAG;
        Function0 msg$iv = (Function0)new Function0<String>(this, source, (String)reasonLog){
            final /* synthetic */ RCPointer this$0;
            final /* synthetic */ String $source;
            final /* synthetic */ String $reasonLog;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                this.$reasonLog = $reasonLog;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Releasing " + this.this$0.getLabel() + " (source: " + this.$source + "; " + this.$reasonLog + "ref count before release: " + RCPointer.access$getReferenceCount$p(this.this$0).get() + ")";
            }
        };
        boolean $i$f$v = false;
        RiveLog.INSTANCE.getLogger().v((String)tag$iv, (Function0<String>)msg$iv);
        int count = this.referenceCount.decrementAndGet();
        if (!(count >= 0)) {
            boolean bl = false;
            String string2 = "RCPointer (" + this.label + ") released too many times.";
            throw new IllegalStateException(string2.toString());
        }
        if (count == 0) {
            this.onDelete.invoke((Object)this.cppPointer);
        }
    }

    public static /* synthetic */ void release$default(RCPointer rCPointer, String string, String string2, int n, Object object) throws IllegalStateException {
        if ((n & 2) != 0) {
            string2 = "";
        }
        rCPointer.release(string, string2);
    }

    public static final /* synthetic */ AtomicInteger access$getReferenceCount$p(RCPointer $this) {
        return $this.referenceCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/rive/core/RCPointer$Companion;", "", "()V", "TAG", "", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

