/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import androidx.annotation.RawRes;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.util.SparseBooleanArrayKt;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import app.rive.runtime.kotlin.ChangedInput;
import app.rive.runtime.kotlin.Observable;
import app.rive.runtime.kotlin.R;
import app.rive.runtime.kotlin.ResourceType;
import app.rive.runtime.kotlin.RiveAnimationView;
import app.rive.runtime.kotlin.RiveFileRequest;
import app.rive.runtime.kotlin.RiveTextureView;
import app.rive.runtime.kotlin.RiveViewLifecycleObserver;
import app.rive.runtime.kotlin.controllers.ControllerState;
import app.rive.runtime.kotlin.controllers.ControllerStateManagement;
import app.rive.runtime.kotlin.controllers.RiveFileController;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.ContextAssetLoader;
import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.FallbackAssetLoader;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.FileAssetLoader;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.RefCount;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.core.errors.RiveException;
import app.rive.runtime.kotlin.renderers.PointerEvents;
import app.rive.runtime.kotlin.renderers.Renderer;
import app.rive.runtime.kotlin.renderers.RendererMetrics;
import app.rive.runtime.kotlin.renderers.RiveArtboardRenderer;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0010\b\u0017\u0018\u0000 \u00bb\u00012\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0006\u00ba\u0001\u00bb\u0001\u00bc\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hJ\b\u0010i\u001a\u00020jH\u0014J\b\u0010k\u001a\u00020lH\u0014J\u0016\u0010m\u001a\u00020f2\u0006\u0010n\u001a\u00020\u00192\u0006\u0010o\u001a\u00020\u0019J\u0016\u0010p\u001a\u00020f2\u0006\u0010o\u001a\u00020\u00192\u0006\u0010q\u001a\u00020\u0019J\u0010\u0010r\u001a\u0004\u0018\u00010\u00192\u0006\u0010s\u001a\u00020\u0019J\u0018\u0010r\u001a\u0004\u0018\u00010\u00192\u0006\u0010s\u001a\u00020\u00192\u0006\u0010q\u001a\u00020\u0019J\r\u0010t\u001a\u0004\u0018\u00010@\u00a2\u0006\u0002\u0010CJ\u0018\u0010u\u001a\u00020#2\u0006\u0010v\u001a\u00020@2\u0006\u0010w\u001a\u00020@H\u0002J\u001c\u0010x\u001a\u00020f2\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020f0zH\u0002J$\u0010{\u001a\u00020f2\u0006\u0010|\u001a\u00020\u00192\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020f0zH\u0002J\b\u0010}\u001a\u00020fH\u0014J\b\u0010~\u001a\u00020fH\u0014J\u001c\u0010\u007f\u001a\u00020f2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0081\u0001H\u0014J'\u0010\u0083\u0001\u001a\u00020f2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0081\u00012\b\u0010\u0087\u0001\u001a\u00030\u0081\u0001H\u0016J'\u0010\u0088\u0001\u001a\u00020f2\b\u0010\u0089\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0081\u00012\b\u0010\u0087\u0001\u001a\u00030\u0081\u0001H\u0016J\u0013\u0010\u008a\u0001\u001a\u00020#2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0016J\u0007\u0010\u008d\u0001\u001a\u00020fJ\u001b\u0010\u008d\u0001\u001a\u00020f2\u0007\u0010\u008e\u0001\u001a\u00020\u00192\t\b\u0002\u0010\u008f\u0001\u001a\u00020#J!\u0010\u008d\u0001\u001a\u00020f2\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\t\b\u0002\u0010\u0091\u0001\u001a\u00020#J*\u0010\u0092\u0001\u001a\u00020f2\n\b\u0002\u0010\u0093\u0001\u001a\u00030\u0094\u00012\n\b\u0002\u0010\u0095\u0001\u001a\u00030\u0096\u00012\t\b\u0002\u0010\u0097\u0001\u001a\u00020#J>\u0010\u0092\u0001\u001a\u00020f2\u0007\u0010\u008e\u0001\u001a\u00020\u00192\n\b\u0002\u0010\u0093\u0001\u001a\u00030\u0094\u00012\n\b\u0002\u0010\u0095\u0001\u001a\u00030\u0096\u00012\t\b\u0002\u0010\u008f\u0001\u001a\u00020#2\t\b\u0002\u0010\u0097\u0001\u001a\u00020#JD\u0010\u0092\u0001\u001a\u00020f2\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\n\b\u0002\u0010\u0093\u0001\u001a\u00030\u0094\u00012\n\b\u0002\u0010\u0095\u0001\u001a\u00030\u0096\u00012\t\b\u0002\u0010\u0091\u0001\u001a\u00020#2\t\b\u0002\u0010\u0097\u0001\u001a\u00020#J\u0011\u0010\u0098\u0001\u001a\u00020f2\u0006\u0010g\u001a\u00020\u0003H\u0016J\u000f\u0010\u0099\u0001\u001a\u00020f2\u0006\u0010g\u001a\u00020hJ\u0007\u0010\u009a\u0001\u001a\u00020fJ\u0013\u0010\u009b\u0001\u001a\u00020f2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0007J\f\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009d\u0001H\u0007J\u0013\u0010\u009f\u0001\u001a\u00020f2\n\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u00a1\u0001J\u001f\u0010\u00a2\u0001\u001a\u00020f2\u0006\u0010n\u001a\u00020\u00192\u0006\u0010o\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020#J\u001f\u0010\u00a3\u0001\u001a\u00020f2\u0006\u0010o\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020#2\u0006\u0010q\u001a\u00020\u0019J%\u0010\u00a4\u0001\u001a\u00020f2\u0016\u0010\u00a5\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00a7\u00010\u00a6\u0001\"\u00030\u00a7\u0001\u00a2\u0006\u0003\u0010\u00a8\u0001J\u001f\u0010\u00a9\u0001\u001a\u00020f2\u0006\u0010n\u001a\u00020\u00192\u0006\u0010o\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020@J\u001f\u0010\u00aa\u0001\u001a\u00020f2\u0006\u0010o\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020@2\u0006\u0010q\u001a\u00020\u0019Jk\u0010\u00ab\u0001\u001a\u00020f2\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u00012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u000b\b\u0002\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010$\u001a\u00020#2\t\b\u0002\u0010\u00ae\u0001\u001a\u00020#2\b\b\u0002\u00108\u001a\u0002072\b\b\u0002\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u0093\u0001\u001a\u00030\u0094\u0001Ji\u0010\u00af\u0001\u001a\u00020f2\u0006\u00103\u001a\u0002042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u000b\b\u0002\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010$\u001a\u00020#2\t\b\u0002\u0010\u00ae\u0001\u001a\u00020#2\b\b\u0002\u00108\u001a\u0002072\b\b\u0002\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u0093\u0001\u001a\u00030\u0094\u0001Jm\u0010\u00b0\u0001\u001a\u00020f2\n\b\u0001\u0010\u00b1\u0001\u001a\u00030\u0081\u00012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u000b\b\u0002\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010$\u001a\u00020#2\t\b\u0002\u0010\u00ae\u0001\u001a\u00020#2\b\b\u0002\u00108\u001a\u0002072\b\b\u0002\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u0093\u0001\u001a\u00030\u0094\u0001J\u0018\u0010\u00b2\u0001\u001a\u00020f2\u0006\u0010s\u001a\u00020\u00192\u0007\u0010\u00b3\u0001\u001a\u00020\u0019J \u0010\u00b2\u0001\u001a\u00020f2\u0006\u0010s\u001a\u00020\u00192\u0007\u0010\u00b3\u0001\u001a\u00020\u00192\u0006\u0010q\u001a\u00020\u0019J\u000f\u0010\u00b4\u0001\u001a\u00020f2\u0006\u0010\f\u001a\u00020@J\t\u0010\u00b5\u0001\u001a\u00020fH\u0003J\u0007\u0010\u00b6\u0001\u001a\u00020fJ\u001b\u0010\u00b6\u0001\u001a\u00020f2\u0007\u0010\u008e\u0001\u001a\u00020\u00192\t\b\u0002\u0010\u008f\u0001\u001a\u00020#J!\u0010\u00b6\u0001\u001a\u00020f2\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\t\b\u0002\u0010\u0091\u0001\u001a\u00020#J\t\u0010\u00b7\u0001\u001a\u00020fH\u0003J\u0011\u0010\u00b8\u0001\u001a\u00020f2\u0006\u0010g\u001a\u00020\u0003H\u0016J\t\u0010\u00b9\u0001\u001a\u00020fH\u0002R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010$\u001a\u00020#2\u0006\u0010\f\u001a\u00020#8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u00020#X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010&R\u0013\u00103\u001a\u0004\u0018\u0001048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R$\u00108\u001a\u0002072\u0006\u0010\f\u001a\u0002078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010?\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010&R(\u0010A\u001a\u0004\u0018\u00010@2\b\u0010\f\u001a\u0004\u0018\u00010@8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER$\u0010F\u001a\u00020@2\u0006\u0010\f\u001a\u00020@8F@@X\u0086\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u0010\u0010K\u001a\u0004\u0018\u00010LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010M\u001a\u00020#2\u0006\u0010\f\u001a\u00020#@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010&\"\u0004\bO\u0010(R!\u0010P\u001a\u0012\u0012\u0004\u0012\u00020\u00150Qj\b\u0012\u0004\u0012\u00020\u0015`R8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR!\u0010U\u001a\u0012\u0012\u0004\u0012\u00020V0Qj\b\u0012\u0004\u0012\u00020V`R8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010TR\u000e\u0010X\u001a\u00020YX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010Z\u001a\u00020[8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\\\u0010]\u001a\u0004\b^\u0010_R\u0017\u0010`\u001a\b\u0012\u0004\u0012\u00020V0\u00148F\u00a2\u0006\u0006\u001a\u0004\ba\u0010\u0017R\u001a\u0010b\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010&\"\u0004\bd\u0010(\u00a8\u0006\u00bd\u0001"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView;", "Lapp/rive/runtime/kotlin/RiveTextureView;", "Lapp/rive/runtime/kotlin/Observable;", "Lapp/rive/runtime/kotlin/controllers/RiveFileController$Listener;", "builder", "Lapp/rive/runtime/kotlin/RiveAnimationView$Builder;", "(Lapp/rive/runtime/kotlin/RiveAnimationView$Builder;)V", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "value", "Lapp/rive/runtime/kotlin/core/Alignment;", "alignment", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "animations", "", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getAnimations", "()Ljava/util/List;", "name", "", "artboardName", "getArtboardName", "()Ljava/lang/String;", "setArtboardName", "(Ljava/lang/String;)V", "artboardRenderer", "Lapp/rive/runtime/kotlin/renderers/RiveArtboardRenderer;", "getArtboardRenderer", "()Lapp/rive/runtime/kotlin/renderers/RiveArtboardRenderer;", "", "autoplay", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "bounds", "Landroid/graphics/RectF;", "controller", "Lapp/rive/runtime/kotlin/controllers/RiveFileController;", "getController", "()Lapp/rive/runtime/kotlin/controllers/RiveFileController;", "setController", "(Lapp/rive/runtime/kotlin/controllers/RiveFileController;)V", "defaultAutoplay", "getDefaultAutoplay", "file", "Lapp/rive/runtime/kotlin/core/File;", "getFile", "()Lapp/rive/runtime/kotlin/core/File;", "Lapp/rive/runtime/kotlin/core/Fit;", "fit", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "frameMetricsListener", "Landroid/view/Window$OnFrameMetricsAvailableListener;", "isPlaying", "", "layoutScaleFactor", "getLayoutScaleFactor", "()Ljava/lang/Float;", "setLayoutScaleFactor", "(Ljava/lang/Float;)V", "layoutScaleFactorAutomatic", "getLayoutScaleFactorAutomatic", "()F", "setLayoutScaleFactorAutomatic$kotlin_release", "(F)V", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "multiTouchEnabled", "getMultiTouchEnabled", "setMultiTouchEnabled", "playingAnimations", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getPlayingAnimations", "()Ljava/util/HashSet;", "playingStateMachines", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getPlayingStateMachines", "pointersInsideView", "Landroid/util/SparseBooleanArray;", "rendererAttributes", "Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "getRendererAttributes$annotations", "()V", "getRendererAttributes", "()Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "stateMachines", "getStateMachines", "touchPassThrough", "getTouchPassThrough", "setTouchPassThrough", "addEventListener", "", "listener", "Lapp/rive/runtime/kotlin/controllers/RiveFileController$RiveEventListener;", "createObserver", "Landroidx/lifecycle/LifecycleObserver;", "createRenderer", "Lapp/rive/runtime/kotlin/renderers/Renderer;", "fireState", "stateMachineName", "inputName", "fireStateAtPath", "path", "getTextRunValue", "textRunName", "getVolume", "inBounds", "x", "y", "loadFileFromResource", "onComplete", "Lkotlin/Function1;", "loadFromNetwork", "url", "onAttachedToWindow", "onDetachedFromWindow", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "onSurfaceTextureAvailable", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureSizeChanged", "surface", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "pause", "animationName", "isStateMachine", "animationNames", "areStateMachines", "play", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "settleInitialState", "registerListener", "removeEventListener", "reset", "restoreControllerState", "state", "Lapp/rive/runtime/kotlin/controllers/ControllerState;", "saveControllerState", "setAssetLoader", "assetLoader", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "setBooleanState", "setBooleanStateAtPath", "setMultipleStates", "inputs", "", "Lapp/rive/runtime/kotlin/ChangedInput;", "([Lapp/rive/runtime/kotlin/ChangedInput;)V", "setNumberState", "setNumberStateAtPath", "setRiveBytes", "bytes", "", "autoBind", "setRiveFile", "setRiveResource", "resId", "setTextRunValue", "textValue", "setVolume", "startFrameMetrics", "stop", "stopFrameMetrics", "unregisterListener", "validateLifecycleOwner", "Builder", "Companion", "RendererAttributes", "kotlin_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRiveAnimationView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiveAnimationView.kt\napp/rive/runtime/kotlin/RiveAnimationView\n+ 2 RiveTextureView.kt\napp/rive/runtime/kotlin/RiveTextureView\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1291:1\n64#2,8:1292\n1#3:1300\n*S KotlinDebug\n*F\n+ 1 RiveAnimationView.kt\napp/rive/runtime/kotlin/RiveAnimationView\n*L\n193#1:1292,8\n*E\n"})
public class RiveAnimationView
extends RiveTextureView
implements Observable<RiveFileController.Listener> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean defaultAutoplay;
    @NotNull
    private RiveFileController controller;
    @NotNull
    private final RendererAttributes rendererAttributes;
    @Nullable
    private Window.OnFrameMetricsAvailableListener frameMetricsListener;
    @NotNull
    private final RectF bounds;
    @Nullable
    private LifecycleOwner lifecycleOwner;
    private boolean touchPassThrough;
    @NotNull
    private final SparseBooleanArray pointersInsideView;
    private boolean multiTouchEnabled;
    public static final int $stable = 8;
    @NotNull
    public static final String TAG = "RiveAnimationView";
    public static final int SINGLE_TOUCH_ID = 0;
    private static final int alignmentIndexDefault = Alignment.CENTER.ordinal();
    private static final int fitIndexDefault = Fit.CONTAIN.ordinal();
    private static final int loopIndexDefault = Loop.AUTO.ordinal();
    public static final boolean traceAnimationsDefault = false;
    public static final boolean shouldLoadCDNAssetsDefault = true;
    private static final int rendererIndexDefault = Rive.INSTANCE.getDefaultRendererType().getValue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RiveAnimationView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Context context2;
        RiveTextureView riveTextureView;
        block7: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, attrs);
            this.defaultAutoplay = true;
            this.bounds = new RectF();
            riveTextureView = this;
            RiveAnimationView riveAnimationView = this;
            boolean $i$f$getContextAsType = false;
            Context ctx$iv = this_$iv.getContext();
            while (ctx$iv instanceof ContextWrapper) {
                if (ctx$iv instanceof LifecycleOwner) {
                    context2 = ctx$iv;
                    break block7;
                }
                ctx$iv = ((ContextWrapper)ctx$iv).getBaseContext();
            }
            context2 = null;
        }
        riveAnimationView.lifecycleOwner = (LifecycleOwner)context2;
        this.pointersInsideView = new SparseBooleanArray();
        RiveTextureView $this$_init__u24lambda_u241 = riveTextureView = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RiveAnimationView, 0, 0);
        boolean bl = false;
        try {
            int resId = $this$_init__u24lambda_u241.getResourceId(R.styleable.RiveAnimationView_riveResource, -1);
            String resUrl = $this$_init__u24lambda_u241.getString(R.styleable.RiveAnimationView_riveUrl);
            ResourceType resourceFromValue = ResourceType.Companion.makeMaybeResource(resId == -1 ? resUrl : Integer.valueOf(resId));
            String string = $this$_init__u24lambda_u241.getString(R.styleable.RiveAnimationView_riveAssetLoaderClass);
            Context context3 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getApplicationContext(...)");
            FileAssetLoader customLoader = RendererAttributes.Companion.assetLoaderFrom(string, context3);
            boolean shouldLoadCDNAssets = $this$_init__u24lambda_u241.getBoolean(R.styleable.RiveAnimationView_riveShouldLoadCDNAssets, true);
            this.setTouchPassThrough($this$_init__u24lambda_u241.getBoolean(R.styleable.RiveAnimationView_riveTouchPassThrough, false));
            this.setMultiTouchEnabled($this$_init__u24lambda_u241.getBoolean(R.styleable.RiveAnimationView_riveMultiTouchEnabled, false));
            int n = $this$_init__u24lambda_u241.getInteger(R.styleable.RiveAnimationView_riveAlignment, alignmentIndexDefault);
            int n2 = $this$_init__u24lambda_u241.getInteger(R.styleable.RiveAnimationView_riveFit, fitIndexDefault);
            int n3 = $this$_init__u24lambda_u241.getInteger(R.styleable.RiveAnimationView_riveLoop, loopIndexDefault);
            boolean bl2 = $this$_init__u24lambda_u241.getBoolean(R.styleable.RiveAnimationView_riveAutoPlay, this.getDefaultAutoplay());
            boolean bl3 = $this$_init__u24lambda_u241.getBoolean(R.styleable.RiveAnimationView_riveAutoBind, false);
            boolean bl4 = $this$_init__u24lambda_u241.getBoolean(R.styleable.RiveAnimationView_riveTraceAnimations, false);
            String string2 = $this$_init__u24lambda_u241.getString(R.styleable.RiveAnimationView_riveArtboard);
            String string3 = $this$_init__u24lambda_u241.getString(R.styleable.RiveAnimationView_riveAnimation);
            String string4 = $this$_init__u24lambda_u241.getString(R.styleable.RiveAnimationView_riveStateMachine);
            int n4 = $this$_init__u24lambda_u241.getInteger(R.styleable.RiveAnimationView_riveRenderer, rendererIndexDefault);
            Context context4 = context.getApplicationContext();
            Intrinsics.checkNotNull((Object)context4);
            FallbackAssetLoader fallbackAssetLoader = new FallbackAssetLoader(context4, shouldLoadCDNAssets, customLoader);
            this.rendererAttributes = new RendererAttributes(n, n2, n3, n4, bl2, bl3, bl4, string2, string3, string4, resourceFromValue, fallbackAssetLoader);
            this.controller = new RiveFileController(this.rendererAttributes.getLoop(), this.rendererAttributes.getAutoplay(), null, null, null, 28, null);
            LifecycleOwner lifecycleOwner = this.lifecycleOwner;
            if (lifecycleOwner != null && (lifecycleOwner = lifecycleOwner.getLifecycle()) != null) {
                lifecycleOwner.addObserver(this.getLifecycleObserver());
            }
            ResourceType resourceType = resourceFromValue;
            if (resourceType != null) {
                ResourceType it = resourceType;
                boolean bl5 = false;
                this.loadFileFromResource((Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
                    final /* synthetic */ RiveAnimationView this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.getController().setFile(it);
                        this.this$0.getController().setupScene$kotlin_release(this.this$0.getRendererAttributes());
                    }
                }));
            }
        }
        finally {
            $this$_init__u24lambda_u241.recycle();
        }
    }

    public /* synthetic */ RiveAnimationView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public boolean getDefaultAutoplay() {
        return this.defaultAutoplay;
    }

    @NotNull
    public final RiveFileController getController() {
        return this.controller;
    }

    public final void setController(@NotNull RiveFileController riveFileController) {
        Intrinsics.checkNotNullParameter((Object)riveFileController, (String)"<set-?>");
        this.controller = riveFileController;
    }

    @Nullable
    public final RiveArtboardRenderer getArtboardRenderer() {
        String string;
        Renderer renderer = this.getRenderer();
        if (renderer == null ? true : renderer instanceof RiveArtboardRenderer) {
            return (RiveArtboardRenderer)this.getRenderer();
        }
        Object object = this.getRenderer();
        if ((object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : (string = null)) == null) {
            string = "NULL";
        }
        throw new TypeCastException("Expected RiveArtboardRenderer but got " + string);
    }

    @NotNull
    public final RendererAttributes getRendererAttributes() {
        return this.rendererAttributes;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getRendererAttributes$annotations() {
    }

    @NotNull
    public final Fit getFit() {
        return this.controller.getFit();
    }

    public final void setFit(@NotNull Fit value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.controller.setFit(value);
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.controller.getAlignment();
    }

    public final void setAlignment(@NotNull Alignment value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.controller.setAlignment(value);
    }

    @Nullable
    public final Float getLayoutScaleFactor() {
        return this.controller.getLayoutScaleFactor();
    }

    public final void setLayoutScaleFactor(@Nullable Float value) {
        this.controller.setLayoutScaleFactor(value);
    }

    public final float getLayoutScaleFactorAutomatic() {
        return this.controller.getLayoutScaleFactorAutomatic();
    }

    public final void setLayoutScaleFactorAutomatic$kotlin_release(float value) {
        this.controller.setLayoutScaleFactorAutomatic$kotlin_release(value);
    }

    @Nullable
    public final File getFile() {
        return this.controller.getFile();
    }

    @Nullable
    public final String getArtboardName() {
        Artboard artboard = this.controller.getActiveArtboard();
        return artboard != null ? artboard.getName() : null;
    }

    public final void setArtboardName(@Nullable String name2) {
        this.controller.selectArtboard(name2);
    }

    public final boolean getAutoplay() {
        return this.controller.getAutoplay();
    }

    public final void setAutoplay(boolean value) {
        this.controller.setAutoplay(value);
    }

    @NotNull
    public final List<LinearAnimationInstance> getAnimations() {
        return this.controller.getAnimations();
    }

    @NotNull
    public final List<StateMachineInstance> getStateMachines() {
        return this.controller.getStateMachines();
    }

    @NotNull
    public final HashSet<LinearAnimationInstance> getPlayingAnimations() {
        return this.controller.getPlayingAnimations();
    }

    @NotNull
    public final HashSet<StateMachineInstance> getPlayingStateMachines() {
        return this.controller.getPlayingStateMachines();
    }

    public boolean getTouchPassThrough() {
        return this.touchPassThrough;
    }

    public void setTouchPassThrough(boolean bl) {
        this.touchPassThrough = bl;
    }

    public boolean getMultiTouchEnabled() {
        return this.multiTouchEnabled;
    }

    public void setMultiTouchEnabled(boolean value) {
        this.multiTouchEnabled = value;
        if (!value) {
            IntIterator pointers = SparseBooleanArrayKt.keyIterator((SparseBooleanArray)this.pointersInsideView);
            while (pointers.hasNext()) {
                int pointerId = pointers.nextInt();
                if (pointerId == 0) continue;
                this.controller.pointerEvent(PointerEvents.POINTER_UP, pointerId, -1.0f, -1.0f);
                this.controller.pointerEvent(PointerEvents.POINTER_EXIT, pointerId, -1.0f, -1.0f);
                this.pointersInsideView.delete(pointerId);
            }
        }
    }

    public RiveAnimationView(@NotNull Builder builder) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this(builder.getContext$kotlin_release(), null, 2, null);
        if (!(this.getArtboardRenderer() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        RendererAttributes $this$_init__u24lambda_u242 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        RendererType rendererType = builder.getRendererType$kotlin_release();
        if (rendererType == null) {
            rendererType = RendererType.Companion.fromIndex(rendererIndexDefault);
        }
        $this$_init__u24lambda_u242.setRendererType(rendererType);
        Boolean bl2 = builder.getAutoplay$kotlin_release();
        $this$_init__u24lambda_u242.setAutoplay(bl2 != null ? bl2.booleanValue() : this.getDefaultAutoplay());
        $this$_init__u24lambda_u242.setAutoBind(builder.getAutoBind$kotlin_release());
        Boolean bl3 = builder.getTraceAnimations$kotlin_release();
        $this$_init__u24lambda_u242.setRiveTraceAnimations(bl3 != null ? bl3 : false);
        $this$_init__u24lambda_u242.setArtboardName(builder.getArtboardName$kotlin_release());
        $this$_init__u24lambda_u242.setAnimationName(builder.getAnimationName$kotlin_release());
        $this$_init__u24lambda_u242.setStateMachineName(builder.getStateMachineName$kotlin_release());
        $this$_init__u24lambda_u242.setResource(builder.getResourceType$kotlin_release());
        FileAssetLoader fileAssetLoader = $this$_init__u24lambda_u242.getAssetLoader();
        Intrinsics.checkNotNull((Object)fileAssetLoader, (String)"null cannot be cast to non-null type app.rive.runtime.kotlin.core.FallbackAssetLoader");
        ((FallbackAssetLoader)fileAssetLoader).resetWith$kotlin_release(builder);
        Alignment alignment = builder.getAlignment$kotlin_release();
        if (alignment == null) {
            alignment = $this$_init__u24lambda_u242.getAlignment();
        }
        $this$_init__u24lambda_u242.setAlignment(alignment);
        Fit fit = builder.getFit$kotlin_release();
        if (fit == null) {
            fit = $this$_init__u24lambda_u242.getFit();
        }
        $this$_init__u24lambda_u242.setFit(fit);
        Loop loop = builder.getLoop$kotlin_release();
        if (loop == null) {
            loop = $this$_init__u24lambda_u242.getLoop();
        }
        $this$_init__u24lambda_u242.setLoop(loop);
        this.setTouchPassThrough(builder.getTouchPassThrough$kotlin_release());
        this.setMultiTouchEnabled(builder.getMultiTouchEnabled$kotlin_release());
    }

    @Override
    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        super.onSurfaceTextureSizeChanged(surface, width, height);
        this.controller.setTargetBounds(new RectF(0.0f, 0.0f, (float)width, (float)height));
    }

    @Override
    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        super.onSurfaceTextureAvailable(surfaceTexture, width, height);
        this.controller.setTargetBounds(new RectF(0.0f, 0.0f, (float)width, (float)height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadFileFromResource(Function1<? super File, Unit> onComplete) {
        ResourceType resource = this.rendererAttributes.getResource();
        if (resource == null) {
            Log.w((String)TAG, (String)"loadResource: no resource to load");
        } else if (resource instanceof ResourceType.ResourceRiveFile) {
            onComplete.invoke((Object)((ResourceType.ResourceRiveFile)resource).getFile());
        } else if (resource instanceof ResourceType.ResourceUrl) {
            this.loadFromNetwork(((ResourceType.ResourceUrl)resource).getUrl(), onComplete);
        } else if (resource instanceof ResourceType.ResourceBytes) {
            File file = new File(((ResourceType.ResourceBytes)resource).getBytes(), this.rendererAttributes.getRendererType(), this.rendererAttributes.getAssetLoader());
            onComplete.invoke((Object)file);
            file.release();
        } else if (resource instanceof ResourceType.ResourceId) {
            Closeable closeable = this.getResources().openRawResource(((ResourceType.ResourceId)resource).getId());
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                File file = new File(ByteStreamsKt.readBytes((InputStream)it), this.rendererAttributes.getRendererType(), this.rendererAttributes.getAssetLoader());
                onComplete.invoke((Object)file);
                int n = file.release();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private final void loadFromNetwork(String url, Function1<? super File, Unit> onComplete) {
        RequestQueue requestQueue = Volley.newRequestQueue((Context)this.getContext().getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)requestQueue, (String)"newRequestQueue(...)");
        RequestQueue queue2 = requestQueue;
        RiveFileRequest stringRequest = new RiveFileRequest(url, this.rendererAttributes.getRendererType(), (Response.Listener<File>)((Response.Listener)arg_0 -> RiveAnimationView.loadFromNetwork$lambda$4(onComplete, arg_0)), arg_0 -> RiveAnimationView.loadFromNetwork$lambda$5(url, arg_0), this.rendererAttributes.getAssetLoader());
        queue2.add((Request)stringRequest);
    }

    public final void pause() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        if (riveArtboardRenderer != null) {
            riveArtboardRenderer.stop();
        }
        this.controller.pause();
        this.stopFrameMetrics();
    }

    public final void pause(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        this.controller.pause(animationNames, areStateMachines);
    }

    public static /* synthetic */ void pause$default(RiveAnimationView riveAnimationView, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.pause(list, bl);
    }

    public final void pause(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        this.controller.pause(animationName, isStateMachine);
    }

    public static /* synthetic */ void pause$default(RiveAnimationView riveAnimationView, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.pause(string, bl);
    }

    public final void stop() {
        this.controller.stopAnimations();
        this.stopFrameMetrics();
    }

    public final void stop(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        this.controller.stopAnimations(animationNames, areStateMachines);
    }

    public static /* synthetic */ void stop$default(RiveAnimationView riveAnimationView, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stop");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.stop(list, bl);
    }

    public final void stop(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        this.controller.stopAnimations(animationName, isStateMachine);
    }

    public static /* synthetic */ void stop$default(RiveAnimationView riveAnimationView, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stop");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.stop(string, bl);
    }

    public final void play(@NotNull Loop loop, @NotNull Direction direction, boolean settleInitialState) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        RendererAttributes $this$play_u24lambda_u246 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$play_u24lambda_u246.setLoop(loop);
        this.controller.play(loop, direction, settleInitialState);
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 1) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 2) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        riveAnimationView.play(loop, direction, bl);
    }

    public final void play(@NotNull List<String> animationNames, @NotNull Loop loop, @NotNull Direction direction, boolean areStateMachines, boolean settleInitialState) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        RendererAttributes $this$play_u24lambda_u247 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$play_u24lambda_u247.setLoop(loop);
        this.controller.play(animationNames, loop, direction, areStateMachines, settleInitialState);
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, List list, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveAnimationView.play(list, loop, direction, bl, bl2);
    }

    public final void play(@NotNull String animationName, @NotNull Loop loop, @NotNull Direction direction, boolean isStateMachine, boolean settleInitialState) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        RendererAttributes $this$play_u24lambda_u248 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$play_u24lambda_u248.setAnimationName(isStateMachine ? null : animationName);
        $this$play_u24lambda_u248.setStateMachineName(isStateMachine ? animationName : null);
        $this$play_u24lambda_u248.setLoop(loop);
        this.controller.play(animationName, loop, direction, isStateMachine, settleInitialState);
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveAnimationView.play(string, loop, direction, bl, bl2);
    }

    public final void reset() {
        block0: {
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.reset();
        }
    }

    public final void fireState(@NotNull String stateMachineName, @NotNull String inputName) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        RiveFileController.fireState$default(this.controller, stateMachineName, inputName, null, 4, null);
    }

    public final void setBooleanState(@NotNull String stateMachineName, @NotNull String inputName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        RiveFileController.setBooleanState$default(this.controller, stateMachineName, inputName, value, null, 8, null);
    }

    public final void setNumberState(@NotNull String stateMachineName, @NotNull String inputName, float value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        RiveFileController.setNumberState$default(this.controller, stateMachineName, inputName, value, null, 8, null);
    }

    public final void fireStateAtPath(@NotNull String inputName, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.controller.fireStateAtPath(inputName, path);
    }

    public final void setBooleanStateAtPath(@NotNull String inputName, boolean value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.controller.setBooleanStateAtPath(inputName, value, path);
    }

    public final void setNumberStateAtPath(@NotNull String inputName, float value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.controller.setNumberStateAtPath(inputName, value, path);
    }

    public final void setMultipleStates(ChangedInput ... inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        this.controller.queueInputs$kotlin_release(Arrays.copyOf(inputs, inputs.length));
    }

    @Nullable
    public final String getTextRunValue(@NotNull String textRunName) {
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        return this.controller.getTextRunValue(textRunName);
    }

    @Nullable
    public final String getTextRunValue(@NotNull String textRunName, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.controller.getTextRunValue(textRunName, path);
    }

    public final void setTextRunValue(@NotNull String textRunName, @NotNull String textValue) {
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        this.controller.setTextRunValue(textRunName, textValue);
    }

    public final void setTextRunValue(@NotNull String textRunName, @NotNull String textValue, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.controller.setTextRunValue(textRunName, textValue, path);
    }

    @Nullable
    public final Float getVolume() {
        return this.controller.getVolume();
    }

    public final void setVolume(float value) {
        this.controller.setVolume(value);
    }

    public final boolean isPlaying() {
        Renderer renderer = this.getRenderer();
        return renderer != null ? renderer.isPlaying() : false;
    }

    public final void setRiveResource(@RawRes int resId, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, boolean autoBind, @NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        RendererAttributes $this$setRiveResource_u24lambda_u249 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$setRiveResource_u24lambda_u249.setArtboardName(artboardName);
        $this$setRiveResource_u24lambda_u249.setAnimationName(animationName);
        $this$setRiveResource_u24lambda_u249.setStateMachineName(stateMachineName);
        $this$setRiveResource_u24lambda_u249.setAutoplay(autoplay);
        $this$setRiveResource_u24lambda_u249.setAutoBind(autoBind);
        $this$setRiveResource_u24lambda_u249.setFit(fit);
        $this$setRiveResource_u24lambda_u249.setAlignment(alignment);
        $this$setRiveResource_u24lambda_u249.setLoop(loop);
        $this$setRiveResource_u24lambda_u249.setResource(ResourceType.Companion.makeMaybeResource(resId));
        this.loadFileFromResource((Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ RiveAnimationView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getController().setFile(it);
                this.this$0.getController().setupScene$kotlin_release(this.this$0.getRendererAttributes());
            }
        }));
    }

    public static /* synthetic */ void setRiveResource$default(RiveAnimationView riveAnimationView, int n, String string, String string2, String string3, boolean bl, boolean bl2, Fit fit, Alignment alignment, Loop loop, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setRiveResource");
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = riveAnimationView.controller.getAutoplay();
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            fit = Fit.Companion.fromIndex(fitIndexDefault);
        }
        if ((n2 & 0x80) != 0) {
            alignment = Alignment.Companion.fromIndex(alignmentIndexDefault);
        }
        if ((n2 & 0x100) != 0) {
            loop = Loop.Companion.fromIndex(loopIndexDefault);
        }
        riveAnimationView.setRiveResource(n, string, string2, string3, bl, bl2, fit, alignment, loop);
    }

    public final void setRiveBytes(@NotNull byte[] bytes, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, boolean autoBind, @NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        RendererAttributes $this$setRiveBytes_u24lambda_u2410 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$setRiveBytes_u24lambda_u2410.setArtboardName(artboardName);
        $this$setRiveBytes_u24lambda_u2410.setAnimationName(animationName);
        $this$setRiveBytes_u24lambda_u2410.setStateMachineName(stateMachineName);
        $this$setRiveBytes_u24lambda_u2410.setAutoplay(autoplay);
        $this$setRiveBytes_u24lambda_u2410.setAutoBind(autoBind);
        $this$setRiveBytes_u24lambda_u2410.setFit(fit);
        $this$setRiveBytes_u24lambda_u2410.setAlignment(alignment);
        $this$setRiveBytes_u24lambda_u2410.setLoop(loop);
        $this$setRiveBytes_u24lambda_u2410.setResource(ResourceType.Companion.makeMaybeResource(bytes));
        this.loadFileFromResource((Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ RiveAnimationView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getController().setFile(it);
                this.this$0.getController().setupScene$kotlin_release(this.this$0.getRendererAttributes());
            }
        }));
    }

    public static /* synthetic */ void setRiveBytes$default(RiveAnimationView riveAnimationView, byte[] byArray, String string, String string2, String string3, boolean bl, boolean bl2, Fit fit, Alignment alignment, Loop loop, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setRiveBytes");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            bl = riveAnimationView.controller.getAutoplay();
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            fit = Fit.Companion.fromIndex(fitIndexDefault);
        }
        if ((n & 0x80) != 0) {
            alignment = Alignment.Companion.fromIndex(alignmentIndexDefault);
        }
        if ((n & 0x100) != 0) {
            loop = Loop.Companion.fromIndex(loopIndexDefault);
        }
        riveAnimationView.setRiveBytes(byArray, string, string2, string3, bl, bl2, fit, alignment, loop);
    }

    public final void setRiveFile(@NotNull File file, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, boolean autoBind, @NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        if (file.getRendererType() != this.rendererAttributes.getRendererType()) {
            throw new RiveException("Incompatible Renderer types: file initialized with " + file.getRendererType().name() + " but View is set up for " + this.rendererAttributes.getRendererType().name());
        }
        RendererAttributes $this$setRiveFile_u24lambda_u2411 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$setRiveFile_u24lambda_u2411.setArtboardName(artboardName);
        $this$setRiveFile_u24lambda_u2411.setAnimationName(animationName);
        $this$setRiveFile_u24lambda_u2411.setStateMachineName(stateMachineName);
        $this$setRiveFile_u24lambda_u2411.setAutoplay(autoplay);
        $this$setRiveFile_u24lambda_u2411.setAutoBind(autoBind);
        $this$setRiveFile_u24lambda_u2411.setFit(fit);
        $this$setRiveFile_u24lambda_u2411.setAlignment(alignment);
        $this$setRiveFile_u24lambda_u2411.setLoop(loop);
        $this$setRiveFile_u24lambda_u2411.setResource(ResourceType.Companion.makeMaybeResource(file));
        this.controller.setFile(file);
        this.controller.setupScene$kotlin_release(this.rendererAttributes);
    }

    public static /* synthetic */ void setRiveFile$default(RiveAnimationView riveAnimationView, File file, String string, String string2, String string3, boolean bl, boolean bl2, Fit fit, Alignment alignment, Loop loop, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setRiveFile");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            bl = riveAnimationView.controller.getAutoplay();
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            fit = Fit.Companion.fromIndex(fitIndexDefault);
        }
        if ((n & 0x80) != 0) {
            alignment = Alignment.Companion.fromIndex(alignmentIndexDefault);
        }
        if ((n & 0x100) != 0) {
            loop = Loop.Companion.fromIndex(loopIndexDefault);
        }
        riveAnimationView.setRiveFile(file, string, string2, string3, bl, bl2, fit, alignment, loop);
    }

    public final void setAssetLoader(@Nullable FileAssetLoader assetLoader) {
        block5: {
            if (Intrinsics.areEqual((Object)assetLoader, (Object)this.rendererAttributes.getAssetLoader())) {
                return;
            }
            FileAssetLoader currentAssetLoader = this.rendererAttributes.getAssetLoader();
            this.rendererAttributes.setAssetLoader(assetLoader);
            FileAssetLoader fileAssetLoader = assetLoader;
            if (fileAssetLoader != null) {
                fileAssetLoader.acquire();
            }
            FileAssetLoader fileAssetLoader2 = currentAssetLoader;
            if (fileAssetLoader2 != null) {
                fileAssetLoader2.release();
            }
            LifecycleObserver lifecycleObserver2 = this.getLifecycleObserver();
            RiveViewLifecycleObserver riveViewLifecycleObserver = lifecycleObserver2 instanceof RiveViewLifecycleObserver ? (RiveViewLifecycleObserver)lifecycleObserver2 : null;
            if (riveViewLifecycleObserver == null) break block5;
            RiveViewLifecycleObserver depObserver = riveViewLifecycleObserver;
            boolean bl = false;
            FileAssetLoader fileAssetLoader3 = currentAssetLoader;
            if (fileAssetLoader3 != null) {
                FileAssetLoader old = fileAssetLoader3;
                boolean bl2 = false;
                depObserver.remove(old);
            }
            FileAssetLoader fileAssetLoader4 = assetLoader;
            if (fileAssetLoader4 != null) {
                FileAssetLoader fileAssetLoader5 = fileAssetLoader4;
                boolean bl3 = false;
                depObserver.insert(fileAssetLoader5);
            }
        }
    }

    @Override
    @NotNull
    protected Renderer createRenderer() {
        boolean bl = this.rendererAttributes.getRiveTraceAnimations();
        RiveFileController riveFileController = this.controller;
        RendererType rendererType = this.rendererAttributes.getRendererType();
        return new RiveArtboardRenderer(bl, rendererType, riveFileController);
    }

    @Override
    @NotNull
    protected LifecycleObserver createObserver() {
        Object[] objectArray = new RefCount[]{this.controller, this.rendererAttributes.getAssetLoader()};
        return (LifecycleObserver)new RiveViewLifecycleObserver(CollectionsKt.toMutableList((Collection)CollectionsKt.listOfNotNull((Object[])objectArray)));
    }

    private final void validateLifecycleOwner() {
        block3: {
            LifecycleOwner currentLifecycleOwner;
            LifecycleOwner lifecycleOwner = currentLifecycleOwner = ViewTreeLifecycleOwner.get((View)((View)this));
            if (lifecycleOwner == null) break block3;
            LifecycleOwner it = lifecycleOwner;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)this.lifecycleOwner)) {
                LifecycleOwner lifecycleOwner2;
                LifecycleOwner lifecycleOwner3 = this.lifecycleOwner;
                if (lifecycleOwner3 != null && (lifecycleOwner3 = lifecycleOwner3.getLifecycle()) != null) {
                    lifecycleOwner3.removeObserver(this.getLifecycleObserver());
                }
                if ((lifecycleOwner2 = (this.lifecycleOwner = currentLifecycleOwner)) != null && (lifecycleOwner2 = lifecycleOwner2.getLifecycle()) != null) {
                    lifecycleOwner2.addObserver(this.getLifecycleObserver());
                }
            }
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.validateLifecycleOwner();
        if (this.controller.getFile() == null) {
            this.loadFileFromResource((Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
                final /* synthetic */ RiveAnimationView this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.getController().setFile(it);
                    this.this$0.getController().setupScene$kotlin_release(this.this$0.getRendererAttributes());
                }
            }));
        }
        Renderer renderer = this.getRenderer();
        Intrinsics.checkNotNull((Object)renderer);
        if (renderer.getTrace()) {
            this.startFrameMetrics();
        }
        this.controller.setActive(true);
        Renderer renderer2 = this.getRenderer();
        Intrinsics.checkNotNull((Object)renderer2);
        renderer2.start();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.controller.setActive(false);
        this.stopFrameMetrics();
        super.onDetachedFromWindow();
    }

    @ControllerStateManagement
    @Nullable
    public final ControllerState saveControllerState() {
        this.rendererAttributes.setResource(null);
        return this.controller.saveControllerState();
    }

    @ControllerStateManagement
    public final void restoreControllerState(@NotNull ControllerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.controller.restoreControllerState(state);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=24)
    private final void startFrameMetrics() {
        if (Build.VERSION.SDK_INT >= 24) {
            void it;
            RendererMetrics rendererMetrics;
            RendererMetrics rendererMetrics2 = rendererMetrics = new RendererMetrics(this.getActivity());
            RiveAnimationView riveAnimationView = this;
            boolean bl = false;
            this.getActivity().getWindow().addOnFrameMetricsAvailableListener((Window.OnFrameMetricsAvailableListener)it, new Handler(Looper.getMainLooper()));
            riveAnimationView.frameMetricsListener = rendererMetrics;
        } else {
            Log.w((String)TAG, (String)"FrameMetrics is available with Android SDK 24 (Nougat) and higher");
        }
    }

    @TargetApi(value=24)
    private final void stopFrameMetrics() {
        block1: {
            if (Build.VERSION.SDK_INT < 24) break block1;
            Window.OnFrameMetricsAvailableListener onFrameMetricsAvailableListener = this.frameMetricsListener;
            if (onFrameMetricsAvailableListener != null) {
                Window.OnFrameMetricsAvailableListener it = onFrameMetricsAvailableListener;
                boolean bl = false;
                this.getActivity().getWindow().removeOnFrameMetricsAvailableListener(it);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getRenderer() == null) {
            Log.w((String)TAG, (String)"onMeasure(): Renderer not instantiated yet.");
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int providedWidth = widthMode == 0 ? (int)this.controller.getArtboardBounds().width() : View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int providedHeight = heightMode == 0 ? (int)this.controller.getArtboardBounds().height() : View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.controller.setLayoutScaleFactorAutomatic$kotlin_release(this.getResources().getDisplayMetrics().density);
        this.controller.getRequireArtboardResize$kotlin_release().set(true);
        this.bounds.set(0.0f, 0.0f, (float)providedWidth, (float)providedHeight);
        RectF usedBounds = Rive.INSTANCE.calculateRequiredBounds(this.controller.getFit(), this.controller.getAlignment(), this.bounds, this.controller.getArtboardBounds(), this.controller.getLayoutScaleFactorActive$kotlin_release());
        switch (widthMode) {
            case 0x40000000: {
                n2 = providedWidth;
                break;
            }
            case -2147483648: {
                n2 = Math.min((int)usedBounds.width(), providedWidth);
                break;
            }
            default: {
                n2 = (int)usedBounds.width();
            }
        }
        int width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = providedHeight;
                break;
            }
            case -2147483648: {
                n = Math.min((int)usedBounds.height(), providedHeight);
                break;
            }
            default: {
                n = (int)usedBounds.height();
            }
        }
        int height = n;
        this.setMeasuredDimension(width, height);
    }

    @Override
    public void registerListener(@NotNull RiveFileController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.controller.registerListener(listener);
    }

    @Override
    public void unregisterListener(@NotNull RiveFileController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.controller.unregisterListener(listener);
    }

    public final void addEventListener(@NotNull RiveFileController.RiveEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.controller.addEventListener(listener);
    }

    public final void removeEventListener(@NotNull RiveFileController.RiveEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.controller.removeEventListener(listener);
    }

    private final boolean inBounds(float x, float y) {
        return x >= 0.0f && y >= 0.0f && x < (float)this.getWidth() && y < (float)this.getHeight();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean returnVal = !this.getTouchPassThrough();
        switch (event.getActionMasked()) {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J,\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"app/rive/runtime/kotlin/RiveAnimationView$onTouchEvent$PointerInfo", "", "id", "", "x", "", "y", "(IFF)V", "getId", "()I", "getX", "()F", "getY", "component1", "component2", "component3", "copy", "(IFF)Lapp/rive/runtime/kotlin/RiveAnimationView$onTouchEvent$PointerInfo;", "equals", "", "other", "hashCode", "toString", "", "kotlin_release"})
            public final class PointerInfo {
                private final int id;
                private final float x;
                private final float y;

                public PointerInfo(int id, float x, float y) {
                    this.id = id;
                    this.x = x;
                    this.y = y;
                }

                public final int getId() {
                    return this.id;
                }

                public final float getX() {
                    return this.x;
                }

                public final float getY() {
                    return this.y;
                }

                public final int component1() {
                    return this.id;
                }

                public final float component2() {
                    return this.x;
                }

                public final float component3() {
                    return this.y;
                }

                @NotNull
                public final PointerInfo copy(int id, float x, float y) {
                    return new PointerInfo(id, x, y);
                }

                public static /* synthetic */ PointerInfo copy$default(PointerInfo pointerInfo, int n, float f, float f2, int n2, Object object) {
                    if ((n2 & 1) != 0) {
                        n = pointerInfo.id;
                    }
                    if ((n2 & 2) != 0) {
                        f = pointerInfo.x;
                    }
                    if ((n2 & 4) != 0) {
                        f2 = pointerInfo.y;
                    }
                    return pointerInfo.copy(n, f, f2);
                }

                @NotNull
                public String toString() {
                    return "PointerInfo(id=" + this.id + ", x=" + this.x + ", y=" + this.y + ")";
                }

                public int hashCode() {
                    int result = Integer.hashCode(this.id);
                    result = result * 31 + Float.hashCode(this.x);
                    result = result * 31 + Float.hashCode(this.y);
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof PointerInfo)) {
                        return false;
                    }
                    PointerInfo pointerInfo = (PointerInfo)other;
                    if (this.id != pointerInfo.id) {
                        return false;
                    }
                    if (Float.compare(this.x, pointerInfo.x) != 0) {
                        return false;
                    }
                    return Float.compare(this.y, pointerInfo.y) == 0;
                }
            }
            case 0: {
                PointerInfo pointerInfo = RiveAnimationView.onTouchEvent$pointerInfoAt(this, event, event.getActionIndex());
                int id = pointerInfo.component1();
                float x = pointerInfo.component2();
                float y = pointerInfo.component3();
                this.pointersInsideView.put(id, this.inBounds(x, y));
                this.controller.pointerEvent(PointerEvents.POINTER_DOWN, id, x, y);
                break;
            }
            case 5: {
                if (!this.getMultiTouchEnabled()) {
                    return returnVal;
                }
                PointerInfo pointerInfo = RiveAnimationView.onTouchEvent$pointerInfoAt(this, event, event.getActionIndex());
                int id = pointerInfo.component1();
                float x = pointerInfo.component2();
                float y = pointerInfo.component3();
                this.pointersInsideView.put(id, this.inBounds(x, y));
                this.controller.pointerEvent(PointerEvents.POINTER_DOWN, id, x, y);
                break;
            }
            case 2: {
                int upperBound = this.getMultiTouchEnabled() ? event.getPointerCount() : 1;
                for (int i = 0; i < upperBound; ++i) {
                    PointerInfo x = RiveAnimationView.onTouchEvent$pointerInfoAt(this, event, i);
                    int id = x.component1();
                    float x2 = x.component2();
                    float y = x.component3();
                    boolean wasInside = this.pointersInsideView.get(id);
                    boolean nowInside = this.inBounds(x2, y);
                    if (wasInside && !nowInside) {
                        this.controller.pointerEvent(PointerEvents.POINTER_EXIT, id, x2, y);
                    }
                    this.pointersInsideView.put(id, nowInside);
                    this.controller.pointerEvent(PointerEvents.POINTER_MOVE, id, x2, y);
                }
                break;
            }
            case 6: {
                if (!this.getMultiTouchEnabled()) {
                    return returnVal;
                }
                PointerInfo upperBound = RiveAnimationView.onTouchEvent$pointerInfoAt(this, event, event.getActionIndex());
                int id = upperBound.component1();
                float x = upperBound.component2();
                float y = upperBound.component3();
                this.controller.pointerEvent(PointerEvents.POINTER_UP, id, x, y);
                this.controller.pointerEvent(PointerEvents.POINTER_EXIT, id, x, y);
                if (this.pointersInsideView.get(id)) {
                    this.performClick();
                }
                this.pointersInsideView.delete(id);
                break;
            }
            case 1: {
                PointerInfo upperBound = RiveAnimationView.onTouchEvent$pointerInfoAt(this, event, event.getActionIndex());
                int id = upperBound.component1();
                float x = upperBound.component2();
                float y = upperBound.component3();
                this.controller.pointerEvent(PointerEvents.POINTER_UP, id, x, y);
                this.controller.pointerEvent(PointerEvents.POINTER_EXIT, id, x, y);
                if (this.pointersInsideView.get(id)) {
                    this.performClick();
                }
                this.pointersInsideView.clear();
                break;
            }
            case 3: {
                IntIterator keyIterator = SparseBooleanArrayKt.keyIterator((SparseBooleanArray)this.pointersInsideView);
                while (keyIterator.hasNext()) {
                    int remainingId = keyIterator.nextInt();
                    this.controller.pointerEvent(PointerEvents.POINTER_UP, remainingId, -1.0f, -1.0f);
                    this.controller.pointerEvent(PointerEvents.POINTER_EXIT, remainingId, -1.0f, -1.0f);
                }
                this.pointersInsideView.clear();
                break;
            }
            default: {
                Log.w((String)TAG, (String)"onTouchEvent(): Renderer not instantiated yet.");
            }
        }
        return returnVal;
    }

    private static final void loadFromNetwork$lambda$4(Function1 $onComplete, File it) {
        Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
        Intrinsics.checkNotNull((Object)it);
        $onComplete.invoke((Object)it);
        it.release();
    }

    private static final void loadFromNetwork$lambda$5(String $url, VolleyError it) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        throw new IOException("Unable to download Rive file " + $url);
    }

    private static final onTouchEvent.PointerInfo onTouchEvent$pointerInfoAt(RiveAnimationView this$0, MotionEvent $event, int index) {
        int id = this$0.getMultiTouchEnabled() ? $event.getPointerId(index) : 0;
        return new PointerInfo(id, $event.getX(index), $event.getY(index));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010T\u001a\u00020UJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0006J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\fJ\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\fJ\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0015J\u000e\u0010[\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u001bJ\u000e\u0010\\\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u001bJ\u000e\u0010]\u001a\u00020\u00002\u0006\u0010W\u001a\u00020)J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010W\u001a\u00020/J\u000e\u0010_\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u001bJ\u000e\u0010`\u001a\u00020\u00002\u0006\u0010W\u001a\u000208J\u000e\u0010a\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0001J\u000e\u0010b\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u001bJ\u000e\u0010c\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\fJ\u000e\u0010d\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u001bJ\u000e\u0010e\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u001bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u0004\u0018\u00010\u001bX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001d\"\u0004\b6\u0010\u001fR\u001c\u00107\u001a\u0004\u0018\u000108X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001c\u0010=\u001a\u0004\u0018\u00010\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u001d\"\u0004\bJ\u0010\u001fR\u001c\u0010K\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\u000e\"\u0004\bM\u0010\u0010R\u001a\u0010N\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\u001d\"\u0004\bP\u0010\u001fR\u001e\u0010Q\u001a\u0004\u0018\u00010\u001bX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\bR\u0010\"\"\u0004\bS\u0010$\u00a8\u0006f"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "getAlignment$kotlin_release", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment$kotlin_release", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "animationName", "", "getAnimationName$kotlin_release", "()Ljava/lang/String;", "setAnimationName$kotlin_release", "(Ljava/lang/String;)V", "artboardName", "getArtboardName$kotlin_release", "setArtboardName$kotlin_release", "assetLoader", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "getAssetLoader$kotlin_release", "()Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "setAssetLoader$kotlin_release", "(Lapp/rive/runtime/kotlin/core/FileAssetLoader;)V", "autoBind", "", "getAutoBind$kotlin_release", "()Z", "setAutoBind$kotlin_release", "(Z)V", "autoplay", "getAutoplay$kotlin_release", "()Ljava/lang/Boolean;", "setAutoplay$kotlin_release", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getContext$kotlin_release", "()Landroid/content/Context;", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "getFit$kotlin_release", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit$kotlin_release", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "getLoop$kotlin_release", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop$kotlin_release", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "multiTouchEnabled", "getMultiTouchEnabled$kotlin_release", "setMultiTouchEnabled$kotlin_release", "rendererType", "Lapp/rive/runtime/kotlin/core/RendererType;", "getRendererType$kotlin_release", "()Lapp/rive/runtime/kotlin/core/RendererType;", "setRendererType$kotlin_release", "(Lapp/rive/runtime/kotlin/core/RendererType;)V", "resource", "getResource$kotlin_release", "()Ljava/lang/Object;", "setResource$kotlin_release", "(Ljava/lang/Object;)V", "resourceType", "Lapp/rive/runtime/kotlin/ResourceType;", "getResourceType$kotlin_release", "()Lapp/rive/runtime/kotlin/ResourceType;", "setResourceType$kotlin_release", "(Lapp/rive/runtime/kotlin/ResourceType;)V", "shouldLoadCDNAssets", "getShouldLoadCDNAssets$kotlin_release", "setShouldLoadCDNAssets$kotlin_release", "stateMachineName", "getStateMachineName$kotlin_release", "setStateMachineName$kotlin_release", "touchPassThrough", "getTouchPassThrough$kotlin_release", "setTouchPassThrough$kotlin_release", "traceAnimations", "getTraceAnimations$kotlin_release", "setTraceAnimations$kotlin_release", "build", "Lapp/rive/runtime/kotlin/RiveAnimationView;", "setAlignment", "value", "setAnimationName", "setArtboardName", "setAssetLoader", "setAutoBind", "setAutoplay", "setFit", "setLoop", "setMultiTouchEnabled", "setRendererType", "setResource", "setShouldLoadCDNAssets", "setStateMachineName", "setTouchPassThrough", "setTraceAnimations", "kotlin_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nRiveAnimationView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiveAnimationView.kt\napp/rive/runtime/kotlin/RiveAnimationView$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1291:1\n1#2:1292\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Context context;
        @Nullable
        private Alignment alignment;
        @Nullable
        private Fit fit;
        @Nullable
        private Loop loop;
        @Nullable
        private RendererType rendererType;
        @Nullable
        private Boolean autoplay;
        private boolean autoBind;
        @Nullable
        private Boolean traceAnimations;
        @Nullable
        private String artboardName;
        @Nullable
        private String animationName;
        @Nullable
        private String stateMachineName;
        @Nullable
        private FileAssetLoader assetLoader;
        private boolean shouldLoadCDNAssets;
        private boolean touchPassThrough;
        private boolean multiTouchEnabled;
        @Nullable
        private Object resource;
        @Nullable
        private ResourceType resourceType;
        public static final int $stable = 8;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.shouldLoadCDNAssets = true;
        }

        @NotNull
        public final Context getContext$kotlin_release() {
            return this.context;
        }

        @Nullable
        public final Alignment getAlignment$kotlin_release() {
            return this.alignment;
        }

        public final void setAlignment$kotlin_release(@Nullable Alignment alignment) {
            this.alignment = alignment;
        }

        @Nullable
        public final Fit getFit$kotlin_release() {
            return this.fit;
        }

        public final void setFit$kotlin_release(@Nullable Fit fit) {
            this.fit = fit;
        }

        @Nullable
        public final Loop getLoop$kotlin_release() {
            return this.loop;
        }

        public final void setLoop$kotlin_release(@Nullable Loop loop) {
            this.loop = loop;
        }

        @Nullable
        public final RendererType getRendererType$kotlin_release() {
            return this.rendererType;
        }

        public final void setRendererType$kotlin_release(@Nullable RendererType rendererType) {
            this.rendererType = rendererType;
        }

        @Nullable
        public final Boolean getAutoplay$kotlin_release() {
            return this.autoplay;
        }

        public final void setAutoplay$kotlin_release(@Nullable Boolean bl) {
            this.autoplay = bl;
        }

        public final boolean getAutoBind$kotlin_release() {
            return this.autoBind;
        }

        public final void setAutoBind$kotlin_release(boolean bl) {
            this.autoBind = bl;
        }

        @Nullable
        public final Boolean getTraceAnimations$kotlin_release() {
            return this.traceAnimations;
        }

        public final void setTraceAnimations$kotlin_release(@Nullable Boolean bl) {
            this.traceAnimations = bl;
        }

        @Nullable
        public final String getArtboardName$kotlin_release() {
            return this.artboardName;
        }

        public final void setArtboardName$kotlin_release(@Nullable String string) {
            this.artboardName = string;
        }

        @Nullable
        public final String getAnimationName$kotlin_release() {
            return this.animationName;
        }

        public final void setAnimationName$kotlin_release(@Nullable String string) {
            this.animationName = string;
        }

        @Nullable
        public final String getStateMachineName$kotlin_release() {
            return this.stateMachineName;
        }

        public final void setStateMachineName$kotlin_release(@Nullable String string) {
            this.stateMachineName = string;
        }

        @Nullable
        public final FileAssetLoader getAssetLoader$kotlin_release() {
            return this.assetLoader;
        }

        public final void setAssetLoader$kotlin_release(@Nullable FileAssetLoader fileAssetLoader) {
            this.assetLoader = fileAssetLoader;
        }

        public final boolean getShouldLoadCDNAssets$kotlin_release() {
            return this.shouldLoadCDNAssets;
        }

        public final void setShouldLoadCDNAssets$kotlin_release(boolean bl) {
            this.shouldLoadCDNAssets = bl;
        }

        public final boolean getTouchPassThrough$kotlin_release() {
            return this.touchPassThrough;
        }

        public final void setTouchPassThrough$kotlin_release(boolean bl) {
            this.touchPassThrough = bl;
        }

        public final boolean getMultiTouchEnabled$kotlin_release() {
            return this.multiTouchEnabled;
        }

        public final void setMultiTouchEnabled$kotlin_release(boolean bl) {
            this.multiTouchEnabled = bl;
        }

        @Nullable
        public final Object getResource$kotlin_release() {
            return this.resource;
        }

        public final void setResource$kotlin_release(@Nullable Object object) {
            this.resource = object;
        }

        @Nullable
        public final ResourceType getResourceType$kotlin_release() {
            return this.resourceType;
        }

        public final void setResourceType$kotlin_release(@Nullable ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        @NotNull
        public final Builder setAlignment(@NotNull Alignment value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Builder $this$setAlignment_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setAlignment_u24lambda_u240.alignment = value;
            return builder;
        }

        @NotNull
        public final Builder setFit(@NotNull Fit value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Builder $this$setFit_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setFit_u24lambda_u241.fit = value;
            return builder;
        }

        @NotNull
        public final Builder setLoop(@NotNull Loop value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Builder $this$setLoop_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setLoop_u24lambda_u242.loop = value;
            return builder;
        }

        @NotNull
        public final Builder setRendererType(@NotNull RendererType value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Builder $this$setRendererType_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$setRendererType_u24lambda_u243.rendererType = value;
            return builder;
        }

        @NotNull
        public final Builder setAutoplay(boolean value) {
            Builder builder;
            Builder $this$setAutoplay_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$setAutoplay_u24lambda_u244.autoplay = value;
            return builder;
        }

        @NotNull
        public final Builder setAutoBind(boolean value) {
            Builder builder;
            Builder $this$setAutoBind_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$setAutoBind_u24lambda_u245.autoBind = value;
            return builder;
        }

        @NotNull
        public final Builder setTraceAnimations(boolean value) {
            Builder builder;
            Builder $this$setTraceAnimations_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$setTraceAnimations_u24lambda_u246.traceAnimations = value;
            return builder;
        }

        @NotNull
        public final Builder setArtboardName(@NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$setArtboardName_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$setArtboardName_u24lambda_u247.artboardName = value;
            return builder;
        }

        @NotNull
        public final Builder setAnimationName(@NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$setAnimationName_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$setAnimationName_u24lambda_u248.animationName = value;
            return builder;
        }

        @NotNull
        public final Builder setStateMachineName(@NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$setStateMachineName_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$setStateMachineName_u24lambda_u249.stateMachineName = value;
            return builder;
        }

        @NotNull
        public final Builder setResource(@NotNull Object value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$setResource_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$setResource_u24lambda_u2410.resourceType = ResourceType.Companion.makeMaybeResource(value);
            $this$setResource_u24lambda_u2410.resource = value;
            return builder;
        }

        @NotNull
        public final Builder setAssetLoader(@NotNull FileAssetLoader value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$setAssetLoader_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$setAssetLoader_u24lambda_u2411.assetLoader = value;
            return builder;
        }

        @NotNull
        public final Builder setShouldLoadCDNAssets(boolean value) {
            Builder builder;
            Builder $this$setShouldLoadCDNAssets_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$setShouldLoadCDNAssets_u24lambda_u2412.shouldLoadCDNAssets = value;
            return builder;
        }

        @NotNull
        public final Builder setTouchPassThrough(boolean value) {
            Builder builder;
            Builder $this$setTouchPassThrough_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$setTouchPassThrough_u24lambda_u2413.touchPassThrough = value;
            return builder;
        }

        @NotNull
        public final Builder setMultiTouchEnabled(boolean value) {
            Builder builder;
            Builder $this$setMultiTouchEnabled_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$setMultiTouchEnabled_u24lambda_u2414.multiTouchEnabled = value;
            return builder;
        }

        @NotNull
        public final RiveAnimationView build() {
            return new RiveAnimationView(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView$Companion;", "", "()V", "SINGLE_TOUCH_ID", "", "TAG", "", "alignmentIndexDefault", "getAlignmentIndexDefault", "()I", "fitIndexDefault", "getFitIndexDefault", "loopIndexDefault", "getLoopIndexDefault", "rendererIndexDefault", "getRendererIndexDefault", "shouldLoadCDNAssetsDefault", "", "traceAnimationsDefault", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getAlignmentIndexDefault() {
            return alignmentIndexDefault;
        }

        public final int getFitIndexDefault() {
            return fitIndexDefault;
        }

        public final int getLoopIndexDefault() {
            return loopIndexDefault;
        }

        public final int getRendererIndexDefault() {
            return rendererIndexDefault;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 D2\u00020\u0001:\u0001DB}\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\r\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010%\"\u0004\bA\u0010'R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u001b\"\u0004\bC\u0010\u001d\u00a8\u0006E"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "", "alignmentIndex", "", "fitIndex", "loopIndex", "rendererIndex", "autoplay", "", "autoBind", "riveTraceAnimations", "artboardName", "", "animationName", "stateMachineName", "resource", "Lapp/rive/runtime/kotlin/ResourceType;", "assetLoader", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "(IIIIZZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lapp/rive/runtime/kotlin/ResourceType;Lapp/rive/runtime/kotlin/core/FileAssetLoader;)V", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "getAnimationName", "()Ljava/lang/String;", "setAnimationName", "(Ljava/lang/String;)V", "getArtboardName", "setArtboardName", "getAssetLoader", "()Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "setAssetLoader", "(Lapp/rive/runtime/kotlin/core/FileAssetLoader;)V", "getAutoBind", "()Z", "setAutoBind", "(Z)V", "getAutoplay", "setAutoplay", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "rendererType", "Lapp/rive/runtime/kotlin/core/RendererType;", "getRendererType", "()Lapp/rive/runtime/kotlin/core/RendererType;", "setRendererType", "(Lapp/rive/runtime/kotlin/core/RendererType;)V", "getResource", "()Lapp/rive/runtime/kotlin/ResourceType;", "setResource", "(Lapp/rive/runtime/kotlin/ResourceType;)V", "getRiveTraceAnimations", "setRiveTraceAnimations", "getStateMachineName", "setStateMachineName", "Companion", "kotlin_release"})
    @StabilityInferred(parameters=0)
    public static final class RendererAttributes {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean autoplay;
        private boolean autoBind;
        private boolean riveTraceAnimations;
        @Nullable
        private String artboardName;
        @Nullable
        private String animationName;
        @Nullable
        private String stateMachineName;
        @Nullable
        private ResourceType resource;
        @Nullable
        private FileAssetLoader assetLoader;
        @NotNull
        private Alignment alignment;
        @NotNull
        private Fit fit;
        @NotNull
        private Loop loop;
        @NotNull
        private RendererType rendererType;
        public static final int $stable = 8;

        public RendererAttributes(int alignmentIndex, int fitIndex, int loopIndex, int rendererIndex, boolean autoplay, boolean autoBind, boolean riveTraceAnimations, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, @Nullable ResourceType resource, @Nullable FileAssetLoader assetLoader) {
            this.autoplay = autoplay;
            this.autoBind = autoBind;
            this.riveTraceAnimations = riveTraceAnimations;
            this.artboardName = artboardName;
            this.animationName = animationName;
            this.stateMachineName = stateMachineName;
            this.resource = resource;
            this.assetLoader = assetLoader;
            this.alignment = Alignment.Companion.fromIndex(alignmentIndex);
            this.fit = Fit.Companion.fromIndex(fitIndex);
            this.loop = Loop.Companion.fromIndex(loopIndex);
            this.rendererType = RendererType.Companion.fromIndex(rendererIndex);
        }

        public /* synthetic */ RendererAttributes(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, ResourceType resourceType, FileAssetLoader fileAssetLoader, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = Companion.getAlignmentIndexDefault();
            }
            if ((n5 & 2) != 0) {
                n2 = Companion.getFitIndexDefault();
            }
            if ((n5 & 4) != 0) {
                n3 = Companion.getLoopIndexDefault();
            }
            if ((n5 & 8) != 0) {
                n4 = Companion.getRendererIndexDefault();
            }
            if ((n5 & 0x20) != 0) {
                bl2 = false;
            }
            if ((n5 & 0x40) != 0) {
                bl3 = false;
            }
            if ((n5 & 0x800) != 0) {
                fileAssetLoader = null;
            }
            this(n, n2, n3, n4, bl, bl2, bl3, string, string2, string3, resourceType, fileAssetLoader);
        }

        public final boolean getAutoplay() {
            return this.autoplay;
        }

        public final void setAutoplay(boolean bl) {
            this.autoplay = bl;
        }

        public final boolean getAutoBind() {
            return this.autoBind;
        }

        public final void setAutoBind(boolean bl) {
            this.autoBind = bl;
        }

        public final boolean getRiveTraceAnimations() {
            return this.riveTraceAnimations;
        }

        public final void setRiveTraceAnimations(boolean bl) {
            this.riveTraceAnimations = bl;
        }

        @Nullable
        public final String getArtboardName() {
            return this.artboardName;
        }

        public final void setArtboardName(@Nullable String string) {
            this.artboardName = string;
        }

        @Nullable
        public final String getAnimationName() {
            return this.animationName;
        }

        public final void setAnimationName(@Nullable String string) {
            this.animationName = string;
        }

        @Nullable
        public final String getStateMachineName() {
            return this.stateMachineName;
        }

        public final void setStateMachineName(@Nullable String string) {
            this.stateMachineName = string;
        }

        @Nullable
        public final ResourceType getResource() {
            return this.resource;
        }

        public final void setResource(@Nullable ResourceType resourceType) {
            this.resource = resourceType;
        }

        @Nullable
        public final FileAssetLoader getAssetLoader() {
            return this.assetLoader;
        }

        public final void setAssetLoader(@Nullable FileAssetLoader fileAssetLoader) {
            this.assetLoader = fileAssetLoader;
        }

        @NotNull
        public final Alignment getAlignment() {
            return this.alignment;
        }

        public final void setAlignment(@NotNull Alignment alignment) {
            Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"<set-?>");
            this.alignment = alignment;
        }

        @NotNull
        public final Fit getFit() {
            return this.fit;
        }

        public final void setFit(@NotNull Fit fit) {
            Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"<set-?>");
            this.fit = fit;
        }

        @NotNull
        public final Loop getLoop() {
            return this.loop;
        }

        public final void setLoop(@NotNull Loop loop) {
            Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"<set-?>");
            this.loop = loop;
        }

        @NotNull
        public final RendererType getRendererType() {
            return this.rendererType;
        }

        public final void setRendererType(@NotNull RendererType rendererType) {
            Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"<set-?>");
            this.rendererType = rendererType;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes$Companion;", "", "()V", "assetLoaderFrom", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "name", "", "context", "Landroid/content/Context;", "kotlin_release"})
        @SourceDebugExtension(value={"SMAP\nRiveAnimationView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiveAnimationView.kt\napp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1291:1\n1#2:1292\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final FileAssetLoader assetLoaderFrom(@Nullable String name2, @NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                CharSequence charSequence = name2;
                if (charSequence == null || charSequence.length() == 0) {
                    return null;
                }
                try {
                    Constructor noArgConstructor;
                    Constructor constructor;
                    Object object;
                    block10: {
                        Constructor contextConstructor;
                        Constructor constructor2;
                        Object object2;
                        Object[] objectArray;
                        Class<?> clazz;
                        block9: {
                            clazz = Class.forName(name2);
                            Constructor<?>[] constructorArray = clazz.getConstructors();
                            Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
                            objectArray = constructorArray;
                            int n = objectArray.length;
                            for (int i = 0; i < n; ++i) {
                                Object object3 = objectArray[i];
                                Constructor it = (Constructor)object3;
                                boolean bl = false;
                                if (!(it.getParameterTypes().length == 1 && Intrinsics.areEqual(it.getParameterTypes()[0], Context.class))) continue;
                                object2 = object3;
                                break block9;
                            }
                            object2 = null;
                        }
                        if ((constructor2 = (contextConstructor = (Constructor)object2)) != null && (constructor2 = constructor2.newInstance(objectArray = new Object[]{context.getApplicationContext()})) != null) {
                            Constructor it = constructor2;
                            int n = 0;
                            if (it instanceof ContextAssetLoader) {
                                return (FileAssetLoader)((Object)it);
                            }
                        }
                        Constructor<?>[] constructorArray = clazz.getConstructors();
                        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
                        for (Object object4 : (Object[])constructorArray) {
                            Constructor it = (Constructor)object4;
                            boolean bl = false;
                            Class<?>[] classArray = it.getParameterTypes();
                            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                            boolean bl2 = ((Object[])classArray).length == 0;
                            if (!bl2) continue;
                            object = object4;
                            break block10;
                        }
                        object = null;
                    }
                    if ((constructor = (noArgConstructor = (Constructor)object)) != null && (constructor = constructor.newInstance(new Object[0])) != null) {
                        Constructor it = constructor;
                        boolean bl = false;
                        if (it instanceof FileAssetLoader) {
                            return (FileAssetLoader)((Object)it);
                        }
                    }
                    Log.e((String)RiveAnimationView.TAG, (String)("Failed to initialize AssetLoader: No suitable constructor in " + name2));
                    charSequence = null;
                }
                catch (Exception e) {
                    Log.e((String)RiveAnimationView.TAG, (String)("Failed to initialize AssetLoader from name: " + name2), (Throwable)e);
                    charSequence = null;
                }
                return charSequence;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

