/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.content.Context;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.runtime.kotlin.core.BytesRequest;
import app.rive.runtime.kotlin.core.FileAsset;
import app.rive.runtime.kotlin.core.FileAssetLoader;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/rive/runtime/kotlin/core/CDNAssetLoader;", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "queue", "Lcom/android/volley/RequestQueue;", "getQueue", "()Lcom/android/volley/RequestQueue;", "queue$delegate", "Lkotlin/Lazy;", "tag", "", "kotlin.jvm.PlatformType", "loadContents", "", "asset", "Lapp/rive/runtime/kotlin/core/FileAsset;", "inBandBytes", "", "kotlin_release"})
@StabilityInferred(parameters=0)
public class CDNAssetLoader
extends FileAssetLoader {
    private final String tag;
    @NotNull
    private final Lazy queue$delegate;
    public static final int $stable = 8;

    public CDNAssetLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.tag = this.getClass().getSimpleName();
        this.queue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RequestQueue>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final RequestQueue invoke() {
                return Volley.newRequestQueue((Context)this.$context);
            }
        }));
    }

    private final RequestQueue getQueue() {
        Lazy lazy = this.queue$delegate;
        return (RequestQueue)lazy.getValue();
    }

    @Override
    public boolean loadContents(@NotNull FileAsset asset, @NotNull byte[] inBandBytes) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)inBandBytes, (String)"inBandBytes");
        String url = asset.getCdnUrl();
        if (((CharSequence)url).length() == 0) {
            return false;
        }
        BytesRequest request2 = new BytesRequest(url, (Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>(asset){
            final /* synthetic */ FileAsset $asset;
            {
                this.$asset = $asset;
                super(1);
            }

            public final void invoke(@NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                this.$asset.decode(bytes);
            }
        }), arg_0 -> CDNAssetLoader.loadContents$lambda$0(this, arg_0));
        this.getQueue().add((Request)request2);
        return true;
    }

    private static final void loadContents$lambda$0(CDNAssetLoader this$0, VolleyError it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Log.e((String)this$0.tag, (String)"onAssetLoaded: loading image failed.");
        it.printStackTrace();
    }
}

