/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import androidx.annotation.OpenForTesting;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.BindableArtboard;
import app.rive.runtime.kotlin.core.FileAssetLoader;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import app.rive.runtime.kotlin.core.ViewModel;
import app.rive.runtime.kotlin.core.errors.ArtboardException;
import app.rive.runtime.kotlin.core.errors.RiveException;
import app.rive.runtime.kotlin.core.errors.ViewModelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001:\u0001BB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0019\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020\nH\u0095 J\u0019\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010#\u001a\u00020\u000fH\u0092 J\u0011\u0010(\u001a\u00020\n2\u0006\u0010&\u001a\u00020%H\u0092 J\u0019\u0010)\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020\nH\u0092 J\u0019\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010#\u001a\u00020\u000fH\u0092 J\u0011\u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0092 J\u0019\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010-\u001a\u00020%H\u0092 J\u0011\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020%H\u0096 J\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010&\u001a\u00020%H\u0092 J\u0019\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u00103\u001a\u00020\nH\u0092 J\u0019\u00104\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u00105\u001a\u00020\u000fH\u0095 J\u0011\u00106\u001a\u00020\n2\u0006\u0010&\u001a\u00020%H\u0092 J\u0010\u00107\u001a\u0002082\u0006\u0010#\u001a\u00020\u000fH\u0016J\b\u00109\u001a\u000208H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010<\u001a\u00020;2\u0006\u00103\u001a\u00020\nH\u0016J\u0010\u0010=\u001a\u00020;2\u0006\u00105\u001a\u00020\u000fH\u0016J)\u0010>\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\n2\u0006\u0010@\u001a\u00020%H\u0092 J\b\u0010A\u001a\u00020\nH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\f\u00a8\u0006C"}, d2={"Lapp/rive/runtime/kotlin/core/File;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "bytes", "", "rendererType", "Lapp/rive/runtime/kotlin/core/RendererType;", "fileAssetLoader", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "([BLapp/rive/runtime/kotlin/core/RendererType;Lapp/rive/runtime/kotlin/core/FileAssetLoader;)V", "artboardCount", "", "getArtboardCount", "()I", "artboardNames", "", "", "getArtboardNames", "()Ljava/util/List;", "enums", "Lapp/rive/runtime/kotlin/core/File$Enum;", "getEnums", "firstArtboard", "Lapp/rive/runtime/kotlin/core/Artboard;", "getFirstArtboard", "()Lapp/rive/runtime/kotlin/core/Artboard;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getRendererType", "()Lapp/rive/runtime/kotlin/core/RendererType;", "viewModelCount", "getViewModelCount", "artboard", "index", "name", "cppArtboardByIndex", "", "cppPointer", "cppArtboardByName", "cppArtboardCount", "cppArtboardNameByIndex", "cppCreateBindableArtboardByName", "cppCreateDefaultBindableArtboard", "cppDefaultViewModelForArtboard", "artboardPointer", "cppDelete", "", "pointer", "cppEnums", "cppViewModelByIndex", "viewModelIdx", "cppViewModelByName", "viewModelName", "cppViewModelCount", "createBindableArtboardByName", "Lapp/rive/runtime/kotlin/core/BindableArtboard;", "createDefaultBindableArtboard", "defaultViewModelForArtboard", "Lapp/rive/runtime/kotlin/core/ViewModel;", "getViewModelByIndex", "getViewModelByName", "import", "length", "fileAssetLoaderPointer", "release", "Enum", "kotlin_release"})
@OpenForTesting
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 File.kt\napp/rive/runtime/kotlin/core/File\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1557#2:251\n1628#2,3:252\n1557#2:256\n1628#2,3:257\n1#3:255\n*S KotlinDebug\n*F\n+ 1 File.kt\napp/rive/runtime/kotlin/core/File\n*L\n109#1:251\n109#1:252,3\n180#1:256\n180#1:257,3\n*E\n"})
public class File
extends NativeObject {
    @NotNull
    private final RendererType rendererType;
    @NotNull
    private final ReentrantLock lock;
    public static final int $stable = 8;

    public File(@NotNull byte[] bytes, @NotNull RendererType rendererType, @Nullable FileAssetLoader fileAssetLoader) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
        super(0L);
        this.rendererType = rendererType;
        FileAssetLoader fileAssetLoader2 = fileAssetLoader;
        if (fileAssetLoader2 != null) {
            FileAssetLoader it = fileAssetLoader2;
            boolean bl = false;
            it.setRendererType(this.getRendererType());
            it.acquire();
            this.getDependencies().add(it);
        }
        FileAssetLoader fileAssetLoader3 = fileAssetLoader;
        this.setCppPointer(this.import(bytes, bytes.length, this.getRendererType().getValue(), fileAssetLoader3 != null ? fileAssetLoader3.getCppPointer() : 0L));
        this.getRefs().incrementAndGet();
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ File(byte[] byArray, RendererType rendererType, FileAssetLoader fileAssetLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            rendererType = Rive.INSTANCE.getDefaultRendererType();
        }
        if ((n & 4) != 0) {
            fileAssetLoader = null;
        }
        this(byArray, rendererType, fileAssetLoader);
    }

    @NotNull
    public RendererType getRendererType() {
        return this.rendererType;
    }

    @NotNull
    public ReentrantLock getLock() {
        return this.lock;
    }

    private native long import(byte[] var1, int var2, int var3, long var4);

    private native long cppArtboardByName(long var1, String var3);

    @VisibleForTesting(otherwise=2)
    protected native long cppArtboardByIndex(long var1, int var3);

    private native String cppArtboardNameByIndex(long var1, int var3);

    private native int cppArtboardCount(long var1);

    private native long cppCreateBindableArtboardByName(long var1, String var3);

    private native long cppCreateDefaultBindableArtboard(long var1);

    private native List<Enum> cppEnums(long var1);

    private native int cppViewModelCount(long var1);

    private native long cppViewModelByIndex(long var1, int var3);

    @VisibleForTesting(otherwise=2)
    protected native long cppViewModelByName(long var1, @NotNull String var3);

    private native long cppDefaultViewModelForArtboard(long var1, long var3);

    @Override
    public native void cppDelete(long var1);

    @NotNull
    public Artboard getFirstArtboard() throws RiveException {
        return this.artboard(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Artboard artboard(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long artboardPointer = this.cppArtboardByName(this.getCppPointer(), name2);
        if (artboardPointer == 0L) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getArtboardNames();
            String string = name2;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add("\"" + (String)it + "\"");
            }
            String string3 = "Artboard \"" + string + "\" not found. Available Artboards: " + (List)destination$iv$iv;
            throw new ArtboardException(string3);
        }
        Artboard ab = new Artboard(artboardPointer, this.getLock(), this);
        this.getDependencies().add(ab);
        return ab;
    }

    @NotNull
    public Artboard artboard(int index) throws RiveException {
        long artboardPointer = this.cppArtboardByIndex(this.getCppPointer(), index);
        if (artboardPointer == 0L) {
            throw new ArtboardException("No Artboard found at index " + index + ".");
        }
        Artboard ab = new Artboard(artboardPointer, this.getLock(), this);
        this.getDependencies().add(ab);
        return ab;
    }

    @NotNull
    public BindableArtboard createBindableArtboardByName(@NotNull String name2) {
        BindableArtboard bindableArtboard;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long artboardPointer = this.cppCreateBindableArtboardByName(this.getCppPointer(), name2);
        if (artboardPointer == 0L) {
            throw new ArtboardException("No BindableArtboard found with name " + name2 + ".");
        }
        BindableArtboard it = bindableArtboard = new BindableArtboard(artboardPointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return bindableArtboard;
    }

    @NotNull
    public BindableArtboard createDefaultBindableArtboard() {
        BindableArtboard bindableArtboard;
        long artboardPointer = this.cppCreateDefaultBindableArtboard(this.getCppPointer());
        if (artboardPointer == 0L) {
            throw new ArtboardException("No default BindableArtboard.");
        }
        BindableArtboard it = bindableArtboard = new BindableArtboard(artboardPointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return bindableArtboard;
    }

    public int getArtboardCount() {
        return this.cppArtboardCount(this.getCppPointer());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getArtboardNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getArtboardCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name2 = this.cppArtboardNameByIndex(this.getCppPointer(), (int)it);
            collection.add(name2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<Enum> getEnums() {
        return this.cppEnums(this.getCppPointer());
    }

    public int getViewModelCount() {
        return this.cppViewModelCount(this.getCppPointer());
    }

    @NotNull
    public ViewModel getViewModelByIndex(int viewModelIdx) {
        ViewModel viewModel;
        long vmPointer = this.cppViewModelByIndex(this.getCppPointer(), viewModelIdx);
        if (vmPointer == 0L) {
            throw new ViewModelException("No ViewModel found at index " + viewModelIdx + ".");
        }
        ViewModel it = viewModel = new ViewModel(vmPointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return viewModel;
    }

    @NotNull
    public ViewModel getViewModelByName(@NotNull String viewModelName) {
        ViewModel viewModel;
        Intrinsics.checkNotNullParameter((Object)viewModelName, (String)"viewModelName");
        long vmPointer = this.cppViewModelByName(this.getCppPointer(), viewModelName);
        if (vmPointer == 0L) {
            throw new ViewModelException("No ViewModel found with name " + viewModelName + ".");
        }
        ViewModel it = viewModel = new ViewModel(vmPointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return viewModel;
    }

    @NotNull
    public ViewModel defaultViewModelForArtboard(@NotNull Artboard artboard) {
        ViewModel viewModel;
        Intrinsics.checkNotNullParameter((Object)artboard, (String)"artboard");
        long vmPointer = this.cppDefaultViewModelForArtboard(this.getCppPointer(), artboard.getCppPointer());
        if (vmPointer == 0L) {
            throw new ViewModelException("No default ViewModel found for artboard " + artboard.getName() + ".");
        }
        ViewModel it = viewModel = new ViewModel(vmPointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return viewModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int release() {
        ReentrantLock reentrantLock = this.getLock();
        synchronized (reentrantLock) {
            boolean bl = false;
            int n = super.release();
            return n;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lapp/rive/runtime/kotlin/core/File$Enum;", "", "name", "", "values", "", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getValues", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin_release"})
    @StabilityInferred(parameters=0)
    public static final class Enum {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> values;
        public static final int $stable = 8;

        public Enum(@NotNull String name2, @NotNull List<String> values) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.name = name2;
            this.values = values;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getValues() {
            return this.values;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<String> component2() {
            return this.values;
        }

        @NotNull
        public final Enum copy(@NotNull String name2, @NotNull List<String> values) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new Enum(name2, values);
        }

        public static /* synthetic */ Enum copy$default(Enum enum_, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = enum_.name;
            }
            if ((n & 2) != 0) {
                list = enum_.values;
            }
            return enum_.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "Enum(name=" + this.name + ", values=" + this.values + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.values).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Enum)) {
                return false;
            }
            Enum enum_ = (Enum)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)enum_.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.values, enum_.values);
        }
    }
}

