/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RefCount;
import app.rive.runtime.kotlin.core.errors.RiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020\"H\u0002J\b\u0010%\u001a\u00020\u001eH\u0016R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lapp/rive/runtime/kotlin/core/NativeObject;", "Lapp/rive/runtime/kotlin/core/RefCount;", "initialPointer", "", "(J)V", "value", "cppPointer", "getCppPointer", "()J", "setCppPointer", "dependencies", "", "getDependencies", "()Ljava/util/List;", "disposeStackTrace", "Lkotlin/sequences/Sequence;", "Ljava/lang/StackTraceElement;", "hasCppObject", "", "getHasCppObject", "()Z", "refs", "Ljava/util/concurrent/atomic/AtomicInteger;", "getRefs", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setRefs", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "unsafeCppPointer", "Ljava/util/concurrent/atomic/AtomicLong;", "acquire", "", "buildCombinedStackTrace", "", "cppDelete", "", "pointer", "dispose", "release", "Companion", "kotlin_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNativeObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeObject.kt\napp/rive/runtime/kotlin/core/NativeObject\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n37#2,2:159\n1863#3,2:161\n*S KotlinDebug\n*F\n+ 1 NativeObject.kt\napp/rive/runtime/kotlin/core/NativeObject\n*L\n55#1:159,2\n151#1:161,2\n*E\n"})
public abstract class NativeObject
implements RefCount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicLong unsafeCppPointer;
    @Nullable
    private Sequence<StackTraceElement> disposeStackTrace;
    @NotNull
    private AtomicInteger refs;
    @NotNull
    private final List<RefCount> dependencies;
    public static final int $stable = 8;
    public static final long NULL_POINTER = 0L;

    public NativeObject(long initialPointer) {
        this.unsafeCppPointer = new AtomicLong(initialPointer);
        this.refs = new AtomicInteger(initialPointer == 0L ? 0 : 1);
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.dependencies = list;
    }

    public final boolean getHasCppObject() {
        return this.unsafeCppPointer.get() != 0L;
    }

    @Override
    @NotNull
    public final AtomicInteger getRefs() {
        return this.refs;
    }

    @Override
    public final void setRefs(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.refs = atomicInteger;
    }

    public final long getCppPointer() throws RiveException {
        long pointer = this.unsafeCppPointer.get();
        if (pointer == 0L) {
            String nativeObjectName = this.getClass().getSimpleName();
            RiveException riveException = new RiveException("Accessing disposed C++ object " + nativeObjectName + ".");
            Collection $this$toTypedArray$iv = this.buildCombinedStackTrace();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            riveException.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
            throw riveException;
        }
        return pointer;
    }

    public final void setCppPointer(long value) {
        this.unsafeCppPointer.set(value);
    }

    @NotNull
    public final List<RefCount> getDependencies() {
        return this.dependencies;
    }

    public void cppDelete(long pointer) {
    }

    private final List<StackTraceElement> buildCombinedStackTrace() {
        Sequence sequence;
        List combinedTrace = new ArrayList();
        Sequence sequence2 = this.disposeStackTrace;
        if (sequence2 != null) {
            Sequence trace = sequence = sequence2;
            boolean bl = false;
            ((Collection)combinedTrace).add(new StackTraceElement("--- Stack Trace for NativeObject Dispose ---", "", null, -1));
            CollectionsKt.addAll((Collection)combinedTrace, (Sequence)trace);
            ((Collection)combinedTrace).add(new StackTraceElement("--- Current Stack Trace ---", "", null, -1));
        }
        Collection collection = combinedTrace;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        sequence = SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)ArraysKt.asSequence((Object[])stackTraceElementArray), (Function1)buildCombinedStackTrace.2.INSTANCE), (int)1);
        CollectionsKt.addAll((Collection)collection, (Sequence)sequence);
        return combinedTrace;
    }

    @Override
    public synchronized int acquire() throws IllegalArgumentException {
        int count = RefCount.DefaultImpls.acquire(this);
        if (!(count > 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return count;
    }

    @Override
    public synchronized int release() throws IllegalArgumentException {
        int count = RefCount.DefaultImpls.release(this);
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (count == 0 && this.getHasCppObject()) {
            this.dispose();
        }
        return count;
    }

    private final synchronized void dispose() throws IllegalArgumentException {
        List<RefCount> list;
        if (!(this.refs.get() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        this.disposeStackTrace = SequencesKt.dropWhile((Sequence)ArraysKt.asSequence((Object[])stackTraceElementArray), (Function1)dispose.1.INSTANCE);
        List<RefCount> $this$dispose_u24lambda_u242 = list = this.dependencies;
        boolean bl = false;
        Iterable $this$forEach$iv = $this$dispose_u24lambda_u242;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RefCount it = (RefCount)element$iv;
            boolean bl2 = false;
            it.release();
        }
        $this$dispose_u24lambda_u242.clear();
        this.cppDelete(this.unsafeCppPointer.get());
        this.unsafeCppPointer.set(0L);
    }

    @Override
    public int getRefCount() {
        return RefCount.DefaultImpls.getRefCount(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/rive/runtime/kotlin/core/NativeObject$Companion;", "", "()V", "NULL_POINTER", "", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

