/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0096 \u00a8\u0006\t"}, d2={"Lapp/rive/runtime/kotlin/core/RiveRenderImage;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "address", "", "(J)V", "cppDelete", "", "pointer", "Companion", "kotlin_release"})
@StabilityInferred(parameters=1)
public final class RiveRenderImage
extends NativeObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    public RiveRenderImage(long address) {
        super(address);
    }

    @Override
    public native void cppDelete(long var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0082 J\u0011\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0082 J\u0019\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0082 J1\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0082 J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0018J2\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007\u00a8\u0006\u001f"}, d2={"Lapp/rive/runtime/kotlin/core/RiveRenderImage$Companion;", "", "()V", "cppFromARGBInts", "", "colors", "", "width", "", "height", "rendererTypeIdx", "premultiplied", "", "cppFromBitmapCanvas", "bitmap", "Landroid/graphics/Bitmap;", "cppFromBitmapRive", "cppFromRGBABytes", "bytes", "", "fromARGBInts", "Lapp/rive/runtime/kotlin/core/RiveRenderImage;", "pixels", "rendererType", "Lapp/rive/runtime/kotlin/core/RendererType;", "fromBitmap", "fromEncoded", "encodedBytes", "fromRGBABytes", "pixelBytes", "make", "kotlin_release"})
    @SourceDebugExtension(value={"SMAP\nFileAsset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAsset.kt\napp/rive/runtime/kotlin/core/RiveRenderImage$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,367:1\n1#2:368\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final native long cppFromRGBABytes(byte[] var1, int var2, int var3, int var4, boolean var5);

        private final native long cppFromARGBInts(int[] var1, int var2, int var3, int var4, boolean var5);

        private final native long cppFromBitmapRive(Bitmap var1, boolean var2);

        private final native long cppFromBitmapCanvas(Bitmap var1);

        @Deprecated(message="This method name is misleading; use fromEncoded instead", replaceWith=@ReplaceWith(expression="fromEncoded(bytes, rendererType)", imports={}))
        @NotNull
        public final RiveRenderImage make(@NotNull byte[] bytes, @NotNull RendererType rendererType) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
            return this.fromEncoded(bytes, rendererType);
        }

        public static /* synthetic */ RiveRenderImage make$default(Companion companion, byte[] byArray, RendererType rendererType, int n, Object object) {
            if ((n & 2) != 0) {
                rendererType = Rive.INSTANCE.getDefaultRendererType();
            }
            return companion.make(byArray, rendererType);
        }

        @NotNull
        public final RiveRenderImage fromEncoded(@NotNull byte[] encodedBytes, @NotNull RendererType rendererType) {
            BitmapFactory.Options options;
            Intrinsics.checkNotNullParameter((Object)encodedBytes, (String)"encodedBytes");
            Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
            BitmapFactory.Options $this$fromEncoded_u24lambda_u240 = options = new BitmapFactory.Options();
            boolean bl = false;
            $this$fromEncoded_u24lambda_u240.inPreferredConfig = Bitmap.Config.ARGB_8888;
            $this$fromEncoded_u24lambda_u240.inPremultiplied = true;
            BitmapFactory.Options options2 = options;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])encodedBytes, (int)0, (int)encodedBytes.length, (BitmapFactory.Options)options2);
            if (bitmap == null) {
                boolean bl2 = false;
                String string = "Failed to decode image from encoded bytes";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(bitmap.isPremultiplied() || !bitmap.hasAlpha())) {
                boolean bl3 = false;
                String string = "Decoded bitmap was not premultiplied";
                throw new IllegalStateException(string.toString());
            }
            return this.fromBitmap(bitmap, rendererType);
        }

        public static /* synthetic */ RiveRenderImage fromEncoded$default(Companion companion, byte[] byArray, RendererType rendererType, int n, Object object) {
            if ((n & 2) != 0) {
                rendererType = Rive.INSTANCE.getDefaultRendererType();
            }
            return companion.fromEncoded(byArray, rendererType);
        }

        @NotNull
        public final RiveRenderImage fromRGBABytes(@NotNull byte[] pixelBytes, int width, int height, @NotNull RendererType rendererType, boolean premultiplied) {
            Intrinsics.checkNotNullParameter((Object)pixelBytes, (String)"pixelBytes");
            Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
            if (!(width > 0 && height > 0)) {
                boolean $i$a$-require-RiveRenderImage$Companion$fromRGBABytes$32 = false;
                String $i$a$-require-RiveRenderImage$Companion$fromRGBABytes$32 = "Width and height must be > 0";
                throw new IllegalArgumentException($i$a$-require-RiveRenderImage$Companion$fromRGBABytes$32.toString());
            }
            if (!(pixelBytes.length == width * height * 4)) {
                boolean bl = false;
                String string = "Bytes must have size = width * height * 4";
                throw new IllegalArgumentException(string.toString());
            }
            long address = this.cppFromRGBABytes(pixelBytes, width, height, rendererType.getValue(), premultiplied);
            return new RiveRenderImage(address);
        }

        public static /* synthetic */ RiveRenderImage fromRGBABytes$default(Companion companion, byte[] byArray, int n, int n2, RendererType rendererType, boolean bl, int n3, Object object) {
            if ((n3 & 8) != 0) {
                rendererType = Rive.INSTANCE.getDefaultRendererType();
            }
            if ((n3 & 0x10) != 0) {
                bl = true;
            }
            return companion.fromRGBABytes(byArray, n, n2, rendererType, bl);
        }

        @NotNull
        public final RiveRenderImage fromARGBInts(@NotNull int[] pixels, int width, int height, @NotNull RendererType rendererType, boolean premultiplied) {
            Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
            Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
            if (!(width > 0 && height > 0)) {
                boolean $i$a$-require-RiveRenderImage$Companion$fromARGBInts$32 = false;
                String $i$a$-require-RiveRenderImage$Companion$fromARGBInts$32 = "Width and height must be > 0";
                throw new IllegalArgumentException($i$a$-require-RiveRenderImage$Companion$fromARGBInts$32.toString());
            }
            if (!(pixels.length == width * height)) {
                boolean $i$a$-require-RiveRenderImage$Companion$fromARGBInts$42 = false;
                String $i$a$-require-RiveRenderImage$Companion$fromARGBInts$42 = "Colors must have size = width * height";
                throw new IllegalArgumentException($i$a$-require-RiveRenderImage$Companion$fromARGBInts$42.toString());
            }
            if (rendererType == RendererType.Canvas && !premultiplied) {
                Bitmap bitmap = Bitmap.createBitmap((int[])pixels, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
                Bitmap bitmap2 = bitmap;
                bitmap2.setPremultiplied(true);
                long address = this.cppFromBitmapCanvas(bitmap2);
                return new RiveRenderImage(address);
            }
            long address = this.cppFromARGBInts(pixels, width, height, rendererType.getValue(), premultiplied);
            return new RiveRenderImage(address);
        }

        public static /* synthetic */ RiveRenderImage fromARGBInts$default(Companion companion, int[] nArray, int n, int n2, RendererType rendererType, boolean bl, int n3, Object object) {
            if ((n3 & 8) != 0) {
                rendererType = Rive.INSTANCE.getDefaultRendererType();
            }
            if ((n3 & 0x10) != 0) {
                bl = false;
            }
            return companion.fromARGBInts(nArray, n, n2, rendererType, bl);
        }

        @NotNull
        public final RiveRenderImage fromBitmap(@NotNull Bitmap bitmap, @NotNull RendererType rendererType) {
            RiveRenderImage riveRenderImage;
            Bitmap safeBitmap;
            Bitmap bitmap2;
            boolean isHardware;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
            if (!(!bitmap.isRecycled())) {
                boolean $i$a$-require-RiveRenderImage$Companion$fromBitmap$22 = false;
                String $i$a$-require-RiveRenderImage$Companion$fromBitmap$22 = "Bitmap must not be recycled";
                throw new IllegalArgumentException($i$a$-require-RiveRenderImage$Companion$fromBitmap$22.toString());
            }
            boolean bl = isHardware = Build.VERSION.SDK_INT >= 26 && bitmap.getConfig() == Bitmap.Config.HARDWARE;
            if (bitmap.getConfig() == Bitmap.Config.ARGB_8888 && !isHardware) {
                bitmap2 = bitmap;
            } else {
                Bitmap bitmap3 = bitmap.copy(Bitmap.Config.ARGB_8888, false);
                if (bitmap3 == null) {
                    throw new IllegalStateException("Failed to copy bitmap to ARGB_8888".toString());
                }
                bitmap2 = safeBitmap = bitmap3;
            }
            if (rendererType == RendererType.Rive) {
                long address = this.cppFromBitmapRive(safeBitmap, safeBitmap.isPremultiplied());
                riveRenderImage = new RiveRenderImage(address);
            } else {
                long address = this.cppFromBitmapCanvas(safeBitmap);
                riveRenderImage = new RiveRenderImage(address);
            }
            return riveRenderImage;
        }

        public static /* synthetic */ RiveRenderImage fromBitmap$default(Companion companion, Bitmap bitmap, RendererType rendererType, int n, Object object) {
            if ((n & 2) != 0) {
                rendererType = Rive.INSTANCE.getDefaultRendererType();
            }
            return companion.fromBitmap(bitmap, rendererType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

