/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import androidx.annotation.OpenForTesting;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.ViewModelInstance;
import app.rive.runtime.kotlin.core.errors.ViewModelException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0002#$B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0095 J\u0011\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0092 J\u0019\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0006H\u0092 J\u0019\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0092 J\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0015\u001a\u00020\u0003H\u0092 J\u0011\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0003H\u0092 J\u0011\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0003H\u0092 J\u0011\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0003H\u0092 J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00a8\u0006%"}, d2={"Lapp/rive/runtime/kotlin/core/ViewModel;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "(J)V", "instanceCount", "", "getInstanceCount", "()I", "name", "", "getName", "()Ljava/lang/String;", "properties", "", "Lapp/rive/runtime/kotlin/core/ViewModel$Property;", "getProperties", "()Ljava/util/List;", "propertyCount", "getPropertyCount", "cppCreateBlankInstance", "cppPointer", "cppCreateDefaultInstance", "cppCreateInstanceFromIndex", "index", "cppCreateInstanceFromName", "cppGetProperties", "cppInstanceCount", "cppName", "cppPropertyCount", "createBlankInstance", "Lapp/rive/runtime/kotlin/core/ViewModelInstance;", "createDefaultInstance", "createInstanceFromIndex", "createInstanceFromName", "Property", "PropertyDataType", "kotlin_release"})
@OpenForTesting
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewModel.kt\napp/rive/runtime/kotlin/core/ViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public class ViewModel
extends NativeObject {
    public static final int $stable;

    public ViewModel(long unsafeCppPointer) {
        super(unsafeCppPointer);
    }

    private native String cppName(long var1);

    private native int cppInstanceCount(long var1);

    private native int cppPropertyCount(long var1);

    private native List<Property> cppGetProperties(long var1);

    @VisibleForTesting(otherwise=2)
    protected native long cppCreateBlankInstance(long var1);

    private native long cppCreateDefaultInstance(long var1);

    private native long cppCreateInstanceFromIndex(long var1, int var3);

    private native long cppCreateInstanceFromName(long var1, String var3);

    @NotNull
    public String getName() {
        return this.cppName(this.getCppPointer());
    }

    public int getInstanceCount() {
        return this.cppInstanceCount(this.getCppPointer());
    }

    public int getPropertyCount() {
        return this.cppPropertyCount(this.getCppPointer());
    }

    @NotNull
    public List<Property> getProperties() {
        return this.cppGetProperties(this.getCppPointer());
    }

    @NotNull
    public ViewModelInstance createBlankInstance() {
        ViewModelInstance viewModelInstance;
        long instancePointer = this.cppCreateBlankInstance(this.getCppPointer());
        if (instancePointer == 0L) {
            throw new ViewModelException("Could not create a blank ViewModel instance");
        }
        ViewModelInstance it = viewModelInstance = new ViewModelInstance(instancePointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return viewModelInstance;
    }

    @NotNull
    public ViewModelInstance createDefaultInstance() {
        ViewModelInstance viewModelInstance;
        long instancePointer = this.cppCreateDefaultInstance(this.getCppPointer());
        if (instancePointer == 0L) {
            throw new ViewModelException("Could not create default ViewModel instance");
        }
        ViewModelInstance it = viewModelInstance = new ViewModelInstance(instancePointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return viewModelInstance;
    }

    @NotNull
    public ViewModelInstance createInstanceFromIndex(int index) {
        ViewModelInstance viewModelInstance;
        long instancePointer = this.cppCreateInstanceFromIndex(this.getCppPointer(), index);
        if (instancePointer == 0L) {
            throw new ViewModelException("ViewModel instance not found: " + index);
        }
        ViewModelInstance it = viewModelInstance = new ViewModelInstance(instancePointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return viewModelInstance;
    }

    @NotNull
    public ViewModelInstance createInstanceFromName(@NotNull String name2) {
        ViewModelInstance viewModelInstance;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long instancePointer = this.cppCreateInstanceFromName(this.getCppPointer(), name2);
        if (instancePointer == 0L) {
            throw new ViewModelException("ViewModel instance not found: " + name2);
        }
        ViewModelInstance it = viewModelInstance = new ViewModelInstance(instancePointer);
        boolean bl = false;
        this.getDependencies().add(it);
        return viewModelInstance;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lapp/rive/runtime/kotlin/core/ViewModel$Property;", "", "type", "Lapp/rive/runtime/kotlin/core/ViewModel$PropertyDataType;", "name", "", "(Lapp/rive/runtime/kotlin/core/ViewModel$PropertyDataType;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "()Lapp/rive/runtime/kotlin/core/ViewModel$PropertyDataType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin_release"})
    @StabilityInferred(parameters=1)
    public static final class Property {
        @NotNull
        private final PropertyDataType type;
        @NotNull
        private final String name;
        public static final int $stable;

        public Property(@NotNull PropertyDataType type, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.type = type;
            this.name = name2;
        }

        @NotNull
        public final PropertyDataType getType() {
            return this.type;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final PropertyDataType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Property copy(@NotNull PropertyDataType type, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new Property(type, name2);
        }

        public static /* synthetic */ Property copy$default(Property property, PropertyDataType propertyDataType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                propertyDataType = property.type;
            }
            if ((n & 2) != 0) {
                string = property.name;
            }
            return property.copy(propertyDataType, string);
        }

        @NotNull
        public String toString() {
            return "Property(type=" + this.type + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Property)) {
                return false;
            }
            Property property = (Property)other;
            if (this.type != property.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)property.name);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lapp/rive/runtime/kotlin/core/ViewModel$PropertyDataType;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "NONE", "STRING", "NUMBER", "BOOLEAN", "COLOR", "LIST", "ENUM", "TRIGGER", "VIEW_MODEL", "INTEGER", "SYMBOL_LIST_INDEX", "ASSET_IMAGE", "ARTBOARD", "Companion", "kotlin_release"})
    @SourceDebugExtension(value={"SMAP\nViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewModel.kt\napp/rive/runtime/kotlin/core/ViewModel$PropertyDataType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1202#2,2:157\n1230#2,4:159\n*S KotlinDebug\n*F\n+ 1 ViewModel.kt\napp/rive/runtime/kotlin/core/ViewModel$PropertyDataType\n*L\n149#1:157,2\n149#1:159,4\n*E\n"})
    public static final class PropertyDataType
    extends Enum<PropertyDataType> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        @NotNull
        private static final Map<Integer, PropertyDataType> map;
        public static final /* enum */ PropertyDataType NONE;
        public static final /* enum */ PropertyDataType STRING;
        public static final /* enum */ PropertyDataType NUMBER;
        public static final /* enum */ PropertyDataType BOOLEAN;
        public static final /* enum */ PropertyDataType COLOR;
        public static final /* enum */ PropertyDataType LIST;
        public static final /* enum */ PropertyDataType ENUM;
        public static final /* enum */ PropertyDataType TRIGGER;
        public static final /* enum */ PropertyDataType VIEW_MODEL;
        public static final /* enum */ PropertyDataType INTEGER;
        public static final /* enum */ PropertyDataType SYMBOL_LIST_INDEX;
        public static final /* enum */ PropertyDataType ASSET_IMAGE;
        public static final /* enum */ PropertyDataType ARTBOARD;
        private static final /* synthetic */ PropertyDataType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PropertyDataType(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static PropertyDataType[] values() {
            return (PropertyDataType[])$VALUES.clone();
        }

        public static PropertyDataType valueOf(String value) {
            return Enum.valueOf(PropertyDataType.class, value);
        }

        @NotNull
        public static EnumEntries<PropertyDataType> getEntries() {
            return $ENTRIES;
        }

        @JvmStatic
        @Nullable
        public static final PropertyDataType fromInt(int type) {
            return Companion.fromInt(type);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            NONE = new PropertyDataType(0);
            STRING = new PropertyDataType(1);
            NUMBER = new PropertyDataType(2);
            BOOLEAN = new PropertyDataType(3);
            COLOR = new PropertyDataType(4);
            LIST = new PropertyDataType(5);
            ENUM = new PropertyDataType(6);
            TRIGGER = new PropertyDataType(7);
            VIEW_MODEL = new PropertyDataType(8);
            INTEGER = new PropertyDataType(9);
            SYMBOL_LIST_INDEX = new PropertyDataType(10);
            ASSET_IMAGE = new PropertyDataType(11);
            ARTBOARD = new PropertyDataType(12);
            $VALUES = propertyDataTypeArray = new PropertyDataType[]{PropertyDataType.NONE, PropertyDataType.STRING, PropertyDataType.NUMBER, PropertyDataType.BOOLEAN, PropertyDataType.COLOR, PropertyDataType.LIST, PropertyDataType.ENUM, PropertyDataType.TRIGGER, PropertyDataType.VIEW_MODEL, PropertyDataType.INTEGER, PropertyDataType.SYMBOL_LIST_INDEX, PropertyDataType.ASSET_IMAGE, PropertyDataType.ARTBOARD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$associateBy$iv = (Iterable)PropertyDataType.getEntries();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void p0;
                PropertyDataType propertyDataType = (PropertyDataType)((Object)element$iv$iv);
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(p0.value, element$iv$iv);
            }
            map = destination$iv$iv;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/rive/runtime/kotlin/core/ViewModel$PropertyDataType$Companion;", "", "()V", "map", "", "", "Lapp/rive/runtime/kotlin/core/ViewModel$PropertyDataType;", "fromInt", "type", "kotlin_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nullable
            public final PropertyDataType fromInt(int type) {
                return (PropertyDataType)((Object)map.get(type));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

