/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.runtime.kotlin.core.ViewModelInstance;
import app.rive.runtime.kotlin.core.ViewModelProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0019\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0082 J!\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0004H\u0082 J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0019\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nH\u0082 J\u0019\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0082 J\u0019\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nH\u0082 J\u0011\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0004H\u0082 J!\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0082 J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0011\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0086\u0002J\b\u0010!\u001a\u00020\u0002H\u0014J\u0015\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010&\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010'\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lapp/rive/runtime/kotlin/core/ViewModelListProperty;", "Lapp/rive/runtime/kotlin/core/ViewModelProperty;", "", "unsafeCppPointer", "", "(J)V", "cachedItems", "", "Lapp/rive/runtime/kotlin/core/ViewModelListProperty$CacheEntry;", "size", "", "getSize", "()I", "add", "item", "Lapp/rive/runtime/kotlin/core/ViewModelInstance;", "index", "boundsCheck", "cppAdd", "cppPointer", "itemPointer", "cppAddAt", "cppDelete", "pointer", "cppElementAt", "cppRemove", "cppRemoveAt", "cppSize", "cppSwap", "index1", "index2", "elementAt", "get", "nativeGetValue", "nativeSetValue", "value", "(Lkotlin/Unit;)V", "remove", "removeAt", "swap", "CacheEntry", "kotlin_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nViewModelInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewModelInstance.kt\napp/rive/runtime/kotlin/core/ViewModelListProperty\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,750:1\n1863#2,2:751\n1#3:753\n381#4,7:754\n381#4,7:761\n*S KotlinDebug\n*F\n+ 1 ViewModelInstance.kt\napp/rive/runtime/kotlin/core/ViewModelListProperty\n*L\n533#1:751,2\n582#1:754,7\n602#1:761,7\n*E\n"})
public final class ViewModelListProperty
extends ViewModelProperty<Unit> {
    @NotNull
    private Map<Long, CacheEntry> cachedItems = new LinkedHashMap();
    public static final int $stable = 8;

    public ViewModelListProperty(long unsafeCppPointer) {
        super(unsafeCppPointer);
    }

    private final native int cppSize(long var1);

    private final native long cppElementAt(long var1, int var3);

    private final native void cppAdd(long var1, long var3);

    private final native void cppAddAt(long var1, int var3, long var4);

    private final native void cppRemove(long var1, long var3);

    private final native void cppRemoveAt(long var1, int var3);

    private final native void cppSwap(long var1, int var3, int var4);

    @Override
    public void cppDelete(long pointer) {
        super.cppDelete(pointer);
        Iterable $this$forEach$iv = this.cachedItems.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CacheEntry it = (CacheEntry)element$iv;
            boolean bl = false;
            it.getInstance().release();
        }
        this.cachedItems.clear();
    }

    private final void boundsCheck(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("Index out of bounds for ViewModelListProperty.");
        }
    }

    public final int getSize() {
        return this.cppSize(this.getCppPointer());
    }

    @NotNull
    public final ViewModelInstance elementAt(int index) throws IndexOutOfBoundsException {
        this.boundsCheck(index);
        long cppPointer = this.cppElementAt(this.getCppPointer(), index);
        Object object = this.cachedItems.get(cppPointer);
        if (object == null || (object = ((CacheEntry)object).getInstance()) == null) {
            ViewModelListProperty $this$elementAt_u24lambda_u241 = this;
            boolean bl = false;
            ViewModelInstance newItem = new ViewModelInstance(cppPointer);
            Long l = cppPointer;
            $this$elementAt_u24lambda_u241.cachedItems.put(l, new CacheEntry(newItem, 1));
            object = newItem;
        }
        return object;
    }

    @NotNull
    public final ViewModelInstance get(int index) {
        return this.elementAt(index);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull ViewModelInstance item) throws IllegalArgumentException {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!item.getHasCppObject()) {
            boolean $i$a$-require-ViewModelListProperty$add$22 = false;
            String $i$a$-require-ViewModelListProperty$add$22 = "Cannot add a disposed ViewModelProperty to ViewModelListProperty.";
            throw new IllegalArgumentException($i$a$-require-ViewModelListProperty$add$22.toString());
        }
        Map<Long, CacheEntry> $i$a$-require-ViewModelListProperty$add$22 = this.cachedItems;
        Long key$iv = item.getCppPointer();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            item.acquire();
            CacheEntry answer$iv = new CacheEntry(item, 0);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        CacheEntry cacheEntry = (CacheEntry)object;
        int n = cacheEntry.getCount();
        cacheEntry.setCount(n + 1);
        this.cppAdd(this.getCppPointer(), item.getCppPointer());
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int index, @NotNull ViewModelInstance item) throws IndexOutOfBoundsException, IllegalArgumentException {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.boundsCheck(index);
        if (!item.getHasCppObject()) {
            boolean $i$a$-require-ViewModelListProperty$add$42 = false;
            String $i$a$-require-ViewModelListProperty$add$42 = "Cannot add a disposed ViewModelProperty to ViewModelListProperty.";
            throw new IllegalArgumentException($i$a$-require-ViewModelListProperty$add$42.toString());
        }
        Map<Long, CacheEntry> $i$a$-require-ViewModelListProperty$add$42 = this.cachedItems;
        Long key$iv = item.getCppPointer();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            item.acquire();
            CacheEntry answer$iv = new CacheEntry(item, 0);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        CacheEntry cacheEntry = (CacheEntry)object;
        int n = cacheEntry.getCount();
        cacheEntry.setCount(n + 1);
        this.cppAddAt(this.getCppPointer(), index, item.getCppPointer());
    }

    public final void remove(@NotNull ViewModelInstance item) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!item.getHasCppObject()) {
            boolean bl = false;
            String string = "Cannot remove a disposed ViewModelProperty from ViewModelListProperty.";
            throw new IllegalArgumentException(string.toString());
        }
        CacheEntry cacheEntry = this.cachedItems.remove(item.getCppPointer());
        if (cacheEntry != null) {
            CacheEntry cacheEntry2;
            CacheEntry it = cacheEntry2 = cacheEntry;
            boolean bl = false;
            it.getInstance().release();
        }
        this.cppRemove(this.getCppPointer(), item.getCppPointer());
    }

    public final void removeAt(int index) throws IndexOutOfBoundsException {
        this.boundsCheck(index);
        long itemPointer = this.cppElementAt(this.getCppPointer(), index);
        CacheEntry cacheEntry = this.cachedItems.get(itemPointer);
        if (cacheEntry != null) {
            CacheEntry entry = cacheEntry;
            boolean bl = false;
            entry.setCount(entry.getCount() + -1);
            if (entry.getCount() == 0) {
                CacheEntry cacheEntry2 = this.cachedItems.remove(itemPointer);
                if (cacheEntry2 != null) {
                    CacheEntry cacheEntry3;
                    CacheEntry it = cacheEntry3 = cacheEntry2;
                    boolean bl2 = false;
                    it.getInstance().release();
                }
            }
        }
        this.cppRemoveAt(this.getCppPointer(), index);
    }

    public final void swap(int index1, int index2) throws IndexOutOfBoundsException {
        this.boundsCheck(index1);
        this.boundsCheck(index2);
        if (index1 == index2) {
            return;
        }
        this.cppSwap(this.getCppPointer(), index1, index2);
    }

    @Override
    protected void nativeGetValue() {
    }

    @Override
    protected void nativeSetValue(@NotNull Unit value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lapp/rive/runtime/kotlin/core/ViewModelListProperty$CacheEntry;", "", "instance", "Lapp/rive/runtime/kotlin/core/ViewModelInstance;", "count", "", "(Lapp/rive/runtime/kotlin/core/ViewModelInstance;I)V", "getCount", "()I", "setCount", "(I)V", "getInstance", "()Lapp/rive/runtime/kotlin/core/ViewModelInstance;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin_release"})
    private static final class CacheEntry {
        @NotNull
        private final ViewModelInstance instance;
        private int count;

        public CacheEntry(@NotNull ViewModelInstance instance, int count) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            this.instance = instance;
            this.count = count;
        }

        @NotNull
        public final ViewModelInstance getInstance() {
            return this.instance;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @NotNull
        public final ViewModelInstance component1() {
            return this.instance;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final CacheEntry copy(@NotNull ViewModelInstance instance, int count) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            return new CacheEntry(instance, count);
        }

        public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, ViewModelInstance viewModelInstance, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                viewModelInstance = cacheEntry.instance;
            }
            if ((n2 & 2) != 0) {
                n = cacheEntry.count;
            }
            return cacheEntry.copy(viewModelInstance, n);
        }

        @NotNull
        public String toString() {
            return "CacheEntry(instance=" + this.instance + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = this.instance.hashCode();
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheEntry)) {
                return false;
            }
            CacheEntry cacheEntry = (CacheEntry)other;
            if (!Intrinsics.areEqual((Object)this.instance, (Object)cacheEntry.instance)) {
                return false;
            }
            return this.count == cacheEntry.count;
        }
    }
}

