/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.fonts;

import android.util.Log;
import android.util.Xml;
import androidx.compose.runtime.internal.StabilityInferred;
import app.rive.runtime.kotlin.fonts.Fonts;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lapp/rive/runtime/kotlin/fonts/SystemFontsParser;", "", "()V", "Companion", "kotlin_release"})
@StabilityInferred(parameters=1)
public final class SystemFontsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String TAG = "SystemFontsParser";
    @NotNull
    public static final String FONTS_XML_PATH = "/system/etc/fonts.xml";
    @NotNull
    public static final String SYSTEM_FONTS_XML_PATH = "/system/etc/system_fonts.xml";
    @NotNull
    public static final String FALLBACK_FONTS_XML_PATH = "/system/etc/system_fallback.xml";
    @NotNull
    private static final List<String> SYSTEM_FONTS_PATHS;
    @NotNull
    private static final List<Pair<Fonts.Weight, String>> fontFilesOrder;

    static {
        Object[] objectArray = new String[]{"/system/fonts/", "/system/font/", "/data/fonts/", "/system/product/fonts/"};
        SYSTEM_FONTS_PATHS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{new Pair((Object)Fonts.Weight.Companion.getNORMAL(), (Object)"normal"), new Pair((Object)Fonts.Weight.Companion.getBOLD(), (Object)"normal"), new Pair((Object)Fonts.Weight.Companion.getNORMAL(), (Object)"italic"), new Pair((Object)Fonts.Weight.Companion.getBOLD(), (Object)"italic")};
        fontFilesOrder = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00070\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0002JD\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00070\r2\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002J&\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J!\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100(2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b)J\u0012\u0010*\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001100H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u00102\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J$\u00103\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0007\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J2\u00105\u001a\u0002062\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0010082\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001100H\u0002J$\u00109\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001100H\u0002J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100(2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010\u00102\u0006\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u0010H\u0002J\u0010\u0010?\u001a\u0002062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lapp/rive/runtime/kotlin/fonts/SystemFontsParser$Companion;", "", "()V", "FALLBACK_FONTS_XML_PATH", "", "FONTS_XML_PATH", "SYSTEM_FONTS_PATHS", "", "getSYSTEM_FONTS_PATHS$kotlin_release", "()Ljava/util/List;", "SYSTEM_FONTS_XML_PATH", "TAG", "fontFilesOrder", "Lkotlin/Pair;", "Lapp/rive/runtime/kotlin/fonts/Fonts$Weight;", "fromFileFonts", "Lapp/rive/runtime/kotlin/fonts/Fonts$Family;", "Lapp/rive/runtime/kotlin/fonts/Fonts$Alias;", "filesList", "Lapp/rive/runtime/kotlin/fonts/Fonts$FileFont;", "aliasNames", "familyName", "familyLang", "familyVariant", "fromFontList", "fontList", "Lapp/rive/runtime/kotlin/fonts/Fonts$Font;", "lang", "variant", "getOptionalAttribute", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "name", "default", "getRequiredAttribute", "parseFontsXML", "xmlFileStream", "Ljava/io/InputStream;", "parseFontsXML$kotlin_release", "parseFontsXMLMap", "", "parseFontsXMLMap$kotlin_release", "readAlias", "readAxis", "Lapp/rive/runtime/kotlin/fonts/Fonts$Axis;", "readFamily", "readFamilyEntry", "aliases", "", "readFileset", "readFont", "readLegacyFamily", "readNameset", "readNestedFamilies", "", "familiesMap", "", "readNestedFamiliesList", "readRootElement", "readRootElementMap", "remapAlias", "alias", "ogFamily", "skip", "kotlin_release"})
    @SourceDebugExtension(value={"SMAP\nFontHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontHelpers.kt\napp/rive/runtime/kotlin/fonts/SystemFontsParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1218:1\n1#2:1219\n1#2:1255\n1863#3,2:1220\n1557#3:1222\n1628#3,3:1223\n1863#3,2:1226\n1872#3,2:1235\n1874#3:1244\n1611#3,9:1245\n1863#3:1254\n1864#3:1256\n1620#3:1257\n1863#3:1258\n1864#3:1266\n381#4,7:1228\n381#4,7:1237\n381#4,7:1259\n*S KotlinDebug\n*F\n+ 1 FontHelpers.kt\napp/rive/runtime/kotlin/fonts/SystemFontsParser$Companion\n*L\n986#1:1255\n566#1:1220,2\n638#1:1222\n638#1:1223,3\n639#1:1226,2\n947#1:1235,2\n947#1:1244\n986#1:1245,9\n986#1:1254\n986#1:1256\n986#1:1257\n1017#1:1258\n1017#1:1266\n837#1:1228,7\n968#1:1237,7\n1026#1:1259,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getSYSTEM_FONTS_PATHS$kotlin_release() {
            return SYSTEM_FONTS_PATHS;
        }

        @NotNull
        public final Map<String, Fonts.Family> parseFontsXMLMap$kotlin_release(@NotNull InputStream xmlFileStream) {
            XmlPullParser xmlPullParser;
            Intrinsics.checkNotNullParameter((Object)xmlFileStream, (String)"xmlFileStream");
            XmlPullParser $this$parseFontsXMLMap_u24lambda_u240 = xmlPullParser = Xml.newPullParser();
            boolean bl = false;
            $this$parseFontsXMLMap_u24lambda_u240.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            $this$parseFontsXMLMap_u24lambda_u240.setInput(xmlFileStream, null);
            $this$parseFontsXMLMap_u24lambda_u240.nextTag();
            XmlPullParser parser = xmlPullParser;
            Intrinsics.checkNotNull((Object)parser);
            return this.readRootElementMap(parser);
        }

        @NotNull
        public final List<Fonts.Family> parseFontsXML$kotlin_release(@NotNull InputStream xmlFileStream) {
            XmlPullParser xmlPullParser;
            Intrinsics.checkNotNullParameter((Object)xmlFileStream, (String)"xmlFileStream");
            XmlPullParser $this$parseFontsXML_u24lambda_u241 = xmlPullParser = Xml.newPullParser();
            boolean bl = false;
            $this$parseFontsXML_u24lambda_u241.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            $this$parseFontsXML_u24lambda_u241.setInput(xmlFileStream, null);
            $this$parseFontsXML_u24lambda_u241.nextTag();
            XmlPullParser parser = xmlPullParser;
            Intrinsics.checkNotNull((Object)parser);
            return this.readRootElement(parser);
        }

        /*
         * Unable to fully structure code
         */
        private final Map<String, Fonts.Family> readRootElementMap(XmlPullParser parser) {
            parser.require(2, null, null);
            rootTagName = parser.getName();
            if (!(Intrinsics.areEqual((Object)rootTagName, (Object)"familyset") || Intrinsics.areEqual((Object)rootTagName, (Object)"fonts-modification") || Intrinsics.areEqual((Object)rootTagName, (Object)"config"))) {
                Log.w((String)"SystemFontsParser", (String)("Unexpected root tag '" + rootTagName + "' in font XML"));
            }
            familiesMap = new LinkedHashMap<K, V>();
            aliases = new ArrayList<E>();
            block5: while (parser.next() != 3) {
                block15: {
                    if (parser.getEventType() != 2) continue;
                    v0 = parser.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                    var5_5 = StringsKt.trim((CharSequence)v0).toString();
                    switch (var5_5.hashCode()) {
                        case 92902992: {
                            if (var5_5.equals("alias")) break;
                            ** break;
                        }
                        case -1359677826: {
                            if (!var5_5.equals("familyset")) {
                                ** break;
                            }
                            break block15;
                        }
                        case -1281860764: {
                            if (!var5_5.equals("family")) ** break;
                            if (this.readFamilyEntry(parser, aliases) == null) continue block5;
                            $i$a$-let-SystemFontsParser$Companion$readRootElementMap$1 = false;
                            var10_10 = family.getName();
                            mapKey = (var10_10 == null || var10_10.length() == 0) != false ? ((Fonts.Font)CollectionsKt.first((List)CollectionsKt.flatten((Iterable)family.getFonts().values()))).getName() : family.getName();
                            familiesMap.put(mapKey, family);
                            continue block5;
                        }
                    }
                    if (this.readAlias(parser) == null) continue;
                    $i$a$-let-SystemFontsParser$Companion$readRootElementMap$2 = false;
                    aliases.add(it);
                    continue;
                }
                this.readNestedFamilies(parser, familiesMap, aliases);
                continue;
lbl39:
                // 4 sources

                this.skip(parser);
            }
            $this$forEach$iv = aliases;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                alias = (Fonts.Alias)element$iv;
                $i$a$-forEach-SystemFontsParser$Companion$readRootElementMap$3 = false;
                if (!familiesMap.containsKey(alias.getName())) {
                    if ((Fonts.Family)familiesMap.get(alias.getOriginal()) != null) {
                        $i$a$-let-SystemFontsParser$Companion$readRootElementMap$3$1 = false;
                        if (SystemFontsParser.Companion.remapAlias(alias, ogFamily) != null) {
                            $i$a$-let-SystemFontsParser$Companion$readRootElementMap$3$1$1 = false;
                            familiesMap.put(alias.getName(), it);
                            continue;
                        }
                        Log.w((String)"SystemFontsParser", (String)("Could not remap alias '" + alias.getName() + "' because target '" + alias.getOriginal() + "' not found."));
                    }
                    continue;
                }
                Log.w((String)"SystemFontsParser", (String)("Skipping alias '" + alias.getName() + "' because a family with that name already exists."));
            }
            unresolvedAliases = CollectionsKt.toMutableList((Collection)aliases);
            progress = false;
            progress = true;
            while (progress && ((Collection)unresolvedAliases).isEmpty() == false) {
                progress = false;
                iterator = unresolvedAliases.iterator();
                while (iterator.hasNext()) {
                    alias = (Fonts.Alias)iterator.next();
                    if (!familiesMap.containsKey(alias.getName())) {
                        if ((Fonts.Family)familiesMap.get(alias.getOriginal()) == null) continue;
                        $i$a$-let-SystemFontsParser$Companion$readRootElementMap$4 = false;
                        if (SystemFontsParser.Companion.remapAlias(alias, ogFamily) == null) continue;
                        $i$a$-let-SystemFontsParser$Companion$readRootElementMap$4$1 = false;
                        familiesMap.put(alias.getName(), it);
                        iterator.remove();
                        progress = true;
                        continue;
                    }
                    iterator.remove();
                }
            }
            return familiesMap;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final List<Fonts.Family> readRootElement(XmlPullParser parser) {
            parser.require(2, null, null);
            rootTagName = parser.getName();
            if (!(Intrinsics.areEqual((Object)rootTagName, (Object)"familyset") || Intrinsics.areEqual((Object)rootTagName, (Object)"fonts-modification") || Intrinsics.areEqual((Object)rootTagName, (Object)"config"))) {
                Log.w((String)"SystemFontsParser", (String)("Unexpected root tag '" + rootTagName + "' in font XML"));
            }
            familiesList = new ArrayList<E>();
            aliases = new ArrayList<E>();
            block5: while (parser.next() != 3) {
                block18: {
                    if (parser.getEventType() != 2) continue;
                    v0 = parser.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                    var5_5 = StringsKt.trim((CharSequence)v0).toString();
                    switch (var5_5.hashCode()) {
                        case 92902992: {
                            if (var5_5.equals("alias")) break;
                            ** break;
                        }
                        case -1359677826: {
                            if (!var5_5.equals("familyset")) {
                                ** break;
                            }
                            break block18;
                        }
                        case -1281860764: {
                            if (!var5_5.equals("family")) ** break;
                            if (this.readFamilyEntry(parser, aliases) == null) continue block5;
                            $i$a$-let-SystemFontsParser$Companion$readRootElement$1 = false;
                            familiesList.add(it);
                            continue block5;
                        }
                    }
                    if (this.readAlias(parser) == null) continue;
                    $i$a$-let-SystemFontsParser$Companion$readRootElement$2 = false;
                    aliases.add(it);
                    continue;
                }
                familiesList.addAll((Collection)this.readNestedFamiliesList(parser, aliases));
                continue;
lbl37:
                // 4 sources

                this.skip(parser);
            }
            $this$map$iv = familiesList;
            $i$f$map = false;
            it = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            var11_13 = $this$mapTo$iv$iv.iterator();
            while (var11_13.hasNext()) {
                item$iv$iv = var11_13.next();
                var13_16 = (Fonts.Family)item$iv$iv;
                var17_24 = destination$iv$iv;
                $i$a$-map-SystemFontsParser$Companion$readRootElement$familyNames$1 = false;
                var17_24.add(it.getName());
            }
            familyNames = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            $this$forEach$iv = aliases;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                block16: {
                    alias = (Fonts.Alias)element$iv;
                    $i$a$-forEach-SystemFontsParser$Companion$readRootElement$3 = false;
                    if (familyNames.contains(alias.getName())) continue;
                    item$iv$iv = familiesList;
                    it = item$iv$iv.iterator();
                    while (it.hasNext()) {
                        $i$a$-map-SystemFontsParser$Companion$readRootElement$familyNames$1 = it.next();
                        it = (Fonts.Family)$i$a$-map-SystemFontsParser$Companion$readRootElement$familyNames$1;
                        $i$a$-find-SystemFontsParser$Companion$readRootElement$3$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)alias.getOriginal())) continue;
                        v1 = $i$a$-map-SystemFontsParser$Companion$readRootElement$familyNames$1;
                        break block16;
                    }
                    v1 = null;
                }
                if ((Fonts.Family)v1 == null) continue;
                $i$a$-let-SystemFontsParser$Companion$readRootElement$3$2 = false;
                if (SystemFontsParser.Companion.remapAlias(alias, (Fonts.Family)ogFamily) != null) {
                    $i$a$-let-SystemFontsParser$Companion$readRootElement$3$2$1 = false;
                    familyNames.add(alias.getName());
                    familiesList.add(it);
                    continue;
                }
                Log.w((String)"SystemFontsParser", (String)("Could not remap alias '" + alias.getName() + "' because target '" + alias.getOriginal() + "' not found."));
            }
            unresolvedAliases = CollectionsKt.toMutableList((Collection)aliases);
            progress = false;
            progress = true;
            while (progress && ((Collection)unresolvedAliases).isEmpty() == false) {
                progress = false;
                iterator = unresolvedAliases.iterator();
                while (iterator.hasNext()) {
                    alias = (Fonts.Alias)iterator.next();
                    if (!familyNames.contains(alias.getName())) {
                        block17: {
                            ogFamily = familiesList;
                            $i$a$-let-SystemFontsParser$Companion$readRootElement$3$2 = ogFamily.iterator();
                            while ($i$a$-let-SystemFontsParser$Companion$readRootElement$3$2.hasNext()) {
                                it /* !! */  = $i$a$-let-SystemFontsParser$Companion$readRootElement$3$2.next();
                                it = (Fonts.Family)it /* !! */ ;
                                $i$a$-find-SystemFontsParser$Companion$readRootElement$4 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)alias.getOriginal())) continue;
                                v2 = it /* !! */ ;
                                break block17;
                            }
                            v2 = null;
                        }
                        v3 = v2;
                        if (v3 == null) continue;
                        ogFamily = v3;
                        $i$a$-let-SystemFontsParser$Companion$readRootElement$5 = false;
                        if (SystemFontsParser.Companion.remapAlias(alias, (Fonts.Family)ogFamily) == null) continue;
                        $i$a$-let-SystemFontsParser$Companion$readRootElement$5$1 = false;
                        familyNames.add(alias.getName());
                        familiesList.add(it /* !! */ );
                        iterator.remove();
                        progress = true;
                        continue;
                    }
                    iterator.remove();
                }
            }
            return familiesList;
        }

        private final void readNestedFamilies(XmlPullParser parser, Map<String, Fonts.Family> familiesMap, List<Fonts.Alias> aliases) {
            parser.require(2, null, "familyset");
            while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (Intrinsics.areEqual((Object)string2, (Object)"family")) {
                    if (this.readFamilyEntry(parser, aliases) != null) {
                        Fonts.Family family;
                        boolean bl = false;
                        CharSequence charSequence = family.getName();
                        String mapKey = charSequence == null || charSequence.length() == 0 ? ((Fonts.Font)CollectionsKt.first((List)CollectionsKt.flatten((Iterable)family.getFonts().values()))).getName() : family.getName();
                        familiesMap.put(mapKey, family);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)"alias")) {
                    if (this.readAlias(parser) != null) {
                        Fonts.Alias it;
                        boolean bl = false;
                        aliases.add(it);
                    }
                    continue;
                }
                this.skip(parser);
            }
        }

        private final List<Fonts.Family> readNestedFamiliesList(XmlPullParser parser, List<Fonts.Alias> aliases) {
            parser.require(2, null, "familyset");
            List families = new ArrayList();
            while (parser.next() != 3) {
                Object it;
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (Intrinsics.areEqual((Object)string2, (Object)"family")) {
                    if (this.readFamilyEntry(parser, aliases) != null) {
                        boolean bl = false;
                        families.add(it);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)"alias")) {
                    if (this.readAlias(parser) != null) {
                        boolean bl = false;
                        aliases.add((Fonts.Alias)it);
                    }
                    continue;
                }
                this.skip(parser);
            }
            return families;
        }

        private final Fonts.Family readFamilyEntry(XmlPullParser parser, List<Fonts.Alias> aliases) {
            Fonts.Family family;
            String familyNameAttr;
            parser.require(2, null, "family");
            String string = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(this, parser, "name", null, 4, null);
            String string2 = familyNameAttr = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            if (familyNameAttr != null && ((CharSequence)familyNameAttr).length() > 0) {
                family = this.readFamily(familyNameAttr, parser);
            } else {
                Pair<Fonts.Family, List<Fonts.Alias>> pair = this.readLegacyFamily(parser);
                if (pair != null) {
                    Pair<Fonts.Family, List<Fonts.Alias>> pair2 = pair;
                    boolean bl = false;
                    Fonts.Family family2 = (Fonts.Family)pair2.component1();
                    List legacyAliases = (List)pair2.component2();
                    if (!((Collection)legacyAliases).isEmpty()) {
                        Log.w((String)SystemFontsParser.TAG, (String)"Legacy family generated aliases - these will be processed globally.");
                        aliases.addAll(legacyAliases);
                    }
                    family = family2;
                } else {
                    family = null;
                }
            }
            return family;
        }

        private final Fonts.Alias readAlias(XmlPullParser parser) {
            Fonts.Alias alias;
            parser.require(2, null, "alias");
            try {
                Fonts.Alias alias2;
                Fonts.Weight weight;
                String name2 = this.getRequiredAttribute(parser, "name");
                String to = this.getRequiredAttribute(parser, "to");
                String string = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(this, parser, "weight", null, 4, null);
                if (string != null) {
                    String weightStr = string;
                    boolean bl = false;
                    weight = Fonts.Weight.Companion.fromString(weightStr);
                } else {
                    weight = null;
                }
                Fonts.Weight weight2 = weight;
                this.skip(parser);
                if (StringsKt.isBlank((CharSequence)name2) || StringsKt.isBlank((CharSequence)to)) {
                    Log.w((String)SystemFontsParser.TAG, (String)("Skipping alias with blank name ('" + name2 + "') or to ('" + to + "')."));
                    alias2 = null;
                } else {
                    alias2 = new Fonts.Alias(((Object)StringsKt.trim((CharSequence)name2)).toString(), ((Object)StringsKt.trim((CharSequence)to)).toString(), weight2);
                }
                alias = alias2;
            }
            catch (IllegalArgumentException e) {
                Log.e((String)SystemFontsParser.TAG, (String)("Skipping alias due to missing required attribute: " + e.getMessage()));
                this.skip(parser);
                alias = null;
            }
            return alias;
        }

        private final Fonts.Family remapAlias(Fonts.Alias alias, Fonts.Family ogFamily) {
            Fonts.Weight weight = alias.getWeight();
            if (weight == null) {
                return new Fonts.Family(alias.getName(), ogFamily.getVariant(), ogFamily.getLang(), ogFamily.getFonts());
            }
            List<Fonts.Font> weightedFonts = ogFamily.getFonts().get(weight);
            if (weightedFonts == null || weightedFonts.isEmpty()) {
                Log.w((String)SystemFontsParser.TAG, (String)("Alias '" + alias.getName() + "' targets weight " + weight.getWeight() + " in family '" + alias.getOriginal() + "', but that doesn't exist"));
                return null;
            }
            String variant = ogFamily.component2();
            String lang = ogFamily.component3();
            return new Fonts.Family(alias.getName(), variant, lang, MapsKt.mapOf((Pair)TuplesKt.to((Object)weight, weightedFonts)));
        }

        /*
         * WARNING - void declaration
         */
        private final Fonts.Family readFamily(String familyName, XmlPullParser parser) {
            XmlPullParser $this$readFamily_u24lambda_u2425 = parser;
            boolean bl = false;
            Triple attributes = new Triple((Object)app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(Companion, $this$readFamily_u24lambda_u2425, "lang", null, 4, null), (Object)app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(Companion, $this$readFamily_u24lambda_u2425, "variant", null, 4, null), (Object)app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(Companion, $this$readFamily_u24lambda_u2425, "ignore", null, 4, null));
            String lang = (String)attributes.component1();
            String variant = (String)attributes.component2();
            String ignore = (String)attributes.component3();
            Map fonts = new LinkedHashMap();
            while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"font")) {
                    try {
                        Object object;
                        void $this$getOrPut$iv;
                        Fonts.Font font;
                        Fonts.Font font2 = font = this.readFont(parser);
                        boolean bl2 = false;
                        Map map2 = fonts;
                        Fonts.Weight key$iv = font2.getWeight();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(font2);
                    }
                    catch (Exception e) {
                        Log.e((String)SystemFontsParser.TAG, (String)("Failed to read <font> in family '" + familyName + "': " + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                this.skip(parser);
            }
            Object[] objectArray = new String[]{"true", "1"};
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)ignore) || fonts.isEmpty()) {
                return null;
            }
            return new Fonts.Family(familyName, variant, lang, fonts);
        }

        private final Pair<Fonts.Family, List<Fonts.Alias>> readLegacyFamily(XmlPullParser parser) {
            String familyName;
            List namesList = new ArrayList();
            List filesList = new ArrayList();
            List fontList = new ArrayList();
            String familyVariant = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(this, parser, "variant", null, 4, null);
            String familyLang = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(this, parser, "lang", null, 4, null);
            block12: while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                try {
                    String string = parser.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    switch (((Object)StringsKt.trim((CharSequence)string)).toString()) {
                        case "fileset": {
                            filesList.addAll((Collection)this.readFileset(parser));
                            continue block12;
                        }
                        case "nameset": {
                            namesList.addAll((Collection)this.readNameset(parser));
                            continue block12;
                        }
                        case "font": {
                            Fonts.Font font = this.readFont(parser);
                            fontList.add(font);
                            continue block12;
                        }
                    }
                    this.skip(parser);
                }
                catch (Exception e) {
                    Log.e((String)SystemFontsParser.TAG, (String)("Error reading tag '" + parser.getName() + "' inside legacy family - Skipping tag - " + e.getMessage()), (Throwable)e);
                }
            }
            if (!((Collection)fontList).isEmpty()) {
                familyName = !((Collection)namesList).isEmpty() ? (String)namesList.remove(0) : "";
                return this.fromFontList(familyName, fontList, familyLang, familyVariant);
            }
            if (filesList.isEmpty()) {
                return null;
            }
            if (namesList.isEmpty()) {
                namesList.add("");
            }
            familyName = ((Object)StringsKt.trim((CharSequence)((String)namesList.remove(0)))).toString();
            return this.fromFileFonts(filesList, namesList, familyName, familyLang, familyVariant);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Fonts.Family, List<Fonts.Alias>> fromFileFonts(List<Fonts.FileFont> filesList, List<String> aliasNames, String familyName, String familyLang, String familyVariant) {
            String string;
            String derivedVariant;
            void $this$mapNotNullTo$iv$iv;
            Map fontsMap = new LinkedHashMap();
            Iterable $this$forEachIndexed$iv = filesList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Object object;
                void filefont;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Fonts.FileFont fileFont = (Fonts.FileFont)item$iv;
                int index = n;
                boolean bl = false;
                if (index >= fontFilesOrder.size()) {
                    Log.w((String)SystemFontsParser.TAG, (String)("Legacy family '" + familyName + "' has more than " + fontFilesOrder.size() + " files in <fileset>. Ignoring extra file: '" + filefont.getName() + "'"));
                    continue;
                }
                Pair pair = (Pair)fontFilesOrder.get(index);
                Fonts.Weight weight = (Fonts.Weight)pair.component1();
                String style = (String)pair.component2();
                String filename = ((Object)StringsKt.trim((CharSequence)filefont.getName())).toString();
                if (((CharSequence)filename).length() == 0) {
                    Log.w((String)SystemFontsParser.TAG, (String)("Skipping empty filename in <fileset> for family '" + familyName + "'."));
                    continue;
                }
                Fonts.Font font = new Fonts.Font(weight, style, filename, null, 0, null, null, 112, null);
                Map $this$getOrPut$iv = fontsMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(weight);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(weight, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(font);
            }
            if (fontsMap.isEmpty()) {
                Log.e((String)SystemFontsParser.TAG, (String)("Could not extract any valid fonts from <fileset> for legacy family '" + familyName + "'"));
                return new Pair((Object)new Fonts.Family(familyName, familyVariant, familyLang, MapsKt.emptyMap()), (Object)CollectionsKt.emptyList());
            }
            Iterable $this$mapNotNull$iv = aliasNames;
            boolean $i$f$mapNotNull = false;
            Object object = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach22 = false;
            Object object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                Fonts.Alias it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl = false;
                String aliasName = (String)element$iv$iv;
                boolean bl3 = false;
                String trimmedAlias = ((Object)StringsKt.trim((CharSequence)aliasName)).toString();
                if ((((CharSequence)trimmedAlias).length() > 0 ? new Fonts.Alias(trimmedAlias, familyName, null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List aliases = (List)destination$iv$iv;
            String string2 = familyVariant;
            if (string2 == null) {
                Fonts.FileFont fileFont = (Fonts.FileFont)CollectionsKt.firstOrNull(filesList);
                string2 = derivedVariant = fileFont != null ? fileFont.getVariant() : null;
            }
            if ((string = familyLang) == null) {
                Fonts.FileFont fileFont = (Fonts.FileFont)CollectionsKt.firstOrNull(filesList);
                string = fileFont != null ? fileFont.getLang() : null;
            }
            String derivedLang = string;
            String string3 = derivedVariant;
            String it = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
            boolean bl = false;
            CharSequence $i$f$forEach22 = it;
            object = $i$f$forEach22 == null || StringsKt.isBlank((CharSequence)$i$f$forEach22) ? null : it;
            String string4 = derivedLang;
            String it2 = string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null;
            boolean bl5 = false;
            object2 = it2;
            String string5 = object2 == null || StringsKt.isBlank((CharSequence)object2) ? null : it2;
            List list = aliases;
            Fonts.Family family = new Fonts.Family(familyName, (String)object, string5, fontsMap);
            return new Pair((Object)family, (Object)list);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Fonts.Family, List<Fonts.Alias>> fromFontList(String familyName, List<Fonts.Font> fontList, String lang, String variant) {
            Map fontsMap = new LinkedHashMap();
            Iterable $this$forEach$iv = fontList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                void $this$getOrPut$iv;
                Fonts.Font font = (Fonts.Font)element$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)font.getName())) {
                    Log.w((String)SystemFontsParser.TAG, (String)("Skipping font with blank filename in family '" + familyName + "'."));
                    continue;
                }
                Map map2 = fontsMap;
                Fonts.Weight key$iv = font.getWeight();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(font);
            }
            if (fontsMap.isEmpty()) {
                Log.w((String)SystemFontsParser.TAG, (String)("Family '" + familyName + "' from <font> list resulted in no valid fonts. Creating empty family."));
                return new Pair((Object)new Fonts.Family(familyName, variant, lang, MapsKt.emptyMap()), (Object)CollectionsKt.emptyList());
            }
            return new Pair((Object)new Fonts.Family(familyName, variant, lang, fontsMap), (Object)CollectionsKt.emptyList());
        }

        /*
         * WARNING - void declaration
         */
        private final Fonts.Font readFont(XmlPullParser parser) {
            void it;
            Object e2;
            Object it2;
            String string;
            String string2;
            String it3;
            parser.require(2, null, "font");
            Fonts.Weight weight = Fonts.Weight.Companion.fromString(this.getOptionalAttribute(parser, "weight", String.valueOf(Fonts.Weight.Companion.getNORMAL().getWeight())));
            String string3 = this.getOptionalAttribute(parser, "style", "normal");
            if (string3 == null) {
                string3 = "normal";
            }
            String style = string3;
            Object object = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(this, parser, "index", null, 4, null);
            int ttcIndex = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            String string4 = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(this, parser, "postScriptName", null, 4, null);
            if (string4 != null) {
                String string5;
                it3 = string5 = string4;
                boolean bl = false;
                string2 = !StringsKt.isBlank((CharSequence)it3) ? string5 : null;
            } else {
                string2 = null;
            }
            String postScriptName = string2;
            String string6 = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(this, parser, "fallbackFor", null, 4, null);
            if (string6 != null) {
                String it4 = it3 = string6;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it4) ? it3 : null;
            } else {
                string = null;
            }
            String fallbackFor = string;
            StringBuilder filenameBuilder = new StringBuilder();
            List axes = new ArrayList();
            while (parser.next() != 3) {
                switch (parser.getEventType()) {
                    case 4: {
                        if (parser.getText() != null) {
                            boolean bl = false;
                            filenameBuilder.append((String)it2);
                        }
                        break;
                    }
                    case 2: {
                        String string7 = parser.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
                        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string7)).toString(), (Object)"axis")) {
                            try {
                                Fonts.Axis axis = this.readAxis(parser);
                                it2 = axis;
                                boolean bl = false;
                                axes.add(it2);
                            }
                            catch (Exception e2) {
                                Log.e((String)SystemFontsParser.TAG, (String)("Failed to read <axis> tag: " + e2.getMessage()), (Throwable)e2);
                            }
                            break;
                        }
                        this.skip(parser);
                    }
                }
            }
            String string8 = filenameBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
            it2 = e2 = ((Object)StringsKt.trim((CharSequence)string8)).toString();
            boolean bl = false;
            Object object2 = !(((CharSequence)it2).length() == 0) ? e2 : null;
            if (object2 == null) {
                throw new IllegalStateException("Font tag found with empty filename");
            }
            String filename = object2;
            List list = axes;
            e2 = list;
            String string9 = filename;
            String string10 = style;
            Fonts.Weight weight2 = weight;
            boolean bl2 = false;
            boolean bl3 = it.isEmpty();
            List list2 = !bl3 ? list : null;
            String string11 = fallbackFor;
            String string12 = postScriptName;
            int n = ttcIndex;
            List list3 = list2;
            String string13 = string9;
            String string14 = string10;
            Fonts.Weight weight3 = weight2;
            return new Fonts.Font(weight3, string14, string13, list3, n, string12, string11);
        }

        private final Fonts.Axis readAxis(XmlPullParser parser) {
            String tagStr = this.getRequiredAttribute(parser, "tag");
            String styleValueStr = this.getRequiredAttribute(parser, "stylevalue");
            this.skip(parser);
            if (StringsKt.isBlank((CharSequence)tagStr) || StringsKt.isBlank((CharSequence)styleValueStr)) {
                throw new IllegalArgumentException("Axis tag found with blank 'tag' or 'stylevalue'.");
            }
            return new Fonts.Axis(tagStr, styleValueStr);
        }

        private final List<String> readNameset(XmlPullParser parser) {
            parser.require(2, null, "nameset");
            List namesetList = new ArrayList();
            while (parser.next() != 3) {
                block6: {
                    String nameText;
                    block8: {
                        block7: {
                            if (parser.getEventType() != 2) continue;
                            String string = parser.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"name")) break block6;
                            nameText = "";
                            if (parser.next() == 4) {
                                String string2 = parser.getText();
                                if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
                                    string2 = "";
                                }
                                nameText = string2;
                                parser.next();
                            }
                            if (parser.getEventType() != 3) break block7;
                            String string3 = parser.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string3)).toString(), (Object)"name")) break block8;
                        }
                        Log.w((String)SystemFontsParser.TAG, (String)("Expected </name> tag after reading text, but found " + parser.getEventType() + " " + parser.getName()));
                    }
                    if (!(!StringsKt.isBlank((CharSequence)nameText))) continue;
                    namesetList.add(nameText);
                    continue;
                }
                this.skip(parser);
            }
            return namesetList;
        }

        private final List<Fonts.FileFont> readFileset(XmlPullParser parser) {
            List list;
            List $this$readFileset_u24lambda_u2446 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            parser.require(2, null, "fileset");
            while (parser.next() != 3) {
                block12: {
                    String fileName;
                    String string;
                    CharSequence lang;
                    String variant;
                    block17: {
                        block16: {
                            CharSequence charSequence;
                            block13: {
                                String string2;
                                CharSequence $this$readFileset_u24lambda_u2446_u24lambda_u2443;
                                block15: {
                                    block14: {
                                        CharSequence charSequence2;
                                        String string3;
                                        if (parser.getEventType() != 2) continue;
                                        String string4 = parser.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                                        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string4)).toString(), (Object)"file")) break block12;
                                        if (app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(Companion, parser, "variant", null, 4, null) != null) {
                                            String string5;
                                            String it = string5;
                                            boolean bl2 = false;
                                            string3 = !StringsKt.isBlank((CharSequence)it) ? string5 : null;
                                        } else {
                                            string3 = null;
                                        }
                                        variant = string3;
                                        String string6 = app.rive.runtime.kotlin.fonts.SystemFontsParser$Companion.getOptionalAttribute$default(Companion, parser, "lang", null, 4, null);
                                        if (string6 != null) {
                                            charSequence = string6;
                                            String it = charSequence;
                                            boolean bl3 = false;
                                            charSequence2 = !StringsKt.isBlank((CharSequence)it) ? charSequence : null;
                                        } else {
                                            charSequence2 = null;
                                        }
                                        lang = charSequence2;
                                        $this$readFileset_u24lambda_u2446_u24lambda_u2443 = charSequence = new StringBuilder();
                                        boolean bl4 = false;
                                        if (parser.next() != 4) break block13;
                                        String string7 = parser.getText();
                                        string2 = string7;
                                        if (string2 == null) break block14;
                                        Intrinsics.checkNotNull((Object)string2);
                                        string2 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                                        if (string2 != null) break block15;
                                    }
                                    string2 = "";
                                }
                                ((StringBuilder)$this$readFileset_u24lambda_u2446_u24lambda_u2443).append(string2);
                                parser.next();
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)charSequence).toString(), (String)"toString(...)");
                            if (parser.getEventType() != 3) break block16;
                            String string8 = parser.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
                            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string8)).toString(), (Object)"file")) break block17;
                        }
                        Log.w((String)SystemFontsParser.TAG, (String)("Expected </file> tag after reading text, found " + parser.getEventType() + " " + parser.getName()));
                    }
                    String it = string = fileName;
                    boolean bl5 = false;
                    if ((!(((CharSequence)it).length() == 0) ? string : null) != null) {
                        String name2;
                        name2 = name2;
                        boolean bl6 = false;
                        $this$readFileset_u24lambda_u2446.add(new Fonts.FileFont(name2, variant, (String)lang));
                        continue;
                    }
                    Log.w((String)SystemFontsParser.TAG, (String)"Skipping <file> tag with empty content within <fileset>");
                    continue;
                }
                Companion.skip(parser);
            }
            return CollectionsKt.build((List)list);
        }

        private final String getRequiredAttribute(XmlPullParser parser, String name2) {
            String string = parser.getAttributeValue(null, name2);
            if (string == null) {
                throw new IllegalArgumentException("Missing required attribute: " + name2);
            }
            return string;
        }

        private final String getOptionalAttribute(XmlPullParser parser, String name2, String string) {
            String string2 = parser.getAttributeValue(null, name2);
            if (string2 == null) {
                string2 = string;
            }
            return string2;
        }

        static /* synthetic */ String getOptionalAttribute$default(Companion companion, XmlPullParser xmlPullParser, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.getOptionalAttribute(xmlPullParser, string, string2);
        }

        private final void skip(XmlPullParser parser) {
            int depth = 1;
            block5: while (depth > 0) {
                switch (parser.next()) {
                    case 2: {
                        ++depth;
                        continue block5;
                    }
                    case 3: {
                        --depth;
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

