/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import androidx.annotation.RawRes;
import androidx.annotation.VisibleForTesting;
import app.rive.runtime.kotlin.Observable;
import app.rive.runtime.kotlin.PointerEvents;
import app.rive.runtime.kotlin.R;
import app.rive.runtime.kotlin.ResourceType;
import app.rive.runtime.kotlin.RiveArtboardRenderer;
import app.rive.runtime.kotlin.RiveFileRequest;
import app.rive.runtime.kotlin.RiveTextureView;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.Rive;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.renderers.RendererMetrics;
import app.rive.runtime.kotlin.renderers.RendererSkia;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\b\u0016\u0018\u0000 z2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002z{B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020GH\u0014J\u0016\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u0016J\u0010\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020\u0016H\u0002J\b\u0010M\u001a\u00020EH\u0002J\u0012\u0010N\u001a\u00020E2\b\b\u0001\u0010O\u001a\u00020PH\u0002J\b\u0010Q\u001a\u00020EH\u0014J\b\u0010R\u001a\u00020EH\u0014J\u0018\u0010S\u001a\u00020E2\u0006\u0010T\u001a\u00020P2\u0006\u0010U\u001a\u00020PH\u0014J \u0010V\u001a\u00020E2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020P2\u0006\u0010Z\u001a\u00020PH\u0016J \u0010[\u001a\u00020E2\u0006\u0010\\\u001a\u00020X2\u0006\u0010Y\u001a\u00020P2\u0006\u0010Z\u001a\u00020PH\u0016J\u0012\u0010]\u001a\u00020 2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u0006\u0010`\u001a\u00020EJ\u0018\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020\u00162\b\b\u0002\u0010b\u001a\u00020 J\u001e\u0010`\u001a\u00020E2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\b\b\u0002\u0010d\u001a\u00020 J$\u0010e\u001a\u00020E2\b\b\u0002\u0010f\u001a\u00020g2\b\b\u0002\u0010h\u001a\u00020i2\b\b\u0002\u0010j\u001a\u00020 J6\u0010e\u001a\u00020E2\u0006\u0010a\u001a\u00020\u00162\b\b\u0002\u0010f\u001a\u00020g2\b\b\u0002\u0010h\u001a\u00020i2\b\b\u0002\u0010b\u001a\u00020 2\b\b\u0002\u0010j\u001a\u00020 J<\u0010e\u001a\u00020E2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\b\b\u0002\u0010f\u001a\u00020g2\b\b\u0002\u0010h\u001a\u00020i2\b\b\u0002\u0010d\u001a\u00020 2\b\b\u0002\u0010j\u001a\u00020 J\u0010\u0010k\u001a\u00020E2\u0006\u0010l\u001a\u00020\u0003H\u0016J\u0006\u0010m\u001a\u00020EJ\u001e\u0010n\u001a\u00020E2\u0006\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020 J\u001e\u0010o\u001a\u00020E2\u0006\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020pJZ\u0010q\u001a\u00020E2\u0006\u0010r\u001a\u00020s2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010!\u001a\u00020 2\b\b\u0002\u0010-\u001a\u00020,2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010f\u001a\u00020gJ\u0010\u0010t\u001a\u00020E2\u0006\u0010(\u001a\u00020)H\u0002J\\\u0010u\u001a\u00020E2\b\b\u0001\u0010O\u001a\u00020P2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010!\u001a\u00020 2\b\b\u0002\u0010-\u001a\u00020,2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010f\u001a\u00020gJ\b\u0010v\u001a\u00020EH\u0003J\u0006\u0010w\u001a\u00020EJ\u0018\u0010w\u001a\u00020E2\u0006\u0010a\u001a\u00020\u00162\b\b\u0002\u0010b\u001a\u00020 J\u001e\u0010w\u001a\u00020E2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\b\b\u0002\u0010d\u001a\u00020 J\b\u0010x\u001a\u00020EH\u0003J\u0010\u0010y\u001a\u00020E2\u0006\u0010l\u001a\u00020\u0003H\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u00020 2\u0006\u0010\t\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020 X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u0013\u0010(\u001a\u0004\u0018\u00010)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R$\u0010-\u001a\u00020,2\u0006\u0010\t\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010#R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\u0012068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020:068F\u00a2\u0006\u0006\u001a\u0004\b;\u00108R\u001c\u0010<\u001a\u00020=8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b>\u0010?\u001a\u0004\b@\u0010AR\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020:0\u00118F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0014\u00a8\u0006|"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView;", "Lapp/rive/runtime/kotlin/RiveTextureView;", "Lapp/rive/runtime/kotlin/Observable;", "Lapp/rive/runtime/kotlin/RiveArtboardRenderer$Listener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "value", "Lapp/rive/runtime/kotlin/core/Alignment;", "alignment", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "animations", "", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getAnimations", "()Ljava/util/List;", "name", "", "artboardName", "getArtboardName", "()Ljava/lang/String;", "setArtboardName", "(Ljava/lang/String;)V", "artboardRenderer", "Lapp/rive/runtime/kotlin/RiveArtboardRenderer;", "getArtboardRenderer", "()Lapp/rive/runtime/kotlin/RiveArtboardRenderer;", "", "autoplay", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "defaultAutoplay", "getDefaultAutoplay", "file", "Lapp/rive/runtime/kotlin/core/File;", "getFile", "()Lapp/rive/runtime/kotlin/core/File;", "Lapp/rive/runtime/kotlin/core/Fit;", "fit", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "frameMetricsListener", "Landroid/view/Window$OnFrameMetricsAvailableListener;", "isPlaying", "playingAnimations", "Ljava/util/HashSet;", "getPlayingAnimations", "()Ljava/util/HashSet;", "playingStateMachines", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getPlayingStateMachines", "rendererAttributes", "Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "getRendererAttributes$annotations", "()V", "getRendererAttributes", "()Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "stateMachines", "getStateMachines", "configureRenderer", "", "createRenderer", "Lapp/rive/runtime/kotlin/renderers/RendererSkia;", "fireState", "stateMachineName", "inputName", "loadHttp", "url", "loadResource", "loadRiveResource", "resId", "", "onAttachedToWindow", "onDetachedFromWindow", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSurfaceTextureAvailable", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureSizeChanged", "surface", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "pause", "animationName", "isStateMachine", "animationNames", "areStateMachines", "play", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "settleInitialState", "registerListener", "listener", "reset", "setBooleanState", "setNumberState", "", "setRiveBytes", "bytes", "", "setRiveFile", "setRiveResource", "startFrameMetrics", "stop", "stopFrameMetrics", "unregisterListener", "Companion", "RendererAttributes", "kotlin_release"})
public class RiveAnimationView
extends RiveTextureView
implements Observable<RiveArtboardRenderer.Listener> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean defaultAutoplay;
    @NotNull
    private final RendererAttributes rendererAttributes;
    @Nullable
    private Window.OnFrameMetricsAvailableListener frameMetricsListener;
    @NotNull
    public static final String TAG = "RiveAnimationView";
    public static final int alignmentIndexDefault = 4;
    public static final int fitIndexDefault = 1;
    public static final int loopIndexDefault = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiveAnimationView(@NotNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.defaultAutoplay = true;
        TypedArray $this$_init__u24lambda_u2d0 = typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RiveAnimationView, 0, 0);
        boolean bl = false;
        try {
            int resId = $this$_init__u24lambda_u2d0.getResourceId(R.styleable.RiveAnimationView_riveResource, -1);
            String resUrl = $this$_init__u24lambda_u2d0.getString(R.styleable.RiveAnimationView_riveUrl);
            ResourceType resourceFromValue = ResourceType.Companion.makeMaybeResource(resId == -1 ? resUrl : Integer.valueOf(resId));
            this.rendererAttributes = new RendererAttributes($this$_init__u24lambda_u2d0.getInteger(R.styleable.RiveAnimationView_riveAlignment, 4), $this$_init__u24lambda_u2d0.getInteger(R.styleable.RiveAnimationView_riveFit, 1), $this$_init__u24lambda_u2d0.getInteger(R.styleable.RiveAnimationView_riveLoop, 3), $this$_init__u24lambda_u2d0.getBoolean(R.styleable.RiveAnimationView_riveAutoPlay, this.getDefaultAutoplay()), $this$_init__u24lambda_u2d0.getBoolean(R.styleable.RiveAnimationView_riveTraceAnimations, false), $this$_init__u24lambda_u2d0.getString(R.styleable.RiveAnimationView_riveArtboard), $this$_init__u24lambda_u2d0.getString(R.styleable.RiveAnimationView_riveAnimation), $this$_init__u24lambda_u2d0.getString(R.styleable.RiveAnimationView_riveStateMachine), resourceFromValue);
        }
        finally {
            $this$_init__u24lambda_u2d0.recycle();
        }
    }

    public /* synthetic */ RiveAnimationView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public boolean getDefaultAutoplay() {
        return this.defaultAutoplay;
    }

    @Nullable
    public final RiveArtboardRenderer getArtboardRenderer() {
        String string;
        RendererSkia rendererSkia = this.getRenderer();
        if (rendererSkia == null ? true : rendererSkia instanceof RiveArtboardRenderer) {
            return (RiveArtboardRenderer)this.getRenderer();
        }
        StringBuilder stringBuilder = new StringBuilder().append("Expected RiveArtboardRenderer but got ");
        Object object = this.getRenderer();
        if ((object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : (string = null)) == null) {
            string = "NULL";
        }
        throw new TypeCastException(stringBuilder.append(string).toString());
    }

    @NotNull
    public final RendererAttributes getRendererAttributes() {
        return this.rendererAttributes;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getRendererAttributes$annotations() {
    }

    @NotNull
    public final Fit getFit() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getFit();
    }

    public final void setFit(@NotNull Fit value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        if (riveArtboardRenderer != null) {
            riveArtboardRenderer.setFit(value);
        }
    }

    @NotNull
    public final Alignment getAlignment() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getAlignment();
    }

    public final void setAlignment(@NotNull Alignment value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        if (riveArtboardRenderer != null) {
            riveArtboardRenderer.setAlignment(value);
        }
    }

    @Nullable
    public final File getFile() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getFile();
    }

    @Nullable
    public final String getArtboardName() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getArtboardName();
    }

    public final void setArtboardName(@Nullable String name) {
        block0: {
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.setArtboardByName(name);
        }
    }

    public final boolean getAutoplay() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getAutoplay();
    }

    public final void setAutoplay(boolean value) {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        if (riveArtboardRenderer != null) {
            riveArtboardRenderer.setAutoplay(value);
        }
    }

    @NotNull
    public final List<LinearAnimationInstance> getAnimations() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getAnimations();
    }

    @NotNull
    public final List<StateMachineInstance> getStateMachines() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getStateMachines();
    }

    @NotNull
    public final HashSet<LinearAnimationInstance> getPlayingAnimations() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getPlayingAnimations();
    }

    @NotNull
    public final HashSet<StateMachineInstance> getPlayingStateMachines() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        return riveArtboardRenderer.getPlayingStateMachines();
    }

    @Override
    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        super.onSurfaceTextureSizeChanged(surface, width, height);
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        riveArtboardRenderer.setTargetBounds(new RectF(0.0f, 0.0f, (float)width, (float)height));
    }

    @Override
    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        super.onSurfaceTextureAvailable(surfaceTexture, width, height);
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        riveArtboardRenderer.setTargetBounds(new RectF(0.0f, 0.0f, (float)width, (float)height));
    }

    private final void loadResource() {
        ResourceType resource = this.rendererAttributes.getResource();
        if (resource == null) {
            Log.w((String)TAG, (String)"loadResource: no resource to load");
        } else if (resource instanceof ResourceType.ResourceBytes) {
            this.setRiveFile(new File(((ResourceType.ResourceBytes)resource).getBytes()));
        } else if (resource instanceof ResourceType.ResourceId) {
            this.loadRiveResource(((ResourceType.ResourceId)resource).getId());
        } else if (resource instanceof ResourceType.ResourceUrl) {
            this.loadHttp(((ResourceType.ResourceUrl)resource).getUrl());
        }
    }

    private final void loadRiveResource(@RawRes int resId) {
        InputStream inputStream = this.getResources().openRawResource(resId);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resources.openRawResource(resId)");
        InputStream stream = inputStream;
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)stream);
        this.setRiveFile(new File(bytes));
        stream.close();
    }

    private final void loadHttp(String url) {
        RequestQueue requestQueue = Volley.newRequestQueue((Context)this.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)requestQueue, (String)"newRequestQueue(context)");
        RequestQueue queue = requestQueue;
        RiveFileRequest stringRequest = new RiveFileRequest(url, (Response.Listener<File>)((Response.Listener)arg_0 -> RiveAnimationView.loadHttp$lambda-1(this, arg_0)), arg_0 -> RiveAnimationView.loadHttp$lambda-2(url, arg_0));
        queue.add((Request)stringRequest);
    }

    public final void pause() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        if (riveArtboardRenderer != null) {
            riveArtboardRenderer.pause();
        }
        this.stopFrameMetrics();
    }

    public final void pause(@NotNull List<String> animationNames, boolean areStateMachines) {
        block0: {
            Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.pause(animationNames, areStateMachines);
        }
    }

    public static /* synthetic */ void pause$default(RiveAnimationView riveAnimationView, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.pause(list, bl);
    }

    public final void pause(@NotNull String animationName, boolean isStateMachine) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.pause(animationName, isStateMachine);
        }
    }

    public static /* synthetic */ void pause$default(RiveAnimationView riveAnimationView, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.pause(string, bl);
    }

    public final void stop() {
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        if (riveArtboardRenderer != null) {
            riveArtboardRenderer.stopAnimations();
        }
        this.stopFrameMetrics();
    }

    public final void stop(@NotNull List<String> animationNames, boolean areStateMachines) {
        block0: {
            Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.stopAnimations(animationNames, areStateMachines);
        }
    }

    public static /* synthetic */ void stop$default(RiveAnimationView riveAnimationView, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stop");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.stop(list, bl);
    }

    public final void stop(@NotNull String animationName, boolean isStateMachine) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.stopAnimations(animationName, isStateMachine);
        }
    }

    public static /* synthetic */ void stop$default(RiveAnimationView riveAnimationView, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stop");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveAnimationView.stop(string, bl);
    }

    public final void play(@NotNull Loop loop, @NotNull Direction direction, boolean settleInitialState) {
        block0: {
            RendererAttributes rendererAttributes;
            Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            RendererAttributes $this$play_u24lambda_u2d3 = rendererAttributes = this.rendererAttributes;
            boolean bl = false;
            $this$play_u24lambda_u2d3.setLoop(loop);
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.play(loop, direction, settleInitialState);
        }
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 1) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 2) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        riveAnimationView.play(loop, direction, bl);
    }

    public final void play(@NotNull List<String> animationNames, @NotNull Loop loop, @NotNull Direction direction, boolean areStateMachines, boolean settleInitialState) {
        block0: {
            RendererAttributes rendererAttributes;
            Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
            Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            RendererAttributes $this$play_u24lambda_u2d4 = rendererAttributes = this.rendererAttributes;
            boolean bl = false;
            $this$play_u24lambda_u2d4.setLoop(loop);
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.play(animationNames, loop, direction, areStateMachines, settleInitialState);
        }
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, List list, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveAnimationView.play(list, loop, direction, bl, bl2);
    }

    public final void play(@NotNull String animationName, @NotNull Loop loop, @NotNull Direction direction, boolean isStateMachine, boolean settleInitialState) {
        block0: {
            RendererAttributes rendererAttributes;
            Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
            Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            RendererAttributes $this$play_u24lambda_u2d5 = rendererAttributes = this.rendererAttributes;
            boolean bl = false;
            $this$play_u24lambda_u2d5.setAnimationName(animationName);
            $this$play_u24lambda_u2d5.setLoop(loop);
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.play(animationName, loop, direction, isStateMachine, settleInitialState);
        }
    }

    public static /* synthetic */ void play$default(RiveAnimationView riveAnimationView, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveAnimationView.play(string, loop, direction, bl, bl2);
    }

    public final void reset() {
        block0: {
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.reset();
        }
    }

    public final void fireState(@NotNull String stateMachineName, @NotNull String inputName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
            Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.fireState(stateMachineName, inputName);
        }
    }

    public final void setBooleanState(@NotNull String stateMachineName, @NotNull String inputName, boolean value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
            Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.setBooleanState(stateMachineName, inputName, value);
        }
    }

    public final void setNumberState(@NotNull String stateMachineName, @NotNull String inputName, float value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
            Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.setNumberState(stateMachineName, inputName, value);
        }
    }

    public final boolean isPlaying() {
        RendererSkia rendererSkia = this.getRenderer();
        return rendererSkia != null ? rendererSkia.isPlaying() : false;
    }

    public final void setRiveResource(@RawRes int resId, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, @NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        RendererAttributes $this$setRiveResource_u24lambda_u2d6 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$setRiveResource_u24lambda_u2d6.setArtboardName(artboardName);
        $this$setRiveResource_u24lambda_u2d6.setAnimationName(animationName);
        $this$setRiveResource_u24lambda_u2d6.setStateMachineName(stateMachineName);
        $this$setRiveResource_u24lambda_u2d6.setAutoplay(autoplay);
        $this$setRiveResource_u24lambda_u2d6.setFit(fit);
        $this$setRiveResource_u24lambda_u2d6.setAlignment(alignment);
        $this$setRiveResource_u24lambda_u2d6.setLoop(loop);
        $this$setRiveResource_u24lambda_u2d6.setResource(ResourceType.Companion.makeMaybeResource(resId));
        if (this.getRenderer() != null) {
            this.configureRenderer();
            this.loadResource();
        }
    }

    public static /* synthetic */ void setRiveResource$default(RiveAnimationView riveAnimationView, int n, String string, String string2, String string3, boolean bl, Fit fit, Alignment alignment, Loop loop, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setRiveResource");
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            RiveArtboardRenderer riveArtboardRenderer = riveAnimationView.getArtboardRenderer();
            boolean bl2 = bl = riveArtboardRenderer != null ? riveArtboardRenderer.getAutoplay() : riveAnimationView.getDefaultAutoplay();
        }
        if ((n2 & 0x20) != 0) {
            fit = Fit.CONTAIN;
        }
        if ((n2 & 0x40) != 0) {
            alignment = Alignment.CENTER;
        }
        if ((n2 & 0x80) != 0) {
            loop = Loop.AUTO;
        }
        riveAnimationView.setRiveResource(n, string, string2, string3, bl, fit, alignment, loop);
    }

    public final void setRiveBytes(@NotNull byte[] bytes, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, @NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop) {
        RendererAttributes rendererAttributes;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        RendererAttributes $this$setRiveBytes_u24lambda_u2d7 = rendererAttributes = this.rendererAttributes;
        boolean bl = false;
        $this$setRiveBytes_u24lambda_u2d7.setArtboardName(artboardName);
        $this$setRiveBytes_u24lambda_u2d7.setAnimationName(animationName);
        $this$setRiveBytes_u24lambda_u2d7.setStateMachineName(stateMachineName);
        $this$setRiveBytes_u24lambda_u2d7.setAutoplay(autoplay);
        $this$setRiveBytes_u24lambda_u2d7.setFit(fit);
        $this$setRiveBytes_u24lambda_u2d7.setAlignment(alignment);
        $this$setRiveBytes_u24lambda_u2d7.setLoop(loop);
        $this$setRiveBytes_u24lambda_u2d7.setResource(ResourceType.Companion.makeMaybeResource(bytes));
        if (this.getRenderer() != null) {
            this.configureRenderer();
            this.loadResource();
        }
    }

    public static /* synthetic */ void setRiveBytes$default(RiveAnimationView riveAnimationView, byte[] byArray, String string, String string2, String string3, boolean bl, Fit fit, Alignment alignment, Loop loop, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setRiveBytes");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            RiveArtboardRenderer riveArtboardRenderer = riveAnimationView.getArtboardRenderer();
            boolean bl2 = bl = riveArtboardRenderer != null ? riveArtboardRenderer.getAutoplay() : riveAnimationView.getDefaultAutoplay();
        }
        if ((n & 0x20) != 0) {
            fit = Fit.CONTAIN;
        }
        if ((n & 0x40) != 0) {
            alignment = Alignment.CENTER;
        }
        if ((n & 0x80) != 0) {
            loop = Loop.AUTO;
        }
        riveAnimationView.setRiveBytes(byArray, string, string2, string3, bl, fit, alignment, loop);
    }

    private final void configureRenderer() {
        RiveArtboardRenderer riveArtboardRenderer;
        RiveArtboardRenderer riveArtboardRenderer2 = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer2);
        RiveArtboardRenderer $this$configureRenderer_u24lambda_u2d8 = riveArtboardRenderer = riveArtboardRenderer2;
        boolean bl = false;
        $this$configureRenderer_u24lambda_u2d8.setAutoplay(this.rendererAttributes.getAutoplay());
        $this$configureRenderer_u24lambda_u2d8.setAnimationName(this.rendererAttributes.getAnimationName());
        $this$configureRenderer_u24lambda_u2d8.setStateMachineName(this.rendererAttributes.getStateMachineName());
        $this$configureRenderer_u24lambda_u2d8.setArtboardName(this.rendererAttributes.getArtboardName());
        $this$configureRenderer_u24lambda_u2d8.stopAnimations();
        $this$configureRenderer_u24lambda_u2d8.setFit(this.rendererAttributes.getFit());
        $this$configureRenderer_u24lambda_u2d8.setAlignment(this.rendererAttributes.getAlignment());
        $this$configureRenderer_u24lambda_u2d8.setLoop(this.rendererAttributes.getLoop());
    }

    private final void setRiveFile(File file) {
        block0: {
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.setRiveFile(file);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        this.pause();
        super.onDetachedFromWindow();
    }

    @Override
    @NotNull
    protected RendererSkia createRenderer() {
        return new RiveArtboardRenderer(null, null, null, null, null, null, this.rendererAttributes.getAutoplay(), this.rendererAttributes.getRiveTraceAnimations(), 63, null);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.configureRenderer();
        this.loadResource();
        RendererSkia rendererSkia = this.getRenderer();
        Intrinsics.checkNotNull((Object)rendererSkia);
        if (rendererSkia.getTrace()) {
            this.startFrameMetrics();
        }
        RendererSkia rendererSkia2 = this.getRenderer();
        Intrinsics.checkNotNull((Object)rendererSkia2);
        rendererSkia2.start();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=24)
    private final void startFrameMetrics() {
        if (Build.VERSION.SDK_INT >= 24) {
            void it;
            RendererMetrics rendererMetrics;
            RendererMetrics rendererMetrics2 = rendererMetrics = new RendererMetrics(this.getActivity());
            RiveAnimationView riveAnimationView = this;
            boolean bl = false;
            this.getActivity().getWindow().addOnFrameMetricsAvailableListener((Window.OnFrameMetricsAvailableListener)it, new Handler(Looper.getMainLooper()));
            riveAnimationView.frameMetricsListener = rendererMetrics;
        } else {
            Log.w((String)TAG, (String)"FrameMetrics is available with Android SDK 24 (Nougat) and higher");
        }
    }

    @TargetApi(value=24)
    private final void stopFrameMetrics() {
        block1: {
            if (Build.VERSION.SDK_INT < 24) break block1;
            Window.OnFrameMetricsAvailableListener onFrameMetricsAvailableListener = this.frameMetricsListener;
            if (onFrameMetricsAvailableListener != null) {
                Window.OnFrameMetricsAvailableListener it = onFrameMetricsAvailableListener;
                boolean bl = false;
                this.getActivity().getWindow().removeOnFrameMetricsAvailableListener(it);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        int n4;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getRenderer() == null) {
            Log.w((String)TAG, (String)"onMeasure(): Renderer not instantiated yet.");
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == 0) {
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            Intrinsics.checkNotNull((Object)riveArtboardRenderer);
            n4 = (int)riveArtboardRenderer.artboardBounds().width();
        } else {
            n4 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        int providedWidth = n4;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0) {
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            Intrinsics.checkNotNull((Object)riveArtboardRenderer);
            n3 = (int)riveArtboardRenderer.artboardBounds().height();
        } else {
            n3 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        }
        int providedHeight = n3;
        RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer);
        Fit fit = riveArtboardRenderer.getFit();
        RiveArtboardRenderer riveArtboardRenderer2 = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer2);
        Alignment alignment = riveArtboardRenderer2.getAlignment();
        RectF rectF = new RectF(0.0f, 0.0f, (float)providedWidth, (float)providedHeight);
        RiveArtboardRenderer riveArtboardRenderer3 = this.getArtboardRenderer();
        Intrinsics.checkNotNull((Object)riveArtboardRenderer3);
        RectF usedBounds = Rive.INSTANCE.calculateRequiredBounds(fit, alignment, rectF, riveArtboardRenderer3.artboardBounds());
        switch (widthMode) {
            case 0x40000000: {
                n2 = providedWidth;
                break;
            }
            case -2147483648: {
                n2 = Math.min((int)usedBounds.width(), providedWidth);
                break;
            }
            default: {
                n2 = (int)usedBounds.width();
            }
        }
        int width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = providedHeight;
                break;
            }
            case -2147483648: {
                n = Math.min((int)usedBounds.height(), providedHeight);
                break;
            }
            default: {
                n = (int)usedBounds.height();
            }
        }
        int height = n;
        this.setMeasuredDimension(width, height);
    }

    @Override
    public void registerListener(@NotNull RiveArtboardRenderer.Listener listener) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Log.w((String)TAG, (String)"registerListener(): Renderer not instantiated yet.");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.registerListener(listener);
        }
    }

    @Override
    public void unregisterListener(@NotNull RiveArtboardRenderer.Listener listener) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Log.w((String)TAG, (String)"unregisterListener(): Renderer not instantiated yet.");
            RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
            if (riveArtboardRenderer == null) break block0;
            riveArtboardRenderer.unregisterListener(listener);
        }
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        block10: {
            MotionEvent motionEvent;
            MotionEvent motionEvent2 = event;
            if (motionEvent2 == null) break block10;
            MotionEvent $this$onTouchEvent_u24lambda_u2d11 = motionEvent = motionEvent2;
            boolean bl = false;
            switch ($this$onTouchEvent_u24lambda_u2d11.getAction()) {
                case 2: {
                    RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
                    if (riveArtboardRenderer != null) {
                        riveArtboardRenderer.pointerEvent(PointerEvents.POINTER_MOVE, $this$onTouchEvent_u24lambda_u2d11.getX(), $this$onTouchEvent_u24lambda_u2d11.getY());
                    }
                    break;
                }
                case 3: {
                    RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
                    if (riveArtboardRenderer != null) {
                        riveArtboardRenderer.pointerEvent(PointerEvents.POINTER_UP, $this$onTouchEvent_u24lambda_u2d11.getX(), $this$onTouchEvent_u24lambda_u2d11.getY());
                    }
                    break;
                }
                case 0: {
                    RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
                    if (riveArtboardRenderer != null) {
                        riveArtboardRenderer.pointerEvent(PointerEvents.POINTER_DOWN, $this$onTouchEvent_u24lambda_u2d11.getX(), $this$onTouchEvent_u24lambda_u2d11.getY());
                    }
                    break;
                }
                case 1: {
                    RiveArtboardRenderer riveArtboardRenderer = this.getArtboardRenderer();
                    if (riveArtboardRenderer != null) {
                        riveArtboardRenderer.pointerEvent(PointerEvents.POINTER_UP, $this$onTouchEvent_u24lambda_u2d11.getX(), $this$onTouchEvent_u24lambda_u2d11.getY());
                    }
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)"onTouchEvent(): Renderer not instantiated yet.");
                }
            }
        }
        return true;
    }

    private static final void loadHttp$lambda-1(RiveAnimationView this$0, File file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        this$0.setRiveFile(file);
    }

    private static final void loadHttp$lambda-2(String $url, VolleyError it) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        throw new IOException("Unable to download Rive file " + $url);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView$Companion;", "", "()V", "TAG", "", "alignmentIndexDefault", "", "fitIndexDefault", "loopIndexDefault", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B]\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001dR\u001c\u0010\f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u0010\u0019\u00a8\u00063"}, d2={"Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "", "alignmentIndex", "", "fitIndex", "loopIndex", "autoplay", "", "riveTraceAnimations", "artboardName", "", "animationName", "stateMachineName", "resource", "Lapp/rive/runtime/kotlin/ResourceType;", "(IIIZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lapp/rive/runtime/kotlin/ResourceType;)V", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "getAnimationName", "()Ljava/lang/String;", "setAnimationName", "(Ljava/lang/String;)V", "getArtboardName", "setArtboardName", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "getResource", "()Lapp/rive/runtime/kotlin/ResourceType;", "setResource", "(Lapp/rive/runtime/kotlin/ResourceType;)V", "getRiveTraceAnimations", "getStateMachineName", "setStateMachineName", "kotlin_release"})
    public static final class RendererAttributes {
        private boolean autoplay;
        private final boolean riveTraceAnimations;
        @Nullable
        private String artboardName;
        @Nullable
        private String animationName;
        @Nullable
        private String stateMachineName;
        @Nullable
        private ResourceType resource;
        @NotNull
        private Alignment alignment;
        @NotNull
        private Fit fit;
        @NotNull
        private Loop loop;

        public RendererAttributes(int alignmentIndex, int fitIndex, int loopIndex, boolean autoplay, boolean riveTraceAnimations, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, @Nullable ResourceType resource) {
            this.autoplay = autoplay;
            this.riveTraceAnimations = riveTraceAnimations;
            this.artboardName = artboardName;
            this.animationName = animationName;
            this.stateMachineName = stateMachineName;
            this.resource = resource;
            this.alignment = Alignment.Companion.fromIndex(alignmentIndex);
            this.fit = Fit.Companion.fromIndex(fitIndex);
            this.loop = Loop.Companion.fromIndex(loopIndex);
        }

        public /* synthetic */ RendererAttributes(int n, int n2, int n3, boolean bl, boolean bl2, String string, String string2, String string3, ResourceType resourceType, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 4;
            }
            if ((n4 & 2) != 0) {
                n2 = 1;
            }
            if ((n4 & 4) != 0) {
                n3 = 3;
            }
            if ((n4 & 0x10) != 0) {
                bl2 = false;
            }
            this(n, n2, n3, bl, bl2, string, string2, string3, resourceType);
        }

        public final boolean getAutoplay() {
            return this.autoplay;
        }

        public final void setAutoplay(boolean bl) {
            this.autoplay = bl;
        }

        public final boolean getRiveTraceAnimations() {
            return this.riveTraceAnimations;
        }

        @Nullable
        public final String getArtboardName() {
            return this.artboardName;
        }

        public final void setArtboardName(@Nullable String string) {
            this.artboardName = string;
        }

        @Nullable
        public final String getAnimationName() {
            return this.animationName;
        }

        public final void setAnimationName(@Nullable String string) {
            this.animationName = string;
        }

        @Nullable
        public final String getStateMachineName() {
            return this.stateMachineName;
        }

        public final void setStateMachineName(@Nullable String string) {
            this.stateMachineName = string;
        }

        @Nullable
        public final ResourceType getResource() {
            return this.resource;
        }

        public final void setResource(@Nullable ResourceType resourceType) {
            this.resource = resourceType;
        }

        @NotNull
        public final Alignment getAlignment() {
            return this.alignment;
        }

        public final void setAlignment(@NotNull Alignment alignment) {
            Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"<set-?>");
            this.alignment = alignment;
        }

        @NotNull
        public final Fit getFit() {
            return this.fit;
        }

        public final void setFit(@NotNull Fit fit) {
            Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"<set-?>");
            this.fit = fit;
        }

        @NotNull
        public final Loop getLoop() {
            return this.loop;
        }

        public final void setLoop(@NotNull Loop loop) {
            Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"<set-?>");
            this.loop = loop;
        }
    }
}

