/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin;

import android.graphics.PointF;
import android.graphics.RectF;
import app.rive.runtime.kotlin.Observable;
import app.rive.runtime.kotlin.PointerEvents;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.Helpers;
import app.rive.runtime.kotlin.core.LayerState;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.PlayableInstance;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.renderers.RendererSkia;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u008d\u0001B[\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u000b0VH\u0002J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020E0 2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u001eH\u0002J\u0010\u0010X\u001a\u00020Y2\u0006\u0010[\u001a\u00020EH\u0002J \u0010\\\u001a\u00020Y2\u0006\u0010]\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010^\u001a\u00020_H\u0002J\u001a\u0010\\\u001a\u00020Y2\u0006\u0010`\u001a\u00020E2\b\b\u0002\u0010a\u001a\u00020\u000fH\u0002J8\u0010b\u001a\u00020Y2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010^\u001a\u00020_2\b\b\u0002\u0010c\u001a\u00020\u000f2\b\b\u0002\u0010d\u001a\u00020\u000fH\u0002J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020E0 2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010e\u001a\b\u0012\u0004\u0012\u00020E0 2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u000b0VH\u0002J\u0010\u0010f\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u001eH\u0002J\u0010\u0010f\u001a\u00020Y2\u0006\u0010[\u001a\u00020EH\u0002J\u0010\u0010g\u001a\u00020Y2\u0006\u0010h\u001a\u00020iH\u0016J\u0006\u0010j\u001a\u00020OJ\b\u0010k\u001a\u00020YH\u0002J\b\u0010l\u001a\u00020YH\u0016J\u0016\u0010m\u001a\u00020Y2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010n\u001a\u00020\u000bJ\u0010\u0010o\u001a\u00020Y2\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020Y2\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010s\u001a\u00020Y2\u0006\u0010p\u001a\u00020qH\u0002J\u0018\u0010t\u001a\u00020Y2\u0006\u0010[\u001a\u00020E2\u0006\u0010u\u001a\u00020vH\u0002J\u0010\u0010w\u001a\u00020Y2\u0006\u0010p\u001a\u00020qH\u0002J\u0006\u0010x\u001a\u00020YJ\u0018\u0010x\u001a\u00020Y2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010c\u001a\u00020\u000fJ\u001e\u0010x\u001a\u00020Y2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\b\b\u0002\u0010y\u001a\u00020\u000fJ$\u0010z\u001a\u00020Y2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010^\u001a\u00020_2\b\b\u0002\u0010d\u001a\u00020\u000fJ6\u0010z\u001a\u00020Y2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010^\u001a\u00020_2\b\b\u0002\u0010c\u001a\u00020\u000f2\b\b\u0002\u0010d\u001a\u00020\u000fJ<\u0010z\u001a\u00020Y2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010^\u001a\u00020_2\b\b\u0002\u0010y\u001a\u00020\u000f2\b\b\u0002\u0010d\u001a\u00020\u000fJ\u001e\u0010{\u001a\u00020Y2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020i2\u0006\u0010\u007f\u001a\u00020iJ\u0012\u0010\u0080\u0001\u001a\u00020Y2\u0007\u0010\u0081\u0001\u001a\u00020\u0002H\u0016J\u0007\u0010\u0082\u0001\u001a\u00020YJ\u0019\u0010\u0083\u0001\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020E2\u0006\u0010h\u001a\u00020iH\u0002J\t\u0010\u0084\u0001\u001a\u00020YH\u0002J\u0012\u0010\u0085\u0001\u001a\u00020Y2\u0007\u0010\u0086\u0001\u001a\u00020\u0013H\u0002J\u0011\u0010\u0087\u0001\u001a\u00020Y2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001f\u0010\u0088\u0001\u001a\u00020Y2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000fJ\u001f\u0010\u0089\u0001\u001a\u00020Y2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020iJ\u000f\u0010\u008a\u0001\u001a\u00020Y2\u0006\u0010/\u001a\u00020.J\u0007\u0010\u008b\u0001\u001a\u00020YJ\u0019\u0010\u008b\u0001\u001a\u00020Y2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010c\u001a\u00020\u000fJ\u001f\u0010\u008b\u0001\u001a\u00020Y2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\b\b\u0002\u0010y\u001a\u00020\u000fJ\u0012\u0010\u008c\u0001\u001a\u00020Y2\u0007\u0010\u0081\u0001\u001a\u00020\u0002H\u0016R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR2\u0010\u001c\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010 0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0 8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010$R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\"\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u0012\u001a\u0004\u0018\u00010.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010+R\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R2\u0010>\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010@0?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001e098F\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR2\u0010D\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010E0E \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010E0E\u0018\u00010@0?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020E098F\u00a2\u0006\u0006\u001a\u0004\bG\u0010CR\u0010\u0010H\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010I\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010E0E \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010E0E\u0018\u00010 0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\"\"\u0004\bK\u0010$R\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020E0 8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010'R\u001a\u0010N\u001a\u00020OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010S\u00a8\u0006\u008e\u0001"}, d2={"Lapp/rive/runtime/kotlin/RiveArtboardRenderer;", "Lapp/rive/runtime/kotlin/Observable;", "Lapp/rive/runtime/kotlin/RiveArtboardRenderer$Listener;", "Lapp/rive/runtime/kotlin/renderers/RendererSkia;", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "artboardName", "", "animationName", "stateMachineName", "autoplay", "", "trace", "(Lapp/rive/runtime/kotlin/core/Fit;Lapp/rive/runtime/kotlin/core/Alignment;Lapp/rive/runtime/kotlin/core/Loop;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)V", "<set-?>", "Lapp/rive/runtime/kotlin/core/Artboard;", "activeArtboard", "getActiveArtboard", "()Lapp/rive/runtime/kotlin/core/Artboard;", "value", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "animationList", "", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "kotlin.jvm.PlatformType", "", "getAnimationName", "()Ljava/lang/String;", "setAnimationName", "(Ljava/lang/String;)V", "animations", "getAnimations", "()Ljava/util/List;", "getArtboardName", "setArtboardName", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "Lapp/rive/runtime/kotlin/core/File;", "file", "getFile", "()Lapp/rive/runtime/kotlin/core/File;", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "hasPlayingAnimations", "getHasPlayingAnimations", "listeners", "Ljava/util/HashSet;", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "playingAnimationSet", "", "", "playingAnimations", "getPlayingAnimations", "()Ljava/util/HashSet;", "playingStateMachineSet", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "playingStateMachines", "getPlayingStateMachines", "selectedArtboard", "stateMachineList", "getStateMachineName", "setStateMachineName", "stateMachines", "getStateMachines", "targetBounds", "Landroid/graphics/RectF;", "getTargetBounds", "()Landroid/graphics/RectF;", "setTargetBounds", "(Landroid/graphics/RectF;)V", "_animations", "animationNames", "", "_getOrCreateStateMachines", "_pause", "", "animation", "stateMachine", "_play", "animationInstance", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "stateMachineInstance", "settleStateMachineState", "_playAnimation", "isStateMachine", "settleInitialState", "_stateMachines", "_stop", "advance", "elapsed", "", "artboardBounds", "clearObjectsWithStaleNatives", "draw", "fireState", "inputName", "notifyLoop", "playableInstance", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "state", "Lapp/rive/runtime/kotlin/core/LayerState;", "notifyStop", "pause", "areStateMachines", "play", "pointerEvent", "eventType", "Lapp/rive/runtime/kotlin/PointerEvents;", "x", "y", "registerListener", "listener", "reset", "resolveStateMachineAdvance", "selectArtboard", "setArtboard", "artboard", "setArtboardByName", "setBooleanState", "setNumberState", "setRiveFile", "stopAnimations", "unregisterListener", "Listener", "kotlin_release"})
public class RiveArtboardRenderer
extends RendererSkia
implements Observable<Listener> {
    @NotNull
    private Loop loop;
    @Nullable
    private String artboardName;
    @Nullable
    private String animationName;
    @Nullable
    private String stateMachineName;
    private boolean autoplay;
    @NotNull
    private HashSet<Listener> listeners;
    @NotNull
    private RectF targetBounds;
    @Nullable
    private Artboard selectedArtboard;
    @Nullable
    private Artboard activeArtboard;
    private Set<LinearAnimationInstance> playingAnimationSet;
    private Set<StateMachineInstance> playingStateMachineSet;
    private List<LinearAnimationInstance> animationList;
    private List<StateMachineInstance> stateMachineList;
    @Nullable
    private File file;
    @NotNull
    private Fit fit;
    @NotNull
    private Alignment alignment;

    public RiveArtboardRenderer(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop, @Nullable String artboardName, @Nullable String animationName, @Nullable String stateMachineName, boolean autoplay, boolean trace) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        super(trace);
        this.loop = loop;
        this.artboardName = artboardName;
        this.animationName = animationName;
        this.stateMachineName = stateMachineName;
        this.autoplay = autoplay;
        this.listeners = new HashSet();
        this.targetBounds = new RectF();
        this.playingAnimationSet = Collections.synchronizedSet(new HashSet());
        this.playingStateMachineSet = Collections.synchronizedSet(new HashSet());
        this.animationList = Collections.synchronizedList(new ArrayList());
        this.stateMachineList = Collections.synchronizedList(new ArrayList());
        this.fit = fit;
        this.alignment = alignment;
    }

    public /* synthetic */ RiveArtboardRenderer(Fit fit, Alignment alignment, Loop loop, String string, String string2, String string3, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fit = Fit.CONTAIN;
        }
        if ((n & 2) != 0) {
            alignment = Alignment.CENTER;
        }
        if ((n & 4) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        this(fit, alignment, loop, string, string2, string3, bl, bl2);
    }

    @NotNull
    public final Loop getLoop() {
        return this.loop;
    }

    public final void setLoop(@NotNull Loop loop) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"<set-?>");
        this.loop = loop;
    }

    @Nullable
    public final String getArtboardName() {
        return this.artboardName;
    }

    public final void setArtboardName(@Nullable String string) {
        this.artboardName = string;
    }

    @Nullable
    public final String getAnimationName() {
        return this.animationName;
    }

    public final void setAnimationName(@Nullable String string) {
        this.animationName = string;
    }

    @Nullable
    public final String getStateMachineName() {
        return this.stateMachineName;
    }

    public final void setStateMachineName(@Nullable String string) {
        this.stateMachineName = string;
    }

    public final boolean getAutoplay() {
        return this.autoplay;
    }

    public final void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    @NotNull
    public final RectF getTargetBounds() {
        return this.targetBounds;
    }

    public final void setTargetBounds(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.targetBounds = rectF;
    }

    @Nullable
    public final Artboard getActiveArtboard() {
        return this.activeArtboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashSet<LinearAnimationInstance> getPlayingAnimations() {
        HashSet hashSet;
        Set<LinearAnimationInstance> set = this.playingAnimationSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingAnimationSet");
        Set<LinearAnimationInstance> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Set<LinearAnimationInstance> set3 = this.playingAnimationSet;
            Intrinsics.checkNotNullExpressionValue(set3, (String)"playingAnimationSet");
            hashSet = CollectionsKt.toHashSet((Iterable)set3);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashSet<StateMachineInstance> getPlayingStateMachines() {
        HashSet hashSet;
        Set<StateMachineInstance> set = this.playingStateMachineSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingStateMachineSet");
        Set<StateMachineInstance> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Set<StateMachineInstance> set3 = this.playingStateMachineSet;
            Intrinsics.checkNotNullExpressionValue(set3, (String)"playingStateMachineSet");
            hashSet = CollectionsKt.toHashSet((Iterable)set3);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LinearAnimationInstance> getAnimations() {
        List list;
        List<LinearAnimationInstance> list2 = this.animationList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"animationList");
        List<LinearAnimationInstance> list3 = list2;
        synchronized (list3) {
            boolean bl = false;
            List<LinearAnimationInstance> list4 = this.animationList;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"animationList");
            list = CollectionsKt.toList((Iterable)list4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<StateMachineInstance> getStateMachines() {
        List list;
        List<StateMachineInstance> list2 = this.stateMachineList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"stateMachineList");
        List<StateMachineInstance> list3 = list2;
        synchronized (list3) {
            boolean bl = false;
            List<StateMachineInstance> list4 = this.stateMachineList;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"stateMachineList");
            list = CollectionsKt.toList((Iterable)list4);
        }
        return list;
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Fit getFit() {
        return this.fit;
    }

    public final void setFit(@NotNull Fit value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.fit = value;
        this.start();
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final void setAlignment(@NotNull Alignment value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.alignment = value;
        this.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasPlayingAnimations() {
        Set<LinearAnimationInstance> set = this.playingAnimationSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingAnimationSet");
        if (!((Collection)set).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Set<StateMachineInstance> set2 = this.playingStateMachineSet;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"playingStateMachineSet");
        if (((Collection)set2).isEmpty()) return false;
        return true;
    }

    @Override
    public void draw() {
        block1: {
            if (!this.getHasCppObject()) {
                return;
            }
            Artboard artboard = this.activeArtboard;
            if (artboard == null) break block1;
            artboard.drawSkia(this.getCppPointer(), this.fit, this.alignment);
        }
    }

    @Override
    public void advance(float elapsed) {
        if (!this.getHasCppObject()) {
            return;
        }
        Artboard artboard = this.activeArtboard;
        if (artboard != null) {
            Artboard ab = artboard;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getAnimations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animationInstance = (LinearAnimationInstance)element$iv;
                boolean bl2 = false;
                if (!this.getPlayingAnimations().contains(animationInstance)) continue;
                Loop looped = animationInstance.advance(elapsed);
                animationInstance.apply();
                if (looped == Loop.ONESHOT) {
                    this._stop(animationInstance);
                    continue;
                }
                if (looped == null) continue;
                this.notifyLoop(animationInstance);
            }
            $this$forEach$iv = this.getStateMachines();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean stillPlaying;
                StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv;
                boolean bl3 = false;
                if (!this.getPlayingStateMachines().contains(stateMachineInstance) || (stillPlaying = this.resolveStateMachineAdvance(stateMachineInstance, elapsed))) continue;
                this._pause(stateMachineInstance);
            }
            ab.advance(elapsed);
        }
        if (!this.getHasPlayingAnimations()) {
            this.stopThread$kotlin_release();
        }
    }

    private final boolean resolveStateMachineAdvance(StateMachineInstance stateMachineInstance, float elapsed) {
        boolean stillPlaying = stateMachineInstance.advance(elapsed);
        Iterable $this$forEach$iv = stateMachineInstance.getStatesChanged();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LayerState it = (LayerState)element$iv;
            boolean bl = false;
            this.notifyStateChanged(stateMachineInstance, it);
        }
        return stillPlaying;
    }

    public final void setRiveFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.clearObjectsWithStaleNatives();
        this.file = file;
        this.getDependencies().add(file);
        this.selectArtboard();
    }

    private final void clearObjectsWithStaleNatives() {
        this.playingAnimationSet.clear();
        this.animationList.clear();
        this.playingStateMachineSet.clear();
        this.stateMachineList.clear();
        this.activeArtboard = null;
        this.selectedArtboard = null;
    }

    public final void setArtboardByName(@Nullable String artboardName) {
        if (Intrinsics.areEqual((Object)this.artboardName, (Object)artboardName)) {
            return;
        }
        this.stopAnimations();
        if (this.file == null) {
            this.artboardName = artboardName;
        } else {
            this.artboardName = artboardName;
            this.selectArtboard();
        }
    }

    @NotNull
    public final RectF artboardBounds() {
        RectF output;
        Artboard artboard = this.activeArtboard;
        Object object = output = artboard != null ? artboard.getBounds() : null;
        if (output == null) {
            output = new RectF();
        }
        return output;
    }

    public final void reset() {
        this.stopAnimations();
        this.stop();
        this.selectArtboard();
        this.start();
    }

    public final void play(@NotNull List<String> animationNames, @NotNull Loop loop, @NotNull Direction direction, boolean areStateMachines, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Iterable $this$forEach$iv = animationNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this._playAnimation(it, loop, direction, areStateMachines, settleInitialState);
        }
    }

    public static /* synthetic */ void play$default(RiveArtboardRenderer riveArtboardRenderer, List list, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveArtboardRenderer.play(list, loop, direction, bl, bl2);
    }

    public final void play(@NotNull String animationName, @NotNull Loop loop, @NotNull Direction direction, boolean isStateMachine, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this._playAnimation(animationName, loop, direction, isStateMachine, settleInitialState);
    }

    public static /* synthetic */ void play$default(RiveArtboardRenderer riveArtboardRenderer, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveArtboardRenderer.play(string, loop, direction, bl, bl2);
    }

    public final void play(@NotNull Loop loop, @NotNull Direction direction, boolean settleInitialState) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            Artboard artboard = this.activeArtboard;
            if (artboard == null) break block2;
            Artboard activeArtboard = artboard;
            boolean bl = false;
            List<String> animationNames = activeArtboard.getAnimationNames();
            if (!((Collection)animationNames).isEmpty()) {
                RiveArtboardRenderer._playAnimation$default(this, (String)CollectionsKt.first(animationNames), loop, direction, false, false, 24, null);
                return;
            }
            List<String> stateMachineNames = activeArtboard.getStateMachineNames();
            if (!((Collection)stateMachineNames).isEmpty()) {
                RiveArtboardRenderer._playAnimation$default(this, (String)CollectionsKt.first(stateMachineNames), loop, direction, settleInitialState, false, 16, null);
            }
        }
    }

    public static /* synthetic */ void play$default(RiveArtboardRenderer riveArtboardRenderer, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
        }
        if ((n & 1) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 2) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        riveArtboardRenderer.play(loop, direction, bl);
    }

    public final void pause() {
        Iterable $this$forEach$iv = this.getPlayingAnimations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this._pause(animation);
        }
        $this$forEach$iv = this.getPlayingStateMachines();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
            boolean bl = false;
            this._pause(stateMachine);
        }
    }

    public final void pause(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this._stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._pause(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._pause(animation);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveArtboardRenderer riveArtboardRenderer, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveArtboardRenderer.pause(list, bl);
    }

    public final void pause(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this._stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._pause(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._pause(animation);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveArtboardRenderer riveArtboardRenderer, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveArtboardRenderer.pause(string, bl);
    }

    public final void stopAnimations() {
        Iterable $this$forEach$iv = this.getAnimations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this._stop(animation);
        }
        $this$forEach$iv = this.getStateMachines();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
            boolean bl = false;
            this._stop(stateMachine);
        }
    }

    public final void stopAnimations(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this._stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._stop(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._stop(animation);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveArtboardRenderer riveArtboardRenderer, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopAnimations");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveArtboardRenderer.stopAnimations(list, bl);
    }

    public final void stopAnimations(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this._stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance stateMachine = (StateMachineInstance)element$iv;
                boolean bl = false;
                this._stop(stateMachine);
            }
        } else {
            Iterable $this$forEach$iv = this._animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animation = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._stop(animation);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveArtboardRenderer riveArtboardRenderer, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopAnimations");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        riveArtboardRenderer.stopAnimations(string, bl);
    }

    public final void fireState(@NotNull String stateMachineName, @NotNull String inputName) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            Intrinsics.checkNotNull((Object)sMIInput, (String)"null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMITrigger");
            ((SMITrigger)sMIInput).fire();
            this._play(it, false);
        }
    }

    public final void setBooleanState(@NotNull String stateMachineName, @NotNull String inputName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            Intrinsics.checkNotNull((Object)sMIInput, (String)"null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMIBoolean");
            ((SMIBoolean)sMIInput).setValue(value);
            this._play(it, false);
        }
    }

    public final void setNumberState(@NotNull String stateMachineName, @NotNull String inputName, float value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            Intrinsics.checkNotNull((Object)sMIInput, (String)"null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMINumber");
            ((SMINumber)sMIInput).setValue(value);
            this._play(it, false);
        }
    }

    public final void pointerEvent(@NotNull PointerEvents eventType, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        PointF artboardEventLocation = Helpers.INSTANCE.convertToArtboardSpace(this.targetBounds, new PointF(x, y), this.fit, this.alignment, this.artboardBounds());
        Iterable $this$forEach$iv = this.getStateMachines();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                case 1: {
                    it.pointerDown(artboardEventLocation.x, artboardEventLocation.y);
                    break;
                }
                case 2: {
                    it.pointerUp(artboardEventLocation.x, artboardEventLocation.y);
                    break;
                }
                case 3: {
                    it.pointerMove(artboardEventLocation.x, artboardEventLocation.y);
                }
            }
            this._play(it, false);
        }
    }

    private final List<LinearAnimationInstance> _animations(String animationName) {
        return this._animations(CollectionsKt.listOf((Object)animationName));
    }

    private final List<StateMachineInstance> _stateMachines(String animationName) {
        return this._stateMachines(CollectionsKt.listOf((Object)animationName));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LinearAnimationInstance> _animations(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAnimations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LinearAnimationInstance animationInstance = (LinearAnimationInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(animationInstance.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StateMachineInstance> _stateMachines(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getStateMachines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(stateMachineInstance.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<StateMachineInstance> _getOrCreateStateMachines(String animationName) {
        Artboard artboard;
        List<StateMachineInstance> stateMachineInstances = this._stateMachines(animationName);
        if (stateMachineInstances.isEmpty() && (artboard = this.activeArtboard) != null) {
            Artboard activeArtboard = artboard;
            boolean bl = false;
            StateMachineInstance stateMachineInstance = activeArtboard.stateMachine(animationName);
            this.stateMachineList.add(stateMachineInstance);
            return CollectionsKt.listOf((Object)stateMachineInstance);
        }
        return stateMachineInstances;
    }

    private final void _playAnimation(String animationName, Loop loop, Direction direction, boolean isStateMachine, boolean settleInitialState) {
        block4: {
            LinearAnimationInstance animationInstance;
            block3: {
                if (!isStateMachine) break block3;
                List<StateMachineInstance> stateMachineInstances = this._getOrCreateStateMachines(animationName);
                Iterable $this$forEach$iv = stateMachineInstances;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv;
                    boolean bl = false;
                    this._play(stateMachineInstance, settleInitialState);
                }
                break block4;
            }
            List<LinearAnimationInstance> animationInstances = this._animations(animationName);
            Iterable $this$forEach$iv = animationInstances;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                animationInstance = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this._play(animationInstance, loop, direction);
            }
            if (!animationInstances.isEmpty()) break block4;
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                Artboard activeArtboard = artboard;
                boolean bl = false;
                animationInstance = activeArtboard.animation(animationName);
                this._play(animationInstance, loop, direction);
            }
        }
    }

    static /* synthetic */ void _playAnimation$default(RiveArtboardRenderer riveArtboardRenderer, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: _playAnimation");
        }
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveArtboardRenderer._playAnimation(string, loop, direction, bl, bl2);
    }

    private final void _play(StateMachineInstance stateMachineInstance, boolean settleStateMachineState) {
        if (!this.stateMachineList.contains(stateMachineInstance)) {
            this.stateMachineList.add(stateMachineInstance);
        }
        if (settleStateMachineState) {
            this.resolveStateMachineAdvance(stateMachineInstance, 0.0f);
        }
        this.playingStateMachineSet.add(stateMachineInstance);
        this.start();
        this.notifyPlay(stateMachineInstance);
    }

    static /* synthetic */ void _play$default(RiveArtboardRenderer riveArtboardRenderer, StateMachineInstance stateMachineInstance, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: _play");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        riveArtboardRenderer._play(stateMachineInstance, bl);
    }

    private final void _play(LinearAnimationInstance animationInstance, Loop loop, Direction direction) {
        Loop appliedLoop;
        Loop loop2 = appliedLoop = loop == Loop.AUTO ? this.loop : loop;
        if (appliedLoop != Loop.AUTO) {
            animationInstance.setLoop(appliedLoop);
        }
        if (!this.animationList.contains(animationInstance)) {
            if (direction == Direction.BACKWARDS) {
                animationInstance.time(animationInstance.getEndTime());
            }
            this.animationList.add(animationInstance);
        }
        if (direction != Direction.AUTO) {
            animationInstance.setDirection(direction);
        }
        this.playingAnimationSet.add(animationInstance);
        this.start();
        this.notifyPlay(animationInstance);
    }

    private final void _pause(LinearAnimationInstance animation) {
        boolean removed = this.playingAnimationSet.remove(animation);
        if (removed) {
            this.notifyPause(animation);
        }
    }

    private final void _pause(StateMachineInstance stateMachine) {
        boolean removed = this.playingStateMachineSet.remove(stateMachine);
        if (removed) {
            this.notifyPause(stateMachine);
        }
    }

    private final void _stop(LinearAnimationInstance animation) {
        this.playingAnimationSet.remove(animation);
        boolean removed = this.animationList.remove(animation);
        if (removed) {
            this.notifyStop(animation);
        }
    }

    private final void _stop(StateMachineInstance stateMachine) {
        this.playingStateMachineSet.remove(stateMachine);
        boolean removed = this.stateMachineList.remove(stateMachine);
        if (removed) {
            this.notifyStop(stateMachine);
        }
    }

    private final void selectArtboard() {
        block8: {
            String string;
            block6: {
                Artboard selectedArtboard;
                File file;
                block7: {
                    Unit unit;
                    File file2 = this.file;
                    if (file2 == null) break block6;
                    file = file2;
                    boolean bl = false;
                    string = this.artboardName;
                    if (string == null) break block7;
                    String artboardName = string;
                    boolean bl2 = false;
                    Artboard artboard = this.selectedArtboard = file.artboard(artboardName);
                    if (artboard != null) {
                        selectedArtboard = artboard;
                        boolean bl3 = false;
                        this.setArtboard(selectedArtboard);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    string = unit;
                    if (unit != null) break block8;
                }
                RiveArtboardRenderer $this$selectArtboard_u24lambda_u2d36_u24lambda_u2d35 = this;
                boolean bl = false;
                Artboard artboard = $this$selectArtboard_u24lambda_u2d36_u24lambda_u2d35.selectedArtboard = file.getFirstArtboard();
                if (artboard != null) {
                    selectedArtboard = artboard;
                    boolean bl4 = false;
                    $this$selectArtboard_u24lambda_u2d36_u24lambda_u2d35.setArtboard(selectedArtboard);
                    string = Unit.INSTANCE;
                } else {
                    string = null;
                }
                break block8;
            }
            string = null;
        }
    }

    private final void setArtboard(Artboard artboard) {
        this.activeArtboard = artboard;
        if (this.autoplay) {
            Unit unit;
            String string = this.animationName;
            if (string != null) {
                String animationName = string;
                boolean bl = false;
                RiveArtboardRenderer.play$default(this, animationName, null, null, false, false, 30, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                Unit unit2;
                RiveArtboardRenderer $this$setArtboard_u24lambda_u2d40 = this;
                boolean bl = false;
                String string2 = $this$setArtboard_u24lambda_u2d40.stateMachineName;
                if (string2 != null) {
                    String stateMachineName = string2;
                    boolean bl2 = false;
                    RiveArtboardRenderer.play$default($this$setArtboard_u24lambda_u2d40, stateMachineName, null, null, true, true, 6, null);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                if (unit2 == null) {
                    RiveArtboardRenderer $this$setArtboard_u24lambda_u2d40_u24lambda_u2d39 = $this$setArtboard_u24lambda_u2d40;
                    boolean bl3 = false;
                    RiveArtboardRenderer.play$default($this$setArtboard_u24lambda_u2d40_u24lambda_u2d39, null, null, true, 3, null);
                }
            }
        } else {
            Artboard artboard2 = this.activeArtboard;
            if (artboard2 != null) {
                artboard2.advance(0.0f);
            }
            this.start();
        }
    }

    @Override
    public void registerListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    private final void notifyPlay(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPlay(playableInstance);
        }
    }

    private final void notifyPause(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPause(playableInstance);
        }
    }

    private final void notifyStop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStop(playableInstance);
        }
    }

    private final void notifyLoop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyLoop(playableInstance);
        }
    }

    private final void notifyStateChanged(StateMachineInstance stateMachine, LayerState state) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStateChanged(stateMachine.getName(), state.toString());
        }
    }

    public RiveArtboardRenderer() {
        this(null, null, null, null, null, null, false, false, 255, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH&J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\r"}, d2={"Lapp/rive/runtime/kotlin/RiveArtboardRenderer$Listener;", "", "notifyLoop", "", "animation", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "stateMachineName", "", "stateName", "notifyStop", "kotlin_release"})
    public static interface Listener {
        public void notifyPlay(@NotNull PlayableInstance var1);

        public void notifyPause(@NotNull PlayableInstance var1);

        public void notifyStop(@NotNull PlayableInstance var1);

        public void notifyLoop(@NotNull PlayableInstance var1);

        public void notifyStateChanged(@NotNull String var1, @NotNull String var2);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PointerEvents.values().length];
            nArray[PointerEvents.POINTER_DOWN.ordinal()] = 1;
            nArray[PointerEvents.POINTER_UP.ordinal()] = 2;
            nArray[PointerEvents.POINTER_MOVE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

