/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin;

import app.rive.runtime.kotlin.core.File;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u000fH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lapp/rive/runtime/kotlin/RiveFileRequest;", "Lcom/android/volley/Request;", "Lapp/rive/runtime/kotlin/core/File;", "url", "", "listener", "Lcom/android/volley/Response$Listener;", "errorListener", "Lcom/android/volley/Response$ErrorListener;", "(Ljava/lang/String;Lcom/android/volley/Response$Listener;Lcom/android/volley/Response$ErrorListener;)V", "deliverResponse", "", "response", "parseNetworkResponse", "Lcom/android/volley/Response;", "Lcom/android/volley/NetworkResponse;", "kotlin_release"})
public final class RiveFileRequest
extends Request<File> {
    @NotNull
    private final Response.Listener<File> listener;

    public RiveFileRequest(@NotNull String url, @NotNull Response.Listener<File> listener, @NotNull Response.ErrorListener errorListener) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)errorListener, (String)"errorListener");
        super(0, url, errorListener);
        this.listener = listener;
    }

    protected void deliverResponse(@NotNull File response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.listener.onResponse((Object)response);
    }

    @NotNull
    protected Response<File> parseNetworkResponse(@Nullable NetworkResponse response) {
        Response response2;
        try {
            NetworkResponse networkResponse = response;
            byte[] byArray = (byte[])(networkResponse != null ? networkResponse.data : null);
            if (byArray == null) {
                byArray = new byte[]{};
            }
            byte[] bytes = byArray;
            File file = new File(bytes);
            response2 = Response.success((Object)file, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"{\n            val bytes \u2026ders(response))\n        }");
        }
        catch (UnsupportedEncodingException e) {
            Response response3 = Response.error((VolleyError)((VolleyError)new ParseError((Throwable)e)));
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"{\n            Response.e\u2026(ParseError(e))\n        }");
            response2 = response3;
        }
        return response2;
    }
}

