/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.controllers;

import app.rive.runtime.kotlin.controllers.RiveController;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lapp/rive/runtime/kotlin/controllers/LinearAnimationController;", "Lapp/rive/runtime/kotlin/controllers/RiveController;", "Lapp/rive/runtime/kotlin/core/Artboard;", "animationName", "", "autoplay", "", "mix", "", "(Ljava/lang/String;ZF)V", "animationInstance", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getAnimationInstance", "()Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "setAnimationInstance", "(Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;)V", "value", "getMix", "()F", "setMix", "(F)V", "apply", "", "elapsed", "initialize", "artboard", "kotlin_release"})
public final class LinearAnimationController
extends RiveController<Artboard> {
    @NotNull
    private final String animationName;
    private final boolean autoplay;
    @Nullable
    private LinearAnimationInstance animationInstance;
    private float mix;

    public LinearAnimationController(@NotNull String animationName, boolean autoplay, float mix) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        this.animationName = animationName;
        this.autoplay = autoplay;
        this.mix = mix;
    }

    public /* synthetic */ LinearAnimationController(String string, boolean bl, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            f = 1.0f;
        }
        this(string, bl, f);
    }

    @Nullable
    public final LinearAnimationInstance getAnimationInstance() {
        return this.animationInstance;
    }

    public final void setAnimationInstance(@Nullable LinearAnimationInstance linearAnimationInstance) {
        this.animationInstance = linearAnimationInstance;
    }

    public final float getMix() {
        return this.mix;
    }

    public final void setMix(float value) {
        this.mix = RangesKt.coerceIn((float)value, (float)0.0f, (float)1.0f);
    }

    @Override
    public void apply(float elapsed) {
        block1: {
            if (this.animationInstance == null) {
                this.setActive(false);
            }
            LinearAnimationInstance linearAnimationInstance = this.animationInstance;
            if (linearAnimationInstance == null) break block1;
            LinearAnimationInstance it = linearAnimationInstance;
            boolean bl = false;
            it.apply(this.mix);
            it.advance(elapsed);
        }
    }

    @Override
    public boolean initialize(@NotNull Artboard artboard) {
        Intrinsics.checkNotNullParameter((Object)artboard, (String)"artboard");
        LinearAnimationInstance ai = artboard.animation(this.animationName);
        ai.apply(this.mix);
        ai.advance(0.0f);
        this.animationInstance = ai;
        this.setActive(this.autoplay);
        return this.animationInstance != null;
    }
}

