/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.graphics.RectF;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.core.errors.AnimationException;
import app.rive.runtime.kotlin.core.errors.RiveException;
import app.rive.runtime.kotlin.core.errors.StateMachineException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000bJ\u0019\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0082 J\u0019\u0010)\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0006H\u0082 J\u0019\u0010*\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000bH\u0082 J\u0011\u0010+\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0003H\u0082 J\u0019\u0010,\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0006H\u0082 J\u0011\u0010-\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0003H\u0082 J\u0011\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003H\u0096 J\u0019\u00101\u001a\u00020/2\u0006\u0010(\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0082 J)\u00103\u001a\u00020/2\u0006\u0010(\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0082 J\u0011\u00108\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0003H\u0082 J\u0019\u00109\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0006H\u0082 J\u0019\u0010:\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000bH\u0082 J\u0011\u0010;\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0003H\u0082 J\u0019\u0010<\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0006H\u0082 J\u000e\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020\u0003J\u001e\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020\u00032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u000e\u0010?\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0006J\u000e\u0010?\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000bR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\r\u00a8\u0006@"}, d2={"Lapp/rive/runtime/kotlin/core/Artboard;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "(J)V", "animationCount", "", "getAnimationCount", "()I", "animationNames", "", "", "getAnimationNames", "()Ljava/util/List;", "bounds", "Landroid/graphics/RectF;", "getBounds", "()Landroid/graphics/RectF;", "firstAnimation", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getFirstAnimation", "()Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "firstStateMachine", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getFirstStateMachine", "()Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "name", "getName", "()Ljava/lang/String;", "stateMachineCount", "getStateMachineCount", "stateMachineNames", "getStateMachineNames", "advance", "", "elapsedTime", "", "animation", "index", "cppAdvance", "cppPointer", "cppAnimationByIndex", "cppAnimationByName", "cppAnimationCount", "cppAnimationNameByIndex", "cppBounds", "cppDelete", "", "pointer", "cppDrawSkia", "rendererPointer", "cppDrawSkiaAligned", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "cppName", "cppStateMachineByIndex", "cppStateMachineByName", "cppStateMachineCount", "cppStateMachineNameByIndex", "drawSkia", "rendererAddress", "stateMachine", "kotlin_release"})
public final class Artboard
extends NativeObject {
    public Artboard(long unsafeCppPointer) {
        super(unsafeCppPointer);
    }

    private final native String cppName(long var1);

    private final native long cppAnimationByIndex(long var1, int var3);

    private final native long cppAnimationByName(long var1, String var3);

    private final native int cppAnimationCount(long var1);

    private final native String cppAnimationNameByIndex(long var1, int var3);

    private final native long cppStateMachineByIndex(long var1, int var3);

    private final native long cppStateMachineByName(long var1, String var3);

    private final native int cppStateMachineCount(long var1);

    private final native String cppStateMachineNameByIndex(long var1, int var3);

    private final native boolean cppAdvance(long var1, float var3);

    private final native void cppDrawSkia(long var1, long var3);

    private final native void cppDrawSkiaAligned(long var1, long var3, Fit var5, Alignment var6);

    private final native RectF cppBounds(long var1);

    @Override
    public native void cppDelete(long var1);

    @NotNull
    public final String getName() {
        return this.cppName(this.getCppPointer());
    }

    @NotNull
    public final LinearAnimationInstance getFirstAnimation() throws RiveException {
        return this.animation(0);
    }

    @NotNull
    public final LinearAnimationInstance animation(int index) throws RiveException {
        long animationPointer = this.cppAnimationByIndex(this.getCppPointer(), index);
        if (animationPointer == 0L) {
            throw new AnimationException("No Animation found at index " + index + '.');
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, 0.0f, 2, null);
        this.getDependencies().add(lai);
        return lai;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinearAnimationInstance animation(@NotNull String name) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long animationPointer = this.cppAnimationByName(this.getCppPointer(), name);
        if (animationPointer == 0L) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getAnimationNames();
            StringBuilder stringBuilder = new StringBuilder().append("Animation \"").append(name).append("\" not found. Available Animations: ");
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add('\"' + (String)it + '\"');
            }
            String string = stringBuilder.append((List)destination$iv$iv).append('\"').toString();
            throw new AnimationException(string);
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, 0.0f, 2, null);
        this.getDependencies().add(lai);
        return lai;
    }

    @NotNull
    public final StateMachineInstance getFirstStateMachine() throws RiveException {
        return this.stateMachine(0);
    }

    @NotNull
    public final StateMachineInstance stateMachine(int index) throws RiveException {
        long stateMachinePointer = this.cppStateMachineByIndex(this.getCppPointer(), index);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found at index " + index + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer);
        this.getDependencies().add(smi);
        return smi;
    }

    @NotNull
    public final StateMachineInstance stateMachine(@NotNull String name) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long stateMachinePointer = this.cppStateMachineByName(this.getCppPointer(), name);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found with name " + name + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer);
        this.getDependencies().add(smi);
        return smi;
    }

    public final int getAnimationCount() {
        return this.cppAnimationCount(this.getCppPointer());
    }

    public final int getStateMachineCount() {
        return this.cppStateMachineCount(this.getCppPointer());
    }

    public final boolean advance(float elapsedTime) {
        return this.cppAdvance(this.getCppPointer(), elapsedTime);
    }

    public final void drawSkia(long rendererAddress) {
        this.cppDrawSkia(this.getCppPointer(), rendererAddress);
    }

    public final void drawSkia(long rendererAddress, @NotNull Fit fit, @NotNull Alignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.cppDrawSkiaAligned(this.getCppPointer(), rendererAddress, fit, alignment);
    }

    @NotNull
    public final RectF getBounds() {
        return this.cppBounds(this.getCppPointer());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAnimationNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getAnimationCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppAnimationNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStateMachineNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateMachineCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppStateMachineNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }
}

