/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.content.Context;
import android.graphics.RectF;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import com.getkeepsafe.relinker.ReLinker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0082 J\t\u0010\u0010\u001a\u00020\u000eH\u0082 J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lapp/rive/runtime/kotlin/core/Rive;", "", "()V", "JNIRiveBridge", "", "calculateRequiredBounds", "Landroid/graphics/RectF;", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "availableBounds", "artboardBounds", "cppCalculateRequiredBounds", "", "requiredBounds", "cppInitialize", "init", "context", "Landroid/content/Context;", "initializeCppEnvironment", "kotlin_release"})
public final class Rive {
    @NotNull
    public static final Rive INSTANCE = new Rive();
    @NotNull
    private static final String JNIRiveBridge = "jnirivebridge";

    private Rive() {
    }

    private final native void cppInitialize();

    private final native void cppCalculateRequiredBounds(Fit var1, Alignment var2, RectF var3, RectF var4, RectF var5);

    public final void init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReLinker.loadLibrary((Context)context, (String)JNIRiveBridge);
        this.initializeCppEnvironment();
    }

    public final void initializeCppEnvironment() {
        this.cppInitialize();
    }

    @NotNull
    public final RectF calculateRequiredBounds(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull RectF availableBounds, @NotNull RectF artboardBounds) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)availableBounds, (String)"availableBounds");
        Intrinsics.checkNotNullParameter((Object)artboardBounds, (String)"artboardBounds");
        RectF requiredBounds = new RectF();
        this.cppCalculateRequiredBounds(fit, alignment, availableBounds, artboardBounds, requiredBounds);
        return requiredBounds;
    }
}

