/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.renderers;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.FrameMetrics;
import android.view.Window;
import androidx.annotation.RequiresApi;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lapp/rive/runtime/kotlin/renderers/RendererMetrics;", "Landroid/view/Window$OnFrameMetricsAvailableListener;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "allFrames", "", "jankyFrames", "refreshRateMs", "", "sampleCount", "totalTime", "Ljava/math/BigDecimal;", "onFrameMetricsAvailable", "", "window", "Landroid/view/Window;", "frameMetrics", "Landroid/view/FrameMetrics;", "dropCountSinceLastInvocation", "Companion", "kotlin_release"})
@RequiresApi(value=24)
public final class RendererMetrics
implements Window.OnFrameMetricsAvailableListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int allFrames;
    private int sampleCount;
    private int jankyFrames;
    @NotNull
    private BigDecimal totalTime;
    private final float refreshRateMs;
    @NotNull
    private static final String TAG = "RendererMetrics";
    private static final double ONE_MS_IN_NS = 1000000.0;
    public static final int SAMPLES = 30;

    public RendererMetrics(@NotNull Activity activity2) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        this.totalTime = new BigDecimal(0.0);
        Window window = activity2.getWindow();
        float refreshRateHz = 0.0f;
        refreshRateHz = 60.0f;
        if (Build.VERSION.SDK_INT >= 30) {
            Display display = window.getContext().getDisplay();
            if (display != null) {
                Display it = display;
                boolean bl = false;
                refreshRateHz = it.getRefreshRate();
            } else {
                RendererMetrics $this$_init__u24lambda_u2d1 = this;
                boolean bl = false;
                Log.w((String)TAG, (String)"Failed to get the display, defaulting to 60hz");
            }
        } else {
            refreshRateHz = window.getWindowManager().getDefaultDisplay().getRefreshRate();
        }
        String string = "Refresh rate: %.1f Hz";
        Object[] objectArray = new Object[]{Float.valueOf(refreshRateHz)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        Log.i((String)TAG, (String)string2);
        this.refreshRateMs = (float)1000 / refreshRateHz;
    }

    public void onFrameMetricsAvailable(@Nullable Window window, @Nullable FrameMetrics frameMetrics, int dropCountSinceLastInvocation) {
        if (window == null) {
            Log.w((String)TAG, (String)"Invalid Window reference");
            return;
        }
        if (frameMetrics == null) {
            Log.w((String)TAG, (String)"Invalid FrameMetrics reference");
            return;
        }
        FrameMetrics frameMetricsCopy = new FrameMetrics(frameMetrics);
        int n = this.allFrames;
        this.allFrames = n + 1;
        n = this.sampleCount;
        this.sampleCount = n + 1;
        double totalDurationMs = (double)frameMetricsCopy.getMetric(8) / 1000000.0;
        BigDecimal bigDecimal = this.totalTime.add(new BigDecimal(String.valueOf(totalDurationMs)));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"totalTime.add(totalDurationMs.toBigDecimal())");
        this.totalTime = bigDecimal;
        if (this.totalTime.compareTo(new BigDecimal(String.valueOf(this.refreshRateMs))) > 0) {
            int n2 = this.jankyFrames;
            this.jankyFrames = n2 + 1;
        }
        if (this.sampleCount == 30) {
            this.sampleCount = 0;
            double drawMs = (double)frameMetricsCopy.getMetric(4) / 1000000.0;
            double swapBuffersMs = (double)frameMetricsCopy.getMetric(7) / 1000000.0;
            double issueGPUCommandsMs = (double)frameMetricsCopy.getMetric(6) / 1000000.0;
            Object[] objectArray = new Object[5];
            objectArray[0] = totalDurationMs;
            objectArray[1] = drawMs;
            objectArray[2] = swapBuffersMs;
            objectArray[3] = issueGPUCommandsMs;
            BigDecimal bigDecimal2 = BigDecimal.valueOf(this.allFrames);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this.toLong())");
            objectArray[4] = this.totalTime.divide(bigDecimal2, 2, RoundingMode.HALF_UP);
            String frameValues = String.format(Locale.US, "\\n\n============ FrameMetrics ============\n=== Frame issued in:        %.2fms ===\n=== Draw Time:              %.2fms ===\n=== Swap Buffers Duration:  %.2fms ===\n=== GPU commands sent in:   %.2fms ===\n======================================\n=== Overall average:        %.2fms ===", objectArray);
            Log.i((String)TAG, (String)frameValues);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/rive/runtime/kotlin/renderers/RendererMetrics$Companion;", "", "()V", "ONE_MS_IN_NS", "", "SAMPLES", "", "TAG", "", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

