/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.renderers;

import android.graphics.RectF;
import android.view.Choreographer;
import android.view.Surface;
import androidx.annotation.CallSuper;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.NativeObject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H&J&\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\b\u0010\u001f\u001a\u00020\u0015H\u0002J\u0011\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0004H\u0082 J1\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001dH\u0082 J\u0011\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020!H\u0082 J\u0011\u0010'\u001a\u00020\u00152\u0006\u0010&\u001a\u00020!H\u0082 J\u0011\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020!H\u0096 J\u0019\u0010*\u001a\u00020\u00152\u0006\u0010&\u001a\u00020!2\u0006\u0010+\u001a\u00020!H\u0082 J\u0011\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020!H\u0082 J\u0011\u0010.\u001a\u00020\u00152\u0006\u0010&\u001a\u00020!H\u0082 J\u0011\u0010/\u001a\u00020\u00152\u0006\u0010&\u001a\u00020!H\u0082 J\u0019\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u0002022\u0006\u0010&\u001a\u00020!H\u0082 J\u0019\u00103\u001a\u00020\u00152\u0006\u0010&\u001a\u00020!2\u0006\u00104\u001a\u00020!H\u0082 J\u0011\u00105\u001a\u00020\u00152\u0006\u0010&\u001a\u00020!H\u0082 J\u0011\u00106\u001a\u00020-2\u0006\u0010&\u001a\u00020!H\u0082 J\b\u00107\u001a\u00020\u0015H\u0017J\b\u00108\u001a\u00020\u0015H\u0014J\u0010\u00109\u001a\u00020\u00152\u0006\u0010+\u001a\u00020!H\u0017J\b\u0010:\u001a\u00020\u0015H&J\b\u0010;\u001a\u00020\u0015H\u0017J\u0006\u0010<\u001a\u00020\u0015J\u0006\u0010=\u001a\u00020\u0015J\b\u0010>\u001a\u00020\u0015H\u0016J\u000e\u0010?\u001a\u00020\u00152\u0006\u00101\u001a\u000202J\u0006\u0010@\u001a\u00020\u0015J\b\u0010A\u001a\u00020\u0015H\u0007J\r\u0010B\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\bCR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR$\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006D"}, d2={"Lapp/rive/runtime/kotlin/renderers/RendererSkia;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "Landroid/view/Choreographer$FrameCallback;", "trace", "", "(Z)V", "averageFps", "", "getAverageFps", "()F", "height", "getHeight", "<set-?>", "isAttached", "()Z", "setAttached", "isPlaying", "getTrace", "width", "getWidth", "advance", "", "elapsed", "align", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "targetBounds", "Landroid/graphics/RectF;", "sourceBounds", "clearSurface", "constructor", "", "cppAlign", "cppPointer", "srcBounds", "cppAvgFps", "rendererPointer", "cppClearSurface", "cppDelete", "pointer", "cppDoFrame", "frameTimeNanos", "cppHeight", "", "cppRestore", "cppSave", "cppSetSurface", "surface", "Landroid/view/Surface;", "cppStart", "timeNanos", "cppStop", "cppWidth", "delete", "disposeDependencies", "doFrame", "draw", "make", "restore", "save", "scheduleFrame", "setSurface", "start", "stop", "stopThread", "stopThread$kotlin_release", "kotlin_release"})
public abstract class RendererSkia
extends NativeObject
implements Choreographer.FrameCallback {
    private final boolean trace;
    private boolean isPlaying;
    private boolean isAttached;

    public RendererSkia(boolean trace) {
        super(0L);
        this.trace = trace;
    }

    public /* synthetic */ RendererSkia(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getTrace() {
        return this.trace;
    }

    @Override
    public native void cppDelete(long var1);

    private final native void cppStart(long var1, long var3);

    private final native void cppStop(long var1);

    private final native void cppSave(long var1);

    private final native void cppRestore(long var1);

    private final native int cppWidth(long var1);

    private final native int cppHeight(long var1);

    private final native float cppAvgFps(long var1);

    private final native void cppDoFrame(long var1, long var3);

    private final native void cppSetSurface(Surface var1, long var2);

    private final native void cppClearSurface(long var1);

    private final native void cppAlign(long var1, Fit var3, Alignment var4, RectF var5, RectF var6);

    private final native long constructor(boolean var1);

    @CallSuper
    public void make() {
        if (!this.getHasCppObject()) {
            this.setCppPointer(this.constructor(this.trace));
        }
    }

    public final boolean isPlaying() {
        return this.isPlaying;
    }

    public final boolean isAttached() {
        return this.isAttached;
    }

    protected final void setAttached(boolean bl) {
        this.isAttached = bl;
    }

    public abstract void draw();

    public abstract void advance(float var1);

    public final void start() {
        if (this.isPlaying) {
            return;
        }
        if (!this.isAttached) {
            return;
        }
        if (!this.getHasCppObject()) {
            return;
        }
        long nanoTime = System.nanoTime();
        this.isPlaying = true;
        this.cppStart(this.getCppPointer(), nanoTime);
        this.scheduleFrame();
    }

    public final void setSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.cppSetSurface(surface, this.getCppPointer());
        this.isAttached = true;
        this.start();
    }

    @CallSuper
    public final void stopThread$kotlin_release() {
        if (!this.isPlaying) {
            return;
        }
        if (!this.getHasCppObject()) {
            return;
        }
        this.isPlaying = false;
        this.cppStop(this.getCppPointer());
    }

    @CallSuper
    public final void stop() {
        this.stopThread$kotlin_release();
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    private final void clearSurface() {
        this.stop();
        this.cppClearSurface(this.getCppPointer());
        this.isAttached = false;
    }

    public void scheduleFrame() {
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public final void save() {
        this.cppSave(this.getCppPointer());
    }

    public final void restore() {
        this.cppRestore(this.getCppPointer());
    }

    public final float getWidth() {
        return this.cppWidth(this.getCppPointer());
    }

    public final float getHeight() {
        return this.cppHeight(this.getCppPointer());
    }

    public final float getAverageFps() {
        return this.cppAvgFps(this.getCppPointer());
    }

    public final void align(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull RectF targetBounds, @NotNull RectF sourceBounds) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)targetBounds, (String)"targetBounds");
        Intrinsics.checkNotNullParameter((Object)sourceBounds, (String)"sourceBounds");
        this.cppAlign(this.getCppPointer(), fit, alignment, targetBounds, sourceBounds);
    }

    @CallSuper
    public void doFrame(long frameTimeNanos) {
        if (this.isPlaying) {
            long nanoTime = System.nanoTime();
            this.cppDoFrame(this.getCppPointer(), nanoTime);
            this.scheduleFrame();
        }
    }

    @CallSuper
    public void delete() {
        this.clearSurface();
        this.cppDelete(this.getCppPointer());
        this.setCppPointer(0L);
    }

    protected void disposeDependencies() {
        Iterable $this$forEach$iv = this.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NativeObject it = (NativeObject)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.getDependencies().clear();
    }

    public RendererSkia() {
        this(false, 1, null);
    }
}

