/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.lifecycle.LifecycleObserver;
import app.rive.runtime.kotlin.renderers.Renderer;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010 \u001a\u00020\u000fH$J\b\u0010!\u001a\u00020\u0019H$J\u0018\u0010\"\u001a\u0004\u0018\u0001H#\"\u0006\b\u0000\u0010#\u0018\u0001H\u0084\b\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0015J\b\u0010'\u001a\u00020&H\u0015J \u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0017J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020*H\u0017J \u00101\u001a\u00020&2\u0006\u00100\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0016J\u0010\u00102\u001a\u00020&2\u0006\u00100\u001a\u00020*H\u0016J\u0018\u00103\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020,H\u0014R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lapp/rive/runtime/kotlin/RiveTextureView;", "Landroid/view/TextureView;", "Landroid/view/TextureView$SurfaceTextureListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "activity", "Landroid/app/Activity;", "getActivity", "()Landroid/app/Activity;", "activity$delegate", "Lkotlin/Lazy;", "lifecycleObserver", "Landroidx/lifecycle/LifecycleObserver;", "getLifecycleObserver", "()Landroidx/lifecycle/LifecycleObserver;", "lifecycleObserver$delegate", "refreshPeriodNanos", "", "getRefreshPeriodNanos", "()J", "refreshPeriodNanos$delegate", "renderer", "Lapp/rive/runtime/kotlin/renderers/Renderer;", "getRenderer", "()Lapp/rive/runtime/kotlin/renderers/Renderer;", "setRenderer", "(Lapp/rive/runtime/kotlin/renderers/Renderer;)V", "viewSurface", "Landroid/view/Surface;", "createObserver", "createRenderer", "getContextAsType", "T", "()Ljava/lang/Object;", "onAttachedToWindow", "", "onDetachedFromWindow", "onSurfaceTextureAvailable", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "width", "", "height", "onSurfaceTextureDestroyed", "", "surface", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "Companion", "kotlin_release"})
public abstract class RiveTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy activity$delegate;
    @NotNull
    private final Lazy lifecycleObserver$delegate;
    @Nullable
    private Renderer renderer;
    private Surface viewSurface;
    @NotNull
    private final Lazy refreshPeriodNanos$delegate;
    @NotNull
    public static final String TAG = "RiveTextureView";

    public RiveTextureView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.activity$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Activity>(this){
            final /* synthetic */ RiveTextureView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Activity invoke() {
                Context context;
                block2: {
                    RiveTextureView this_$iv = this.this$0;
                    boolean $i$f$getContextAsType = false;
                    Context ctx$iv = this_$iv.getContext();
                    while (ctx$iv instanceof ContextWrapper) {
                        if (ctx$iv instanceof Activity) {
                            context = ctx$iv;
                            break block2;
                        }
                        ctx$iv = ((ContextWrapper)ctx$iv).getBaseContext();
                    }
                    context = null;
                }
                Intrinsics.checkNotNull(context);
                return (Activity)context;
            }
        }));
        this.lifecycleObserver$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LifecycleObserver>(this){
            final /* synthetic */ RiveTextureView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LifecycleObserver invoke() {
                return this.this$0.createObserver();
            }
        }));
        this.refreshPeriodNanos$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ RiveTextureView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                long msInNS = 1000000L;
                long sInNS = (long)1000 * msInNS;
                float refreshRateHz = this.this$0.getActivity().getWindowManager().getDefaultDisplay().getRefreshRate();
                String string = "Refresh rate: %.1f Hz";
                Object[] objectArray = new Object[]{Float.valueOf(refreshRateHz)};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                Log.i((String)"RiveSurfaceHolder", (String)string2);
                return (long)((float)sInNS / refreshRateHz);
            }
        }));
    }

    public /* synthetic */ RiveTextureView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @NotNull
    protected final Activity getActivity() {
        Lazy lazy = this.activity$delegate;
        return (Activity)lazy.getValue();
    }

    @NotNull
    protected final LifecycleObserver getLifecycleObserver() {
        Lazy lazy = this.lifecycleObserver$delegate;
        return (LifecycleObserver)lazy.getValue();
    }

    @Nullable
    protected final Renderer getRenderer() {
        return this.renderer;
    }

    protected final void setRenderer(@Nullable Renderer renderer) {
        this.renderer = renderer;
    }

    @NotNull
    protected abstract Renderer createRenderer();

    @NotNull
    protected abstract LifecycleObserver createObserver();

    private final long getRefreshPeriodNanos() {
        Lazy lazy = this.refreshPeriodNanos$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    protected final /* synthetic */ <T> T getContextAsType() {
        boolean $i$f$getContextAsType = false;
        Context ctx = this.getContext();
        while (ctx instanceof ContextWrapper) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (ctx instanceof Object) {
                return (T)ctx;
            }
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return null;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.onSurfaceTextureAvailable(surface, width, height);
    }

    @CallSuper
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setSurfaceTextureListener(this);
        this.setOpaque(false);
        Renderer renderer = this.renderer = this.createRenderer();
        Intrinsics.checkNotNull((Object)renderer);
        renderer.make();
    }

    @CallSuper
    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        block3: {
            Renderer renderer;
            Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
            if (this.viewSurface != null) {
                Surface surface = this.viewSurface;
                if (surface == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewSurface");
                    surface = null;
                }
                surface.release();
            }
            this.viewSurface = new Surface(surfaceTexture);
            Renderer renderer2 = this.renderer;
            if (renderer2 == null) break block3;
            Renderer $this$onSurfaceTextureAvailable_u24lambda_u240 = renderer = renderer2;
            boolean bl = false;
            $this$onSurfaceTextureAvailable_u24lambda_u240.stop();
            Surface surface = this.viewSurface;
            if (surface == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewSurface");
                surface = null;
            }
            $this$onSurfaceTextureAvailable_u24lambda_u240.setSurface(surface);
        }
    }

    @CallSuper
    protected void onDetachedFromWindow() {
        Renderer renderer = this.renderer;
        Intrinsics.checkNotNull((Object)renderer);
        renderer.delete();
        this.renderer = null;
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
                super.onVisibilityChanged(changedView, visibility);
                if (visibility != 0) break block0;
                Renderer renderer = this.renderer;
                if (renderer == null) break block1;
                renderer.start();
                break block1;
            }
            Renderer renderer = this.renderer;
            if (renderer == null) break block1;
            renderer.stop();
        }
    }

    @CallSuper
    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Surface surface2 = this.viewSurface;
        if (surface2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewSurface");
            surface2 = null;
        }
        surface2.release();
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/rive/runtime/kotlin/RiveTextureView$Companion;", "", "()V", "TAG", "", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

