/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.controllers;

import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import app.rive.runtime.kotlin.Observable;
import app.rive.runtime.kotlin.RiveAnimationView;
import app.rive.runtime.kotlin.controllers.ControllerState;
import app.rive.runtime.kotlin.controllers.ControllerStateManagement;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LayerState;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.PlayableInstance;
import app.rive.runtime.kotlin.core.RefCount;
import app.rive.runtime.kotlin.core.RiveEvent;
import app.rive.runtime.kotlin.core.RiveTextValueRun;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.core.errors.RiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00a8\u00012\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0006\u00a8\u0001\u00a9\u0001\u00aa\u0001B]\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011j\u0004\u0018\u0001`\u0013\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010c\u001a\u00020\u00122\u0006\u0010d\u001a\u00020,J\u0010\u0010e\u001a\u00020\u00122\u0006\u0010f\u001a\u00020gH\u0007J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010h\u001a\u00020iH\u0002J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\"2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020i0kH\u0002J\u0006\u0010\n\u001a\u00020\u0012J\u0016\u0010l\u001a\u00020\u00122\u0006\u0010m\u001a\u00020i2\u0006\u0010n\u001a\u00020iJ\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020Q0\"2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010p\u001a\u0004\u0018\u00010i2\u0006\u0010q\u001a\u00020iJ\u0010\u0010r\u001a\u00020\u00122\u0006\u0010f\u001a\u00020gH\u0003J\u0010\u0010s\u001a\u00020\u00122\u0006\u0010t\u001a\u00020uH\u0002J\u0010\u0010v\u001a\u00020\u00122\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010y\u001a\u00020\u00122\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010z\u001a\u00020\u00122\u0006\u0010w\u001a\u00020xH\u0002J\u0018\u0010{\u001a\u00020\u00122\u0006\u0010|\u001a\u00020Q2\u0006\u0010}\u001a\u00020~H\u0002J\u0010\u0010\u007f\u001a\u00020\u00122\u0006\u0010w\u001a\u00020xH\u0002J\u0007\u0010\u0080\u0001\u001a\u00020\u0012J\u0012\u0010\u0080\u0001\u001a\u00020\u00122\u0007\u0010\u0081\u0001\u001a\u00020 H\u0002J\u0011\u0010\u0080\u0001\u001a\u00020\u00122\u0006\u0010|\u001a\u00020QH\u0002J\u001a\u0010\u0080\u0001\u001a\u00020\u00122\u0006\u0010h\u001a\u00020i2\t\b\u0002\u0010\u0082\u0001\u001a\u00020\u000bJ \u0010\u0080\u0001\u001a\u00020\u00122\f\u0010j\u001a\b\u0012\u0004\u0012\u00020i0\"2\t\b\u0002\u0010\u0083\u0001\u001a\u00020\u000bJ*\u0010\u0084\u0001\u001a\u00020\u00122\u0007\u0010\u0085\u0001\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0000\u00a2\u0006\u0003\b\u0088\u0001J(\u0010\u0084\u0001\u001a\u00020\u00122\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0086\u0001\u001a\u00030\u0087\u00012\t\b\u0002\u0010\u0089\u0001\u001a\u00020\u000bJ#\u0010\u0084\u0001\u001a\u00020\u00122\u0007\u0010\u008a\u0001\u001a\u00020Q2\t\b\u0002\u0010\u008b\u0001\u001a\u00020\u000bH\u0000\u00a2\u0006\u0003\b\u0088\u0001J;\u0010\u0084\u0001\u001a\u00020\u00122\u0006\u0010h\u001a\u00020i2\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0086\u0001\u001a\u00030\u0087\u00012\t\b\u0002\u0010\u0082\u0001\u001a\u00020\u000b2\t\b\u0002\u0010\u0089\u0001\u001a\u00020\u000bJA\u0010\u0084\u0001\u001a\u00020\u00122\f\u0010j\u001a\b\u0012\u0004\u0012\u00020i0\"2\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0086\u0001\u001a\u00030\u0087\u00012\t\b\u0002\u0010\u0083\u0001\u001a\u00020\u000b2\t\b\u0002\u0010\u0089\u0001\u001a\u00020\u000bJ=\u0010\u008c\u0001\u001a\u00020\u00122\u0006\u0010h\u001a\u00020i2\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0086\u0001\u001a\u00030\u0087\u00012\t\b\u0002\u0010\u0082\u0001\u001a\u00020\u000b2\t\b\u0002\u0010\u0089\u0001\u001a\u00020\u000bH\u0002J\u0011\u0010\u008d\u0001\u001a\u00020\u00122\u0006\u0010d\u001a\u00020\u0002H\u0016J\n\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0016J\u000f\u0010\u0090\u0001\u001a\u00020\u00122\u0006\u0010d\u001a\u00020,J\u000f\u0010\u0091\u0001\u001a\u00020\u0012H\u0000\u00a2\u0006\u0003\b\u0092\u0001J\u001a\u0010\u0093\u0001\u001a\u00020\u000b2\u0007\u0010\u008a\u0001\u001a\u00020Q2\u0006\u0010f\u001a\u00020gH\u0002J\u0012\u0010\u0094\u0001\u001a\u00020\u00122\u0007\u0010}\u001a\u00030\u0095\u0001H\u0007J\n\u0010\u0096\u0001\u001a\u00030\u0095\u0001H\u0007J\u0014\u0010\u0097\u0001\u001a\u00020\u00122\u000b\b\u0002\u0010\u0098\u0001\u001a\u0004\u0018\u00010iJ\u0012\u0010\u0099\u0001\u001a\u00020\u00122\u0007\u0010\u009a\u0001\u001a\u00020\u000fH\u0002J\u001f\u0010\u009b\u0001\u001a\u00020\u00122\u0006\u0010m\u001a\u00020i2\u0006\u0010n\u001a\u00020i2\u0006\u0010\u0015\u001a\u00020\u000bJ\u001f\u0010\u009c\u0001\u001a\u00020\u00122\u0006\u0010m\u001a\u00020i2\u0006\u0010n\u001a\u00020i2\u0006\u0010\u0015\u001a\u00020gJ\u001c\u0010\u009d\u0001\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u000b\b\u0002\u0010\u009e\u0001\u001a\u0004\u0018\u00010iJ\u0018\u0010\u009f\u0001\u001a\u00020\u00122\u0006\u0010q\u001a\u00020i2\u0007\u0010\u00a0\u0001\u001a\u00020iJ\u0019\u0010\u00a1\u0001\u001a\u00020\u00122\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001H\u0000\u00a2\u0006\u0003\b\u00a4\u0001J\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020Q0\"2\u0006\u0010h\u001a\u00020iH\u0002J\u001c\u0010a\u001a\b\u0012\u0004\u0012\u00020Q0\"2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020i0kH\u0002J\u0012\u0010\u00a5\u0001\u001a\u00020\u00122\u0007\u0010\u0081\u0001\u001a\u00020 H\u0002J\u0011\u0010\u00a5\u0001\u001a\u00020\u00122\u0006\u0010|\u001a\u00020QH\u0002J\u0007\u0010\u00a6\u0001\u001a\u00020\u0012J\u001a\u0010\u00a6\u0001\u001a\u00020\u00122\u0006\u0010h\u001a\u00020i2\t\b\u0002\u0010\u0082\u0001\u001a\u00020\u000bJ \u0010\u00a6\u0001\u001a\u00020\u00122\f\u0010j\u001a\b\u0012\u0004\u0012\u00020i0\"2\t\b\u0002\u0010\u0083\u0001\u001a\u00020\u000bJ\u0011\u0010\u00a7\u0001\u001a\u00020\u00122\u0006\u0010d\u001a\u00020\u0002H\u0016R(\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR2\u0010\u001e\u001a&\u0012\f\u0012\n !*\u0004\u0018\u00010 0  !*\u0012\u0012\f\u0012\n !*\u0004\u0018\u00010 0 \u0018\u00010\"0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R4\u0010*\u001a\u0012\u0012\u0004\u0012\u00020,0+j\b\u0012\u0004\u0012\u00020,`-8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R(\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010'R\u001a\u0010>\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010'\"\u0004\b?\u0010)R4\u0010@\u001a\u0012\u0012\u0004\u0012\u00020\u00020+j\b\u0012\u0004\u0012\u00020\u0002`-8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bA\u0010/\u001a\u0004\bB\u00101\"\u0004\bC\u00103R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR(\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011j\u0004\u0018\u0001`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020 0M8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0M8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010OR2\u0010S\u001a&\u0012\f\u0012\n !*\u0004\u0018\u00010 0  !*\u0012\u0012\f\u0012\n !*\u0004\u0018\u00010 0 \u0018\u00010M0TX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010U\u001a\u0012\u0012\u0004\u0012\u00020 0+j\b\u0012\u0004\u0012\u00020 `-8F\u00a2\u0006\u0006\u001a\u0004\bV\u00101R2\u0010W\u001a&\u0012\f\u0012\n !*\u0004\u0018\u00010Q0Q !*\u0012\u0012\f\u0012\n !*\u0004\u0018\u00010Q0Q\u0018\u00010M0TX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010X\u001a\u0012\u0012\u0004\u0012\u00020Q0+j\b\u0012\u0004\u0012\u00020Q`-8F\u00a2\u0006\u0006\u001a\u0004\bY\u00101R\u001a\u0010Z\u001a\u00020[X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R2\u0010`\u001a&\u0012\f\u0012\n !*\u0004\u0018\u00010Q0Q !*\u0012\u0012\f\u0012\n !*\u0004\u0018\u00010Q0Q\u0018\u00010\"0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010a\u001a\b\u0012\u0004\u0012\u00020Q0\"8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010%\u00a8\u0006\u00ab\u0001"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController;", "Lapp/rive/runtime/kotlin/Observable;", "Lapp/rive/runtime/kotlin/controllers/RiveFileController$Listener;", "Lapp/rive/runtime/kotlin/core/RefCount;", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "autoplay", "", "file", "Lapp/rive/runtime/kotlin/core/File;", "activeArtboard", "Lapp/rive/runtime/kotlin/core/Artboard;", "onStart", "Lkotlin/Function0;", "", "Lapp/rive/runtime/kotlin/controllers/OnStartCallback;", "(Lapp/rive/runtime/kotlin/core/Fit;Lapp/rive/runtime/kotlin/core/Alignment;Lapp/rive/runtime/kotlin/core/Loop;ZLapp/rive/runtime/kotlin/core/File;Lapp/rive/runtime/kotlin/core/Artboard;Lkotlin/jvm/functions/Function0;)V", "value", "getActiveArtboard", "()Lapp/rive/runtime/kotlin/core/Artboard;", "setActiveArtboard", "(Lapp/rive/runtime/kotlin/core/Artboard;)V", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "animationList", "", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "kotlin.jvm.PlatformType", "", "animations", "getAnimations", "()Ljava/util/List;", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "eventListeners", "Ljava/util/HashSet;", "Lapp/rive/runtime/kotlin/controllers/RiveFileController$RiveEventListener;", "Lkotlin/collections/HashSet;", "getEventListeners$kotlin_release$annotations", "()V", "getEventListeners$kotlin_release", "()Ljava/util/HashSet;", "setEventListeners$kotlin_release", "(Ljava/util/HashSet;)V", "getFile", "()Lapp/rive/runtime/kotlin/core/File;", "setFile", "(Lapp/rive/runtime/kotlin/core/File;)V", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "hasPlayingAnimations", "getHasPlayingAnimations", "isActive", "setActive", "listeners", "getListeners$kotlin_release$annotations", "getListeners$kotlin_release", "setListeners$kotlin_release", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "getOnStart", "()Lkotlin/jvm/functions/Function0;", "setOnStart", "(Lkotlin/jvm/functions/Function0;)V", "pausedAnimations", "", "getPausedAnimations", "()Ljava/util/Set;", "pausedStateMachines", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getPausedStateMachines", "playingAnimationSet", "", "playingAnimations", "getPlayingAnimations", "playingStateMachineSet", "playingStateMachines", "getPlayingStateMachines", "refs", "Ljava/util/concurrent/atomic/AtomicInteger;", "getRefs", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setRefs", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "stateMachineList", "stateMachines", "getStateMachines", "addEventListener", "listener", "advance", "elapsed", "", "animationName", "", "animationNames", "", "fireState", "stateMachineName", "inputName", "getOrCreateStateMachines", "getTextRunValue", "textRunName", "notifyAdvance", "notifyEvent", "event", "Lapp/rive/runtime/kotlin/core/RiveEvent;", "notifyLoop", "playableInstance", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "stateMachine", "state", "Lapp/rive/runtime/kotlin/core/LayerState;", "notifyStop", "pause", "animation", "isStateMachine", "areStateMachines", "play", "animationInstance", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "play$kotlin_release", "settleInitialState", "stateMachineInstance", "settleStateMachineState", "playAnimation", "registerListener", "release", "", "removeEventListener", "reset", "reset$kotlin_release", "resolveStateMachineAdvance", "restoreControllerState", "Lapp/rive/runtime/kotlin/controllers/ControllerState;", "saveControllerState", "selectArtboard", "name", "setArtboard", "ab", "setBooleanState", "setNumberState", "setRiveFile", "artboardName", "setTextRunValue", "textValue", "setupScene", "attrs", "Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "setupScene$kotlin_release", "stop", "stopAnimations", "unregisterListener", "Companion", "Listener", "RiveEventListener", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nRiveFileController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiveFileController.kt\napp/rive/runtime/kotlin/controllers/RiveFileController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,722:1\n1855#2,2:723\n1855#2,2:725\n1855#2,2:727\n1855#2,2:729\n1855#2,2:731\n1855#2,2:733\n1855#2,2:735\n1855#2,2:737\n1855#2,2:739\n1855#2,2:741\n1855#2,2:743\n1855#2,2:745\n1855#2,2:747\n1855#2,2:749\n1855#2,2:751\n1855#2,2:753\n1855#2,2:755\n1855#2,2:757\n1855#2,2:759\n1855#2,2:761\n1855#2,2:763\n1855#2,2:765\n1855#2,2:767\n1855#2,2:769\n766#2:771\n857#2,2:772\n766#2:774\n857#2,2:775\n1855#2,2:777\n1855#2,2:779\n1855#2,2:781\n1855#2,2:783\n1855#2,2:785\n1855#2,2:787\n1855#2,2:789\n1855#2,2:791\n1855#2,2:793\n1855#2,2:795\n1855#2,2:797\n*S KotlinDebug\n*F\n+ 1 RiveFileController.kt\napp/rive/runtime/kotlin/controllers/RiveFileController\n*L\n194#1:723,2\n195#1:725,2\n196#1:727,2\n197#1:729,2\n210#1:731,2\n223#1:733,2\n327#1:735,2\n353#1:737,2\n356#1:739,2\n379#1:741,2\n380#1:743,2\n385#1:745,2\n387#1:747,2\n393#1:749,2\n395#1:751,2\n405#1:753,2\n409#1:755,2\n415#1:757,2\n417#1:759,2\n424#1:761,2\n427#1:763,2\n434#1:765,2\n442#1:767,2\n450#1:769,2\n482#1:771\n482#1:772,2\n486#1:774\n486#1:775,2\n510#1:777,2\n513#1:779,2\n531#1:781,2\n537#1:783,2\n655#1:785,2\n659#1:787,2\n663#1:789,2\n667#1:791,2\n672#1:793,2\n676#1:795,2\n680#1:797,2\n*E\n"})
public final class RiveFileController
implements Observable<Listener>,
RefCount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Fit fit;
    @NotNull
    private Alignment alignment;
    @NotNull
    private Loop loop;
    private boolean autoplay;
    @Nullable
    private Function0<Unit> onStart;
    @NotNull
    private AtomicInteger refs;
    private boolean isActive;
    @Nullable
    private File file;
    @Nullable
    private Artboard activeArtboard;
    private List<LinearAnimationInstance> animationList;
    private List<StateMachineInstance> stateMachineList;
    private Set<LinearAnimationInstance> playingAnimationSet;
    private Set<StateMachineInstance> playingStateMachineSet;
    @NotNull
    private HashSet<Listener> listeners;
    @NotNull
    private HashSet<RiveEventListener> eventListeners;
    @NotNull
    public static final String TAG = "RiveFileController";

    public RiveFileController(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull Loop loop, boolean autoplay, @Nullable File file, @Nullable Artboard activeArtboard, @Nullable Function0<Unit> onStart) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        this.fit = fit;
        this.alignment = alignment;
        this.loop = loop;
        this.autoplay = autoplay;
        this.onStart = onStart;
        this.refs = new AtomicInteger(1);
        this.file = file;
        this.activeArtboard = activeArtboard;
        this.animationList = Collections.synchronizedList(new ArrayList());
        this.stateMachineList = Collections.synchronizedList(new ArrayList());
        this.playingAnimationSet = Collections.synchronizedSet(new HashSet());
        this.playingStateMachineSet = Collections.synchronizedSet(new HashSet());
        this.listeners = new HashSet();
        this.eventListeners = new HashSet();
    }

    public /* synthetic */ RiveFileController(Fit fit, Alignment alignment, Loop loop, boolean bl, File file, Artboard artboard, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fit = Fit.CONTAIN;
        }
        if ((n & 2) != 0) {
            alignment = Alignment.CENTER;
        }
        if ((n & 4) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            file = null;
        }
        if ((n & 0x20) != 0) {
            artboard = null;
        }
        if ((n & 0x40) != 0) {
            function0 = null;
        }
        this(fit, alignment, loop, bl, file, artboard, (Function0<Unit>)function0);
    }

    @NotNull
    public final Fit getFit() {
        return this.fit;
    }

    public final void setFit(@NotNull Fit fit) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"<set-?>");
        this.fit = fit;
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final void setAlignment(@NotNull Alignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"<set-?>");
        this.alignment = alignment;
    }

    @NotNull
    public final Loop getLoop() {
        return this.loop;
    }

    public final void setLoop(@NotNull Loop loop) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"<set-?>");
        this.loop = loop;
    }

    public final boolean getAutoplay() {
        return this.autoplay;
    }

    public final void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    @Nullable
    public final Function0<Unit> getOnStart() {
        return this.onStart;
    }

    public final void setOnStart(@Nullable Function0<Unit> function0) {
        this.onStart = function0;
    }

    @Override
    @NotNull
    public AtomicInteger getRefs() {
        return this.refs;
    }

    @Override
    public void setRefs(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.refs = atomicInteger;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final void setActive(boolean bl) {
        this.isActive = bl;
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@Nullable File value) {
        block2: {
            if (Intrinsics.areEqual((Object)value, (Object)this.file)) {
                return;
            }
            File file = this.file;
            if (file != null) {
                File it = file;
                boolean bl = false;
                this.reset$kotlin_release();
                it.release();
            }
            File file2 = this.file = value;
            if (file2 == null) break block2;
            file2.acquire();
        }
    }

    @Nullable
    public final Artboard getActiveArtboard() {
        return this.activeArtboard;
    }

    public final void setActiveArtboard(@Nullable Artboard value) {
        block2: {
            if (Intrinsics.areEqual((Object)value, (Object)this.activeArtboard)) {
                return;
            }
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                artboard.release();
            }
            Artboard artboard2 = this.activeArtboard = value;
            if (artboard2 == null) break block2;
            artboard2.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LinearAnimationInstance> getAnimations() {
        List list;
        List<LinearAnimationInstance> list2 = this.animationList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"animationList");
        List<LinearAnimationInstance> list3 = list2;
        synchronized (list3) {
            boolean bl = false;
            List<LinearAnimationInstance> list4 = this.animationList;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"animationList");
            list = CollectionsKt.toList((Iterable)list4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<StateMachineInstance> getStateMachines() {
        List list;
        List<StateMachineInstance> list2 = this.stateMachineList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"stateMachineList");
        List<StateMachineInstance> list3 = list2;
        synchronized (list3) {
            boolean bl = false;
            List<StateMachineInstance> list4 = this.stateMachineList;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"stateMachineList");
            list = CollectionsKt.toList((Iterable)list4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashSet<LinearAnimationInstance> getPlayingAnimations() {
        HashSet hashSet;
        Set<LinearAnimationInstance> set = this.playingAnimationSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingAnimationSet");
        Set<LinearAnimationInstance> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Set<LinearAnimationInstance> set3 = this.playingAnimationSet;
            Intrinsics.checkNotNullExpressionValue(set3, (String)"playingAnimationSet");
            hashSet = CollectionsKt.toHashSet((Iterable)set3);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashSet<StateMachineInstance> getPlayingStateMachines() {
        HashSet hashSet;
        Set<StateMachineInstance> set = this.playingStateMachineSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingStateMachineSet");
        Set<StateMachineInstance> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Set<StateMachineInstance> set3 = this.playingStateMachineSet;
            Intrinsics.checkNotNullExpressionValue(set3, (String)"playingStateMachineSet");
            hashSet = CollectionsKt.toHashSet((Iterable)set3);
        }
        return hashSet;
    }

    @NotNull
    public final Set<LinearAnimationInstance> getPausedAnimations() {
        List<LinearAnimationInstance> list = this.animationList;
        Intrinsics.checkNotNullExpressionValue(list, (String)"animationList");
        Iterable iterable = list;
        Set<LinearAnimationInstance> set = this.playingAnimationSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingAnimationSet");
        return CollectionsKt.subtract((Iterable)iterable, (Iterable)set);
    }

    @NotNull
    public final Set<StateMachineInstance> getPausedStateMachines() {
        List<StateMachineInstance> list = this.stateMachineList;
        Intrinsics.checkNotNullExpressionValue(list, (String)"stateMachineList");
        Iterable iterable = list;
        Set<StateMachineInstance> set = this.playingStateMachineSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingStateMachineSet");
        return CollectionsKt.subtract((Iterable)iterable, (Iterable)set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getHasPlayingAnimations() {
        Set<LinearAnimationInstance> set = this.playingAnimationSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingAnimationSet");
        if (!((Collection)set).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Set<StateMachineInstance> set2 = this.playingStateMachineSet;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"playingStateMachineSet");
        if (((Collection)set2).isEmpty()) return false;
        return true;
    }

    @ControllerStateManagement
    @NotNull
    public final ControllerState saveControllerState() {
        File file = this.file;
        if (file != null) {
            file.acquire();
        }
        Artboard artboard = this.activeArtboard;
        if (artboard != null) {
            artboard.acquire();
        }
        List<LinearAnimationInstance> list = this.animationList;
        Intrinsics.checkNotNullExpressionValue(list, (String)"animationList");
        List list2 = CollectionsKt.toList((Iterable)list);
        HashSet hashSet = CollectionsKt.toHashSet((Iterable)this.getPlayingAnimations());
        List<StateMachineInstance> list3 = this.stateMachineList;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"stateMachineList");
        return new ControllerState(this.file, this.activeArtboard, list2, hashSet, CollectionsKt.toList((Iterable)list3), CollectionsKt.toHashSet((Iterable)this.getPlayingStateMachines()), this.isActive);
    }

    @ControllerStateManagement
    public final void restoreControllerState(@NotNull ControllerState state) {
        NativeObject it;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.reset$kotlin_release();
        this.setFile(state.getFile());
        this.setActiveArtboard(state.getActiveArtboard());
        Iterable $this$forEach$iv = state.getAnimations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this.animationList.add((LinearAnimationInstance)it);
        }
        $this$forEach$iv = state.getStateMachines();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StateMachineInstance)element$iv;
            boolean bl = false;
            this.stateMachineList.add((StateMachineInstance)it);
        }
        $this$forEach$iv = state.getPlayingAnimations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this.play$kotlin_release((LinearAnimationInstance)it, ((LinearAnimationInstance)it).getLoop(), ((LinearAnimationInstance)it).getDirection());
        }
        $this$forEach$iv = state.getPlayingStateMachines();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StateMachineInstance)element$iv;
            boolean bl = false;
            RiveFileController.play$kotlin_release$default(this, (StateMachineInstance)it, false, 2, null);
        }
        this.isActive = state.isActive();
        state.dispose();
    }

    @WorkerThread
    public final void advance(float elapsed) {
        block3: {
            Artboard artboard = this.activeArtboard;
            if (artboard == null) break block3;
            Artboard ab = artboard;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getAnimations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance animationInstance = (LinearAnimationInstance)element$iv;
                boolean bl2 = false;
                if (!this.getPlayingAnimations().contains(animationInstance)) continue;
                Loop looped = animationInstance.advance(elapsed);
                animationInstance.apply();
                if (looped == Loop.ONESHOT) {
                    this.stop(animationInstance);
                    continue;
                }
                if (looped == null) continue;
                this.notifyLoop(animationInstance);
            }
            $this$forEach$iv = this.getStateMachines();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean stillPlaying;
                StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv;
                boolean bl3 = false;
                if (!this.getPlayingStateMachines().contains(stateMachineInstance) || (stillPlaying = this.resolveStateMachineAdvance(stateMachineInstance, elapsed))) continue;
                this.pause(stateMachineInstance);
            }
            ab.advance(elapsed);
            this.notifyAdvance(elapsed);
        }
    }

    public final void setRiveFile(@NotNull File file, @Nullable String artboardName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file, (Object)this.file)) {
            return;
        }
        this.setFile(file);
        this.selectArtboard(artboardName);
    }

    public static /* synthetic */ void setRiveFile$default(RiveFileController riveFileController, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        riveFileController.setRiveFile(file, string);
    }

    public final void selectArtboard(@Nullable String name2) {
        block0: {
            File file = this.file;
            if (file == null) break block0;
            File it = file;
            boolean bl = false;
            String string = name2;
            Artboard artboard = string != null ? it.artboard(string) : it.getFirstArtboard();
            this.setArtboard(artboard);
        }
    }

    public static /* synthetic */ void selectArtboard$default(RiveFileController riveFileController, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        riveFileController.selectArtboard(string);
    }

    public final void autoplay() {
        block2: {
            block1: {
                if (!this.autoplay) break block1;
                RiveFileController.play$default(this, null, null, true, 3, null);
                break block2;
            }
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                artboard.advance(0.0f);
            }
            Function0<Unit> function0 = this.onStart;
            if (function0 == null) break block2;
            function0.invoke();
        }
    }

    private final void setArtboard(Artboard ab) {
        this.setActiveArtboard(ab);
        this.autoplay();
    }

    public final void setupScene$kotlin_release(@NotNull RiveAnimationView.RendererAttributes attrs) {
        block7: {
            block6: {
                String abName;
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                File mFile = this.file;
                if (mFile == null) {
                    Log.w((String)TAG, (String)"Cannot init without a file");
                    return;
                }
                this.reset$kotlin_release();
                this.autoplay = attrs.getAutoplay();
                this.alignment = attrs.getAlignment();
                this.fit = attrs.getFit();
                this.loop = attrs.getLoop();
                String string = abName = attrs.getArtboardName();
                this.setActiveArtboard(string != null ? mFile.artboard(string) : mFile.getFirstArtboard());
                if (!this.autoplay) break block6;
                String animName = attrs.getAnimationName();
                String smName = attrs.getStateMachineName();
                if (animName != null) {
                    RiveFileController.play$default(this, animName, null, null, false, false, 30, null);
                } else if (smName != null) {
                    RiveFileController.play$default(this, smName, null, null, true, true, 6, null);
                } else {
                    RiveFileController.play$default(this, null, null, true, 3, null);
                }
                break block7;
            }
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                artboard.advance(0.0f);
            }
            Function0<Unit> function0 = this.onStart;
            if (function0 == null) break block7;
            function0.invoke();
        }
    }

    public final void play(@NotNull List<String> animationNames, @NotNull Loop loop, @NotNull Direction direction, boolean areStateMachines, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Iterable $this$forEach$iv = animationNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.playAnimation(it, loop, direction, areStateMachines, settleInitialState);
        }
    }

    public static /* synthetic */ void play$default(RiveFileController riveFileController, List list, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveFileController.play(list, loop, direction, bl, bl2);
    }

    public final void play(@NotNull String animationName, @NotNull Loop loop, @NotNull Direction direction, boolean isStateMachine, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.playAnimation(animationName, loop, direction, isStateMachine, settleInitialState);
    }

    public static /* synthetic */ void play$default(RiveFileController riveFileController, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveFileController.play(string, loop, direction, bl, bl2);
    }

    public final void play(@NotNull Loop loop, @NotNull Direction direction, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Artboard artboard = this.activeArtboard;
        if (artboard != null) {
            Artboard activeArtboard = artboard;
            boolean bl = false;
            if (!((Collection)this.getPausedAnimations()).isEmpty() || !((Collection)this.getPausedStateMachines()).isEmpty()) {
                NativeObject it;
                Iterable $this$forEach$iv = this.getAnimations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (LinearAnimationInstance)element$iv;
                    boolean bl2 = false;
                    this.play$kotlin_release((LinearAnimationInstance)it, loop, direction);
                }
                $this$forEach$iv = this.getStateMachines();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (StateMachineInstance)element$iv;
                    boolean bl3 = false;
                    this.play$kotlin_release((StateMachineInstance)it, settleInitialState);
                }
            } else {
                List<String> stateMachineNames;
                List<String> animationNames = activeArtboard.getAnimationNames();
                if (!((Collection)animationNames).isEmpty()) {
                    RiveFileController.playAnimation$default(this, (String)CollectionsKt.first(animationNames), loop, direction, false, false, 24, null);
                }
                if (!((Collection)(stateMachineNames = activeArtboard.getStateMachineNames())).isEmpty()) {
                    RiveFileController.playAnimation$default(this, (String)CollectionsKt.first(stateMachineNames), loop, direction, settleInitialState, false, 16, null);
                    return;
                }
            }
        }
    }

    public static /* synthetic */ void play$default(RiveFileController riveFileController, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 2) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        riveFileController.play(loop, direction, bl);
    }

    public final void pause() {
        NativeObject it;
        Iterable $this$forEach$iv = this.getPlayingAnimations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this.pause((LinearAnimationInstance)it);
        }
        $this$forEach$iv = this.getPlayingStateMachines();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StateMachineInstance)element$iv;
            boolean bl = false;
            this.pause((StateMachineInstance)it);
        }
    }

    public final void pause(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this.stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveFileController riveFileController, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.pause(list, bl);
    }

    public final void pause(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this.stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveFileController riveFileController, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.pause(string, bl);
    }

    public final void stopAnimations() {
        NativeObject it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<LinearAnimationInstance> list = this.animationList;
        Intrinsics.checkNotNullExpressionValue(list, (String)"animationList");
        if (!((Collection)list).isEmpty()) {
            $this$forEach$iv = this.getAnimations();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.stop((LinearAnimationInstance)it);
            }
        }
        List<StateMachineInstance> list2 = this.stateMachineList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"stateMachineList");
        if (!((Collection)list2).isEmpty()) {
            $this$forEach$iv = this.getStateMachines();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.stop((StateMachineInstance)it);
            }
        }
    }

    public final void stopAnimations(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this.stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveFileController riveFileController, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.stopAnimations(list, bl);
    }

    public final void stopAnimations(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this.stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveFileController riveFileController, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.stopAnimations(string, bl);
    }

    public final void fireState(@NotNull String stateMachineName, @NotNull String inputName) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this.getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            Intrinsics.checkNotNull((Object)sMIInput, (String)"null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMITrigger");
            ((SMITrigger)sMIInput).fire();
            this.play$kotlin_release(it, false);
        }
    }

    public final void setBooleanState(@NotNull String stateMachineName, @NotNull String inputName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this.getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            Intrinsics.checkNotNull((Object)sMIInput, (String)"null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMIBoolean");
            ((SMIBoolean)sMIInput).setValue(value);
            this.play$kotlin_release(it, false);
        }
    }

    public final void setNumberState(@NotNull String stateMachineName, @NotNull String inputName, float value) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        List<StateMachineInstance> stateMachineInstances = this.getOrCreateStateMachines(stateMachineName);
        Iterable $this$forEach$iv = stateMachineInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            SMIInput sMIInput = it.input(inputName);
            Intrinsics.checkNotNull((Object)sMIInput, (String)"null cannot be cast to non-null type app.rive.runtime.kotlin.core.SMINumber");
            ((SMINumber)sMIInput).setValue(value);
            this.play$kotlin_release(it, false);
        }
    }

    @Nullable
    public final String getTextRunValue(@NotNull String textRunName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        try {
            NativeObject nativeObject = this.activeArtboard;
            string = nativeObject != null && (nativeObject = ((Artboard)nativeObject).textRun(textRunName)) != null ? ((RiveTextValueRun)nativeObject).getText() : null;
        }
        catch (RiveException e) {
            string = null;
        }
        return string;
    }

    public final void setTextRunValue(@NotNull String textRunName, @NotNull String textValue) {
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        Artboard artboard = this.activeArtboard;
        RiveTextValueRun riveTextValueRun = artboard != null ? artboard.textRun(textRunName) : null;
        if (riveTextValueRun != null) {
            riveTextValueRun.setText(textValue);
        }
    }

    private final List<LinearAnimationInstance> animations(String animationName) {
        return this.animations(CollectionsKt.listOf((Object)animationName));
    }

    private final List<StateMachineInstance> stateMachines(String animationName) {
        return this.stateMachines(CollectionsKt.listOf((Object)animationName));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LinearAnimationInstance> animations(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAnimations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LinearAnimationInstance it = (LinearAnimationInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StateMachineInstance> stateMachines(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getStateMachines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<StateMachineInstance> getOrCreateStateMachines(String animationName) {
        Artboard artboard;
        List<StateMachineInstance> stateMachineInstances = this.stateMachines(animationName);
        if (stateMachineInstances.isEmpty() && (artboard = this.activeArtboard) != null) {
            Artboard activeArtboard = artboard;
            boolean bl = false;
            StateMachineInstance stateMachineInstance = activeArtboard.stateMachine(animationName);
            this.stateMachineList.add(stateMachineInstance);
            return CollectionsKt.listOf((Object)stateMachineInstance);
        }
        return stateMachineInstances;
    }

    private final void playAnimation(String animationName, Loop loop, Direction direction, boolean isStateMachine, boolean settleInitialState) {
        block4: {
            block3: {
                if (!isStateMachine) break block3;
                List<StateMachineInstance> stateMachineInstances = this.getOrCreateStateMachines(animationName);
                Iterable $this$forEach$iv = stateMachineInstances;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StateMachineInstance it = (StateMachineInstance)element$iv;
                    boolean bl = false;
                    this.play$kotlin_release(it, settleInitialState);
                }
                break block4;
            }
            List<LinearAnimationInstance> animationInstances = this.animations(animationName);
            Iterable $this$forEach$iv = animationInstances;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.play$kotlin_release(it, loop, direction);
            }
            if (!animationInstances.isEmpty()) break block4;
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                Artboard activeArtboard = artboard;
                boolean bl = false;
                LinearAnimationInstance animationInstance = activeArtboard.animation(animationName);
                this.play$kotlin_release(animationInstance, loop, direction);
            }
        }
    }

    static /* synthetic */ void playAnimation$default(RiveFileController riveFileController, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveFileController.playAnimation(string, loop, direction, bl, bl2);
    }

    private final synchronized boolean resolveStateMachineAdvance(StateMachineInstance stateMachineInstance, float elapsed) {
        if (!((Collection)this.eventListeners).isEmpty()) {
            Iterable $this$forEach$iv = stateMachineInstance.getEventsReported();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RiveEvent it = (RiveEvent)element$iv;
                boolean bl = false;
                this.notifyEvent(it);
            }
        }
        boolean stillPlaying = stateMachineInstance.advance(elapsed);
        if (!((Collection)this.listeners).isEmpty()) {
            Iterable $this$forEach$iv = stateMachineInstance.getStatesChanged();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LayerState it = (LayerState)element$iv;
                boolean bl = false;
                this.notifyStateChanged(stateMachineInstance, it);
            }
        }
        return stillPlaying;
    }

    public final void play$kotlin_release(@NotNull StateMachineInstance stateMachineInstance, boolean settleStateMachineState) {
        Intrinsics.checkNotNullParameter((Object)stateMachineInstance, (String)"stateMachineInstance");
        if (!this.stateMachineList.contains(stateMachineInstance)) {
            this.stateMachineList.add(stateMachineInstance);
        }
        if (settleStateMachineState) {
            this.resolveStateMachineAdvance(stateMachineInstance, 0.0f);
        }
        this.playingStateMachineSet.add(stateMachineInstance);
        Function0<Unit> function0 = this.onStart;
        if (function0 != null) {
            function0.invoke();
        }
        this.notifyPlay(stateMachineInstance);
    }

    public static /* synthetic */ void play$kotlin_release$default(RiveFileController riveFileController, StateMachineInstance stateMachineInstance, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        riveFileController.play$kotlin_release(stateMachineInstance, bl);
    }

    public final void play$kotlin_release(@NotNull LinearAnimationInstance animationInstance, @NotNull Loop loop, @NotNull Direction direction) {
        Loop appliedLoop;
        Intrinsics.checkNotNullParameter((Object)animationInstance, (String)"animationInstance");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Loop loop2 = appliedLoop = loop == Loop.AUTO ? this.loop : loop;
        if (appliedLoop != Loop.AUTO) {
            animationInstance.setLoop(appliedLoop);
        }
        if (!this.animationList.contains(animationInstance)) {
            if (direction == Direction.BACKWARDS) {
                animationInstance.time(animationInstance.getEndTime());
            }
            this.animationList.add(animationInstance);
        }
        if (direction != Direction.AUTO) {
            animationInstance.setDirection(direction);
        }
        this.playingAnimationSet.add(animationInstance);
        Function0<Unit> function0 = this.onStart;
        if (function0 != null) {
            function0.invoke();
        }
        this.notifyPlay(animationInstance);
    }

    private final void pause(LinearAnimationInstance animation) {
        boolean removed = this.playingAnimationSet.remove(animation);
        if (removed) {
            this.notifyPause(animation);
        }
    }

    private final void pause(StateMachineInstance stateMachine) {
        boolean removed = this.playingStateMachineSet.remove(stateMachine);
        if (removed) {
            this.notifyPause(stateMachine);
        }
    }

    private final void stop(LinearAnimationInstance animation) {
        this.playingAnimationSet.remove(animation);
        boolean removed = this.animationList.remove(animation);
        if (removed) {
            this.notifyStop(animation);
        }
    }

    private final void stop(StateMachineInstance stateMachine) {
        this.playingStateMachineSet.remove(stateMachine);
        boolean removed = this.stateMachineList.remove(stateMachine);
        if (removed) {
            this.notifyStop(stateMachine);
        }
    }

    @NotNull
    public final HashSet<Listener> getListeners$kotlin_release() {
        return this.listeners;
    }

    public final void setListeners$kotlin_release(@NotNull HashSet<Listener> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.listeners = hashSet;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getListeners$kotlin_release$annotations() {
    }

    @NotNull
    public final HashSet<RiveEventListener> getEventListeners$kotlin_release() {
        return this.eventListeners;
    }

    public final void setEventListeners$kotlin_release(@NotNull HashSet<RiveEventListener> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.eventListeners = hashSet;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getEventListeners$kotlin_release$annotations() {
    }

    @Override
    public void registerListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public final void addEventListener(@NotNull RiveEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventListeners.add(listener);
    }

    public final void removeEventListener(@NotNull RiveEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventListeners.remove(listener);
    }

    private final void notifyPlay(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPlay(playableInstance);
        }
    }

    private final void notifyPause(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPause(playableInstance);
        }
    }

    private final void notifyStop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStop(playableInstance);
        }
    }

    private final void notifyLoop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyLoop(playableInstance);
        }
    }

    @WorkerThread
    private final void notifyAdvance(float elapsed) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyAdvance(elapsed);
        }
    }

    private final void notifyStateChanged(StateMachineInstance stateMachine, LayerState state) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStateChanged(stateMachine.getName(), state.toString());
        }
    }

    private final void notifyEvent(RiveEvent event) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.eventListeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RiveEventListener it = (RiveEventListener)element$iv;
            boolean bl = false;
            it.notifyEvent(event);
        }
    }

    public final void reset$kotlin_release() {
        this.playingAnimationSet.clear();
        this.animationList.clear();
        this.playingStateMachineSet.clear();
        this.stateMachineList.clear();
        this.setActiveArtboard(null);
    }

    @Override
    public synchronized int release() {
        int count = RefCount.DefaultImpls.release(this);
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (count == 0) {
            this.setFile(null);
        }
        return count;
    }

    @Override
    public int getRefCount() {
        return RefCount.DefaultImpls.getRefCount(this);
    }

    @Override
    @CallSuper
    public int acquire() {
        return RefCount.DefaultImpls.acquire(this);
    }

    public RiveFileController() {
        this(null, null, null, false, null, null, null, 127, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController$Companion;", "", "()V", "TAG", "", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH&J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\u0010"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController$Listener;", "", "notifyAdvance", "", "elapsed", "", "notifyLoop", "animation", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "stateMachineName", "", "stateName", "notifyStop", "kotlin_release"})
    public static interface Listener {
        public void notifyPlay(@NotNull PlayableInstance var1);

        public void notifyPause(@NotNull PlayableInstance var1);

        public void notifyStop(@NotNull PlayableInstance var1);

        public void notifyLoop(@NotNull PlayableInstance var1);

        public void notifyStateChanged(@NotNull String var1, @NotNull String var2);

        public void notifyAdvance(float var1);

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void notifyAdvance(@NotNull Listener $this, float elapsed) {
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController$RiveEventListener;", "", "notifyEvent", "", "event", "Lapp/rive/runtime/kotlin/core/RiveEvent;", "kotlin_release"})
    public static interface RiveEventListener {
        public void notifyEvent(@NotNull RiveEvent var1);
    }
}

