/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B8\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0014R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/rive/runtime/kotlin/core/BytesRequest;", "Lcom/android/volley/Request;", "", "url", "", "onResponse", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "bytes", "", "errorListener", "Lcom/android/volley/Response$ErrorListener;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lcom/android/volley/Response$ErrorListener;)V", "deliverResponse", "response", "parseNetworkResponse", "Lcom/android/volley/Response;", "Lcom/android/volley/NetworkResponse;", "kotlin_release"})
public final class BytesRequest
extends Request<byte[]> {
    @NotNull
    private final Function1<byte[], Unit> onResponse;

    public BytesRequest(@NotNull String url, @NotNull Function1<? super byte[], Unit> onResponse, @NotNull Response.ErrorListener errorListener) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter((Object)errorListener, (String)"errorListener");
        super(0, url, errorListener);
        this.onResponse = onResponse;
    }

    protected void deliverResponse(@NotNull byte[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.onResponse.invoke((Object)response);
    }

    @NotNull
    protected Response<byte[]> parseNetworkResponse(@Nullable NetworkResponse response) {
        Response response2;
        try {
            NetworkResponse networkResponse = response;
            byte[] byArray = (byte[])(networkResponse != null ? networkResponse.data : null);
            if (byArray == null) {
                byArray = new byte[]{};
            }
            byte[] bytes = byArray;
            response2 = Response.success((Object)bytes, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"{\n            val bytes \u2026ders(response))\n        }");
        }
        catch (Exception e) {
            Response response3 = Response.error((VolleyError)((VolleyError)new ParseError((Throwable)e)));
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"{\n            Response.e\u2026(ParseError(e))\n        }");
            response2 = response3;
        }
        return response2;
    }
}

