/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.content.Context;
import android.util.Log;
import app.rive.runtime.kotlin.core.BytesRequest;
import app.rive.runtime.kotlin.core.ExperimentalAssetLoader;
import app.rive.runtime.kotlin.core.FileAsset;
import app.rive.runtime.kotlin.core.FileAssetLoader;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lapp/rive/runtime/kotlin/core/CDNAssetLoader;", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "queue", "Lcom/android/volley/RequestQueue;", "tag", "", "kotlin.jvm.PlatformType", "loadContents", "", "asset", "Lapp/rive/runtime/kotlin/core/FileAsset;", "inBandBytes", "", "kotlin_release"})
@ExperimentalAssetLoader
public class CDNAssetLoader
extends FileAssetLoader {
    private final String tag;
    @NotNull
    private final RequestQueue queue;

    public CDNAssetLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.tag = this.getClass().getSimpleName();
        RequestQueue requestQueue = Volley.newRequestQueue((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)requestQueue, (String)"newRequestQueue(context)");
        this.queue = requestQueue;
    }

    @Override
    public boolean loadContents(@NotNull FileAsset asset, @NotNull byte[] inBandBytes) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)inBandBytes, (String)"inBandBytes");
        String url = asset.getCdnUrl();
        if (((CharSequence)url).length() == 0) {
            return false;
        }
        BytesRequest request2 = new BytesRequest(url, (Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>(asset){
            final /* synthetic */ FileAsset $asset;
            {
                this.$asset = $asset;
                super(1);
            }

            public final void invoke(@NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                this.$asset.decode(bytes);
            }
        }), arg_0 -> CDNAssetLoader.loadContents$lambda$0(this, arg_0));
        this.queue.add((Request)request2);
        return true;
    }

    private static final void loadContents$lambda$0(CDNAssetLoader this$0, VolleyError it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Log.e((String)this$0.tag, (String)"onAssetLoaded: loading image failed.");
        it.printStackTrace();
    }
}

