/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.PlayableInstance;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u00100\u001a\u0004\u0018\u00010\u001c2\u0006\u00101\u001a\u00020\u0006J\u0006\u00102\u001a\u000203J\u000e\u00102\u001a\u0002042\u0006\u00105\u001a\u00020\u0006J\u001b\u00106\u001a\u0004\u0018\u00010\u001c2\u0006\u00107\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0006H\u0082 J\u0019\u00108\u001a\u0002032\u0006\u00107\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0082 J\u0011\u00109\u001a\u0002032\u0006\u00107\u001a\u00020\u0004H\u0096 J\u0011\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0004H\u0082 J\u0011\u0010<\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0004H\u0082 J\u0011\u0010=\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0004H\u0082 J\u0011\u0010>\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0004H\u0082 J\u0011\u0010?\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0004H\u0082 J\u0011\u0010@\u001a\u00020%2\u0006\u0010;\u001a\u00020\u0004H\u0082 J\u0019\u0010A\u001a\u0002032\u0006\u00107\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u000fH\u0082 J\u0019\u0010C\u001a\u0002032\u0006\u0010;\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u000fH\u0082 J\u0019\u0010E\u001a\u0002032\u0006\u00107\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0006H\u0082 J\u0011\u0010F\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0004H\u0082 J\u0011\u0010G\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0004H\u0082 J\u000e\u0010*\u001a\u0002032\u0006\u0010*\u001a\u00020\u0006R$\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R\u0011\u0010*\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0016R\u0011\u0010,\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u0011\u0010.\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0011\u00a8\u0006H"}, d2={"Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "mix", "", "(JF)V", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "getDirection", "()Lapp/rive/runtime/kotlin/core/Direction;", "setDirection", "(Lapp/rive/runtime/kotlin/core/Direction;)V", "duration", "", "getDuration", "()I", "effectiveDuration", "getEffectiveDuration", "effectiveDurationInSeconds", "getEffectiveDurationInSeconds", "()F", "endTime", "getEndTime", "fps", "getFps", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "getMix", "setMix", "(F)V", "name", "", "getName", "()Ljava/lang/String;", "startTime", "getStartTime", "time", "getTime", "workEnd", "getWorkEnd", "workStart", "getWorkStart", "advance", "elapsedTime", "apply", "", "", "elapsed", "cppAdvance", "pointer", "cppApply", "cppDelete", "cppDuration", "cppPointer", "cppFps", "cppGetDirection", "cppGetLoop", "cppGetTime", "cppName", "cppSetDirection", "int", "cppSetLoop", "value", "cppSetTime", "cppWorkEnd", "cppWorkStart", "kotlin_release"})
public final class LinearAnimationInstance
extends NativeObject
implements PlayableInstance {
    private float mix;

    public LinearAnimationInstance(long unsafeCppPointer, float mix) {
        super(unsafeCppPointer);
        this.mix = mix;
    }

    public /* synthetic */ LinearAnimationInstance(long l, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(l, f);
    }

    public final float getMix() {
        return this.mix;
    }

    public final void setMix(float f) {
        this.mix = f;
    }

    private final native Loop cppAdvance(long var1, float var3);

    private final native void cppApply(long var1, float var3);

    private final native float cppGetTime(long var1);

    private final native void cppSetTime(long var1, float var3);

    private final native int cppGetDirection(long var1);

    private final native void cppSetDirection(long var1, int var3);

    private final native int cppGetLoop(long var1);

    private final native void cppSetLoop(long var1, int var3);

    private final native String cppName(long var1);

    private final native int cppDuration(long var1);

    private final native int cppFps(long var1);

    private final native int cppWorkStart(long var1);

    private final native int cppWorkEnd(long var1);

    @Override
    public native void cppDelete(long var1);

    @Nullable
    public final Loop advance(float elapsedTime) {
        return this.cppAdvance(this.getCppPointer(), elapsedTime);
    }

    public final void apply() {
        this.cppApply(this.getCppPointer(), this.mix);
    }

    public final boolean apply(float elapsed) {
        this.cppApply(this.getCppPointer(), this.mix);
        Loop loopType = this.cppAdvance(this.getCppPointer(), elapsed);
        return loopType != Loop.ONESHOT;
    }

    public final float getTime() {
        return this.cppGetTime(this.getCppPointer());
    }

    public final void time(float time) {
        this.cppSetTime(this.getCppPointer(), time);
    }

    @NotNull
    public final Direction getDirection() {
        int intDirection = this.cppGetDirection(this.getCppPointer());
        Direction direction = Direction.Companion.fromInt(intDirection);
        if (direction == null) {
            throw new IndexOutOfBoundsException();
        }
        return direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.cppSetDirection(this.getCppPointer(), direction.getValue());
    }

    public final int getDuration() {
        return this.cppDuration(this.getCppPointer());
    }

    public final int getEffectiveDuration() {
        if (this.getWorkStart() == -1) {
            return this.getDuration();
        }
        return this.getWorkEnd() - this.getWorkStart();
    }

    public final float getEffectiveDurationInSeconds() {
        return (float)this.getEffectiveDuration() / (float)this.getFps();
    }

    public final int getFps() {
        return this.cppFps(this.getCppPointer());
    }

    public final int getWorkStart() {
        return this.cppWorkStart(this.getCppPointer());
    }

    public final int getWorkEnd() {
        return this.cppWorkEnd(this.getCppPointer());
    }

    @Override
    @NotNull
    public String getName() {
        return this.cppName(this.getCppPointer());
    }

    public final float getStartTime() {
        return this.getWorkStart() == -1 ? 0.0f : (float)this.getWorkStart() / (float)this.getFps();
    }

    public final float getEndTime() {
        return this.getWorkEnd() == -1 ? (float)this.getDuration() / (float)this.getFps() : (float)this.getWorkEnd() / (float)this.getFps();
    }

    @NotNull
    public final Loop getLoop() {
        int intLoop = this.cppGetLoop(this.getCppPointer());
        return Loop.Companion.fromIndex(intLoop);
    }

    public final void setLoop(@NotNull Loop loop) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        this.cppSetLoop(this.getCppPointer(), loop.ordinal());
    }
}

