/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.renderers;

import android.graphics.RectF;
import android.view.Choreographer;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.VisibleForTesting;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RefCount;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u001f\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH&J&\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u0019\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020&H\u0082 J1\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"H\u0082 J\u0011\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020%H\u0082 J\u0011\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020%H\u0096 J\u0011\u0010.\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020%H\u0082 J\u0011\u0010/\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020%H\u0082 J\u0011\u00100\u001a\u00020&2\u0006\u0010+\u001a\u00020%H\u0082 J\u0011\u00101\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020%H\u0082 J\u0011\u00102\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020%H\u0082 J\u0019\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u0002052\u0006\u0010+\u001a\u00020%H\u0082 J\u0011\u00106\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020%H\u0082 J\u0011\u00107\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020%H\u0082 JA\u00108\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020%2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tH\u0082 J\u0011\u0010?\u001a\u00020&2\u0006\u0010+\u001a\u00020%H\u0082 J\b\u0010@\u001a\u00020\u001aH\u0017J\b\u0010A\u001a\u00020\u001aH\u0002J\b\u0010B\u001a\u00020\u001aH\u0014J\u0010\u0010C\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020%H\u0017J\b\u0010E\u001a\u00020\u001aH&J\b\u0010F\u001a\u00020\u001aH\u0017J\u0006\u0010G\u001a\u00020\u001aJ\u0006\u0010H\u001a\u00020\u001aJ\u0016\u0010I\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\t2\u0006\u0010:\u001a\u00020\tJ\b\u0010J\u001a\u00020\u001aH\u0016J\u000e\u0010K\u001a\u00020\u001a2\u0006\u00104\u001a\u000205J\u0006\u0010L\u001a\u00020\u001aJ\b\u0010M\u001a\u00020\u001aH\u0007J\r\u0010N\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\bOJ6\u0010P\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tJ\u0016\u0010Q\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0003\u001a\u00020\u00048\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006T"}, d2={"Lapp/rive/runtime/kotlin/renderers/Renderer;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "Landroid/view/Choreographer$FrameCallback;", "type", "Lapp/rive/runtime/kotlin/core/RendererType;", "trace", "", "(Lapp/rive/runtime/kotlin/core/RendererType;Z)V", "averageFps", "", "getAverageFps", "()F", "height", "getHeight", "<set-?>", "isAttached", "()Z", "setAttached", "(Z)V", "isPlaying", "getTrace", "getType", "()Lapp/rive/runtime/kotlin/core/RendererType;", "width", "getWidth", "advance", "", "elapsed", "align", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "targetBounds", "Landroid/graphics/RectF;", "sourceBounds", "constructor", "", "", "cppAlign", "cppPointer", "srcBounds", "cppAvgFps", "rendererPointer", "cppDelete", "pointer", "cppDestroySurface", "cppDoFrame", "cppHeight", "cppRestore", "cppSave", "cppSetSurface", "surface", "Landroid/view/Surface;", "cppStart", "cppStop", "cppTransform", "x", "sy", "sx", "y", "tx", "ty", "cppWidth", "delete", "destroySurface", "disposeDependencies", "doFrame", "frameTimeNanos", "draw", "make", "restore", "save", "scale", "scheduleFrame", "setSurface", "start", "stop", "stopThread", "stopThread$kotlin_release", "transform", "translate", "dx", "dy", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer.kt\napp/rive/runtime/kotlin/renderers/Renderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1855#2,2:230\n*S KotlinDebug\n*F\n+ 1 Renderer.kt\napp/rive/runtime/kotlin/renderers/Renderer\n*L\n226#1:230,2\n*E\n"})
public abstract class Renderer
extends NativeObject
implements Choreographer.FrameCallback {
    @NotNull
    private final RendererType type;
    private final boolean trace;
    private boolean isPlaying;
    private boolean isAttached;

    public Renderer(@NotNull RendererType type, boolean trace) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(0L);
        this.type = type;
        this.trace = trace;
    }

    public /* synthetic */ Renderer(RendererType rendererType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            rendererType = Rive.INSTANCE.getDefaultRendererType();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(rendererType, bl);
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final RendererType getType() {
        return this.type;
    }

    public final boolean getTrace() {
        return this.trace;
    }

    @Override
    public native void cppDelete(long var1);

    private final native void cppStart(long var1);

    private final native void cppStop(long var1);

    private final native void cppSave(long var1);

    private final native void cppRestore(long var1);

    private final native int cppWidth(long var1);

    private final native int cppHeight(long var1);

    private final native float cppAvgFps(long var1);

    private final native void cppDoFrame(long var1);

    private final native void cppSetSurface(Surface var1, long var2);

    private final native void cppDestroySurface(long var1);

    private final native void cppAlign(long var1, Fit var3, Alignment var4, RectF var5, RectF var6);

    private final native void cppTransform(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    private final native long constructor(boolean var1, int var2);

    @CallSuper
    public void make() {
        if (!this.getHasCppObject()) {
            this.setCppPointer(this.constructor(this.trace, this.type.getValue()));
        }
    }

    public final boolean isPlaying() {
        return this.isPlaying;
    }

    public final boolean isAttached() {
        return this.isAttached;
    }

    protected final void setAttached(boolean bl) {
        this.isAttached = bl;
    }

    public abstract void draw();

    public abstract void advance(float var1);

    public final void start() {
        if (this.isPlaying) {
            return;
        }
        if (!this.isAttached) {
            return;
        }
        if (!this.getHasCppObject()) {
            return;
        }
        this.isPlaying = true;
        this.cppStart(this.getCppPointer());
        this.scheduleFrame();
    }

    public final void setSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.cppSetSurface(surface, this.getCppPointer());
        this.isAttached = true;
        this.start();
    }

    @CallSuper
    public final void stopThread$kotlin_release() {
        if (!this.isPlaying) {
            return;
        }
        if (!this.getHasCppObject()) {
            return;
        }
        this.isPlaying = false;
        this.cppStop(this.getCppPointer());
    }

    @CallSuper
    public final void stop() {
        this.stopThread$kotlin_release();
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    private final void destroySurface() {
        this.stop();
        this.cppDestroySurface(this.getCppPointer());
        this.isAttached = false;
    }

    public void scheduleFrame() {
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public final void save() {
        this.cppSave(this.getCppPointer());
    }

    public final void restore() {
        this.cppRestore(this.getCppPointer());
    }

    public final float getWidth() {
        return this.cppWidth(this.getCppPointer());
    }

    public final float getHeight() {
        return this.cppHeight(this.getCppPointer());
    }

    public final float getAverageFps() {
        return this.cppAvgFps(this.getCppPointer());
    }

    public final void align(@NotNull Fit fit, @NotNull Alignment alignment, @NotNull RectF targetBounds, @NotNull RectF sourceBounds) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)targetBounds, (String)"targetBounds");
        Intrinsics.checkNotNullParameter((Object)sourceBounds, (String)"sourceBounds");
        this.cppAlign(this.getCppPointer(), fit, alignment, targetBounds, sourceBounds);
    }

    public final void transform(float x, float sy, float sx, float y, float tx, float ty) {
        this.cppTransform(this.getCppPointer(), x, sy, sx, y, tx, ty);
    }

    public final void scale(float sx, float sy) {
        this.transform(sx, 0.0f, 0.0f, sy, 0.0f, 0.0f);
    }

    public final void translate(float dx, float dy) {
        this.transform(1.0f, 0.0f, 0.0f, 1.0f, dx, dy);
    }

    @CallSuper
    public void doFrame(long frameTimeNanos) {
        if (this.isPlaying) {
            this.cppDoFrame(this.getCppPointer());
            this.scheduleFrame();
        }
    }

    @CallSuper
    public void delete() {
        this.destroySurface();
        this.cppDelete(this.getCppPointer());
        this.setCppPointer(0L);
    }

    protected void disposeDependencies() {
        Iterable $this$forEach$iv = this.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RefCount it = (RefCount)element$iv;
            boolean bl = false;
            it.release();
        }
        this.getDependencies().clear();
    }

    public Renderer() {
        this(null, false, 3, null);
    }
}

