/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.graphics.RectF;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RiveTextValueRun;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.core.errors.AnimationException;
import app.rive.runtime.kotlin.core.errors.RiveException;
import app.rive.runtime.kotlin.core.errors.StateMachineException;
import app.rive.runtime.kotlin.core.errors.StateMachineInputException;
import app.rive.runtime.kotlin.core.errors.TextValueRunException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001dJ\u000e\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\bJ\u000e\u00103\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\rJ\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0002J\u0019\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u001dH\u0082 J\u0019\u0010:\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u00104\u001a\u00020\bH\u0082 J\u0019\u0010;\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\rH\u0082 J\u0011\u0010<\u001a\u00020\b2\u0006\u00109\u001a\u00020\u0003H\u0082 J\u0019\u0010=\u001a\u00020\r2\u0006\u00109\u001a\u00020\u00032\u0006\u00104\u001a\u00020\bH\u0082 J\u0011\u0010>\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u0003H\u0082 J\u0011\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0003H\u0096 J\u0019\u0010B\u001a\u00020@2\u0006\u00109\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003H\u0082 J1\u0010D\u001a\u00020@2\u0006\u00109\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u00032\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001dH\u0082 J\u0019\u0010J\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\rH\u0082 J!\u0010K\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rH\u0082 J\u001b\u0010M\u001a\u0004\u0018\u00010\r2\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\rH\u0082 J#\u0010N\u001a\u0004\u0018\u00010\r2\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rH\u0082 J\u0011\u0010O\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0003H\u0082 J\u0011\u0010P\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0003H\u0082 J\u0011\u0010Q\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0003H\u0082 J!\u0010R\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rH\u0082 J\u0011\u0010S\u001a\u00020\r2\u0006\u00109\u001a\u00020\u0003H\u0082 J\u0011\u0010T\u001a\u00020@2\u0006\u00109\u001a\u00020\u0003H\u0082 J\u0019\u0010U\u001a\u00020@2\u0006\u00109\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001dH\u0082 J\u0019\u0010V\u001a\u00020@2\u0006\u00109\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u001dH\u0082 J!\u0010W\u001a\u0002012\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\r2\u0006\u0010X\u001a\u00020\rH\u0082 J)\u0010Y\u001a\u0002012\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\r2\u0006\u0010X\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rH\u0082 J\u0019\u0010Z\u001a\u00020@2\u0006\u00109\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u001dH\u0082 J\u0019\u0010[\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u00104\u001a\u00020\bH\u0082 J\u0019\u0010\\\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\rH\u0082 J\u0011\u0010]\u001a\u00020\b2\u0006\u00109\u001a\u00020\u0003H\u0082 J\u0019\u0010^\u001a\u00020\r2\u0006\u00109\u001a\u00020\u00032\u0006\u00104\u001a\u00020\bH\u0082 J\u000e\u0010_\u001a\u00020@2\u0006\u0010`\u001a\u00020\u0003J(\u0010_\u001a\u00020@2\u0006\u0010`\u001a\u00020\u00032\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\b\b\u0002\u0010I\u001a\u00020\u001dJ\u0010\u0010a\u001a\u00020@2\u0006\u0010`\u001a\u00020\u0003H\u0007J*\u0010a\u001a\u00020@2\u0006\u0010`\u001a\u00020\u00032\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\b\b\u0002\u0010I\u001a\u00020\u001dH\u0007J\u0010\u0010b\u001a\u0004\u0018\u00010\r2\u0006\u0010#\u001a\u00020\rJ\u0018\u0010b\u001a\u0004\u0018\u00010\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rJ\u0016\u00107\u001a\u0002062\u0006\u0010#\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rJ\u0006\u0010c\u001a\u00020@J\u0016\u0010d\u001a\u00020@2\u0006\u0010#\u001a\u00020\r2\u0006\u0010e\u001a\u00020\rJ\u001e\u0010d\u001a\u00020@2\u0006\u0010#\u001a\u00020\r2\u0006\u0010e\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rJ\u000e\u0010f\u001a\u00020\u00192\u0006\u00104\u001a\u00020\bJ\u000e\u0010f\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\rJ\u000e\u0010g\u001a\u00020h2\u0006\u0010#\u001a\u00020\rJ\u0016\u0010g\u001a\u00020h2\u0006\u0010#\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\nR\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000fR$\u0010*\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@@X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R$\u0010-\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010 \"\u0004\b/\u0010\"\u00a8\u0006i"}, d2={"Lapp/rive/runtime/kotlin/core/Artboard;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "(JLjava/util/concurrent/locks/ReentrantLock;)V", "animationCount", "", "getAnimationCount", "()I", "animationNames", "", "", "getAnimationNames", "()Ljava/util/List;", "bounds", "Landroid/graphics/RectF;", "getBounds", "()Landroid/graphics/RectF;", "firstAnimation", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getFirstAnimation", "()Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "firstStateMachine", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getFirstStateMachine", "()Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "value", "", "height", "getHeight", "()F", "setHeight", "(F)V", "name", "getName", "()Ljava/lang/String;", "stateMachineCount", "getStateMachineCount", "stateMachineNames", "getStateMachineNames", "volume", "getVolume", "setVolume$kotlin_release", "width", "getWidth", "setWidth", "advance", "", "elapsedTime", "animation", "index", "convertInput", "Lapp/rive/runtime/kotlin/core/SMIInput;", "input", "cppAdvance", "cppPointer", "cppAnimationByIndex", "cppAnimationByName", "cppAnimationCount", "cppAnimationNameByIndex", "cppBounds", "cppDelete", "", "pointer", "cppDraw", "rendererPointer", "cppDrawAligned", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "scaleFactor", "cppFindTextValueRun", "cppFindTextValueRunAtPath", "path", "cppFindValueOfTextValueRun", "cppFindValueOfTextValueRunAtPath", "cppGetArtboardHeight", "cppGetArtboardWidth", "cppGetVolume", "cppInputByNameAtPath", "cppName", "cppResetArtboardSize", "cppSetArtboardHeight", "cppSetArtboardWidth", "cppSetValueOfTextValueRun", "newText", "cppSetValueOfTextValueRunAtPath", "cppSetVolume", "cppStateMachineByIndex", "cppStateMachineByName", "cppStateMachineCount", "cppStateMachineNameByIndex", "draw", "rendererAddress", "drawSkia", "getTextRunValue", "resetArtboardSize", "setTextRunValue", "textValue", "stateMachine", "textRun", "Lapp/rive/runtime/kotlin/core/RiveTextValueRun;", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nArtboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Artboard.kt\napp/rive/runtime/kotlin/core/Artboard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1549#2:396\n1620#2,3:397\n1549#2:401\n1620#2,3:402\n1549#2:405\n1620#2,3:406\n1#3:400\n*S KotlinDebug\n*F\n+ 1 Artboard.kt\napp/rive/runtime/kotlin/core/Artboard\n*L\n131#1:396\n131#1:397,3\n378#1:401\n378#1:402,3\n384#1:405\n384#1:406,3\n*E\n"})
public final class Artboard
extends NativeObject {
    @NotNull
    private final ReentrantLock lock;

    public Artboard(long unsafeCppPointer, @NotNull ReentrantLock lock) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        super(unsafeCppPointer);
        this.lock = lock;
    }

    private final native String cppName(long var1);

    private final native long cppAnimationByIndex(long var1, int var3);

    private final native long cppAnimationByName(long var1, String var3);

    private final native int cppAnimationCount(long var1);

    private final native String cppAnimationNameByIndex(long var1, int var3);

    private final native long cppStateMachineByIndex(long var1, int var3);

    private final native long cppStateMachineByName(long var1, String var3);

    private final native int cppStateMachineCount(long var1);

    private final native String cppStateMachineNameByIndex(long var1, int var3);

    private final native long cppInputByNameAtPath(long var1, String var3, String var4);

    private final native float cppGetVolume(long var1);

    private final native void cppSetVolume(long var1, float var3);

    private final native boolean cppAdvance(long var1, float var3);

    private final native long cppFindTextValueRun(long var1, String var3);

    private final native String cppFindValueOfTextValueRun(long var1, String var3);

    private final native boolean cppSetValueOfTextValueRun(long var1, String var3, String var4);

    private final native long cppFindTextValueRunAtPath(long var1, String var3, String var4);

    private final native String cppFindValueOfTextValueRunAtPath(long var1, String var3, String var4);

    private final native boolean cppSetValueOfTextValueRunAtPath(long var1, String var3, String var4, String var5);

    private final native void cppDraw(long var1, long var3);

    private final native void cppDrawAligned(long var1, long var3, Fit var5, Alignment var6, float var7);

    private final native RectF cppBounds(long var1);

    private final native void cppResetArtboardSize(long var1);

    private final native float cppGetArtboardWidth(long var1);

    private final native void cppSetArtboardWidth(long var1, float var3);

    private final native float cppGetArtboardHeight(long var1);

    private final native void cppSetArtboardHeight(long var1, float var3);

    @Override
    public native void cppDelete(long var1);

    @NotNull
    public final String getName() {
        return this.cppName(this.getCppPointer());
    }

    @NotNull
    public final LinearAnimationInstance getFirstAnimation() throws RiveException {
        return this.animation(0);
    }

    @NotNull
    public final LinearAnimationInstance animation(int index) throws RiveException {
        long animationPointer = this.cppAnimationByIndex(this.getCppPointer(), index);
        if (animationPointer == 0L) {
            throw new AnimationException("No Animation found at index " + index + '.');
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, this.lock, 0.0f, 4, null);
        this.getDependencies().add(lai);
        return lai;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinearAnimationInstance animation(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long animationPointer = this.cppAnimationByName(this.getCppPointer(), name2);
        if (animationPointer == 0L) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getAnimationNames();
            StringBuilder stringBuilder = new StringBuilder().append("Animation \"").append(name2).append("\" not found. Available Animations: ");
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add('\"' + (String)it + '\"');
            }
            String string = stringBuilder.append((List)destination$iv$iv).append('\"').toString();
            throw new AnimationException(string);
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, this.lock, 0.0f, 4, null);
        this.getDependencies().add(lai);
        return lai;
    }

    @NotNull
    public final StateMachineInstance getFirstStateMachine() throws RiveException {
        return this.stateMachine(0);
    }

    @NotNull
    public final StateMachineInstance stateMachine(int index) throws RiveException {
        long stateMachinePointer = this.cppStateMachineByIndex(this.getCppPointer(), index);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found at index " + index + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer, this.lock);
        this.getDependencies().add(smi);
        return smi;
    }

    @NotNull
    public final StateMachineInstance stateMachine(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long stateMachinePointer = this.cppStateMachineByName(this.getCppPointer(), name2);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found with name " + name2 + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer, this.lock);
        this.getDependencies().add(smi);
        return smi;
    }

    @NotNull
    public final SMIInput input(@NotNull String name2, @NotNull String path) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long stateMachineInputPointer = this.cppInputByNameAtPath(this.getCppPointer(), name2, path);
        if (stateMachineInputPointer == 0L) {
            throw new StateMachineInputException("No StateMachineInput found with name " + name2 + " in nested artboard " + path + '.');
        }
        SMIInput input = new SMIInput(stateMachineInputPointer);
        return this.convertInput(input);
    }

    @NotNull
    public final RiveTextValueRun textRun(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long textRunPointer = this.cppFindTextValueRun(this.getCppPointer(), name2);
        if (textRunPointer == 0L) {
            throw new TextValueRunException("No Rive TextValueRun found with name \"" + name2 + ".\"");
        }
        RiveTextValueRun run = new RiveTextValueRun(textRunPointer);
        this.getDependencies().add(run);
        return run;
    }

    @Nullable
    public final String getTextRunValue(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.cppFindValueOfTextValueRun(this.getCppPointer(), name2);
    }

    public final void setTextRunValue(@NotNull String name2, @NotNull String textValue) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        boolean successCheck = this.cppSetValueOfTextValueRun(this.getCppPointer(), name2, textValue);
        if (!successCheck) {
            throw new TextValueRunException("Could not set text run. No Rive TextValueRun found with name \"" + name2 + ".\"");
        }
    }

    @NotNull
    public final RiveTextValueRun textRun(@NotNull String name2, @NotNull String path) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long textRunPointer = this.cppFindTextValueRunAtPath(this.getCppPointer(), name2, path);
        if (textRunPointer == 0L) {
            throw new TextValueRunException("No Rive TextValueRun found with name \"" + name2 + ".\" in nested artboard " + path);
        }
        RiveTextValueRun run = new RiveTextValueRun(textRunPointer);
        this.getDependencies().add(run);
        return run;
    }

    @Nullable
    public final String getTextRunValue(@NotNull String name2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.cppFindValueOfTextValueRunAtPath(this.getCppPointer(), name2, path);
    }

    public final void setTextRunValue(@NotNull String name2, @NotNull String textValue, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean successCheck = this.cppSetValueOfTextValueRunAtPath(this.getCppPointer(), name2, textValue, path);
        if (!successCheck) {
            throw new TextValueRunException("Could not set text run value at path. No Rive TextValueRun found with name \"" + name2 + ".\" in nested artboard \"" + path + ".\"");
        }
    }

    public final float getVolume() {
        return this.cppGetVolume(this.getCppPointer());
    }

    public final void setVolume$kotlin_release(float value) {
        this.cppSetVolume(this.getCppPointer(), value);
    }

    public final int getAnimationCount() {
        return this.cppAnimationCount(this.getCppPointer());
    }

    public final int getStateMachineCount() {
        return this.cppStateMachineCount(this.getCppPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean advance(float elapsedTime) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = this.cppAdvance(this.getCppPointer(), elapsedTime);
            return bl2;
        }
    }

    @Deprecated(message="Use draw(rendererAddress) instead", replaceWith=@ReplaceWith(expression="draw(rendererAddress)", imports={}))
    public final void drawSkia(long rendererAddress) {
        this.draw(rendererAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(long rendererAddress) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppDraw(this.getCppPointer(), rendererAddress);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Deprecated(message="Use draw(rendererAddress, fit, alignment, scaleFactor) instead", replaceWith=@ReplaceWith(expression="draw(rendererAddress, fit, alignment, scaleFactor)", imports={}))
    public final void drawSkia(long rendererAddress, @NotNull Fit fit, @NotNull Alignment alignment, float scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.draw(rendererAddress, fit, alignment, scaleFactor);
    }

    public static /* synthetic */ void drawSkia$default(Artboard artboard, long l, Fit fit, Alignment alignment, float f, int n, Object object) {
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        artboard.drawSkia(l, fit, alignment, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(long rendererAddress, @NotNull Fit fit, @NotNull Alignment alignment, float scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppDrawAligned(this.getCppPointer(), rendererAddress, fit, alignment, scaleFactor);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void draw$default(Artboard artboard, long l, Fit fit, Alignment alignment, float f, int n, Object object) {
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        artboard.draw(l, fit, alignment, f);
    }

    public final void resetArtboardSize() {
        this.cppResetArtboardSize(this.getCppPointer());
    }

    @NotNull
    public final RectF getBounds() {
        return this.cppBounds(this.getCppPointer());
    }

    public final float getWidth() {
        return this.cppGetArtboardWidth(this.getCppPointer());
    }

    public final void setWidth(float value) {
        this.cppSetArtboardWidth(this.getCppPointer(), value);
    }

    public final float getHeight() {
        return this.cppGetArtboardHeight(this.getCppPointer());
    }

    public final void setHeight(float value) {
        this.cppSetArtboardHeight(this.getCppPointer(), value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAnimationNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getAnimationCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppAnimationNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStateMachineNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateMachineCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppStateMachineNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }

    private final SMIInput convertInput(SMIInput input) {
        SMIInput sMIInput;
        if (input.isBoolean()) {
            sMIInput = new SMIBoolean(input.getCppPointer());
        } else if (input.isTrigger()) {
            sMIInput = new SMITrigger(input.getCppPointer());
        } else if (input.isNumber()) {
            sMIInput = new SMINumber(input.getCppPointer());
        } else {
            throw new StateMachineInputException("Unknown State Machine Input Instance for " + input.getName() + '.');
        }
        SMIInput convertedInput = sMIInput;
        return convertedInput;
    }
}

