/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.AnimationState;
import app.rive.runtime.kotlin.core.AnyState;
import app.rive.runtime.kotlin.core.BlendState;
import app.rive.runtime.kotlin.core.EntryState;
import app.rive.runtime.kotlin.core.ExitState;
import app.rive.runtime.kotlin.core.LayerState;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.PlayableInstance;
import app.rive.runtime.kotlin.core.RiveEvent;
import app.rive.runtime.kotlin.core.RiveEventReport;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.errors.RiveEventException;
import app.rive.runtime.kotlin.core.errors.RiveException;
import app.rive.runtime.kotlin.core.errors.StateMachineInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0015H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020!H\u0002J\u0019\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020&H\u0082 J\u0011\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0004H\u0096 J\u0011\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u0004H\u0082 J\u0011\u00102\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u0004H\u0082 J\u0011\u00103\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0004H\u0082 J!\u00104\u001a\u00020/2\u0006\u00101\u001a\u00020\u00042\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&H\u0082 J!\u00107\u001a\u00020/2\u0006\u00101\u001a\u00020\u00042\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&H\u0082 J!\u00108\u001a\u00020/2\u0006\u00101\u001a\u00020\u00042\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&H\u0082 J\u0019\u00109\u001a\u00020:2\u0006\u00101\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u000eH\u0082 J\u0011\u0010<\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u0004H\u0082 J\u0019\u0010=\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u000eH\u0082 J\u0019\u0010>\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u000eH\u0082 J\u0011\u0010?\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u0004H\u0082 J\u000e\u0010@\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0012J\u0016\u0010A\u001a\u00020/2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&J\u0016\u0010B\u001a\u00020/2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&J\u0016\u0010C\u001a\u00020/2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&J\u000e\u0010D\u001a\u00020!2\u0006\u0010;\u001a\u00020\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u0014\u0010\u001e\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\t8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\f\u00a8\u0006E"}, d2={"Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "(JLjava/util/concurrent/locks/ReentrantLock;)V", "eventsReported", "", "Lapp/rive/runtime/kotlin/core/RiveEvent;", "getEventsReported", "()Ljava/util/List;", "inputCount", "", "getInputCount", "()I", "inputNames", "", "getInputNames", "inputs", "Lapp/rive/runtime/kotlin/core/SMIInput;", "getInputs", "layerCount", "getLayerCount", "name", "getName", "()Ljava/lang/String;", "reportedEventCount", "getReportedEventCount", "stateChangedCount", "getStateChangedCount", "statesChanged", "Lapp/rive/runtime/kotlin/core/LayerState;", "getStatesChanged", "advance", "", "elapsed", "", "convertInput", "input", "convertLayerState", "state", "cppAdvance", "pointer", "elapsedTime", "cppDelete", "", "cppInputCount", "cppPointer", "cppLayerCount", "cppName", "cppPointerDown", "x", "y", "cppPointerMove", "cppPointerUp", "cppReportedEventAt", "Lapp/rive/runtime/kotlin/core/RiveEventReport;", "index", "cppReportedEventCount", "cppSMIInputByIndex", "cppStateChangedByIndex", "cppStateChangedCount", "eventAt", "pointerDown", "pointerMove", "pointerUp", "stateChanged", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nStateMachineInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachineInstance.kt\napp/rive/runtime/kotlin/core/StateMachineInstance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1#2:207\n1549#3:208\n1620#3,3:209\n1549#3:212\n1620#3,3:213\n1549#3:216\n1620#3,3:217\n1549#3:220\n1620#3,3:221\n*S KotlinDebug\n*F\n+ 1 StateMachineInstance.kt\napp/rive/runtime/kotlin/core/StateMachineInstance\n*L\n130#1:208\n130#1:209,3\n136#1:212\n136#1:213,3\n198#1:216\n198#1:217,3\n202#1:220\n202#1:221,3\n*E\n"})
public final class StateMachineInstance
extends NativeObject
implements PlayableInstance {
    @NotNull
    private final ReentrantLock lock;

    public StateMachineInstance(long unsafeCppPointer, @NotNull ReentrantLock lock) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        super(unsafeCppPointer);
        this.lock = lock;
    }

    private final native boolean cppAdvance(long var1, float var3);

    private final native int cppInputCount(long var1);

    private final native long cppSMIInputByIndex(long var1, int var3);

    private final native int cppStateChangedCount(long var1);

    private final native long cppStateChangedByIndex(long var1, int var3);

    private final native int cppReportedEventCount(long var1);

    private final native RiveEventReport cppReportedEventAt(long var1, int var3);

    private final native String cppName(long var1);

    private final native int cppLayerCount(long var1);

    private final native void cppPointerDown(long var1, float var3, float var4);

    private final native void cppPointerUp(long var1, float var3, float var4);

    private final native void cppPointerMove(long var1, float var3, float var4);

    @Override
    public native void cppDelete(long var1);

    @Override
    @NotNull
    public String getName() {
        return this.cppName(this.getCppPointer());
    }

    public final int getLayerCount() {
        return this.cppLayerCount(this.getCppPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean advance(float elapsed) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = this.cppAdvance(this.getCppPointer(), elapsed);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pointerDown(float x, float y) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppPointerDown(this.getCppPointer(), x, y);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pointerUp(float x, float y) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppPointerUp(this.getCppPointer(), x, y);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pointerMove(float x, float y) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppPointerMove(this.getCppPointer(), x, y);
            return;
        }
    }

    public final int getInputCount() {
        return this.cppInputCount(this.getCppPointer());
    }

    private final int getStateChangedCount() {
        return this.cppStateChangedCount(this.getCppPointer());
    }

    private final int getReportedEventCount() {
        return this.cppReportedEventCount(this.getCppPointer());
    }

    private final SMIInput convertInput(SMIInput input) {
        SMIInput sMIInput;
        if (input.isBoolean()) {
            sMIInput = new SMIBoolean(input.getCppPointer());
        } else if (input.isTrigger()) {
            sMIInput = new SMITrigger(input.getCppPointer());
        } else if (input.isNumber()) {
            sMIInput = new SMINumber(input.getCppPointer());
        } else {
            throw new StateMachineInputException("Unknown State Machine Input Instance for " + input.getName() + '.');
        }
        SMIInput convertedInput = sMIInput;
        return convertedInput;
    }

    @NotNull
    public final SMIInput input(int index) throws RiveException {
        long stateMachineInputPointer = this.cppSMIInputByIndex(this.getCppPointer(), index);
        if (stateMachineInputPointer == 0L) {
            throw new StateMachineInputException("No StateMachineInput found at index " + index + '.');
        }
        SMIInput input = new SMIInput(stateMachineInputPointer);
        return this.convertInput(input);
    }

    @NotNull
    public final SMIInput input(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int n = this.getInputCount();
        for (int i = 0; i < n; ++i) {
            SMIInput output = this.input(i);
            if (!Intrinsics.areEqual((Object)output.getName(), (Object)name2)) continue;
            return output;
        }
        throw new StateMachineInputException("No StateMachineInput found with name " + name2 + '.');
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SMIInput> getInputs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.input((int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getInputNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getInputCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.input((int)it).getName());
        }
        return (List)destination$iv$iv;
    }

    private final LayerState convertLayerState(LayerState state) {
        LayerState layerState;
        if (state.isAnimationState()) {
            layerState = new AnimationState(state.getCppPointer());
        } else if (state.isAnyState()) {
            layerState = new AnyState(state.getCppPointer());
        } else if (state.isEntryState()) {
            layerState = new EntryState(state.getCppPointer());
        } else if (state.isExitState()) {
            layerState = new ExitState(state.getCppPointer());
        } else if (state.isBlendState()) {
            layerState = new BlendState(state.getCppPointer());
        } else {
            throw new StateMachineInputException("Unknown Layer State for " + state + '.');
        }
        LayerState convertedState = layerState;
        return convertedState;
    }

    @NotNull
    public final LayerState stateChanged(int index) throws RiveException {
        long stateChanged = this.cppStateChangedByIndex(this.getCppPointer(), index);
        if (stateChanged == 0L) {
            throw new StateMachineInputException("No LayerState found at index " + index + '.');
        }
        LayerState layerState = new LayerState(stateChanged);
        return this.convertLayerState(layerState);
    }

    @NotNull
    public final RiveEvent eventAt(int index) throws RiveException {
        RiveEventReport eventReport = this.cppReportedEventAt(this.getCppPointer(), index);
        if (eventReport.getUnsafeCppPointer() == 0L) {
            throw new RiveEventException("No Rive Event found at index " + index + '.');
        }
        return eventReport.getEvent();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LayerState> getStatesChanged() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateChangedCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.stateChanged((int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RiveEvent> getEventsReported() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getReportedEventCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.eventAt((int)it));
        }
        return (List)destination$iv$iv;
    }
}

