/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.fonts;

import android.util.Log;
import app.rive.runtime.kotlin.fonts.FontHelper;
import app.rive.runtime.kotlin.fonts.Fonts;
import app.rive.runtime.kotlin.fonts.SystemFontsParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lapp/rive/runtime/kotlin/fonts/FontHelper;", "", "()V", "Companion", "kotlin_release"})
public final class FontHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "FontHelper";

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J/\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\nJ\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lapp/rive/runtime/kotlin/fonts/FontHelper$Companion;", "", "()V", "TAG", "", "filterNonExistingFonts", "", "Lapp/rive/runtime/kotlin/fonts/Fonts$Family;", "fontFamilies", "findMatch", "Lapp/rive/runtime/kotlin/fonts/Fonts$Font;", "opts", "Lapp/rive/runtime/kotlin/fonts/Fonts$FontOpts;", "findMatch$kotlin_release", "getFallbackFont", "getFallbackFontBytes", "", "getFontBytes", "font", "getFontFile", "Ljava/io/File;", "getSystemFonts", "kotlin_release"})
    @SourceDebugExtension(value={"SMAP\nFontHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontHelpers.kt\napp/rive/runtime/kotlin/fonts/FontHelper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,624:1\n1#2:625\n526#3:626\n511#3,6:627\n453#3:647\n403#3:648\n494#3,7:655\n1054#4:633\n1360#4:634\n1446#4,5:635\n288#4,2:640\n1238#4,2:649\n766#4:651\n857#4,2:652\n1241#4:654\n179#5,2:642\n179#5,2:644\n215#6:646\n216#6:662\n*S KotlinDebug\n*F\n+ 1 FontHelpers.kt\napp/rive/runtime/kotlin/fonts/FontHelper$Companion\n*L\n140#1:626\n140#1:627,6\n218#1:647\n218#1:648\n220#1:655,7\n145#1:633\n148#1:634\n148#1:635,5\n149#1:640,2\n218#1:649,2\n219#1:651\n219#1:652,2\n218#1:654\n171#1:642,2\n202#1:644,2\n216#1:646\n216#1:662\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Fonts.Font getFallbackFont(@Nullable Fonts.FontOpts opts) {
            Fonts.Font font;
            Map<String, Fonts.Family> fontFamilies = this.getSystemFonts();
            if (fontFamilies.isEmpty()) {
                Log.e((String)FontHelper.TAG, (String)"getFallbackFont: no system font found");
                return null;
            }
            Fonts.Font font2 = this.findMatch$kotlin_release(fontFamilies, opts);
            if (font2 == null) {
                return null;
            }
            Fonts.Font match = font2;
            File file = this.getFontFile(match);
            if (file != null) {
                File it = file;
                boolean bl = false;
                font = match;
            } else {
                font = null;
            }
            return font;
        }

        public static /* synthetic */ Fonts.Font getFallbackFont$default(Companion companion, Fonts.FontOpts fontOpts, int n, Object object) {
            if ((n & 1) != 0) {
                fontOpts = null;
            }
            return companion.getFallbackFont(fontOpts);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Fonts.Font findMatch$kotlin_release(@NotNull Map<String, Fonts.Family> fontFamilies, @Nullable Fonts.FontOpts opts) {
            Fonts.Font fontCandidate;
            Fonts.Font font;
            Object v3;
            Fonts.FontOpts fontOpts;
            block6: {
                void $this$firstOrNull$iv;
                Iterator $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                void $this$sortedByDescending$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Intrinsics.checkNotNullParameter(fontFamilies, (String)"fontFamilies");
                Fonts.FontOpts fontOpts2 = opts;
                if (fontOpts2 == null) {
                    fontOpts2 = Fonts.FontOpts.Companion.getDEFAULT();
                }
                fontOpts = fontOpts2;
                String familyName = fontOpts.component1();
                String lang = fontOpts.component2();
                Fonts.Weight weight = fontOpts.component3();
                String style = fontOpts.component4();
                Map<String, Fonts.Family> map = fontFamilies;
                boolean $i$f$filter = false;
                void var11_11 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    boolean bl = false;
                    String key = (String)entry2.getKey();
                    Fonts.Family value = (Fonts.Family)entry2.getValue();
                    boolean bl2 = (familyName == null || Intrinsics.areEqual((Object)key, (Object)familyName)) && (lang == null || Intrinsics.areEqual((Object)value.getLang(), (Object)lang));
                    if (!bl2) continue;
                    destination$iv$iv.put(entry.getKey(), entry.getValue());
                }
                $this$filter$iv = destination$iv$iv.values();
                boolean $i$f$sortedByDescending232 = false;
                List matchingFamilies = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(lang){
                    final /* synthetic */ String $lang$inlined;
                    {
                        this.$lang$inlined = string;
                    }

                    public final int compare(T a, T b) {
                        Fonts.Family it = (Fonts.Family)b;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it.getLang(), (Object)this.$lang$inlined));
                        it = (Fonts.Family)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)it.getLang(), (Object)this.$lang$inlined)));
                    }
                });
                Iterable $i$f$sortedByDescending232 = matchingFamilies;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv3 = iterator2.next();
                    Fonts.Family it = (Fonts.Family)element$iv$iv3;
                    boolean bl = false;
                    List list = it.getFonts().get(weight);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = list;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Fonts.Font it = (Fonts.Font)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getStyle(), (Object)style)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            if ((font = (fontCandidate = (Fonts.Font)v3)) == null) {
                Companion $this$findMatch_u24lambda_u245 = this;
                boolean bl = false;
                Log.w((String)FontHelper.TAG, (String)("getFallbackFont(): failed to find a matching for for " + fontOpts));
                font = null;
            }
            return font;
        }

        public static /* synthetic */ Fonts.Font findMatch$kotlin_release$default(Companion companion, Map map, Fonts.FontOpts fontOpts, int n, Object object) {
            if ((n & 2) != 0) {
                fontOpts = null;
            }
            return companion.findMatch$kotlin_release(map, fontOpts);
        }

        @Nullable
        public final File getFontFile(@NotNull Fonts.Font font) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)font, (String)"font");
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)SystemFontsParser.Companion.getSYSTEM_FONTS_PATHS$kotlin_release()), (Function1)((Function1)new Function1<String, File>(font){
                    final /* synthetic */ Fonts.Font $font;
                    {
                        this.$font = $font;
                        super(1);
                    }

                    @NotNull
                    public final File invoke(@NotNull String basePath) {
                        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
                        return new File(basePath, ((Object)StringsKt.trim((CharSequence)this.$font.getName())).toString());
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    if (!it.exists()) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final byte[] getFontBytes(@NotNull Fonts.Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            File file = this.getFontFile(font);
            return file != null ? FilesKt.readBytes((File)file) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public final Map<String, Fonts.Family> getSystemFonts() {
            Map<String, Fonts.Family> map;
            Object v0;
            Object it;
            block8: {
                Object[] objectArray = new String[]{"/system/etc/fonts.xml", "/system/etc/system_fonts.xml", "/system/etc/system_fallback.xml"};
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)getSystemFonts.validPath.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (File)element$iv;
                    boolean bl = false;
                    if (!((File)it).exists()) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            File validPath2 = v0;
            if (validPath2 != null) {
                Map<String, Fonts.Family> map2;
                Closeable closeable = new FileInputStream(validPath2);
                Throwable throwable = null;
                try {
                    it = (FileInputStream)closeable;
                    boolean bl = false;
                    map2 = Companion.filterNonExistingFonts(SystemFontsParser.Companion.parseFontsXML$kotlin_release((InputStream)it));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Map<String, Fonts.Family> map3 = map2;
                if (map3 != null) {
                    map = map3;
                    return map;
                }
            }
            map = MapsKt.emptyMap();
            return map;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, Fonts.Family> filterNonExistingFonts(Map<String, Fonts.Family> fontFamilies) {
            Map filtered = new LinkedHashMap();
            Map<String, Fonts.Family> $this$forEach$iv = fontFamilies;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Fonts.Family>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$filterValues$iv;
                void $this$mapValuesTo$iv$iv;
                Map.Entry<String, Fonts.Family> element$iv;
                Map.Entry<String, Fonts.Family> entry = element$iv = iterator.next();
                boolean bl = false;
                String familyName = entry.getKey();
                Fonts.Family family = entry.getValue();
                Map $this$mapValues$iv = family.getFonts();
                boolean $i$f$mapValues = false;
                Map map = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void $this$filterTo$iv$iv;
                    void it$iv$iv;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl2 = false;
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl3 = false;
                    List fontList = (List)entry3.getValue();
                    Iterable $this$filter$iv = fontList;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Fonts.Font font = (Fonts.Font)element$iv$iv;
                        boolean bl4 = false;
                        if (!(Companion.getFontFile(font) != null)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List list = (List)destination$iv$iv2;
                    map3.put(k, list);
                }
                $this$mapValues$iv = destination$iv$iv;
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                    List it = (List)entry$iv.getValue();
                    boolean bl5 = false;
                    boolean bl6 = !((Collection)it).isEmpty();
                    if (!bl6) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map existingFonts = result$iv;
                if (!(!existingFonts.isEmpty())) continue;
                filtered.put(familyName, new Fonts.Family(familyName, family.getVariant(), family.getLang(), existingFonts));
            }
            return filtered;
        }

        @Nullable
        public final byte[] getFallbackFontBytes(@Nullable Fonts.FontOpts opts) {
            Fonts.Font font = this.getFallbackFont(opts);
            if (font != null) {
                Fonts.Font it = font;
                boolean bl = false;
                return Companion.getFontBytes(it);
            }
            return null;
        }

        public static /* synthetic */ byte[] getFallbackFontBytes$default(Companion companion, Fonts.FontOpts fontOpts, int n, Object object) {
            if ((n & 1) != 0) {
                fontOpts = null;
            }
            return companion.getFallbackFontBytes(fontOpts);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

