/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.FileAssetLoader;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import app.rive.runtime.kotlin.core.errors.ArtboardException;
import app.rive.runtime.kotlin.core.errors.RiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000fJ\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\nH\u0082 J\u0019\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u000fH\u0082 J\u0011\u0010#\u001a\u00020\n2\u0006\u0010!\u001a\u00020 H\u0082 J\u0019\u0010$\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\nH\u0082 J\u0011\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020 H\u0096 J)\u0010(\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\n2\u0006\u0010*\u001a\u00020 H\u0082 J\b\u0010+\u001a\u00020\nH\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lapp/rive/runtime/kotlin/core/File;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "bytes", "", "rendererType", "Lapp/rive/runtime/kotlin/core/RendererType;", "fileAssetLoader", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "([BLapp/rive/runtime/kotlin/core/RendererType;Lapp/rive/runtime/kotlin/core/FileAssetLoader;)V", "artboardCount", "", "getArtboardCount", "()I", "artboardNames", "", "", "getArtboardNames", "()Ljava/util/List;", "firstArtboard", "Lapp/rive/runtime/kotlin/core/Artboard;", "getFirstArtboard", "()Lapp/rive/runtime/kotlin/core/Artboard;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getRendererType", "()Lapp/rive/runtime/kotlin/core/RendererType;", "artboard", "index", "name", "cppArtboardByIndex", "", "cppPointer", "cppArtboardByName", "cppArtboardCount", "cppArtboardNameByIndex", "cppDelete", "", "pointer", "import", "length", "fileAssetLoaderPointer", "release", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 File.kt\napp/rive/runtime/kotlin/core/File\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n1549#2:118\n1620#2,3:119\n1#3:122\n*S KotlinDebug\n*F\n+ 1 File.kt\napp/rive/runtime/kotlin/core/File\n*L\n72#1:114\n72#1:115,3\n104#1:118\n104#1:119,3\n*E\n"})
public final class File
extends NativeObject {
    @NotNull
    private final RendererType rendererType;
    @NotNull
    private final ReentrantLock lock;

    public File(@NotNull byte[] bytes, @NotNull RendererType rendererType, @Nullable FileAssetLoader fileAssetLoader) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
        super(0L);
        this.rendererType = rendererType;
        FileAssetLoader fileAssetLoader2 = fileAssetLoader;
        if (fileAssetLoader2 != null) {
            fileAssetLoader2.setRendererType(this.rendererType);
        }
        FileAssetLoader fileAssetLoader3 = fileAssetLoader;
        this.setCppPointer(this.import(bytes, bytes.length, this.rendererType.getValue(), fileAssetLoader3 != null ? fileAssetLoader3.getCppPointer() : 0L));
        this.getRefs().incrementAndGet();
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ File(byte[] byArray, RendererType rendererType, FileAssetLoader fileAssetLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            rendererType = Rive.INSTANCE.getDefaultRendererType();
        }
        if ((n & 4) != 0) {
            fileAssetLoader = null;
        }
        this(byArray, rendererType, fileAssetLoader);
    }

    @NotNull
    public final RendererType getRendererType() {
        return this.rendererType;
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    private final native long import(byte[] var1, int var2, int var3, long var4);

    private final native long cppArtboardByName(long var1, String var3);

    private final native long cppArtboardByIndex(long var1, int var3);

    private final native String cppArtboardNameByIndex(long var1, int var3);

    private final native int cppArtboardCount(long var1);

    @Override
    public native void cppDelete(long var1);

    @NotNull
    public final Artboard getFirstArtboard() throws RiveException {
        return this.artboard(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Artboard artboard(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long artboardPointer = this.cppArtboardByName(this.getCppPointer(), name2);
        if (artboardPointer == 0L) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getArtboardNames();
            StringBuilder stringBuilder = new StringBuilder().append("Artboard \"").append(name2).append("\" not found. Available Artboards: ");
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add('\"' + (String)it + '\"');
            }
            String string = stringBuilder.append((List)destination$iv$iv).toString();
            throw new ArtboardException(string);
        }
        Artboard ab = new Artboard(artboardPointer, this.lock);
        this.getDependencies().add(ab);
        return ab;
    }

    @NotNull
    public final Artboard artboard(int index) throws RiveException {
        long artboardPointer = this.cppArtboardByIndex(this.getCppPointer(), index);
        if (artboardPointer == 0L) {
            throw new ArtboardException("No Artboard found at index " + index + '.');
        }
        Artboard ab = new Artboard(artboardPointer, this.lock);
        this.getDependencies().add(ab);
        return ab;
    }

    public final int getArtboardCount() {
        return this.cppArtboardCount(this.getCppPointer());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getArtboardNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getArtboardCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name2 = this.cppArtboardNameByIndex(this.getCppPointer(), (int)it);
            collection.add(name2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int release() {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            int n = super.release();
            return n;
        }
    }
}

