/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.fonts;

import android.util.Xml;
import app.rive.runtime.kotlin.fonts.Fonts;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lapp/rive/runtime/kotlin/fonts/SystemFontsParser;", "", "()V", "Companion", "kotlin_release"})
public final class SystemFontsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String FONTS_XML_PATH = "/system/etc/fonts.xml";
    @NotNull
    public static final String SYSTEM_FONTS_XML_PATH = "/system/etc/system_fonts.xml";
    @NotNull
    public static final String FALLBACK_FONTS_XML_PATH = "/system/etc/system_fallback.xml";
    @NotNull
    private static final List<String> SYSTEM_FONTS_PATHS;
    @NotNull
    private static final List<Pair<Fonts.Weight, String>> fontFilesOrder;

    static {
        Object[] objectArray = new String[]{"/system/fonts/", "/system/font/", "/data/fonts/", "/system/product/fonts/"};
        SYSTEM_FONTS_PATHS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{new Pair((Object)Fonts.Weight.Companion.getNORMAL(), (Object)"normal"), new Pair((Object)Fonts.Weight.Companion.getBOLD(), (Object)"normal"), new Pair((Object)Fonts.Weight.Companion.getNORMAL(), (Object)"italic"), new Pair((Object)Fonts.Weight.Companion.getBOLD(), (Object)"italic")};
        fontFilesOrder = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J<\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J!\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010)\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0007\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010.\u001a\u00020\u00102\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u001fH\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lapp/rive/runtime/kotlin/fonts/SystemFontsParser$Companion;", "", "()V", "FALLBACK_FONTS_XML_PATH", "", "FONTS_XML_PATH", "SYSTEM_FONTS_PATHS", "", "getSYSTEM_FONTS_PATHS$kotlin_release", "()Ljava/util/List;", "SYSTEM_FONTS_XML_PATH", "fontFilesOrder", "Lkotlin/Pair;", "Lapp/rive/runtime/kotlin/fonts/Fonts$Weight;", "fromFileFonts", "Lapp/rive/runtime/kotlin/fonts/Fonts$Family;", "Lapp/rive/runtime/kotlin/fonts/Fonts$Alias;", "filesList", "Lapp/rive/runtime/kotlin/fonts/Fonts$FileFont;", "namesList", "familyName", "fromFontList", "fontList", "Lapp/rive/runtime/kotlin/fonts/Fonts$Font;", "lang", "variant", "keepReading", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "parseFontsXML", "", "xmlFileStream", "Ljava/io/InputStream;", "parseFontsXML$kotlin_release", "readAlias", "readAxis", "Lapp/rive/runtime/kotlin/fonts/Fonts$Axis;", "readFamily", "readFileset", "readFont", "readLegacyFamily", "readNameset", "readText", "readXML", "remapAlias", "alias", "families", "skip", "", "kotlin_release"})
    @SourceDebugExtension(value={"SMAP\nFontHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontHelpers.kt\napp/rive/runtime/kotlin/fonts/SystemFontsParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,622:1\n1#2:623\n1855#3,2:624\n1864#3,2:626\n1866#3:635\n1549#3:636\n1620#3,3:637\n1855#3:640\n1856#3:648\n372#4,7:628\n372#4,7:641\n*S KotlinDebug\n*F\n+ 1 FontHelpers.kt\napp/rive/runtime/kotlin/fonts/SystemFontsParser$Companion\n*L\n297#1:624,2\n446#1:626,2\n446#1:635\n455#1:636\n455#1:637,3\n480#1:640\n480#1:648\n451#1:628,7\n483#1:641,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getSYSTEM_FONTS_PATHS$kotlin_release() {
            return SYSTEM_FONTS_PATHS;
        }

        @NotNull
        public final Map<String, Fonts.Family> parseFontsXML$kotlin_release(@NotNull InputStream xmlFileStream) {
            XmlPullParser xmlPullParser;
            Intrinsics.checkNotNullParameter((Object)xmlFileStream, (String)"xmlFileStream");
            XmlPullParser $this$parseFontsXML_u24lambda_u240 = xmlPullParser = Xml.newPullParser();
            boolean bl = false;
            $this$parseFontsXML_u24lambda_u240.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            $this$parseFontsXML_u24lambda_u240.setInput(xmlFileStream, null);
            $this$parseFontsXML_u24lambda_u240.nextTag();
            XmlPullParser parser = xmlPullParser;
            Intrinsics.checkNotNull((Object)parser);
            return this.readXML(parser);
        }

        private final Map<String, Fonts.Family> readXML(XmlPullParser parser) {
            Map familiesMap = new LinkedHashMap();
            parser.require(2, null, "familyset");
            while (this.keepReading(parser)) {
                String tag;
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = tag = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (Intrinsics.areEqual((Object)string2, (Object)"family")) {
                    String string3 = parser.getAttributeValue(null, "name");
                    if (string3 != null) {
                        Unit unit;
                        String name2 = string3;
                        boolean bl = false;
                        if (Companion.readFamily(((Object)StringsKt.trim((CharSequence)name2)).toString(), parser) != null) {
                            Fonts.Family it;
                            boolean bl2 = false;
                            familiesMap.put(name2, it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        string3 = unit;
                        if (unit != null) continue;
                    }
                    Companion $this$readXML_u24lambda_u246 = this;
                    boolean bl = false;
                    if ($this$readXML_u24lambda_u246.readLegacyFamily(parser) != null) {
                        Pair<Fonts.Family, List<Fonts.Alias>> pair;
                        boolean bl3 = false;
                        Fonts.Family family = (Fonts.Family)pair.component1();
                        List aliases = (List)pair.component2();
                        String string4 = family.getName();
                        Intrinsics.checkNotNull((Object)string4);
                        String familyName = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                        familiesMap.put(familyName, family);
                        Iterable $this$forEach$iv = aliases;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Fonts.Family remapped;
                            Fonts.Alias alias = (Fonts.Alias)element$iv;
                            boolean bl4 = false;
                            if ($this$readXML_u24lambda_u246.remapAlias(alias, familiesMap) == null) continue;
                            boolean bl5 = false;
                            familiesMap.put(alias.getName(), remapped);
                        }
                        string3 = Unit.INSTANCE;
                        continue;
                    }
                    string3 = null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)"alias")) {
                    Fonts.Alias alias = this.readAlias(parser);
                    if (this.remapAlias(alias, familiesMap) != null) {
                        Fonts.Family it;
                        boolean bl = false;
                        familiesMap.put(alias.getName(), it);
                    }
                    continue;
                }
                this.skip(parser);
            }
            return familiesMap;
        }

        private final Fonts.Family remapAlias(Fonts.Alias alias, Map<String, Fonts.Family> families) {
            String familyName = alias.getOriginal();
            Fonts.Family family = families.get(familyName);
            if (family == null) {
                return null;
            }
            Fonts.Family ogFamily = family;
            Fonts.Weight weight = alias.getWeight();
            if (weight == null) {
                return ogFamily;
            }
            Fonts.Weight weight2 = weight;
            List<Fonts.Font> list = ogFamily.getFonts().get(weight2);
            if (list == null) {
                return ogFamily;
            }
            List<Fonts.Font> weightedFonts = list;
            String name2 = ogFamily.component1();
            String variant = ogFamily.component2();
            String lang = ogFamily.component3();
            return new Fonts.Family(name2, variant, lang, MapsKt.mapOf((Pair)TuplesKt.to((Object)weight2, weightedFonts)));
        }

        private final Fonts.Family readFamily(String familyName, XmlPullParser parser) {
            boolean skip;
            String lang = parser.getAttributeValue(null, "lang");
            String variant = parser.getAttributeValue(null, "variant");
            String ignore = parser.getAttributeValue(null, "ignore");
            Map fonts = new LinkedHashMap();
            while (this.keepReading(parser)) {
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String tag = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (Intrinsics.areEqual((Object)tag, (Object)"font")) {
                    Fonts.Font font = this.readFont(parser);
                    if (!fonts.containsKey(font.getWeight())) {
                        fonts.put(font.getWeight(), (List)new ArrayList());
                    }
                    List list = (List)fonts.get(font.getWeight());
                    if (list != null) {
                        list.add(font);
                    }
                    continue;
                }
                this.skip(parser);
            }
            boolean bl = skip = ignore != null && (Intrinsics.areEqual((Object)ignore, (Object)"true") || Intrinsics.areEqual((Object)ignore, (Object)"1"));
            if (skip || fonts.isEmpty()) {
                return null;
            }
            return new Fonts.Family(familyName, variant, lang, fonts);
        }

        private final Pair<Fonts.Family, List<Fonts.Alias>> readLegacyFamily(XmlPullParser parser) {
            List namesList = new ArrayList();
            List filesList = new ArrayList();
            List fontList = new ArrayList();
            String familyVariant = parser.getAttributeValue(null, "variant");
            String familyLang = parser.getAttributeValue(null, "lang");
            block10: while (this.keepReading(parser)) {
                String tag;
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                switch (tag = ((Object)StringsKt.trim((CharSequence)string)).toString()) {
                    case "fileset": {
                        filesList.addAll((Collection)this.readFileset(parser));
                        continue block10;
                    }
                    case "nameset": {
                        namesList.addAll((Collection)this.readNameset(parser));
                        continue block10;
                    }
                    case "font": {
                        Fonts.Font font = this.readFont(parser);
                        fontList.add(font);
                        continue block10;
                    }
                }
                this.skip(parser);
            }
            if (!((Collection)fontList).isEmpty()) {
                return this.fromFontList(fontList, familyLang, familyVariant);
            }
            if (filesList.isEmpty()) {
                return null;
            }
            String familyName = namesList.isEmpty() ? ((Fonts.FileFont)CollectionsKt.first((List)filesList)).getName() : (String)namesList.remove(0);
            if (((CharSequence)familyName).length() == 0) {
                return null;
            }
            return this.fromFileFonts(filesList, namesList, familyName);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Fonts.Family, List<Fonts.Alias>> fromFileFonts(List<Fonts.FileFont> filesList, List<String> namesList, String familyName) {
            void $this$mapTo$iv$iv;
            Map fontsMap = new LinkedHashMap();
            Iterable $this$forEachIndexed$iv = filesList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Object object;
                void filefont;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Fonts.FileFont fileFont = (Fonts.FileFont)item$iv;
                int index = n;
                boolean bl = false;
                Pair pair = (Pair)fontFilesOrder.get(index);
                Fonts.Weight weight = (Fonts.Weight)pair.component1();
                String style = (String)pair.component2();
                String filename = filefont.component1();
                Fonts.Font candidate = new Fonts.Font(weight, style, filename, null, 8, null);
                Map $this$getOrPut$iv = fontsMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(weight);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(weight, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List fontsList = (List)object;
                fontsList.add(candidate);
            }
            Iterable $this$map$iv = namesList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new Fonts.Alias((String)it, familyName, null, 4, null));
            }
            List aliases = (List)destination$iv$iv;
            Fonts.FileFont fileFont = (Fonts.FileFont)CollectionsKt.first(filesList);
            String variant = fileFont.component2();
            String lang = fileFont.component3();
            return new Pair((Object)new Fonts.Family(familyName, variant, lang, fontsMap), (Object)aliases);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Fonts.Family, List<Fonts.Alias>> fromFontList(List<Fonts.Font> fontList, String lang, String variant) {
            void $this$forEach$iv;
            Map fontsMap = new LinkedHashMap();
            Iterable iterable = fontList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                void $this$getOrPut$iv;
                Fonts.Font font = (Fonts.Font)element$iv;
                boolean bl = false;
                Fonts.Weight weight = font.component1();
                String style = font.component2();
                String fontName = font.component3();
                Map map = fontsMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(weight);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(weight, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(font);
            }
            String familyName = ((Fonts.Font)CollectionsKt.first(fontList)).getName();
            return new Pair((Object)new Fonts.Family(familyName, variant, lang, fontsMap), (Object)CollectionsKt.emptyList());
        }

        private final Fonts.Font readFont(XmlPullParser parser) {
            parser.require(2, null, "font");
            String weightStr = parser.getAttributeValue(null, "weight");
            Fonts.Weight weight = Fonts.Weight.Companion.fromString(weightStr);
            String style = parser.getAttributeValue(null, "style");
            StringBuilder filenameBuilder = new StringBuilder();
            List axes = new ArrayList();
            while (this.keepReading(parser)) {
                if (parser.getEventType() == 4) {
                    String string = parser.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    filenameBuilder.append(((Object)StringsKt.trim((CharSequence)string)).toString());
                }
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String tag = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (Intrinsics.areEqual((Object)tag, (Object)"axis")) {
                    axes.add(this.readAxis(parser));
                    continue;
                }
                this.skip(parser);
            }
            Intrinsics.checkNotNull((Object)style);
            String string = filenameBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new Fonts.Font(weight, style, string, null, 8, null);
        }

        private final String readText(XmlPullParser parser) {
            if (parser.next() == 4) {
                String string = parser.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String result = ((Object)StringsKt.trim((CharSequence)string)).toString();
                parser.nextTag();
                return result;
            }
            return "";
        }

        private final List<String> readNameset(XmlPullParser parser) {
            List namesetList = new ArrayList();
            while (this.keepReading(parser)) {
                String nameset;
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String tag = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!Intrinsics.areEqual((Object)tag, (Object)"name") || !(((CharSequence)(nameset = this.readText(parser))).length() > 0)) continue;
                namesetList.add(nameset);
            }
            return namesetList;
        }

        private final List<Fonts.FileFont> readFileset(XmlPullParser parser) {
            List filesetList = new ArrayList();
            while (this.keepReading(parser)) {
                if (parser.getEventType() != 2) continue;
                String string = parser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String tag = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!Intrinsics.areEqual((Object)tag, (Object)"file")) continue;
                String variant = parser.getAttributeValue(null, "variant");
                String lang = parser.getAttributeValue(null, "lang");
                String filesetName = this.readText(parser);
                if (!(((CharSequence)filesetName).length() > 0)) continue;
                filesetList.add(new Fonts.FileFont(filesetName, variant, lang));
            }
            return filesetList;
        }

        private final Fonts.Axis readAxis(XmlPullParser parser) {
            String tagStr = parser.getAttributeValue(null, "tag");
            String styleValueStr = parser.getAttributeValue(null, "stylevalue");
            this.skip(parser);
            Intrinsics.checkNotNull((Object)tagStr);
            Intrinsics.checkNotNull((Object)styleValueStr);
            return new Fonts.Axis(tagStr, styleValueStr);
        }

        private final Fonts.Alias readAlias(XmlPullParser parser) {
            Fonts.Weight weight;
            String name2 = parser.getAttributeValue(null, "name");
            String to = parser.getAttributeValue(null, "to");
            String string = parser.getAttributeValue(null, "weight");
            if (string != null) {
                String weightStr = string;
                boolean bl = false;
                weight = Fonts.Weight.Companion.fromString(weightStr);
            } else {
                weight = null;
            }
            Fonts.Weight weight2 = weight;
            this.skip(parser);
            Intrinsics.checkNotNull((Object)name2);
            String string2 = ((Object)StringsKt.trim((CharSequence)name2)).toString();
            Intrinsics.checkNotNull((Object)to);
            return new Fonts.Alias(string2, to, weight2);
        }

        private final void skip(XmlPullParser parser) {
            int depth = 1;
            block5: while (depth > 0) {
                switch (parser.next()) {
                    case 2: {
                        ++depth;
                        continue block5;
                    }
                    case 3: {
                        --depth;
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                }
            }
        }

        private final boolean keepReading(XmlPullParser parser) {
            int next = parser.next();
            return next != 3 && next != 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

