/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.content.Context;
import android.util.Log;
import app.rive.runtime.kotlin.core.BytesRequest;
import app.rive.runtime.kotlin.core.FileAsset;
import app.rive.runtime.kotlin.core.FileAssetLoader;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lapp/rive/runtime/kotlin/core/CDNAssetLoader;", "Lapp/rive/runtime/kotlin/core/FileAssetLoader;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "tag", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "queue", "Lcom/android/volley/RequestQueue;", "getQueue", "()Lcom/android/volley/RequestQueue;", "queue$delegate", "Lkotlin/Lazy;", "loadContents", "", "asset", "Lapp/rive/runtime/kotlin/core/FileAsset;", "inBandBytes", "", "kotlin_release"})
public class CDNAssetLoader
extends FileAssetLoader {
    private final String tag;
    @NotNull
    private final Lazy queue$delegate;

    public CDNAssetLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.tag = this.getClass().getSimpleName();
        this.queue$delegate = LazyKt.lazy(() -> CDNAssetLoader.queue_delegate$lambda$0(context));
    }

    private final RequestQueue getQueue() {
        Lazy lazy = this.queue$delegate;
        return (RequestQueue)lazy.getValue();
    }

    @Override
    public boolean loadContents(@NotNull FileAsset asset, @NotNull byte[] inBandBytes) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)inBandBytes, (String)"inBandBytes");
        String url = asset.getCdnUrl();
        if (((CharSequence)url).length() == 0) {
            return false;
        }
        BytesRequest request = new BytesRequest(url, (Function1<? super byte[], Unit>)((Function1)arg_0 -> CDNAssetLoader.loadContents$lambda$1(asset, arg_0)), arg_0 -> CDNAssetLoader.loadContents$lambda$2(this, arg_0));
        this.getQueue().add((Request)request);
        return true;
    }

    private static final RequestQueue queue_delegate$lambda$0(Context $context) {
        return Volley.newRequestQueue((Context)$context);
    }

    private static final Unit loadContents$lambda$1(FileAsset $asset, byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        $asset.decode(bytes);
        return Unit.INSTANCE;
    }

    private static final void loadContents$lambda$2(CDNAssetLoader this$0, VolleyError it) {
        Log.e((String)this$0.tag, (String)"onAssetLoaded: loading image failed.");
        it.printStackTrace();
    }
}

