/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import app.rive.runtime.kotlin.core.Helpers;
import app.rive.runtime.kotlin.core.RefCount;
import app.rive.runtime.kotlin.core.errors.RiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0005R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lapp/rive/runtime/kotlin/core/NativeObject;", "Lapp/rive/runtime/kotlin/core/RefCount;", "unsafeCppPointer", "", "<init>", "(J)V", "disposeStackTrace", "Lkotlin/sequences/Sequence;", "Ljava/lang/StackTraceElement;", "hasCppObject", "", "getHasCppObject", "()Z", "refs", "Ljava/util/concurrent/atomic/AtomicInteger;", "getRefs", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setRefs", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "value", "cppPointer", "getCppPointer", "()J", "setCppPointer", "dependencies", "", "getDependencies", "()Ljava/util/List;", "cppDelete", "", "pointer", "buildCombinedStackTrace", "", "acquire", "", "release", "dispose", "Companion", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nNativeObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeObject.kt\napp/rive/runtime/kotlin/core/NativeObject\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n37#2,2:144\n1863#3,2:146\n*S KotlinDebug\n*F\n+ 1 NativeObject.kt\napp/rive/runtime/kotlin/core/NativeObject\n*L\n46#1:144,2\n137#1:146,2\n*E\n"})
public abstract class NativeObject
implements RefCount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long unsafeCppPointer;
    @Nullable
    private Sequence<StackTraceElement> disposeStackTrace;
    @NotNull
    private AtomicInteger refs;
    @NotNull
    private final List<RefCount> dependencies;
    public static final long NULL_POINTER = 0L;

    public NativeObject(long unsafeCppPointer) {
        this.unsafeCppPointer = unsafeCppPointer;
        this.refs = new AtomicInteger(this.unsafeCppPointer == 0L ? 0 : 1);
        this.dependencies = new ArrayList();
    }

    public final boolean getHasCppObject() {
        return this.unsafeCppPointer != 0L;
    }

    @Override
    @NotNull
    public final AtomicInteger getRefs() {
        return this.refs;
    }

    @Override
    public final void setRefs(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.refs = atomicInteger;
    }

    public final long getCppPointer() throws RiveException {
        if (!this.getHasCppObject()) {
            String nativeObjectName = this.getClass().getSimpleName();
            RiveException riveException = new RiveException("Accessing disposed C++ object " + nativeObjectName + ". ");
            Collection $this$toTypedArray$iv = this.buildCombinedStackTrace();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            riveException.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
            throw riveException;
        }
        return this.unsafeCppPointer;
    }

    public final void setCppPointer(long value) {
        this.unsafeCppPointer = value;
    }

    @NotNull
    public final List<RefCount> getDependencies() {
        return this.dependencies;
    }

    public void cppDelete(long pointer) {
    }

    private final List<StackTraceElement> buildCombinedStackTrace() {
        List combinedTrace = new ArrayList();
        Sequence<StackTraceElement> sequence = this.disposeStackTrace;
        if (sequence != null) {
            Sequence<StackTraceElement> sequence2;
            Sequence<StackTraceElement> trace = sequence2 = sequence;
            boolean bl = false;
            ((Collection)combinedTrace).add(new StackTraceElement("Dispose_Trace", "Start", null, -1));
            CollectionsKt.addAll((Collection)combinedTrace, trace);
            ((Collection)combinedTrace).add(new StackTraceElement("Current_Trace", "Start", null, -1));
        }
        CollectionsKt.addAll((Collection)combinedTrace, (Sequence)SequencesKt.drop((Sequence)Helpers.getCurrentStackTrace$default(Helpers.INSTANCE, false, 1, null), (int)1));
        return combinedTrace;
    }

    @Override
    public synchronized int acquire() throws IllegalArgumentException {
        int count = RefCount.DefaultImpls.acquire(this);
        if (!(count > 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return count;
    }

    @Override
    public synchronized int release() throws IllegalArgumentException {
        int count = RefCount.DefaultImpls.release(this);
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (count == 0 && this.getHasCppObject()) {
            this.dispose();
        }
        return count;
    }

    private final synchronized void dispose() throws IllegalArgumentException {
        List<RefCount> list;
        if (!(this.refs.get() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.disposeStackTrace = Helpers.getCurrentStackTrace$default(Helpers.INSTANCE, false, 1, null);
        List<RefCount> $this$dispose_u24lambda_u242 = list = this.dependencies;
        boolean bl = false;
        Iterable $this$forEach$iv = $this$dispose_u24lambda_u242;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RefCount it = (RefCount)element$iv;
            boolean bl2 = false;
            it.release();
        }
        $this$dispose_u24lambda_u242.clear();
        this.cppDelete(this.unsafeCppPointer);
        this.unsafeCppPointer = 0L;
    }

    @Override
    public int getRefCount() {
        return RefCount.DefaultImpls.getRefCount(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lapp/rive/runtime/kotlin/core/NativeObject$Companion;", "", "<init>", "()V", "NULL_POINTER", "", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

